/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.client;



import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.std.server.SMTPAccountStatusNotificationHandlerCfg;
import org.opends.server.types.AttributeType;



/**
 * A client-side interface for reading and modifying SMTP Account
 * Status Notification Handler settings.
 * <p>
 * The SMTP Account Status Notification Handler is a notification
 * handler that sends email messages to end users and/or administrators
 * whenever an account status notification is generated.
 */
public interface SMTPAccountStatusNotificationHandlerCfgClient extends AccountStatusNotificationHandlerCfgClient {

  /**
   * Get the configuration definition associated with this SMTP Account Status Notification Handler.
   *
   * @return Returns the configuration definition associated with this SMTP Account Status Notification Handler.
   */
  ManagedObjectDefinition<? extends SMTPAccountStatusNotificationHandlerCfgClient, ? extends SMTPAccountStatusNotificationHandlerCfg> definition();



  /**
   * Gets the "email-address-attribute-type" property.
   * <p>
   * Specifies which attribute in the user's entries may be used to
   * obtain the email address when notifying the end user.
   * <p>
   * You can specify more than one email address as separate values.
   * In this case, the OpenDJ server sends a notification to all email
   * addresses identified.
   *
   * @return Returns the values of the "email-address-attribute-type" property.
   */
  SortedSet<AttributeType> getEmailAddressAttributeType();



  /**
   * Sets the "email-address-attribute-type" property.
   * <p>
   * Specifies which attribute in the user's entries may be used to
   * obtain the email address when notifying the end user.
   * <p>
   * You can specify more than one email address as separate values.
   * In this case, the OpenDJ server sends a notification to all email
   * addresses identified.
   *
   * @param values The values of the "email-address-attribute-type" property.
   * @throws PropertyException
   *           If one or more of the new values are invalid.
   */
  void setEmailAddressAttributeType(Collection<AttributeType> values) throws PropertyException;



  /**
   * Gets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the SMTP Account Status Notification Handler
   * implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();



  /**
   * Sets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the SMTP Account Status Notification Handler
   * implementation.
   *
   * @param value The value of the "java-class" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setJavaClass(String value) throws PropertyException;



  /**
   * Gets the "message-subject" property.
   * <p>
   * Specifies the subject that should be used for email messages
   * generated by this account status notification handler.
   * <p>
   * The values for this property should begin with the name of an
   * account status notification type followed by a colon and the
   * subject that should be used for the associated notification
   * message. If an email message is generated for an account status
   * notification type for which no subject is defined, then that
   * message is given a generic subject.
   *
   * @return Returns the values of the "message-subject" property.
   */
  SortedSet<String> getMessageSubject();



  /**
   * Sets the "message-subject" property.
   * <p>
   * Specifies the subject that should be used for email messages
   * generated by this account status notification handler.
   * <p>
   * The values for this property should begin with the name of an
   * account status notification type followed by a colon and the
   * subject that should be used for the associated notification
   * message. If an email message is generated for an account status
   * notification type for which no subject is defined, then that
   * message is given a generic subject.
   *
   * @param values The values of the "message-subject" property.
   * @throws PropertyException
   *           If one or more of the new values are invalid.
   */
  void setMessageSubject(Collection<String> values) throws PropertyException;



  /**
   * Gets the "message-template-file" property.
   * <p>
   * Specifies the path to the file containing the message template to
   * generate the email notification messages.
   * <p>
   * The values for this property should begin with the name of an
   * account status notification type followed by a colon and the path
   * to the template file that should be used for that notification
   * type. If an account status notification has a notification type
   * that is not associated with a message template file, then no email
   * message is generated for that notification.
   *
   * @return Returns the values of the "message-template-file" property.
   */
  SortedSet<String> getMessageTemplateFile();



  /**
   * Sets the "message-template-file" property.
   * <p>
   * Specifies the path to the file containing the message template to
   * generate the email notification messages.
   * <p>
   * The values for this property should begin with the name of an
   * account status notification type followed by a colon and the path
   * to the template file that should be used for that notification
   * type. If an account status notification has a notification type
   * that is not associated with a message template file, then no email
   * message is generated for that notification.
   *
   * @param values The values of the "message-template-file" property.
   * @throws PropertyException
   *           If one or more of the new values are invalid.
   */
  void setMessageTemplateFile(Collection<String> values) throws PropertyException;



  /**
   * Gets the "recipient-address" property.
   * <p>
   * Specifies an email address to which notification messages are
   * sent, either instead of or in addition to the end user for whom
   * the notification has been generated.
   * <p>
   * This may be used to ensure that server administrators also
   * receive a copy of any notification messages that are generated.
   *
   * @return Returns the values of the "recipient-address" property.
   */
  SortedSet<String> getRecipientAddress();



  /**
   * Sets the "recipient-address" property.
   * <p>
   * Specifies an email address to which notification messages are
   * sent, either instead of or in addition to the end user for whom
   * the notification has been generated.
   * <p>
   * This may be used to ensure that server administrators also
   * receive a copy of any notification messages that are generated.
   *
   * @param values The values of the "recipient-address" property.
   * @throws PropertyException
   *           If one or more of the new values are invalid.
   */
  void setRecipientAddress(Collection<String> values) throws PropertyException;



  /**
   * Gets the "sender-address" property.
   * <p>
   * Specifies the email address from which the message is sent. Note
   * that this does not necessarily have to be a legitimate email
   * address.
   *
   * @return Returns the value of the "sender-address" property.
   */
  String getSenderAddress();



  /**
   * Sets the "sender-address" property.
   * <p>
   * Specifies the email address from which the message is sent. Note
   * that this does not necessarily have to be a legitimate email
   * address.
   *
   * @param value The value of the "sender-address" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setSenderAddress(String value) throws PropertyException;



  /**
   * Gets the "send-message-without-end-user-address" property.
   * <p>
   * Indicates whether an email notification message should be
   * generated and sent to the set of notification recipients even if
   * the user entry does not contain any values for any of the email
   * address attributes (that is, in cases when it is not be possible
   * to notify the end user).
   * <p>
   * This is only applicable if both one or more email address
   * attribute types and one or more additional recipient addresses are
   * specified.
   *
   * @return Returns the value of the "send-message-without-end-user-address" property.
   */
  boolean isSendMessageWithoutEndUserAddress();



  /**
   * Sets the "send-message-without-end-user-address" property.
   * <p>
   * Indicates whether an email notification message should be
   * generated and sent to the set of notification recipients even if
   * the user entry does not contain any values for any of the email
   * address attributes (that is, in cases when it is not be possible
   * to notify the end user).
   * <p>
   * This is only applicable if both one or more email address
   * attribute types and one or more additional recipient addresses are
   * specified.
   *
   * @param value The value of the "send-message-without-end-user-address" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setSendMessageWithoutEndUserAddress(boolean value) throws PropertyException;

}
