/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.client;



import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.std.server.SMTPAlertHandlerCfg;



/**
 * A client-side interface for reading and modifying SMTP Alert
 * Handler settings.
 * <p>
 * The SMTP Alert Handler may be used to send e-mail messages to
 * notify administrators of significant events that occur within the
 * server.
 */
public interface SMTPAlertHandlerCfgClient extends AlertHandlerCfgClient {

  /**
   * Get the configuration definition associated with this SMTP Alert Handler.
   *
   * @return Returns the configuration definition associated with this SMTP Alert Handler.
   */
  ManagedObjectDefinition<? extends SMTPAlertHandlerCfgClient, ? extends SMTPAlertHandlerCfg> definition();



  /**
   * Gets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the SMTP Alert Handler implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();



  /**
   * Sets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the SMTP Alert Handler implementation.
   *
   * @param value The value of the "java-class" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setJavaClass(String value) throws PropertyException;



  /**
   * Gets the "message-body" property.
   * <p>
   * Specifies the body that should be used for email messages
   * generated by this alert handler.
   * <p>
   * The token "%%%%alert-type%%%%" is dynamically replaced with the
   * alert type string. The token "%%%%alert-id%%%%" is dynamically
   * replaced with the alert ID value. The token
   * "%%%%alert-message%%%%" is dynamically replaced with the alert
   * message. The token "\\n" is replaced with an end-of-line marker.
   *
   * @return Returns the value of the "message-body" property.
   */
  String getMessageBody();



  /**
   * Sets the "message-body" property.
   * <p>
   * Specifies the body that should be used for email messages
   * generated by this alert handler.
   * <p>
   * The token "%%%%alert-type%%%%" is dynamically replaced with the
   * alert type string. The token "%%%%alert-id%%%%" is dynamically
   * replaced with the alert ID value. The token
   * "%%%%alert-message%%%%" is dynamically replaced with the alert
   * message. The token "\\n" is replaced with an end-of-line marker.
   *
   * @param value The value of the "message-body" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setMessageBody(String value) throws PropertyException;



  /**
   * Gets the "message-subject" property.
   * <p>
   * Specifies the subject that should be used for email messages
   * generated by this alert handler.
   * <p>
   * The token "%%%%alert-type%%%%" is dynamically replaced with the
   * alert type string. The token "%%%%alert-id%%%%" is dynamically
   * replaced with the alert ID value. The token
   * "%%%%alert-message%%%%" is dynamically replaced with the alert
   * message. The token "\\n" is replaced with an end-of-line marker.
   *
   * @return Returns the value of the "message-subject" property.
   */
  String getMessageSubject();



  /**
   * Sets the "message-subject" property.
   * <p>
   * Specifies the subject that should be used for email messages
   * generated by this alert handler.
   * <p>
   * The token "%%%%alert-type%%%%" is dynamically replaced with the
   * alert type string. The token "%%%%alert-id%%%%" is dynamically
   * replaced with the alert ID value. The token
   * "%%%%alert-message%%%%" is dynamically replaced with the alert
   * message. The token "\\n" is replaced with an end-of-line marker.
   *
   * @param value The value of the "message-subject" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setMessageSubject(String value) throws PropertyException;



  /**
   * Gets the "recipient-address" property.
   * <p>
   * Specifies an email address to which the messages should be sent.
   * <p>
   * Multiple values may be provided if there should be more than one
   * recipient.
   *
   * @return Returns the values of the "recipient-address" property.
   */
  SortedSet<String> getRecipientAddress();



  /**
   * Sets the "recipient-address" property.
   * <p>
   * Specifies an email address to which the messages should be sent.
   * <p>
   * Multiple values may be provided if there should be more than one
   * recipient.
   *
   * @param values The values of the "recipient-address" property.
   * @throws PropertyException
   *           If one or more of the new values are invalid.
   */
  void setRecipientAddress(Collection<String> values) throws PropertyException;



  /**
   * Gets the "sender-address" property.
   * <p>
   * Specifies the email address to use as the sender for messages
   * generated by this alert handler.
   *
   * @return Returns the value of the "sender-address" property.
   */
  String getSenderAddress();



  /**
   * Sets the "sender-address" property.
   * <p>
   * Specifies the email address to use as the sender for messages
   * generated by this alert handler.
   *
   * @param value The value of the "sender-address" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setSenderAddress(String value) throws PropertyException;

}
