/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.client;



import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.std.server.TelephoneNumberAttributeSyntaxCfg;



/**
 * A client-side interface for reading and modifying Telephone Number
 * Attribute Syntax settings.
 * <p>
 * Telephone Number Attribute Syntaxes define an attribute syntax for
 * storing telephone number information.
 */
public interface TelephoneNumberAttributeSyntaxCfgClient extends AttributeSyntaxCfgClient {

  /**
   * Get the configuration definition associated with this Telephone Number Attribute Syntax.
   *
   * @return Returns the configuration definition associated with this Telephone Number Attribute Syntax.
   */
  ManagedObjectDefinition<? extends TelephoneNumberAttributeSyntaxCfgClient, ? extends TelephoneNumberAttributeSyntaxCfg> definition();



  /**
   * Gets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the Telephone Number Attribute Syntax implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();



  /**
   * Sets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the Telephone Number Attribute Syntax implementation.
   * <p>
   * This property is read-only and can only be modified during
   * creation of a Telephone Number Attribute Syntax.
   *
   * @param value The value of the "java-class" property.
   * @throws PropertyException
   *           If the new value is invalid.
   * @throws PropertyException
   *           If this Telephone Number Attribute Syntax is not being initialized.
   */
  void setJavaClass(String value) throws PropertyException, PropertyException;



  /**
   * Gets the "strict-format" property.
   * <p>
   * Indicates whether to require telephone number values to strictly
   * comply with the standard definition for this syntax.
   *
   * @return Returns the value of the "strict-format" property.
   */
  boolean isStrictFormat();



  /**
   * Sets the "strict-format" property.
   * <p>
   * Indicates whether to require telephone number values to strictly
   * comply with the standard definition for this syntax.
   *
   * @param value The value of the "strict-format" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setStrictFormat(Boolean value) throws PropertyException;

}
