/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.meta;



import java.util.Collection;
import org.forgerock.opendj.config.server.ConfigException;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.IllegalManagedObjectNameException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.AccessLogFilteringCriteriaCfgClient;
import org.opends.server.admin.std.client.AccessLogPublisherCfgClient;
import org.opends.server.admin.std.server.AccessLogFilteringCriteriaCfg;
import org.opends.server.admin.std.server.AccessLogPublisherCfg;
import org.opends.server.admin.std.server.LogPublisherCfg;
import org.opends.server.admin.Tag;
import org.opends.server.types.DN;



/**
 * An interface for querying the Access Log Publisher managed object
 * definition meta information.
 * <p>
 * Access Log Publishers are responsible for distributing access log
 * messages from the access logger to a destination.
 */
public final class AccessLogPublisherCfgDefn extends ManagedObjectDefinition<AccessLogPublisherCfgClient, AccessLogPublisherCfg> {

  // The singleton configuration definition instance.
  private static final AccessLogPublisherCfgDefn INSTANCE = new AccessLogPublisherCfgDefn();



  /**
   * Defines the set of permissable values for the "filtering-policy" property.
   * <p>
   * Specifies how filtering criteria should be applied to log
   * records.
   */
  public static enum FilteringPolicy {

    /**
     * Records must not match any of the filtering criteria in order
     * to be logged.
     */
    EXCLUSIVE("exclusive"),



    /**
     * Records must match at least one of the filtering criteria in
     * order to be logged.
     */
    INCLUSIVE("inclusive"),



    /**
     * No filtering will be performed, and all records will be logged.
     */
    NO_FILTERING("no-filtering");



    // String representation of the value.
    private final String name;



    // Private constructor.
    private FilteringPolicy(String name) { this.name = name; }



    /**
     * {@inheritDoc}
     */
    public String toString() { return name; }

  }



  // The "filtering-policy" property definition.
  private static final EnumPropertyDefinition<FilteringPolicy> PD_FILTERING_POLICY;



  // The "java-class" property definition.
  private static final ClassPropertyDefinition PD_JAVA_CLASS;



  // The "suppress-internal-operations" property definition.
  private static final BooleanPropertyDefinition PD_SUPPRESS_INTERNAL_OPERATIONS;



  // The "suppress-synchronization-operations" property definition.
  private static final BooleanPropertyDefinition PD_SUPPRESS_SYNCHRONIZATION_OPERATIONS;



  // The "access-log-filtering-criteria" relation definition.
  private static final InstantiableRelationDefinition<AccessLogFilteringCriteriaCfgClient, AccessLogFilteringCriteriaCfg> RD_ACCESS_LOG_FILTERING_CRITERIA;



  // Build the "filtering-policy" property definition.
  static {
      EnumPropertyDefinition.Builder<FilteringPolicy> builder = EnumPropertyDefinition.createBuilder(INSTANCE, "filtering-policy");
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "filtering-policy"));
      DefaultBehaviorProvider<FilteringPolicy> provider = new DefinedDefaultBehaviorProvider<FilteringPolicy>("no-filtering");
      builder.setDefaultBehaviorProvider(provider);
      builder.setEnumClass(FilteringPolicy.class);
      PD_FILTERING_POLICY = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_FILTERING_POLICY);
  }



  // Build the "java-class" property definition.
  static {
      ClassPropertyDefinition.Builder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
      builder.setOption(PropertyOption.MANDATORY);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
      DefaultBehaviorProvider<String> provider = new DefinedDefaultBehaviorProvider<String>("org.opends.server.loggers.AccessLogPublisher");
      builder.setDefaultBehaviorProvider(provider);
      builder.addInstanceOf("org.opends.server.loggers.LogPublisher");
      PD_JAVA_CLASS = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
  }



  // Build the "suppress-internal-operations" property definition.
  static {
      BooleanPropertyDefinition.Builder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "suppress-internal-operations");
      builder.setOption(PropertyOption.ADVANCED);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "suppress-internal-operations"));
      DefaultBehaviorProvider<Boolean> provider = new DefinedDefaultBehaviorProvider<Boolean>("true");
      builder.setDefaultBehaviorProvider(provider);
      PD_SUPPRESS_INTERNAL_OPERATIONS = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_SUPPRESS_INTERNAL_OPERATIONS);
  }



  // Build the "suppress-synchronization-operations" property definition.
  static {
      BooleanPropertyDefinition.Builder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "suppress-synchronization-operations");
      builder.setOption(PropertyOption.ADVANCED);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "suppress-synchronization-operations"));
      DefaultBehaviorProvider<Boolean> provider = new DefinedDefaultBehaviorProvider<Boolean>("false");
      builder.setDefaultBehaviorProvider(provider);
      PD_SUPPRESS_SYNCHRONIZATION_OPERATIONS = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_SUPPRESS_SYNCHRONIZATION_OPERATIONS);
  }



  // Build the "access-log-filtering-criteria" relation definition.
  static {
    InstantiableRelationDefinition.Builder<AccessLogFilteringCriteriaCfgClient, AccessLogFilteringCriteriaCfg> builder =
      new InstantiableRelationDefinition.Builder<AccessLogFilteringCriteriaCfgClient, AccessLogFilteringCriteriaCfg>(INSTANCE, "access-log-filtering-criteria", "access-log-filtering-criteria", AccessLogFilteringCriteriaCfgDefn.getInstance());
    RD_ACCESS_LOG_FILTERING_CRITERIA = builder.getInstance();
    INSTANCE.registerRelationDefinition(RD_ACCESS_LOG_FILTERING_CRITERIA);
  }



  // Register the tags associated with this managed object definition.
  static {
    INSTANCE.registerTag(Tag.valueOf("logging"));
  }



  /**
   * Get the Access Log Publisher configuration definition singleton.
   *
   * @return Returns the Access Log Publisher configuration definition
   *         singleton.
   */
  public static AccessLogPublisherCfgDefn getInstance() {
    return INSTANCE;
  }



  /**
   * Private constructor.
   */
  private AccessLogPublisherCfgDefn() {
    super("access-log-publisher", LogPublisherCfgDefn.getInstance());
  }



  /**
   * {@inheritDoc}
   */
  public AccessLogPublisherCfgClient createClientConfiguration(
      ManagedObject<? extends AccessLogPublisherCfgClient> impl) {
    return new AccessLogPublisherCfgClientImpl(impl);
  }



  /**
   * {@inheritDoc}
   */
  public AccessLogPublisherCfg createServerConfiguration(
      ServerManagedObject<? extends AccessLogPublisherCfg> impl) {
    return new AccessLogPublisherCfgServerImpl(impl);
  }



  /**
   * {@inheritDoc}
   */
  public Class<AccessLogPublisherCfg> getServerConfigurationClass() {
    return AccessLogPublisherCfg.class;
  }



  /**
   * Get the "enabled" property definition.
   * <p>
   * Indicates whether the Access Log Publisher is enabled for use.
   *
   * @return Returns the "enabled" property definition.
   */
  public BooleanPropertyDefinition getEnabledPropertyDefinition() {
    return LogPublisherCfgDefn.getInstance().getEnabledPropertyDefinition();
  }



  /**
   * Get the "filtering-policy" property definition.
   * <p>
   * Specifies how filtering criteria should be applied to log
   * records.
   *
   * @return Returns the "filtering-policy" property definition.
   */
  public EnumPropertyDefinition<FilteringPolicy> getFilteringPolicyPropertyDefinition() {
    return PD_FILTERING_POLICY;
  }



  /**
   * Get the "java-class" property definition.
   * <p>
   * The fully-qualified name of the Java class that provides the
   * Access Log Publisher implementation.
   *
   * @return Returns the "java-class" property definition.
   */
  public ClassPropertyDefinition getJavaClassPropertyDefinition() {
    return PD_JAVA_CLASS;
  }



  /**
   * Get the "suppress-internal-operations" property definition.
   * <p>
   * Indicates whether internal operations (for example, operations
   * that are initiated by plugins) should be logged along with the
   * operations that are requested by users.
   *
   * @return Returns the "suppress-internal-operations" property definition.
   */
  public BooleanPropertyDefinition getSuppressInternalOperationsPropertyDefinition() {
    return PD_SUPPRESS_INTERNAL_OPERATIONS;
  }



  /**
   * Get the "suppress-synchronization-operations" property definition.
   * <p>
   * Indicates whether access messages that are generated by
   * synchronization operations should be suppressed.
   *
   * @return Returns the "suppress-synchronization-operations" property definition.
   */
  public BooleanPropertyDefinition getSuppressSynchronizationOperationsPropertyDefinition() {
    return PD_SUPPRESS_SYNCHRONIZATION_OPERATIONS;
  }



  /**
   * Get the "access-log-filtering-criteria" relation definition.
   *
   * @return Returns the "access-log-filtering-criteria" relation definition.
   */
  public InstantiableRelationDefinition<AccessLogFilteringCriteriaCfgClient,AccessLogFilteringCriteriaCfg> getAccessLogFilteringCriteriaRelationDefinition() {
    return RD_ACCESS_LOG_FILTERING_CRITERIA;
  }



  /**
   * Managed object client implementation.
   */
  private static class AccessLogPublisherCfgClientImpl implements
    AccessLogPublisherCfgClient {

    // Private implementation.
    private ManagedObject<? extends AccessLogPublisherCfgClient> impl;



    // Private constructor.
    private AccessLogPublisherCfgClientImpl(
        ManagedObject<? extends AccessLogPublisherCfgClient> impl) {
      this.impl = impl;
    }



    /**
     * {@inheritDoc}
     */
    public Boolean isEnabled() {
      return impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setEnabled(boolean value) {
      impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public FilteringPolicy getFilteringPolicy() {
      return impl.getPropertyValue(INSTANCE.getFilteringPolicyPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setFilteringPolicy(FilteringPolicy value) {
      impl.setPropertyValue(INSTANCE.getFilteringPolicyPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public String getJavaClass() {
      return impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setJavaClass(String value) {
      impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public boolean isSuppressInternalOperations() {
      return impl.getPropertyValue(INSTANCE.getSuppressInternalOperationsPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setSuppressInternalOperations(Boolean value) {
      impl.setPropertyValue(INSTANCE.getSuppressInternalOperationsPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public boolean isSuppressSynchronizationOperations() {
      return impl.getPropertyValue(INSTANCE.getSuppressSynchronizationOperationsPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setSuppressSynchronizationOperations(Boolean value) {
      impl.setPropertyValue(INSTANCE.getSuppressSynchronizationOperationsPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public String[] listAccessLogFilteringCriteria() throws ConcurrentModificationException,
        AuthorizationException, CommunicationException {
      return impl.listChildren(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public AccessLogFilteringCriteriaCfgClient getAccessLogFilteringCriteria(String name)
        throws DefinitionDecodingException, ManagedObjectDecodingException,
        ManagedObjectNotFoundException, ConcurrentModificationException,
        AuthorizationException, CommunicationException {
      return impl.getChild(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), name).getConfiguration();
    }



    /**
     * {@inheritDoc}
     */
    public <M extends AccessLogFilteringCriteriaCfgClient> M createAccessLogFilteringCriteria(
        ManagedObjectDefinition<M, ? extends AccessLogFilteringCriteriaCfg> d, String name, Collection<PropertyException> exceptions) throws IllegalManagedObjectNameException {
      return impl.createChild(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), d, name, exceptions).getConfiguration();
    }



    /**
     * {@inheritDoc}
     */
    public void removeAccessLogFilteringCriteria(String name)
        throws ManagedObjectNotFoundException, ConcurrentModificationException,
        OperationRejectedException, AuthorizationException, CommunicationException {
      impl.removeChild(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), name);
    }



    /**
     * {@inheritDoc}
     */
    public ManagedObjectDefinition<? extends AccessLogPublisherCfgClient, ? extends AccessLogPublisherCfg> definition() {
      return INSTANCE;
    }



    /**
     * {@inheritDoc}
     */
    public PropertyProvider properties() {
      return impl;
    }



    /**
     * {@inheritDoc}
     */
    public void commit() throws ManagedObjectAlreadyExistsException,
        MissingMandatoryPropertiesException, ConcurrentModificationException,
        OperationRejectedException, AuthorizationException,
        CommunicationException {
      impl.commit();
    }

  }



  /**
   * Managed object server implementation.
   */
  private static class AccessLogPublisherCfgServerImpl implements
    AccessLogPublisherCfg {

    // Private implementation.
    private ServerManagedObject<? extends AccessLogPublisherCfg> impl;

    // The value of the "enabled" property.
    private final boolean pEnabled;

    // The value of the "filtering-policy" property.
    private final FilteringPolicy pFilteringPolicy;

    // The value of the "java-class" property.
    private final String pJavaClass;

    // The value of the "suppress-internal-operations" property.
    private final boolean pSuppressInternalOperations;

    // The value of the "suppress-synchronization-operations" property.
    private final boolean pSuppressSynchronizationOperations;



    // Private constructor.
    private AccessLogPublisherCfgServerImpl(ServerManagedObject<? extends AccessLogPublisherCfg> impl) {
      this.impl = impl;
      this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
      this.pFilteringPolicy = impl.getPropertyValue(INSTANCE.getFilteringPolicyPropertyDefinition());
      this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
      this.pSuppressInternalOperations = impl.getPropertyValue(INSTANCE.getSuppressInternalOperationsPropertyDefinition());
      this.pSuppressSynchronizationOperations = impl.getPropertyValue(INSTANCE.getSuppressSynchronizationOperationsPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void addAccessChangeListener(
        ConfigurationChangeListener<AccessLogPublisherCfg> listener) {
      impl.registerChangeListener(listener);
    }



    /**
     * {@inheritDoc}
     */
    public void removeAccessChangeListener(
        ConfigurationChangeListener<AccessLogPublisherCfg> listener) {
      impl.deregisterChangeListener(listener);
    }
    /**
     * {@inheritDoc}
     */
    public void addChangeListener(
        ConfigurationChangeListener<LogPublisherCfg> listener) {
      impl.registerChangeListener(listener);
    }



    /**
     * {@inheritDoc}
     */
    public void removeChangeListener(
        ConfigurationChangeListener<LogPublisherCfg> listener) {
      impl.deregisterChangeListener(listener);
    }



    /**
     * {@inheritDoc}
     */
    public boolean isEnabled() {
      return pEnabled;
    }



    /**
     * {@inheritDoc}
     */
    public FilteringPolicy getFilteringPolicy() {
      return pFilteringPolicy;
    }



    /**
     * {@inheritDoc}
     */
    public String getJavaClass() {
      return pJavaClass;
    }



    /**
     * {@inheritDoc}
     */
    public boolean isSuppressInternalOperations() {
      return pSuppressInternalOperations;
    }



    /**
     * {@inheritDoc}
     */
    public boolean isSuppressSynchronizationOperations() {
      return pSuppressSynchronizationOperations;
    }



    /**
     * {@inheritDoc}
     */
    public String[] listAccessLogFilteringCriteria() {
      return impl.listChildren(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public AccessLogFilteringCriteriaCfg getAccessLogFilteringCriteria(String name) throws ConfigException {
      return impl.getChild(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), name).getConfiguration();
    }



    /**
     * {@inheritDoc}
     */
    public void addAccessLogFilteringCriteriaAddListener(
        ConfigurationAddListener<AccessLogFilteringCriteriaCfg> listener) throws ConfigException {
      impl.registerAddListener(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), listener);
    }



    /**
     * {@inheritDoc}
     */
    public void removeAccessLogFilteringCriteriaAddListener(
        ConfigurationAddListener<AccessLogFilteringCriteriaCfg> listener) {
      impl.deregisterAddListener(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), listener);
    }



    /**
     * {@inheritDoc}
     */
    public void addAccessLogFilteringCriteriaDeleteListener(
        ConfigurationDeleteListener<AccessLogFilteringCriteriaCfg> listener) throws ConfigException {
      impl.registerDeleteListener(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), listener);
    }



    /**
     * {@inheritDoc}
     */
    public void removeAccessLogFilteringCriteriaDeleteListener(
        ConfigurationDeleteListener<AccessLogFilteringCriteriaCfg> listener) {
      impl.deregisterDeleteListener(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), listener);
    }



    /**
     * {@inheritDoc}
     */
    public Class<? extends AccessLogPublisherCfg> configurationClass() {
      return AccessLogPublisherCfg.class;
    }



    /**
     * {@inheritDoc}
     */
    public DN dn() {
      return impl.getDN();
    }

  }
}
