/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.meta;



import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.AttributeCleanupPluginCfgClient;
import org.opends.server.admin.std.meta.PluginCfgDefn.PluginType;
import org.opends.server.admin.std.server.AttributeCleanupPluginCfg;
import org.opends.server.admin.std.server.PluginCfg;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.types.DN;



/**
 * An interface for querying the Attribute Cleanup Plugin managed
 * object definition meta information.
 * <p>
 * A pre-parse plugin which can be used to remove and rename
 * attributes in ADD and MODIFY requests before being processed.
 */
public final class AttributeCleanupPluginCfgDefn extends ManagedObjectDefinition<AttributeCleanupPluginCfgClient, AttributeCleanupPluginCfg> {

  // The singleton configuration definition instance.
  private static final AttributeCleanupPluginCfgDefn INSTANCE = new AttributeCleanupPluginCfgDefn();



  // The "invoke-for-internal-operations" property definition.
  private static final BooleanPropertyDefinition PD_INVOKE_FOR_INTERNAL_OPERATIONS;



  // The "java-class" property definition.
  private static final ClassPropertyDefinition PD_JAVA_CLASS;



  // The "plugin-type" property definition.
  private static final EnumPropertyDefinition<PluginType> PD_PLUGIN_TYPE;



  // The "remove-inbound-attributes" property definition.
  private static final StringPropertyDefinition PD_REMOVE_INBOUND_ATTRIBUTES;



  // The "rename-inbound-attributes" property definition.
  private static final StringPropertyDefinition PD_RENAME_INBOUND_ATTRIBUTES;



  // Build the "invoke-for-internal-operations" property definition.
  static {
      BooleanPropertyDefinition.Builder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "invoke-for-internal-operations");
      builder.setOption(PropertyOption.ADVANCED);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "invoke-for-internal-operations"));
      DefaultBehaviorProvider<Boolean> provider = new DefinedDefaultBehaviorProvider<Boolean>("false");
      builder.setDefaultBehaviorProvider(provider);
      PD_INVOKE_FOR_INTERNAL_OPERATIONS = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_INVOKE_FOR_INTERNAL_OPERATIONS);
  }



  // Build the "java-class" property definition.
  static {
      ClassPropertyDefinition.Builder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
      builder.setOption(PropertyOption.MANDATORY);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
      DefaultBehaviorProvider<String> provider = new DefinedDefaultBehaviorProvider<String>("org.opends.server.plugins.AttributeCleanupPlugin");
      builder.setDefaultBehaviorProvider(provider);
      builder.addInstanceOf("org.opends.server.api.plugin.DirectoryServerPlugin");
      PD_JAVA_CLASS = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
  }



  // Build the "plugin-type" property definition.
  static {
      EnumPropertyDefinition.Builder<PluginType> builder = EnumPropertyDefinition.createBuilder(INSTANCE, "plugin-type");
      builder.setOption(PropertyOption.MULTI_VALUED);
      builder.setOption(PropertyOption.MANDATORY);
      builder.setOption(PropertyOption.ADVANCED);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "plugin-type"));
      DefaultBehaviorProvider<PluginType> provider = new DefinedDefaultBehaviorProvider<PluginType>("preparseadd", "preparsemodify");
      builder.setDefaultBehaviorProvider(provider);
      builder.setEnumClass(PluginType.class);
      PD_PLUGIN_TYPE = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_PLUGIN_TYPE);
  }



  // Build the "remove-inbound-attributes" property definition.
  static {
      StringPropertyDefinition.Builder builder = StringPropertyDefinition.createBuilder(INSTANCE, "remove-inbound-attributes");
      builder.setOption(PropertyOption.MULTI_VALUED);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "remove-inbound-attributes"));
      builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider<String>(INSTANCE, "remove-inbound-attributes"));
      PD_REMOVE_INBOUND_ATTRIBUTES = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_REMOVE_INBOUND_ATTRIBUTES);
  }



  // Build the "rename-inbound-attributes" property definition.
  static {
      StringPropertyDefinition.Builder builder = StringPropertyDefinition.createBuilder(INSTANCE, "rename-inbound-attributes");
      builder.setOption(PropertyOption.MULTI_VALUED);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "rename-inbound-attributes"));
      builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider<String>(INSTANCE, "rename-inbound-attributes"));
      builder.setPattern("^[^:]+:[^:]+$", "FROM:TO");
      PD_RENAME_INBOUND_ATTRIBUTES = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_RENAME_INBOUND_ATTRIBUTES);
  }



  // Register the tags associated with this managed object definition.
  static {
    INSTANCE.registerTag(Tag.valueOf("core-server"));
  }



  /**
   * Get the Attribute Cleanup Plugin configuration definition
   * singleton.
   *
   * @return Returns the Attribute Cleanup Plugin configuration
   *         definition singleton.
   */
  public static AttributeCleanupPluginCfgDefn getInstance() {
    return INSTANCE;
  }



  /**
   * Private constructor.
   */
  private AttributeCleanupPluginCfgDefn() {
    super("attribute-cleanup-plugin", PluginCfgDefn.getInstance());
  }



  /**
   * {@inheritDoc}
   */
  public AttributeCleanupPluginCfgClient createClientConfiguration(
      ManagedObject<? extends AttributeCleanupPluginCfgClient> impl) {
    return new AttributeCleanupPluginCfgClientImpl(impl);
  }



  /**
   * {@inheritDoc}
   */
  public AttributeCleanupPluginCfg createServerConfiguration(
      ServerManagedObject<? extends AttributeCleanupPluginCfg> impl) {
    return new AttributeCleanupPluginCfgServerImpl(impl);
  }



  /**
   * {@inheritDoc}
   */
  public Class<AttributeCleanupPluginCfg> getServerConfigurationClass() {
    return AttributeCleanupPluginCfg.class;
  }



  /**
   * Get the "enabled" property definition.
   * <p>
   * Indicates whether the plug-in is enabled for use.
   *
   * @return Returns the "enabled" property definition.
   */
  public BooleanPropertyDefinition getEnabledPropertyDefinition() {
    return PluginCfgDefn.getInstance().getEnabledPropertyDefinition();
  }



  /**
   * Get the "invoke-for-internal-operations" property definition.
   * <p>
   * Indicates whether the plug-in should be invoked for internal
   * operations.
   * <p>
   * Any plug-in that can be invoked for internal operations must
   * ensure that it does not create any new internal operatons that can
   * cause the same plug-in to be re-invoked.
   *
   * @return Returns the "invoke-for-internal-operations" property definition.
   */
  public BooleanPropertyDefinition getInvokeForInternalOperationsPropertyDefinition() {
    return PD_INVOKE_FOR_INTERNAL_OPERATIONS;
  }



  /**
   * Get the "java-class" property definition.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the plug-in implementation.
   *
   * @return Returns the "java-class" property definition.
   */
  public ClassPropertyDefinition getJavaClassPropertyDefinition() {
    return PD_JAVA_CLASS;
  }



  /**
   * Get the "plugin-type" property definition.
   * <p>
   * Specifies the set of plug-in types for the plug-in, which
   * specifies the times at which the plug-in is invoked.
   *
   * @return Returns the "plugin-type" property definition.
   */
  public EnumPropertyDefinition<PluginType> getPluginTypePropertyDefinition() {
    return PD_PLUGIN_TYPE;
  }



  /**
   * Get the "remove-inbound-attributes" property definition.
   * <p>
   * A list of attributes which should be removed from incoming add or
   * modify requests.
   *
   * @return Returns the "remove-inbound-attributes" property definition.
   */
  public StringPropertyDefinition getRemoveInboundAttributesPropertyDefinition() {
    return PD_REMOVE_INBOUND_ATTRIBUTES;
  }



  /**
   * Get the "rename-inbound-attributes" property definition.
   * <p>
   * A list of attributes which should be renamed in incoming add or
   * modify requests.
   *
   * @return Returns the "rename-inbound-attributes" property definition.
   */
  public StringPropertyDefinition getRenameInboundAttributesPropertyDefinition() {
    return PD_RENAME_INBOUND_ATTRIBUTES;
  }



  /**
   * Managed object client implementation.
   */
  private static class AttributeCleanupPluginCfgClientImpl implements
    AttributeCleanupPluginCfgClient {

    // Private implementation.
    private ManagedObject<? extends AttributeCleanupPluginCfgClient> impl;



    // Private constructor.
    private AttributeCleanupPluginCfgClientImpl(
        ManagedObject<? extends AttributeCleanupPluginCfgClient> impl) {
      this.impl = impl;
    }



    /**
     * {@inheritDoc}
     */
    public Boolean isEnabled() {
      return impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setEnabled(boolean value) {
      impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public boolean isInvokeForInternalOperations() {
      return impl.getPropertyValue(INSTANCE.getInvokeForInternalOperationsPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setInvokeForInternalOperations(Boolean value) {
      impl.setPropertyValue(INSTANCE.getInvokeForInternalOperationsPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public String getJavaClass() {
      return impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setJavaClass(String value) {
      impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<PluginType> getPluginType() {
      return impl.getPropertyValues(INSTANCE.getPluginTypePropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setPluginType(Collection<PluginType> values) {
      impl.setPropertyValues(INSTANCE.getPluginTypePropertyDefinition(), values);
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<String> getRemoveInboundAttributes() {
      return impl.getPropertyValues(INSTANCE.getRemoveInboundAttributesPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setRemoveInboundAttributes(Collection<String> values) {
      impl.setPropertyValues(INSTANCE.getRemoveInboundAttributesPropertyDefinition(), values);
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<String> getRenameInboundAttributes() {
      return impl.getPropertyValues(INSTANCE.getRenameInboundAttributesPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setRenameInboundAttributes(Collection<String> values) {
      impl.setPropertyValues(INSTANCE.getRenameInboundAttributesPropertyDefinition(), values);
    }



    /**
     * {@inheritDoc}
     */
    public ManagedObjectDefinition<? extends AttributeCleanupPluginCfgClient, ? extends AttributeCleanupPluginCfg> definition() {
      return INSTANCE;
    }



    /**
     * {@inheritDoc}
     */
    public PropertyProvider properties() {
      return impl;
    }



    /**
     * {@inheritDoc}
     */
    public void commit() throws ManagedObjectAlreadyExistsException,
        MissingMandatoryPropertiesException, ConcurrentModificationException,
        OperationRejectedException, AuthorizationException,
        CommunicationException {
      impl.commit();
    }

  }



  /**
   * Managed object server implementation.
   */
  private static class AttributeCleanupPluginCfgServerImpl implements
    AttributeCleanupPluginCfg {

    // Private implementation.
    private ServerManagedObject<? extends AttributeCleanupPluginCfg> impl;

    // The value of the "enabled" property.
    private final boolean pEnabled;

    // The value of the "invoke-for-internal-operations" property.
    private final boolean pInvokeForInternalOperations;

    // The value of the "java-class" property.
    private final String pJavaClass;

    // The value of the "plugin-type" property.
    private final SortedSet<PluginType> pPluginType;

    // The value of the "remove-inbound-attributes" property.
    private final SortedSet<String> pRemoveInboundAttributes;

    // The value of the "rename-inbound-attributes" property.
    private final SortedSet<String> pRenameInboundAttributes;



    // Private constructor.
    private AttributeCleanupPluginCfgServerImpl(ServerManagedObject<? extends AttributeCleanupPluginCfg> impl) {
      this.impl = impl;
      this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
      this.pInvokeForInternalOperations = impl.getPropertyValue(INSTANCE.getInvokeForInternalOperationsPropertyDefinition());
      this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
      this.pPluginType = impl.getPropertyValues(INSTANCE.getPluginTypePropertyDefinition());
      this.pRemoveInboundAttributes = impl.getPropertyValues(INSTANCE.getRemoveInboundAttributesPropertyDefinition());
      this.pRenameInboundAttributes = impl.getPropertyValues(INSTANCE.getRenameInboundAttributesPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void addAttributeCleanupChangeListener(
        ConfigurationChangeListener<AttributeCleanupPluginCfg> listener) {
      impl.registerChangeListener(listener);
    }



    /**
     * {@inheritDoc}
     */
    public void removeAttributeCleanupChangeListener(
        ConfigurationChangeListener<AttributeCleanupPluginCfg> listener) {
      impl.deregisterChangeListener(listener);
    }
    /**
     * {@inheritDoc}
     */
    public void addChangeListener(
        ConfigurationChangeListener<PluginCfg> listener) {
      impl.registerChangeListener(listener);
    }



    /**
     * {@inheritDoc}
     */
    public void removeChangeListener(
        ConfigurationChangeListener<PluginCfg> listener) {
      impl.deregisterChangeListener(listener);
    }



    /**
     * {@inheritDoc}
     */
    public boolean isEnabled() {
      return pEnabled;
    }



    /**
     * {@inheritDoc}
     */
    public boolean isInvokeForInternalOperations() {
      return pInvokeForInternalOperations;
    }



    /**
     * {@inheritDoc}
     */
    public String getJavaClass() {
      return pJavaClass;
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<PluginType> getPluginType() {
      return pPluginType;
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<String> getRemoveInboundAttributes() {
      return pRemoveInboundAttributes;
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<String> getRenameInboundAttributes() {
      return pRenameInboundAttributes;
    }



    /**
     * {@inheritDoc}
     */
    public Class<? extends AttributeCleanupPluginCfg> configurationClass() {
      return AttributeCleanupPluginCfg.class;
    }



    /**
     * {@inheritDoc}
     */
    public DN dn() {
      return impl.getDN();
    }

  }
}
