/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.meta;



import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.CoreSchemaCfgClient;
import org.opends.server.admin.std.server.CoreSchemaCfg;
import org.opends.server.admin.std.server.SchemaProviderCfg;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.types.DN;



/**
 * An interface for querying the Core Schema managed object definition
 * meta information.
 * <p>
 * Core Schema define the core schema elements to load.
 */
public final class CoreSchemaCfgDefn extends ManagedObjectDefinition<CoreSchemaCfgClient, CoreSchemaCfg> {

  // The singleton configuration definition instance.
  private static final CoreSchemaCfgDefn INSTANCE = new CoreSchemaCfgDefn();



  // The "allow-zero-length-values-directory-string" property definition.
  private static final BooleanPropertyDefinition PD_ALLOW_ZERO_LENGTH_VALUES_DIRECTORY_STRING;



  // The "disabled-matching-rule" property definition.
  private static final StringPropertyDefinition PD_DISABLED_MATCHING_RULE;



  // The "disabled-syntax" property definition.
  private static final StringPropertyDefinition PD_DISABLED_SYNTAX;



  // The "java-class" property definition.
  private static final ClassPropertyDefinition PD_JAVA_CLASS;



  // The "strict-format-country-string" property definition.
  private static final BooleanPropertyDefinition PD_STRICT_FORMAT_COUNTRY_STRING;



  // The "strip-syntax-min-upper-bound-attribute-type-description" property definition.
  private static final BooleanPropertyDefinition PD_STRIP_SYNTAX_MIN_UPPER_BOUND_ATTRIBUTE_TYPE_DESCRIPTION;



  // Build the "allow-zero-length-values-directory-string" property definition.
  static {
      BooleanPropertyDefinition.Builder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "allow-zero-length-values-directory-string");
      builder.setOption(PropertyOption.ADVANCED);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allow-zero-length-values-directory-string"));
      DefaultBehaviorProvider<Boolean> provider = new DefinedDefaultBehaviorProvider<Boolean>("false");
      builder.setDefaultBehaviorProvider(provider);
      PD_ALLOW_ZERO_LENGTH_VALUES_DIRECTORY_STRING = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_ALLOW_ZERO_LENGTH_VALUES_DIRECTORY_STRING);
  }



  // Build the "disabled-matching-rule" property definition.
  static {
      StringPropertyDefinition.Builder builder = StringPropertyDefinition.createBuilder(INSTANCE, "disabled-matching-rule");
      builder.setOption(PropertyOption.MULTI_VALUED);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "disabled-matching-rule"));
      DefaultBehaviorProvider<String> provider = new DefinedDefaultBehaviorProvider<String>("NONE");
      builder.setDefaultBehaviorProvider(provider);
      builder.setPattern("^([0-9.]+\\d|NONE)$", "OID");
      PD_DISABLED_MATCHING_RULE = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_DISABLED_MATCHING_RULE);
  }



  // Build the "disabled-syntax" property definition.
  static {
      StringPropertyDefinition.Builder builder = StringPropertyDefinition.createBuilder(INSTANCE, "disabled-syntax");
      builder.setOption(PropertyOption.MULTI_VALUED);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "disabled-syntax"));
      DefaultBehaviorProvider<String> provider = new DefinedDefaultBehaviorProvider<String>("NONE");
      builder.setDefaultBehaviorProvider(provider);
      builder.setPattern("^([0-9.]+\\d|NONE)$", "OID");
      PD_DISABLED_SYNTAX = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_DISABLED_SYNTAX);
  }



  // Build the "java-class" property definition.
  static {
      ClassPropertyDefinition.Builder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
      builder.setOption(PropertyOption.MANDATORY);
      builder.setOption(PropertyOption.ADVANCED);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
      DefaultBehaviorProvider<String> provider = new DefinedDefaultBehaviorProvider<String>("org.opends.server.schema.CoreSchemaProvider");
      builder.setDefaultBehaviorProvider(provider);
      builder.addInstanceOf("org.opends.server.schema.SchemaProvider");
      PD_JAVA_CLASS = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
  }



  // Build the "strict-format-country-string" property definition.
  static {
      BooleanPropertyDefinition.Builder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "strict-format-country-string");
      builder.setOption(PropertyOption.ADVANCED);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "strict-format-country-string"));
      DefaultBehaviorProvider<Boolean> provider = new DefinedDefaultBehaviorProvider<Boolean>("true");
      builder.setDefaultBehaviorProvider(provider);
      PD_STRICT_FORMAT_COUNTRY_STRING = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_STRICT_FORMAT_COUNTRY_STRING);
  }



  // Build the "strip-syntax-min-upper-bound-attribute-type-description" property definition.
  static {
      BooleanPropertyDefinition.Builder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "strip-syntax-min-upper-bound-attribute-type-description");
      builder.setOption(PropertyOption.ADVANCED);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "strip-syntax-min-upper-bound-attribute-type-description"));
      DefaultBehaviorProvider<Boolean> provider = new DefinedDefaultBehaviorProvider<Boolean>("false");
      builder.setDefaultBehaviorProvider(provider);
      PD_STRIP_SYNTAX_MIN_UPPER_BOUND_ATTRIBUTE_TYPE_DESCRIPTION = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_STRIP_SYNTAX_MIN_UPPER_BOUND_ATTRIBUTE_TYPE_DESCRIPTION);
  }



  /**
   * Get the Core Schema configuration definition singleton.
   *
   * @return Returns the Core Schema configuration definition
   *         singleton.
   */
  public static CoreSchemaCfgDefn getInstance() {
    return INSTANCE;
  }



  /**
   * Private constructor.
   */
  private CoreSchemaCfgDefn() {
    super("core-schema", SchemaProviderCfgDefn.getInstance());
  }



  /**
   * {@inheritDoc}
   */
  public CoreSchemaCfgClient createClientConfiguration(
      ManagedObject<? extends CoreSchemaCfgClient> impl) {
    return new CoreSchemaCfgClientImpl(impl);
  }



  /**
   * {@inheritDoc}
   */
  public CoreSchemaCfg createServerConfiguration(
      ServerManagedObject<? extends CoreSchemaCfg> impl) {
    return new CoreSchemaCfgServerImpl(impl);
  }



  /**
   * {@inheritDoc}
   */
  public Class<CoreSchemaCfg> getServerConfigurationClass() {
    return CoreSchemaCfg.class;
  }



  /**
   * Get the "allow-zero-length-values-directory-string" property definition.
   * <p>
   * Indicates whether zero-length (that is, an empty string) values
   * are allowed for directory string.
   * <p>
   * This is technically not allowed by the revised LDAPv3
   * specification, but some environments may require it for backward
   * compatibility with servers that do allow it.
   *
   * @return Returns the "allow-zero-length-values-directory-string" property definition.
   */
  public BooleanPropertyDefinition getAllowZeroLengthValuesDirectoryStringPropertyDefinition() {
    return PD_ALLOW_ZERO_LENGTH_VALUES_DIRECTORY_STRING;
  }



  /**
   * Get the "disabled-matching-rule" property definition.
   * <p>
   * The set of disabled matching rules.
   * <p>
   * Matching rules must be specified using the syntax: OID, or use
   * the default value 'NONE' to specify no value.
   *
   * @return Returns the "disabled-matching-rule" property definition.
   */
  public StringPropertyDefinition getDisabledMatchingRulePropertyDefinition() {
    return PD_DISABLED_MATCHING_RULE;
  }



  /**
   * Get the "disabled-syntax" property definition.
   * <p>
   * The set of disabled syntaxes.
   * <p>
   * Syntaxes must be specified using the syntax: OID, or use the
   * default value 'NONE' to specify no value.
   *
   * @return Returns the "disabled-syntax" property definition.
   */
  public StringPropertyDefinition getDisabledSyntaxPropertyDefinition() {
    return PD_DISABLED_SYNTAX;
  }



  /**
   * Get the "enabled" property definition.
   * <p>
   * Indicates whether the Core Schema is enabled for use.
   *
   * @return Returns the "enabled" property definition.
   */
  public BooleanPropertyDefinition getEnabledPropertyDefinition() {
    return SchemaProviderCfgDefn.getInstance().getEnabledPropertyDefinition();
  }



  /**
   * Get the "java-class" property definition.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the Core Schema implementation.
   *
   * @return Returns the "java-class" property definition.
   */
  public ClassPropertyDefinition getJavaClassPropertyDefinition() {
    return PD_JAVA_CLASS;
  }



  /**
   * Get the "strict-format-country-string" property definition.
   * <p>
   * Indicates whether or not country code values are required to
   * strictly comply with the standard definition for this syntax.
   * <p>
   * When set to false, country codes will not be validated and, as a
   * result any string containing 2 characters will be acceptable.
   *
   * @return Returns the "strict-format-country-string" property definition.
   */
  public BooleanPropertyDefinition getStrictFormatCountryStringPropertyDefinition() {
    return PD_STRICT_FORMAT_COUNTRY_STRING;
  }



  /**
   * Get the "strip-syntax-min-upper-bound-attribute-type-description" property definition.
   * <p>
   * Indicates whether the suggested minimum upper bound appended to
   * an attribute's syntax OID in it's schema definition Attribute Type
   * Description is stripped off.
   * <p>
   * When retrieving the server's schema, some APIs (JNDI) fail in
   * their syntax lookup methods, because they do not parse this value
   * correctly. This configuration option allows the server to be
   * configured to provide schema definitions these APIs can parse
   * correctly.
   *
   * @return Returns the "strip-syntax-min-upper-bound-attribute-type-description" property definition.
   */
  public BooleanPropertyDefinition getStripSyntaxMinUpperBoundAttributeTypeDescriptionPropertyDefinition() {
    return PD_STRIP_SYNTAX_MIN_UPPER_BOUND_ATTRIBUTE_TYPE_DESCRIPTION;
  }



  /**
   * Managed object client implementation.
   */
  private static class CoreSchemaCfgClientImpl implements
    CoreSchemaCfgClient {

    // Private implementation.
    private ManagedObject<? extends CoreSchemaCfgClient> impl;



    // Private constructor.
    private CoreSchemaCfgClientImpl(
        ManagedObject<? extends CoreSchemaCfgClient> impl) {
      this.impl = impl;
    }



    /**
     * {@inheritDoc}
     */
    public boolean isAllowZeroLengthValuesDirectoryString() {
      return impl.getPropertyValue(INSTANCE.getAllowZeroLengthValuesDirectoryStringPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setAllowZeroLengthValuesDirectoryString(Boolean value) {
      impl.setPropertyValue(INSTANCE.getAllowZeroLengthValuesDirectoryStringPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<String> getDisabledMatchingRule() {
      return impl.getPropertyValues(INSTANCE.getDisabledMatchingRulePropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setDisabledMatchingRule(Collection<String> values) {
      impl.setPropertyValues(INSTANCE.getDisabledMatchingRulePropertyDefinition(), values);
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<String> getDisabledSyntax() {
      return impl.getPropertyValues(INSTANCE.getDisabledSyntaxPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setDisabledSyntax(Collection<String> values) {
      impl.setPropertyValues(INSTANCE.getDisabledSyntaxPropertyDefinition(), values);
    }



    /**
     * {@inheritDoc}
     */
    public Boolean isEnabled() {
      return impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setEnabled(boolean value) {
      impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public String getJavaClass() {
      return impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setJavaClass(String value) {
      impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public boolean isStrictFormatCountryString() {
      return impl.getPropertyValue(INSTANCE.getStrictFormatCountryStringPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setStrictFormatCountryString(Boolean value) {
      impl.setPropertyValue(INSTANCE.getStrictFormatCountryStringPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public boolean isStripSyntaxMinUpperBoundAttributeTypeDescription() {
      return impl.getPropertyValue(INSTANCE.getStripSyntaxMinUpperBoundAttributeTypeDescriptionPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setStripSyntaxMinUpperBoundAttributeTypeDescription(Boolean value) {
      impl.setPropertyValue(INSTANCE.getStripSyntaxMinUpperBoundAttributeTypeDescriptionPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public ManagedObjectDefinition<? extends CoreSchemaCfgClient, ? extends CoreSchemaCfg> definition() {
      return INSTANCE;
    }



    /**
     * {@inheritDoc}
     */
    public PropertyProvider properties() {
      return impl;
    }



    /**
     * {@inheritDoc}
     */
    public void commit() throws ManagedObjectAlreadyExistsException,
        MissingMandatoryPropertiesException, ConcurrentModificationException,
        OperationRejectedException, AuthorizationException,
        CommunicationException {
      impl.commit();
    }

  }



  /**
   * Managed object server implementation.
   */
  private static class CoreSchemaCfgServerImpl implements
    CoreSchemaCfg {

    // Private implementation.
    private ServerManagedObject<? extends CoreSchemaCfg> impl;

    // The value of the "allow-zero-length-values-directory-string" property.
    private final boolean pAllowZeroLengthValuesDirectoryString;

    // The value of the "disabled-matching-rule" property.
    private final SortedSet<String> pDisabledMatchingRule;

    // The value of the "disabled-syntax" property.
    private final SortedSet<String> pDisabledSyntax;

    // The value of the "enabled" property.
    private final boolean pEnabled;

    // The value of the "java-class" property.
    private final String pJavaClass;

    // The value of the "strict-format-country-string" property.
    private final boolean pStrictFormatCountryString;

    // The value of the "strip-syntax-min-upper-bound-attribute-type-description" property.
    private final boolean pStripSyntaxMinUpperBoundAttributeTypeDescription;



    // Private constructor.
    private CoreSchemaCfgServerImpl(ServerManagedObject<? extends CoreSchemaCfg> impl) {
      this.impl = impl;
      this.pAllowZeroLengthValuesDirectoryString = impl.getPropertyValue(INSTANCE.getAllowZeroLengthValuesDirectoryStringPropertyDefinition());
      this.pDisabledMatchingRule = impl.getPropertyValues(INSTANCE.getDisabledMatchingRulePropertyDefinition());
      this.pDisabledSyntax = impl.getPropertyValues(INSTANCE.getDisabledSyntaxPropertyDefinition());
      this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
      this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
      this.pStrictFormatCountryString = impl.getPropertyValue(INSTANCE.getStrictFormatCountryStringPropertyDefinition());
      this.pStripSyntaxMinUpperBoundAttributeTypeDescription = impl.getPropertyValue(INSTANCE.getStripSyntaxMinUpperBoundAttributeTypeDescriptionPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void addCoreSchemaChangeListener(
        ConfigurationChangeListener<CoreSchemaCfg> listener) {
      impl.registerChangeListener(listener);
    }



    /**
     * {@inheritDoc}
     */
    public void removeCoreSchemaChangeListener(
        ConfigurationChangeListener<CoreSchemaCfg> listener) {
      impl.deregisterChangeListener(listener);
    }
    /**
     * {@inheritDoc}
     */
    public void addChangeListener(
        ConfigurationChangeListener<SchemaProviderCfg> listener) {
      impl.registerChangeListener(listener);
    }



    /**
     * {@inheritDoc}
     */
    public void removeChangeListener(
        ConfigurationChangeListener<SchemaProviderCfg> listener) {
      impl.deregisterChangeListener(listener);
    }



    /**
     * {@inheritDoc}
     */
    public boolean isAllowZeroLengthValuesDirectoryString() {
      return pAllowZeroLengthValuesDirectoryString;
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<String> getDisabledMatchingRule() {
      return pDisabledMatchingRule;
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<String> getDisabledSyntax() {
      return pDisabledSyntax;
    }



    /**
     * {@inheritDoc}
     */
    public boolean isEnabled() {
      return pEnabled;
    }



    /**
     * {@inheritDoc}
     */
    public String getJavaClass() {
      return pJavaClass;
    }



    /**
     * {@inheritDoc}
     */
    public boolean isStrictFormatCountryString() {
      return pStrictFormatCountryString;
    }



    /**
     * {@inheritDoc}
     */
    public boolean isStripSyntaxMinUpperBoundAttributeTypeDescription() {
      return pStripSyntaxMinUpperBoundAttributeTypeDescription;
    }



    /**
     * {@inheritDoc}
     */
    public Class<? extends CoreSchemaCfg> configurationClass() {
      return CoreSchemaCfg.class;
    }



    /**
     * {@inheritDoc}
     */
    public DN dn() {
      return impl.getDN();
    }

  }
}
