/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.server;



import java.util.SortedSet;
import org.opends.server.admin.server.ConfigurationChangeListener;



/**
 * A server-side interface for querying Core Schema settings.
 * <p>
 * Core Schema define the core schema elements to load.
 */
public interface CoreSchemaCfg extends SchemaProviderCfg {

  /**
   * Gets the configuration class associated with this Core Schema.
   *
   * @return Returns the configuration class associated with this Core Schema.
   */
  Class<? extends CoreSchemaCfg> configurationClass();



  /**
   * Register to be notified when this Core Schema is changed.
   *
   * @param listener
   *          The Core Schema configuration change listener.
   */
  void addCoreSchemaChangeListener(ConfigurationChangeListener<CoreSchemaCfg> listener);



  /**
   * Deregister an existing Core Schema configuration change listener.
   *
   * @param listener
   *          The Core Schema configuration change listener.
   */
  void removeCoreSchemaChangeListener(ConfigurationChangeListener<CoreSchemaCfg> listener);



  /**
   * Gets the "allow-zero-length-values-directory-string" property.
   * <p>
   * Indicates whether zero-length (that is, an empty string) values
   * are allowed for directory string.
   * <p>
   * This is technically not allowed by the revised LDAPv3
   * specification, but some environments may require it for backward
   * compatibility with servers that do allow it.
   *
   * @return Returns the value of the "allow-zero-length-values-directory-string" property.
   */
  boolean isAllowZeroLengthValuesDirectoryString();



  /**
   * Gets the "disabled-matching-rule" property.
   * <p>
   * The set of disabled matching rules.
   * <p>
   * Matching rules must be specified using the syntax: OID, or use
   * the default value 'NONE' to specify no value.
   *
   * @return Returns an unmodifiable set containing the values of the "disabled-matching-rule" property.
   */
  SortedSet<String> getDisabledMatchingRule();



  /**
   * Gets the "disabled-syntax" property.
   * <p>
   * The set of disabled syntaxes.
   * <p>
   * Syntaxes must be specified using the syntax: OID, or use the
   * default value 'NONE' to specify no value.
   *
   * @return Returns an unmodifiable set containing the values of the "disabled-syntax" property.
   */
  SortedSet<String> getDisabledSyntax();



  /**
   * Gets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the Core Schema implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();



  /**
   * Gets the "strict-format-country-string" property.
   * <p>
   * Indicates whether or not country code values are required to
   * strictly comply with the standard definition for this syntax.
   * <p>
   * When set to false, country codes will not be validated and, as a
   * result any string containing 2 characters will be acceptable.
   *
   * @return Returns the value of the "strict-format-country-string" property.
   */
  boolean isStrictFormatCountryString();



  /**
   * Gets the "strip-syntax-min-upper-bound-attribute-type-description" property.
   * <p>
   * Indicates whether the suggested minimum upper bound appended to
   * an attribute's syntax OID in it's schema definition Attribute Type
   * Description is stripped off.
   * <p>
   * When retrieving the server's schema, some APIs (JNDI) fail in
   * their syntax lookup methods, because they do not parse this value
   * correctly. This configuration option allows the server to be
   * configured to provide schema definitions these APIs can parse
   * correctly.
   *
   * @return Returns the value of the "strip-syntax-min-upper-bound-attribute-type-description" property.
   */
  boolean isStripSyntaxMinUpperBoundAttributeTypeDescription();

}
