/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.server;



import org.opends.server.admin.server.ConfigurationChangeListener;



/**
 * A server-side interface for querying HTTP Access Log Publisher
 * settings.
 * <p>
 * HTTP Access Log Publishers are responsible for distributing HTTP
 * access log messages from the HTTP access logger to a destination.
 */
public interface HTTPAccessLogPublisherCfg extends LogPublisherCfg {

  /**
   * Gets the configuration class associated with this HTTP Access Log Publisher.
   *
   * @return Returns the configuration class associated with this HTTP Access Log Publisher.
   */
  Class<? extends HTTPAccessLogPublisherCfg> configurationClass();



  /**
   * Register to be notified when this HTTP Access Log Publisher is changed.
   *
   * @param listener
   *          The HTTP Access Log Publisher configuration change listener.
   */
  void addHTTPAccessChangeListener(ConfigurationChangeListener<HTTPAccessLogPublisherCfg> listener);



  /**
   * Deregister an existing HTTP Access Log Publisher configuration change listener.
   *
   * @param listener
   *          The HTTP Access Log Publisher configuration change listener.
   */
  void removeHTTPAccessChangeListener(ConfigurationChangeListener<HTTPAccessLogPublisherCfg> listener);



  /**
   * Gets the "java-class" property.
   * <p>
   * The fully-qualified name of the Java class that provides the HTTP
   * Access Log Publisher implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();

}
