/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.server;



import org.opends.server.admin.server.ConfigurationChangeListener;



/**
 * A server-side interface for querying JPEG Attribute Syntax
 * settings.
 * <p>
 * JPEG Attribute Syntaxes define an attribute syntax for storing JPEG
 * information.
 */
public interface JPEGAttributeSyntaxCfg extends AttributeSyntaxCfg {

  /**
   * Gets the configuration class associated with this JPEG Attribute Syntax.
   *
   * @return Returns the configuration class associated with this JPEG Attribute Syntax.
   */
  Class<? extends JPEGAttributeSyntaxCfg> configurationClass();



  /**
   * Register to be notified when this JPEG Attribute Syntax is changed.
   *
   * @param listener
   *          The JPEG Attribute Syntax configuration change listener.
   */
  void addJPEGChangeListener(ConfigurationChangeListener<JPEGAttributeSyntaxCfg> listener);



  /**
   * Deregister an existing JPEG Attribute Syntax configuration change listener.
   *
   * @param listener
   *          The JPEG Attribute Syntax configuration change listener.
   */
  void removeJPEGChangeListener(ConfigurationChangeListener<JPEGAttributeSyntaxCfg> listener);



  /**
   * Gets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the JPEG Attribute Syntax implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();



  /**
   * Gets the "strict-format" property.
   * <p>
   * Indicates whether to require JPEG values to strictly comply with
   * the standard definition for this syntax.
   *
   * @return Returns the value of the "strict-format" property.
   */
  boolean isStrictFormat();

}
