/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.server;



import org.opends.server.admin.server.ConfigurationChangeListener;



/**
 * A server-side interface for querying PKCS5S2 Password Storage
 * Scheme settings.
 * <p>
 * The PKCS5S2 Password Storage Scheme provides a mechanism for
 * encoding user passwords using the Atlassian PBKDF2-based message
 * digest algorithm.
 */
public interface PKCS5S2PasswordStorageSchemeCfg extends PasswordStorageSchemeCfg {

  /**
   * Gets the configuration class associated with this PKCS5S2 Password Storage Scheme.
   *
   * @return Returns the configuration class associated with this PKCS5S2 Password Storage Scheme.
   */
  Class<? extends PKCS5S2PasswordStorageSchemeCfg> configurationClass();



  /**
   * Register to be notified when this PKCS5S2 Password Storage Scheme is changed.
   *
   * @param listener
   *          The PKCS5S2 Password Storage Scheme configuration change listener.
   */
  void addPKCS5S2ChangeListener(ConfigurationChangeListener<PKCS5S2PasswordStorageSchemeCfg> listener);



  /**
   * Deregister an existing PKCS5S2 Password Storage Scheme configuration change listener.
   *
   * @param listener
   *          The PKCS5S2 Password Storage Scheme configuration change listener.
   */
  void removePKCS5S2ChangeListener(ConfigurationChangeListener<PKCS5S2PasswordStorageSchemeCfg> listener);



  /**
   * Gets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the PKCS5S2 Password Storage Scheme implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();

}
