/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.server;



import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ConfigurationChangeListener;



/**
 * A server-side interface for querying Password Generator settings.
 * <p>
 * Password Generators are used by the password modify extended
 * operation to construct a new password for the user.
 */
public interface PasswordGeneratorCfg extends Configuration {

  /**
   * Gets the configuration class associated with this Password Generator.
   *
   * @return Returns the configuration class associated with this Password Generator.
   */
  Class<? extends PasswordGeneratorCfg> configurationClass();



  /**
   * Register to be notified when this Password Generator is changed.
   *
   * @param listener
   *          The Password Generator configuration change listener.
   */
  void addChangeListener(ConfigurationChangeListener<PasswordGeneratorCfg> listener);



  /**
   * Deregister an existing Password Generator configuration change listener.
   *
   * @param listener
   *          The Password Generator configuration change listener.
   */
  void removeChangeListener(ConfigurationChangeListener<PasswordGeneratorCfg> listener);



  /**
   * Gets the "enabled" property.
   * <p>
   * Indicates whether the Password Generator is enabled for use.
   *
   * @return Returns the value of the "enabled" property.
   */
  boolean isEnabled();



  /**
   * Gets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the Password Generator implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();

}
