/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.server;



import org.opends.server.admin.server.ConfigurationChangeListener;



/**
 * A server-side interface for querying Password Policy State Extended
 * Operation Handler settings.
 * <p>
 * The Password Policy State Extended Operation Handler provides the
 * ability for administrators to request and optionally alter password
 * policy state information for a specified user.
 */
public interface PasswordPolicyStateExtendedOperationHandlerCfg extends ExtendedOperationHandlerCfg {

  /**
   * Gets the configuration class associated with this Password Policy State Extended Operation Handler.
   *
   * @return Returns the configuration class associated with this Password Policy State Extended Operation Handler.
   */
  Class<? extends PasswordPolicyStateExtendedOperationHandlerCfg> configurationClass();



  /**
   * Register to be notified when this Password Policy State Extended Operation Handler is changed.
   *
   * @param listener
   *          The Password Policy State Extended Operation Handler configuration change listener.
   */
  void addPasswordPolicyStateChangeListener(ConfigurationChangeListener<PasswordPolicyStateExtendedOperationHandlerCfg> listener);



  /**
   * Deregister an existing Password Policy State Extended Operation Handler configuration change listener.
   *
   * @param listener
   *          The Password Policy State Extended Operation Handler configuration change listener.
   */
  void removePasswordPolicyStateChangeListener(ConfigurationChangeListener<PasswordPolicyStateExtendedOperationHandlerCfg> listener);



  /**
   * Gets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the Password Policy State Extended Operation Handler
   * implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();

}
