/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.server;



import org.opends.server.admin.server.ConfigurationChangeListener;



/**
 * A server-side interface for querying Stack Trace Monitor Provider
 * settings.
 * <p>
 * The Stack Trace Monitor Provider enables clients to obtain a stack
 * trace of all the threads that are currently running in the directory
 * server.
 */
public interface StackTraceMonitorProviderCfg extends MonitorProviderCfg {

  /**
   * Gets the configuration class associated with this Stack Trace Monitor Provider.
   *
   * @return Returns the configuration class associated with this Stack Trace Monitor Provider.
   */
  Class<? extends StackTraceMonitorProviderCfg> configurationClass();



  /**
   * Register to be notified when this Stack Trace Monitor Provider is changed.
   *
   * @param listener
   *          The Stack Trace Monitor Provider configuration change listener.
   */
  void addStackTraceChangeListener(ConfigurationChangeListener<StackTraceMonitorProviderCfg> listener);



  /**
   * Deregister an existing Stack Trace Monitor Provider configuration change listener.
   *
   * @param listener
   *          The Stack Trace Monitor Provider configuration change listener.
   */
  void removeStackTraceChangeListener(ConfigurationChangeListener<StackTraceMonitorProviderCfg> listener);



  /**
   * Gets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the Stack Trace Monitor Provider implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();

}
