/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.server;



import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ConfigurationChangeListener;



/**
 * A server-side interface for querying Synchronization Provider
 * settings.
 * <p>
 * Synchronization Providers are responsible for handling
 * synchronization of the directory server data with other OpenDJ
 * instances or other data repositories.
 */
public interface SynchronizationProviderCfg extends Configuration {

  /**
   * Gets the configuration class associated with this Synchronization Provider.
   *
   * @return Returns the configuration class associated with this Synchronization Provider.
   */
  Class<? extends SynchronizationProviderCfg> configurationClass();



  /**
   * Register to be notified when this Synchronization Provider is changed.
   *
   * @param listener
   *          The Synchronization Provider configuration change listener.
   */
  void addChangeListener(ConfigurationChangeListener<SynchronizationProviderCfg> listener);



  /**
   * Deregister an existing Synchronization Provider configuration change listener.
   *
   * @param listener
   *          The Synchronization Provider configuration change listener.
   */
  void removeChangeListener(ConfigurationChangeListener<SynchronizationProviderCfg> listener);



  /**
   * Gets the "enabled" property.
   * <p>
   * Indicates whether the Synchronization Provider is enabled for
   * use.
   *
   * @return Returns the value of the "enabled" property.
   */
  boolean isEnabled();



  /**
   * Gets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the Synchronization Provider implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();

}
