/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.server;



import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ConfigurationChangeListener;



/**
 * A server-side interface for querying Work Queue settings.
 * <p>
 * The Work Queue provides the configuration for the server work queue
 * and is responsible for ensuring that requests received from clients
 * are processed in a timely manner.
 */
public interface WorkQueueCfg extends Configuration {

  /**
   * Gets the configuration class associated with this Work Queue.
   *
   * @return Returns the configuration class associated with this Work Queue.
   */
  Class<? extends WorkQueueCfg> configurationClass();



  /**
   * Register to be notified when this Work Queue is changed.
   *
   * @param listener
   *          The Work Queue configuration change listener.
   */
  void addChangeListener(ConfigurationChangeListener<WorkQueueCfg> listener);



  /**
   * Deregister an existing Work Queue configuration change listener.
   *
   * @param listener
   *          The Work Queue configuration change listener.
   */
  void removeChangeListener(ConfigurationChangeListener<WorkQueueCfg> listener);



  /**
   * Gets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the Work Queue implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();

}
