/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2006-2008 Sun Microsystems, Inc.
 *      Portions Copyright 2011-2013 ForgeRock AS
 */
package org.opends.server.core;

import org.opends.server.types.DirectoryException;
import org.opends.server.types.Operation;

/**
 *
 * This class implements the "synchronous" strategy, that is the operation
 * is directly handled, without going to the work queue.
 */
public class SynchronousStrategy implements QueueingStrategy {

  /**
   * Run the request synchronously.
   *
   * @param operation Operation to run.
   * @throws org.opends.server.types.DirectoryException
   *          If a problem occurs in the Directory Server.
   */
  @Override
  public void enqueueRequest(Operation operation) throws DirectoryException {
    operation.run();
    operation.operationCompleted();
  }
}
