/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2006-2008 Sun Microsystems, Inc.
 *      Portions Copyright 2014-2015 ForgeRock AS
 */
package org.opends.server.types.operation;



import java.util.List;
import java.util.Map;

import org.opends.server.types.*;
import org.forgerock.opendj.ldap.ByteString;


/**
 * This class defines a set of methods that are available for use by
 * post-response plugins for add operations.  Note that this interface
 * is intended only to define an API for use by plugins and is not
 * intended to be implemented by any custom classes.
 */
@org.opends.server.types.PublicAPI(
     stability=org.opends.server.types.StabilityLevel.UNCOMMITTED,
     mayInstantiate=false,
     mayExtend=false,
     mayInvoke=true)
public interface PostResponseAddOperation
       extends PostResponseOperation
{
  /**
   * Retrieves the DN of the entry to add in a raw, unparsed form as
   * it was included in the request.  This may or may not actually
   * contain a valid DN, since no validation will have been performed
   * on it.
   *
   * @return  The DN of the entry in a raw, unparsed form.
   */
  ByteString getRawEntryDN();



  /**
   * Retrieves the set of attributes in their raw, unparsed form as
   * read from the client request.  Some of these attributes may be
   * invalid as no validation will have been performed on them.  The
   * returned list must not be altered by the caller.
   *
   * @return  The set of attributes in their raw, unparsed form as
   *          read from the client request.
   */
  List<RawAttribute> getRawAttributes();



  /**
   * Retrieves the DN of the entry to add.
   *
   * @return  The DN of the entry to add.
   */
  DN getEntryDN();



  /**
   * Retrieves the set of processed objectclasses for the entry to
   * add.  The contents of the returned map must not be altered by the
   * caller.
   *
   * @return  The set of processed objectclasses for the entry to add.
   */
  Map<ObjectClass,String> getObjectClasses();



  /**
   * Retrieves the set of processed user attributes for the entry to
   * add.  The contents of the returned map must not be altered by the
   * caller.
   *
   * @return  The set of processed user attributes for the entry to
   *          add.
   */
  Map<AttributeType,List<Attribute>> getUserAttributes();



  /**
   * Retrieves the set of processed operational attributes for the
   * entry to add.  The contents of the returned map must not be
   * altered by the caller.
   *
   * @return  The set of processed operational attributes for the
   *          entry to add.
   */
  Map<AttributeType, List<Attribute>> getOperationalAttributes();

  /**
   * Retrieves the entry to be added to the server.  The contents of
   * the returned entry must not be altered by the caller.
   *
   * @return  The entry to be added to the server.
   */
  Entry getEntryToAdd();
}

