package org.opends.messages;

import org.forgerock.i18n.LocalizableMessageDescriptor;

/**
 * This file contains localizable message descriptors having the resource
 * name {@code org.opends.messages.dsconfig}. This file was generated
 * automatically by the {@code i18n-maven-plugin} from the property file
 * {@code org/opends/messages/dsconfig.properties} and it should not be manually edited.
 */
public final class DsconfigMessages {
    // The name of the resource bundle.
    private static final String RESOURCE = "org.opends.messages.dsconfig";

    // Prevent instantiation.
    private DsconfigMessages() {
        // Do nothing.
    }

    /**
     * Returns the name of the resource associated with the messages contained
     * in this class. The resource name may be used for obtaining named loggers,
     * e.g. using SLF4J's {@code org.slf4j.LoggerFactory#getLogger(String name)}.
     *
     * @return The name of the resource associated with the messages contained
     *         in this class.
     */
    public static String resourceName() {
        return RESOURCE;
    }

    /**
     * Select one or more %s for the "%s" property:
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> INFO_EDITOR_PROMPT_SELECT_COMPONENT_MULTI =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_PROMPT_SELECT_COMPONENT_MULTI_127", 127);

    /**
     * Select a %s for the "%s" property:
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> INFO_EDITOR_PROMPT_SELECT_COMPONENT_SINGLE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_PROMPT_SELECT_COMPONENT_SINGLE_128", 128);

    /**
     * The "%s" property references the following %s:
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> INFO_EDITOR_HEADING_COMPONENT_SUMMARY =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_HEADING_COMPONENT_SUMMARY_129", 129);

    /**
     * Select the %s you wish to add:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_PROMPT_SELECT_COMPONENTS_ADD =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_PROMPT_SELECT_COMPONENTS_ADD_130", 130);

    /**
     * Add all %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_ADD_ALL_COMPONENTS =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_ADD_ALL_COMPONENTS_131", 131);

    /**
     * Select the %s you wish to remove:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_PROMPT_SELECT_COMPONENTS_REMOVE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_PROMPT_SELECT_COMPONENTS_REMOVE_132", 132);

    /**
     * Change it to the default %s: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> INFO_EDITOR_OPTION_CHANGE_TO_DEFAULT_COMPONENT =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_CHANGE_TO_DEFAULT_COMPONENT_133", 133);

    /**
     * Change it to the %s: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> INFO_EDITOR_OPTION_CHANGE_TO_COMPONENT =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_CHANGE_TO_COMPONENT_134", 134);

    /**
     * The referenced %s called "%s" must be enabled so that it can be used with this %s. Do you want to enable it?
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> INFO_EDITOR_PROMPT_ENABLED_REFERENCED_COMPONENT =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_PROMPT_ENABLED_REFERENCED_COMPONENT_135", 135);

    /**
     * The modifications to the %s cannot be made because it contains a reference to a disabled %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_SET_REFERENCED_COMPONENT_DISABLED =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_SET_REFERENCED_COMPONENT_DISABLED_136", 136);

    /**
     * The %s could not be created because the following mandatory property was not defined:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_CREATE_HEADING_MMPE_SINGLE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_CREATE_HEADING_MMPE_SINGLE_138", 138);

    /**
     * The %s could not be created because the following mandatory properties were not defined:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_CREATE_HEADING_MMPE_PLURAL =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_CREATE_HEADING_MMPE_PLURAL_139", 139);

    /**
     * The %s could not be modified because the following mandatory property was not defined:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_MODIFY_HEADING_MMPE_SINGLE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_MODIFY_HEADING_MMPE_SINGLE_140", 140);

    /**
     * The %s could not be modified because the following mandatory properties were not defined:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_MODIFY_HEADING_MMPE_PLURAL =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_MODIFY_HEADING_MMPE_PLURAL_141", 141);

    /**
     * Would you like to edit the properties of the %s in order to resolve this problem?
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_PROMPT_EDIT =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_PROMPT_EDIT_142", 142);

    /**
     * The %s could not be decoded due to the following reason:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_GET_HEADING_MODE_SINGLE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_GET_HEADING_MODE_SINGLE_143", 143);

    /**
     * The %s could not be decoded due to the following reasons:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_GET_HEADING_MODE_PLURAL =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_GET_HEADING_MODE_PLURAL_144", 144);

    /**
     * Create a new %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_CREATE_A_NEW_COMPONENT =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_CREATE_A_NEW_COMPONENT_145", 145);

    /**
     * The referenced %s called "%s" must be enabled so that it can be used with this %s. Do you want to edit its properties in order to enable it?
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> INFO_DSCFG_PROMPT_EDIT_TO_ENABLE =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_PROMPT_EDIT_TO_ENABLE_146", 146);

    /**
     * Custom %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_CUSTOM_TYPE_OPTION =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_CUSTOM_TYPE_OPTION_147", 147);

    /**
     * A Custom %s with a user-defined implementation class
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_CUSTOM_TYPE_SYNOPSIS =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_CUSTOM_TYPE_SYNOPSIS_148", 148);

    /**
     * A Generic %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_GENERIC_TYPE_SYNOPSIS =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_GENERIC_TYPE_SYNOPSIS_149", 149);

    /**
     * Help: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_CREATE_TYPE_HELP_HEADING =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_CREATE_TYPE_HELP_HEADING_150", 150);

    /**
     * The equivalent non-interactive command-line is:%n%s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_NON_INTERACTIVE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_NON_INTERACTIVE_151", 151);

    /**
     * Display the equivalent non-interactive argument in the standard output when this command is run in interactive mode
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_DISPLAY_EQUIVALENT =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_DISPLAY_EQUIVALENT_152", 152);

    /**
     * The full path to the file where the equivalent non-interactive commands will be written when this command is run in interactive mode
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_EQUIVALENT_COMMAND_FILE_PATH =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_EQUIVALENT_COMMAND_FILE_PATH_153", 153);

    /**
     * An error occurred while attempting to write equivalent non-interactive command line to file %s. Error details: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_DSCFG_ERROR_WRITING_EQUIVALENT_COMMAND_LINE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_WRITING_EQUIVALENT_COMMAND_LINE_154", 154);

    /**
     * Cannot write to file %s. Verify that you have access rights to that file and that you provided the full path of the file
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_CANNOT_WRITE_EQUIVALENT_COMMAND_LINE_FILE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_CANNOT_WRITE_EQUIVALENT_COMMAND_LINE_FILE_155", 155);

    /**
     * The specified path %s to write the equivalent command is a directory. You must specify a path to a file
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_EQUIVALENT_COMMAND_LINE_FILE_DIRECTORY =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_EQUIVALENT_COMMAND_LINE_FILE_DIRECTORY_156", 156);

    /**
     * Unable to connect to the server at %s on port %s. In non-interactive mode, if the trustStore related parameters are not used, you must use the '--trustAll' option for remote connections
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT_NOT_TRUSTED =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT_NOT_TRUSTED_158", 158);

    /**
     * The value %s for the %s property does not exist
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_DSCFG_ERROR_VALUE_DOES_NOT_EXIST =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_VALUE_DOES_NOT_EXIST_159", 159);

    /**
     * Unable to continue since there are no available types of %s to choose from
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_NO_AVAILABLE_TYPES =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_NO_AVAILABLE_TYPES_160", 160);

    /**
     * >>>> There is only one type of %s available: "%s". Are you sure that this is the correct one?
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> INFO_DSCFG_TYPE_PROMPT_SINGLE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_TYPE_PROMPT_SINGLE_161", 161);

    /**
     * An error occurred while attempting to read the batch file : %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_READING_BATCH_FILE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_READING_BATCH_FILE_162", 162);

    /**
     * %s session start date: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> INFO_DSCFG_SESSION_START_TIME_MESSAGE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_SESSION_START_TIME_MESSAGE_163", 163);

    /**
     * Session operation number: %d
     */
    public static final LocalizableMessageDescriptor.Arg1<Number> INFO_DSCFG_EQUIVALENT_COMMAND_LINE_SESSION_OPERATION_NUMBER =
                    new LocalizableMessageDescriptor.Arg1<Number>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_EQUIVALENT_COMMAND_LINE_SESSION_OPERATION_NUMBER_164", 164);

    /**
     * The connection parameters could not be read due to the following error: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_CANNOT_READ_CONNECTION_PARAMETERS =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_CANNOT_READ_CONNECTION_PARAMETERS_1000", 1000);

    /**
     * Unable to authenticate to the server as "%s"
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_LDAP_SIMPLE_BIND_FAILED =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_LDAP_SIMPLE_BIND_FAILED_1001", 1001);

    /**
     * Unable to connect to the server at "%s" on port %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT_1002", 1002);

    /**
     * Unable to authenticate using simple authentication
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_DSCFG_ERROR_LDAP_SIMPLE_BIND_NOT_SUPPORTED =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_LDAP_SIMPLE_BIND_NOT_SUPPORTED_1003", 1003);

    /**
     * Creates %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_DESCRIPTION_SUBCMD_CREATE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_SUBCMD_CREATE_1004", 1004);

    /**
     * Deletes %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_DESCRIPTION_SUBCMD_DELETE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_SUBCMD_DELETE_1005", 1005);

    /**
     * Lists existing %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_DESCRIPTION_SUBCMD_LIST =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_SUBCMD_LIST_1006", 1006);

    /**
     * Shows %s properties
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_DESCRIPTION_SUBCMD_GETPROP =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_SUBCMD_GETPROP_1007", 1007);

    /**
     * Modifies %s properties
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_DESCRIPTION_SUBCMD_SETPROP =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_SUBCMD_SETPROP_1008", 1008);

    /**
     * A sub-command must be specified
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_DSCFG_ERROR_MISSING_SUBCOMMAND =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_MISSING_SUBCOMMAND_1009", 1009);

    /**
     * The type of %s which should be created. The value for TYPE can be one of: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> INFO_DSCFG_DESCRIPTION_TYPE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_TYPE_1010", 1010);

    /**
     * No password was specified for administrator "%s"
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_NO_PASSWORD =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_NO_PASSWORD_1011", 1011);

    /**
     * The property "%s" is not a recognized property of %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_DSCFG_ERROR_PROPERTY_UNRECOGNIZED =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_PROPERTY_UNRECOGNIZED_1012", 1012);

    /**
     * The value "%s" is not a valid value for the %s property "%s" which has the following syntax: %s
     */
    public static final LocalizableMessageDescriptor.Arg4<Object, Object, Object, Object> ERR_DSCFG_ERROR_PROPERTY_INVALID_VALUE =
                    new LocalizableMessageDescriptor.Arg4<Object, Object, Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_PROPERTY_INVALID_VALUE_1013", 1013);

    /**
     * The %s property "%s" is read-only and cannot be modified
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_DSCFG_ERROR_PROPERTY_READ_ONLY =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_PROPERTY_READ_ONLY_1014", 1014);

    /**
     * The %s property "%s" is mandatory and must be specified
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_DSCFG_ERROR_PROPERTY_MANDATORY =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_PROPERTY_MANDATORY_1015", 1015);

    /**
     * It is not possible to specify multiple values for the %s property "%s" as it is single-valued
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_DSCFG_ERROR_PROPERTY_SINGLE_VALUED =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_PROPERTY_SINGLE_VALUED_1016", 1016);

    /**
     * Describes managed objects and their properties
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_SUBCMD_HELPPROP =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_SUBCMD_HELPPROP_1017", 1017);

    /**
     * Component
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HEADING_COMPONENT_NAME =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HEADING_COMPONENT_NAME_1018", 1018);

    /**
     * Property
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HEADING_PROPERTY_NAME =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HEADING_PROPERTY_NAME_1019", 1019);

    /**
     * Value(s)
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HEADING_PROPERTY_VALUE =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HEADING_PROPERTY_VALUE_1020", 1020);

    /**
     * Syntax
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HEADING_PROPERTY_SYNTAX =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HEADING_PROPERTY_SYNTAX_1021", 1021);

    /**
     * Options
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HEADING_PROPERTY_OPTIONS =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HEADING_PROPERTY_OPTIONS_1022", 1022);

    /**
     * See detailed help
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_PROPERTY_SYNTAX_HELP =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_PROPERTY_SYNTAX_HELP_1025", 1025);

    /**
     * The parent %s could not be retrieved because its type could not be determined. This is probably due to the %s having an invalid LDAP entry. Check that the %s has the correct object classes
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> ERR_DSCFG_ERROR_GET_PARENT_DDE =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_GET_PARENT_DDE_1026", 1026);

    /**
     * The parent %s could not be retrieved because of the reasons listed below:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_GET_PARENT_MODE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_GET_PARENT_MODE_1027", 1027);

    /**
     * The parent %s does not exist
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_GET_PARENT_MONFE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_GET_PARENT_MONFE_1028", 1028);

    /**
     * The %s could not be created because there is already an existing one with the same name
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_CREATE_MOAEE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_CREATE_MOAEE_1033", 1033);

    /**
     * The %s could not be created because you do not have the correct authorization
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_CREATE_AUTHZ =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_CREATE_AUTHZ_1034", 1034);

    /**
     * The %s could not be created due to a communications problem: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_DSCFG_ERROR_CREATE_CE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_CREATE_CE_1035", 1035);

    /**
     * The %s could not be created because another client is currently making conflicting configuration changes
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_CREATE_CME =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_CREATE_CME_1036", 1036);

    /**
     * The %s could not be deleted because it does not exist
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_DELETE_MONFE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_DELETE_MONFE_1038", 1038);

    /**
     * The %s could not be deleted because you do not have the correct authorization
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_DELETE_AUTHZ =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_DELETE_AUTHZ_1039", 1039);

    /**
     * The %s could not be deleted due to a communications problem: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_DSCFG_ERROR_DELETE_CE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_DELETE_CE_1041", 1041);

    /**
     * The %s could not be deleted because another client is currently making conflicting configuration changes
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_DELETE_CME =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_DELETE_CME_1042", 1042);

    /**
     * The %s could not be retrieved because its type could not be determined. This is probably due to the %s having an invalid LDAP entry. Check that the %s object classes are correct
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> ERR_DSCFG_ERROR_GET_CHILD_DDE =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_GET_CHILD_DDE_1043", 1043);

    /**
     * The %s could not be retrieved because of the reasons listed below:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_GET_CHILD_MODE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_GET_CHILD_MODE_1044", 1044);

    /**
     * The %s does not exist
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_GET_CHILD_MONFE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_GET_CHILD_MONFE_1045", 1045);

    /**
     * The %s could not be accessed because you do not have the correct authorization
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_GET_CHILD_AUTHZ =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_GET_CHILD_AUTHZ_1046", 1046);

    /**
     * The %s could not be accessed due to a communications problem: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_DSCFG_ERROR_GET_CHILD_CE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_GET_CHILD_CE_1047", 1047);

    /**
     * The %s could not be accessed because another client is currently making conflicting configuration changes
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_GET_CHILD_CME =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_GET_CHILD_CME_1048", 1048);

    /**
     * The %s could not be modified because you do not have the correct authorization
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_MODIFY_AUTHZ =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_MODIFY_AUTHZ_1050", 1050);

    /**
     * The %s could not be modified due to a communications problem: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_DSCFG_ERROR_MODIFY_CE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_MODIFY_CE_1051", 1051);

    /**
     * The %s could not be modified because another client is currently making conflicting configuration changes
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_MODIFY_CME =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_MODIFY_CME_1052", 1052);

    /**
     * The %s could not be retrieved because its type could not be determined. This is probably due to the %s having an invalid LDAP entry. Check that the %s object classes are correct
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> ERR_DSCFG_ERROR_LIST_DDE =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_LIST_DDE_1054", 1054);

    /**
     * The %s could not be retrieved because of the reasons listed below:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_LIST_MODE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_LIST_MODE_1055", 1055);

    /**
     * The %s does not exist
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_LIST_MONFE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_LIST_MONFE_1056", 1056);

    /**
     * The %s could not be listed because you do not have the correct authorization
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_LIST_AUTHZ =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_LIST_AUTHZ_1057", 1057);

    /**
     * The %s could not be listed due to a communications problem: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_DSCFG_ERROR_LIST_CE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_LIST_CE_1058", 1058);

    /**
     * The %s could not be listed because another client is currently making conflicting configuration changes
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_LIST_CME =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_LIST_CME_1059", 1059);

    /**
     * The value(s) of the %s property "%s" could not be determined due to an unknown error: %s
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> ERR_DSCFG_ERROR_PROPERTY_UNKNOWN_ERROR =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_PROPERTY_UNKNOWN_ERROR_1060", 1060);

    /**
     * The default value(s) of the %s property "%s" could not be determined due to the following reason: %s
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> ERR_DSCFG_ERROR_PROPERTY_DEFAULT_BEHAVIOR =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_PROPERTY_DEFAULT_BEHAVIOR_1061", 1061);

    /**
     * The property argument "%s" does not contain a name/value separator. The argument should have the following syntax: property:value
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_NO_SEPARATOR_IN_PROPERTY_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_NO_SEPARATOR_IN_PROPERTY_VALUE_1063", 1063);

    /**
     * The property argument "%s" does not contain a property name. The argument should have the following syntax: property:value
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_NO_NAME_IN_PROPERTY_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_NO_NAME_IN_PROPERTY_VALUE_1064", 1064);

    /**
     * The property argument "%s" does not contain a property value. The argument should have the following syntax: property:value
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_NO_VALUE_IN_PROPERTY_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_NO_VALUE_IN_PROPERTY_VALUE_1065", 1065);

    /**
     * The sub-type "%s" is not a recognized type of %s. It should be one of: %s
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> ERR_DSCFG_ERROR_SUB_TYPE_UNRECOGNIZED =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_SUB_TYPE_UNRECOGNIZED_1066", 1066);

    /**
     * The property modification "%s" does not contain a name/value separator. The argument should have the following syntax: property[+|-]:value
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_NO_SEPARATOR_IN_PROPERTY_MOD =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_NO_SEPARATOR_IN_PROPERTY_MOD_1068", 1068);

    /**
     * The property modification "%s" does not contain a property name. The argument should have the following syntax: property[+|-]:value
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_NO_NAME_IN_PROPERTY_MOD =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_NO_NAME_IN_PROPERTY_MOD_1069", 1069);

    /**
     * The property modification "%s" is incompatible with another modification to the same property
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_INCOMPATIBLE_PROPERTY_MOD =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_INCOMPATIBLE_PROPERTY_MOD_1071", 1071);

    /**
     * The type of %s which should be created (Default: %s). The value for TYPE can be one of: %s
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> INFO_DSCFG_DESCRIPTION_TYPE_DEFAULT =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_TYPE_DEFAULT_1073", 1073);

    /**
     * Modifies the display output to show one property value per line
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_RECORD =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_RECORD_1074", 1074);

    /**
     * Display time data using the specified unit. The value for UNIT can be one of ms, s, m, h, d, or w (milliseconds, seconds, minutes, hours, days, or weeks)
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_UNIT_TIME =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_UNIT_TIME_1078", 1078);

    /**
     * Display size data using the specified unit. The value for UNIT can be one of b, kb, mb, gb, or tb (bytes, kilobytes, megabytes, gigabytes, or terabytes)
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_UNIT_SIZE =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_UNIT_SIZE_1079", 1079);

    /**
     * The time unit "%s" is invalid. The valid time units are ms, s, m, h, d, or w (milliseconds, seconds, minutes, hours, days, or weeks)
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_ERROR_TIME_UNIT_UNRECOGNIZED =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_ERROR_TIME_UNIT_UNRECOGNIZED_1080", 1080);

    /**
     * The size unit "%s" is invalid. The valid size units are b, kb, mb, gb, or tb (bytes, kilobytes, megabytes, gigabytes, or terabytes)
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_ERROR_SIZE_UNIT_UNRECOGNIZED =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_ERROR_SIZE_UNIT_UNRECOGNIZED_1081", 1081);

    /**
     * Type
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HEADING_COMPONENT_TYPE =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HEADING_COMPONENT_TYPE_1082", 1082);

    /**
     * Display subcommands relating to %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_DESCRIPTION_SHOW_GROUP_USAGE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_SHOW_GROUP_USAGE_1083", 1083);

    /**
     * Display all subcommands
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_SHOW_GROUP_USAGE_ALL =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_SHOW_GROUP_USAGE_ALL_1084", 1084);

    /**
     * Display summary usage information
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_SHOW_GROUP_USAGE_SUMMARY =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_SHOW_GROUP_USAGE_SUMMARY_1085", 1085);

    /**
     * The name of the %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_DESCRIPTION_NAME =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_NAME_1086", 1086);

    /**
     * The name of a property to be displayed
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_PROP =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_PROP_1087", 1087);

    /**
     * Assigns a value to a property where PROP is the name of the property and VALUE is the single value to be assigned. Specify the same property multiple times in order to assign more than one value to it
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_PROP_VAL =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_PROP_VAL_1088", 1088);

    /**
     * Adds a single value to a property where PROP is the name of the property and VALUE is the single value to be added
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_ADD_PROP_VAL =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_ADD_PROP_VAL_1089", 1089);

    /**
     * Removes a single value from a property where PROP is the name of the property and VALUE is the single value to be removed
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_REMOVE_PROP_VAL =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_REMOVE_PROP_VAL_1090", 1090);

    /**
     * Resets a property back to its default values where PROP is the name of the property to be reset
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_RESET_PROP =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_RESET_PROP_1091", 1091);

    /**
     * The type of components whose properties should be described. The value for TYPE must be one of the component types associated with the CATEGORY specified using the "--category" option
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_HELP_TYPE =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_HELP_TYPE_1092", 1092);

    /**
     * The LDAP bind password was not specified and cannot be read interactively
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_DSCFG_ERROR_BIND_PASSWORD_NONINTERACTIVE =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_BIND_PASSWORD_NONINTERACTIVE_1093", 1093);

    /**
     * Ignore non-existent %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_DESCRIPTION_FORCE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_FORCE_1196", 1196);

    /**
     * The %s property "%s" is mandatory cannot be reset. Use the "%s" option to specify a new value
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> ERR_DSCFG_ERROR_UNABLE_TO_RESET_MANDATORY_PROPERTY =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_UNABLE_TO_RESET_MANDATORY_PROPERTY_1200", 1200);

    /**
     * "--%s %s" : the argument "--%s" reset the property to the default value. It cannot be used to set a property to a given value
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> ERR_DSCFG_ERROR_UNABLE_TO_RESET_PROPERTY_WITH_VALUE =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_UNABLE_TO_RESET_PROPERTY_WITH_VALUE_1201", 1201);

    /**
     * The name "%s" is not a valid name for the %s which has the following syntax: %s
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> ERR_DSCFG_ERROR_ILLEGAL_NAME_SYNTAX =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_ILLEGAL_NAME_SYNTAX_1204", 1204);

    /**
     * Empty names are not permitted for %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_ILLEGAL_NAME_EMPTY =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_ILLEGAL_NAME_EMPTY_1205", 1205);

    /**
     * Blank names are not permitted for %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_ILLEGAL_NAME_BLANK =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_ILLEGAL_NAME_BLANK_1206", 1206);

    /**
     * The name "%s" is not a valid name for the %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_DSCFG_ERROR_ILLEGAL_NAME_UNKNOWN =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_ILLEGAL_NAME_UNKNOWN_1207", 1207);

    /**
     * The name of the new %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_DESCRIPTION_NAME_CREATE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_NAME_CREATE_1208", 1208);

    /**
     * The name of the new %s which will also be used as the value of the "%s" property: %s
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> INFO_DSCFG_DESCRIPTION_NAME_CREATE_EXT =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_NAME_CREATE_EXT_1209", 1209);

    /**
     * The property "%s" cannot be set as it is defined implicitly by the name of the %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_DSCFG_ERROR_UNABLE_TO_SET_NAMING_PROPERTY =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_UNABLE_TO_SET_NAMING_PROPERTY_1210", 1210);

    /**
     * Allows the configuration of advanced components and properties
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_ADVANCED =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_ADVANCED_1216", 1216);

    /**
     * The argument "--%s" must be specified when this application is used non-interactively
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_MISSING_NON_INTERACTIVE_ARG =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_MISSING_NON_INTERACTIVE_ARG_1223", 1223);

    /**
     * >>>> Select the type of %s that you want to create:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_CREATE_TYPE_PROMPT =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_CREATE_TYPE_PROMPT_1225", 1225);

    /**
     * >>>> Enter a name for the %s that you want to create:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_CREATE_NAME_PROMPT =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_CREATE_NAME_PROMPT_1226", 1226);

    /**
     * There is already another %s with the name "%s"
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_DSCFG_ERROR_CREATE_NAME_ALREADY_EXISTS =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_CREATE_NAME_ALREADY_EXISTS_1227", 1227);

    /**
     * Type
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_CREATE_HELP_HEADING_TYPE =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_CREATE_HELP_HEADING_TYPE_1228", 1228);

    /**
     * Description
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_CREATE_HELP_HEADING_DESCR =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_CREATE_HELP_HEADING_DESCR_1229", 1229);

    /**
     * Unable to continue since there are no %s currently configured on the server
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_FINDER_NO_CHILDREN =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_FINDER_NO_CHILDREN_1230", 1230);

    /**
     * >>>> There is only one %s: "%s". Are you sure that this is the correct one?
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> INFO_DSCFG_FINDER_PROMPT_SINGLE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_FINDER_PROMPT_SINGLE_1232", 1232);

    /**
     * >>>> Select the %s from the following list:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_FINDER_PROMPT_MANY =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_FINDER_PROMPT_MANY_1233", 1233);

    /**
     * Unable to continue since there is no such an object currently configured on the server
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_DSCFG_ERROR_FINDER_NO_CHILDREN_NULL =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_FINDER_NO_CHILDREN_NULL_1234", 1234);

    /**
     * one of the following values:
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HELP_FIELD_ENUM =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_FIELD_ENUM_1254", 1254);

    /**
     * undefined
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HELP_FIELD_UNDEFINED =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_FIELD_UNDEFINED_1255", 1255);

    /**
     * inherits from the property "%s" in the %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> INFO_DSCFG_HELP_FIELD_INHERITED_ABS =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_FIELD_INHERITED_ABS_1256", 1256);

    /**
     * inherits from the property "%s" in the parent %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> INFO_DSCFG_HELP_FIELD_INHERITED_PARENT =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_FIELD_INHERITED_PARENT_1257", 1257);

    /**
     * inherits from the property "%s" in this %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> INFO_DSCFG_HELP_FIELD_INHERITED_THIS =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_FIELD_INHERITED_THIS_1258", 1258);

    /**
     * The server must be restarted in order for changes to this property to take effect
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HELP_FIELD_SERVER_RESTART =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_FIELD_SERVER_RESTART_1259", 1259);

    /**
     * The %s must be restarted in order for changes to this property to take effect
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_HELP_FIELD_COMPONENT_RESTART =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_FIELD_COMPONENT_RESTART_1260", 1260);

    /**
     * read-only - this property can only be specified when the %s is created
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_HELP_FIELD_READ_ONLY =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_FIELD_READ_ONLY_1261", 1261);

    /**
     * monitoring - this property is automatically generated by the server
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HELP_FIELD_MONITORING =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_FIELD_MONITORING_1262", 1262);

    /**
     * Property: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_HELP_HEADING_PROPERTY =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_HEADING_PROPERTY_1263", 1263);

    /**
     * Component name: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_HELP_HEADING_COMPONENT =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_HEADING_COMPONENT_1264", 1264);

    /**
     * Default behavior
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HELP_HEADING_DEFAULT =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_HEADING_DEFAULT_1265", 1265);

    /**
     * Mandatory
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HELP_HEADING_MANDATORY =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_HEADING_MANDATORY_1266", 1266);

    /**
     * Advanced
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HELP_HEADING_ADVANCED =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_HEADING_ADVANCED_1267", 1267);

    /**
     * Multi-valued
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HELP_HEADING_MULTI_VALUED =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_HEADING_MULTI_VALUED_1268", 1268);

    /**
     * Read-only
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HELP_HEADING_READ_ONLY =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_HEADING_READ_ONLY_1269", 1269);

    /**
     * Syntax
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HELP_HEADING_SYNTAX =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_HEADING_SYNTAX_1270", 1270);

    /**
     * Option Types:
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HELP_DESCRIPTION_OPTION =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_DESCRIPTION_OPTION_1271", 1271);

    /**
     * Property value(s) are readable
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HELP_DESCRIPTION_READ =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_DESCRIPTION_READ_1272", 1272);

    /**
     * Property value(s) are writable
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HELP_DESCRIPTION_WRITE =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_DESCRIPTION_WRITE_1273", 1273);

    /**
     * The property is mandatory
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HELP_DESCRIPTION_MANDATORY =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_DESCRIPTION_MANDATORY_1274", 1274);

    /**
     * The property is single-valued
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HELP_DESCRIPTION_SINGLE_VALUED =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_DESCRIPTION_SINGLE_VALUED_1275", 1275);

    /**
     * Administrative action is required for changes to take effect
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HELP_DESCRIPTION_ADMIN_ACTION =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HELP_DESCRIPTION_ADMIN_ACTION_1276", 1276);

    /**
     * Are you sure that you want to create the %s?
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_CONFIRM_CREATE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_CONFIRM_CREATE_1277", 1277);

    /**
     * Are you sure that you want to delete the %s?
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_CONFIRM_DELETE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_CONFIRM_DELETE_1278", 1278);

    /**
     * Are you sure that you want to modify the %s?
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_CONFIRM_MODIFY =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_CONFIRM_MODIFY_1279", 1279);

    /**
     * The %s was created successfully
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_CONFIRM_CREATE_SUCCESS =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_CONFIRM_CREATE_SUCCESS_1280", 1280);

    /**
     * The %s was deleted successfully
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_CONFIRM_DELETE_SUCCESS =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_CONFIRM_DELETE_SUCCESS_1281", 1281);

    /**
     * The %s was modified successfully
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_CONFIRM_MODIFY_SUCCESS =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_CONFIRM_MODIFY_SUCCESS_1282", 1282);

    /**
     * The %s was not created
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_CONFIRM_CREATE_FAIL =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_CONFIRM_CREATE_FAIL_1283", 1283);

    /**
     * The %s was not deleted
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_CONFIRM_DELETE_FAIL =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_CONFIRM_DELETE_FAIL_1284", 1284);

    /**
     * The %s was not modified
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_CONFIRM_MODIFY_FAIL =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_CONFIRM_MODIFY_FAIL_1285", 1285);

    /**
     * The category of components whose properties should be described
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_HELP_CATEGORY =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_HELP_CATEGORY_1286", 1286);

    /**
     * "%s" is not a recognized component category
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_CATEGORY_UNRECOGNIZED =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_CATEGORY_UNRECOGNIZED_1287", 1287);

    /**
     * "%s" is not a recognized component type in category "%s"
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_DSCFG_ERROR_CATEGORY_TYPE_UNRECOGNIZED =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_CATEGORY_TYPE_UNRECOGNIZED_1288", 1288);

    /**
     * The property "%s" is not a recognized property
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_PROPERTY_UNRECOGNIZED_NO_DEFN =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_PROPERTY_UNRECOGNIZED_NO_DEFN_1289", 1289);

    /**
     * Modifies the display output to show the inherited properties of components
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_DESCRIPTION_HELP_INHERITED =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_DESCRIPTION_HELP_INHERITED_1290", 1290);

    /**
     * true
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_VALUE_TRUE =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_VALUE_TRUE_1291", 1291);

    /**
     * false
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_VALUE_FALSE =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_VALUE_FALSE_1292", 1292);

    /**
     * unlimited
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_VALUE_UNLIMITED =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_VALUE_UNLIMITED_1293", 1293);

    /**
     * Select a value for the "%s" property:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_PROMPT_SELECT_VALUE_SINGLE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_PROMPT_SELECT_VALUE_SINGLE_1294", 1294);

    /**
     * Select one or more values for the "%s" property:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_PROMPT_SELECT_VALUE_MULTI =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_PROMPT_SELECT_VALUE_MULTI_1295", 1295);

    /**
     * Syntax:
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_HEADING_SYNTAX =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_HEADING_SYNTAX_1296", 1296);

    /**
     * The "%s" property has the following values:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_HEADING_VALUES_SUMMARY =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_HEADING_VALUES_SUMMARY_1297", 1297);

    /**
     * Select the values you wish to add:
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_PROMPT_SELECT_VALUES_ADD =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_PROMPT_SELECT_VALUES_ADD_1299", 1299);

    /**
     * Add all values
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_OPTION_ADD_ALL_VALUES =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_ADD_ALL_VALUES_1300", 1300);

    /**
     * Select the values you wish to remove:
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_PROMPT_SELECT_VALUES_REMOVE =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_PROMPT_SELECT_VALUES_REMOVE_1302", 1302);

    /**
     * Do you want to modify the "%s" property?
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_PROMPT_MODIFY_MENU =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_PROMPT_MODIFY_MENU_1303", 1303);

    /**
     * Add one or more values
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_OPTION_ADD_ONE_OR_MORE_VALUES =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_ADD_ONE_OR_MORE_VALUES_1304", 1304);

    /**
     * Remove one or more values
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_OPTION_REMOVE_ONE_OR_MORE_VALUES =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_REMOVE_ONE_OR_MORE_VALUES_1305", 1305);

    /**
     * Remove all values
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_OPTION_REMOVE_ALL_VALUES =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_REMOVE_ALL_VALUES_1306", 1306);

    /**
     * Revert changes
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_OPTION_REVERT_CHANGES =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_REVERT_CHANGES_1307", 1307);

    /**
     * Use the default behavior: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_USE_DEFAULT_ALIAS =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_USE_DEFAULT_ALIAS_1308", 1308);

    /**
     * Use the inherited default behavior: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_USE_DEFAULT_INHERITED_ALIAS =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_USE_DEFAULT_INHERITED_ALIAS_1309", 1309);

    /**
     * Use the inherited default behavior: undefined
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_OPTION_USE_DEFAULT_INHERITED_ALIAS_UNDEFINED =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_USE_DEFAULT_INHERITED_ALIAS_UNDEFINED_1310", 1310);

    /**
     * Leave undefined
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_OPTION_LEAVE_UNDEFINED =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_LEAVE_UNDEFINED_1311", 1311);

    /**
     * Use the value: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_USE_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_USE_VALUE_1312", 1312);

    /**
     * Use the default value: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_USE_DEFAULT_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_USE_DEFAULT_VALUE_1313", 1313);

    /**
     * Use the inherited default value: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_USE_INHERITED_DEFAULT_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_USE_INHERITED_DEFAULT_VALUE_1314", 1314);

    /**
     * Use these values
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_OPTION_USE_VALUES =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_USE_VALUES_1315", 1315);

    /**
     * Use these default values
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_OPTION_USE_DEFAULT_VALUES =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_USE_DEFAULT_VALUES_1316", 1316);

    /**
     * Use these inherited default values
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_OPTION_USE_INHERITED_DEFAULT_VALUES =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_USE_INHERITED_DEFAULT_VALUES_1317", 1317);

    /**
     * Keep the default behavior: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_KEEP_DEFAULT_ALIAS =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_KEEP_DEFAULT_ALIAS_1318", 1318);

    /**
     * Keep the inherited default behavior: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_KEEP_DEFAULT_INHERITED_ALIAS =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_KEEP_DEFAULT_INHERITED_ALIAS_1319", 1319);

    /**
     * Keep the inherited default behavior: undefined
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_OPTION_KEEP_DEFAULT_INHERITED_ALIAS_UNDEFINED =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_KEEP_DEFAULT_INHERITED_ALIAS_UNDEFINED_1320", 1320);

    /**
     * Keep the value: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_KEEP_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_KEEP_VALUE_1321", 1321);

    /**
     * Keep the default value: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_KEEP_DEFAULT_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_KEEP_DEFAULT_VALUE_1322", 1322);

    /**
     * Keep the inherited default value: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_KEEP_INHERITED_DEFAULT_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_KEEP_INHERITED_DEFAULT_VALUE_1323", 1323);

    /**
     * Keep these values
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_OPTION_KEEP_VALUES =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_KEEP_VALUES_1324", 1324);

    /**
     * Keep these default values
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_OPTION_KEEP_DEFAULT_VALUES =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_KEEP_DEFAULT_VALUES_1325", 1325);

    /**
     * Keep these inherited default values
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_OPTION_KEEP_INHERITED_DEFAULT_VALUES =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_KEEP_INHERITED_DEFAULT_VALUES_1326", 1326);

    /**
     * Reset to the default behavior: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_RESET_DEFAULT_ALIAS =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_RESET_DEFAULT_ALIAS_1327", 1327);

    /**
     * Reset to the inherited default behavior: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_RESET_DEFAULT_INHERITED_ALIAS =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_RESET_DEFAULT_INHERITED_ALIAS_1328", 1328);

    /**
     * Reset to the inherited default behavior: undefined
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_OPTION_RESET_DEFAULT_INHERITED_ALIAS_UNDEFINED =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_RESET_DEFAULT_INHERITED_ALIAS_UNDEFINED_1329", 1329);

    /**
     * Reset to the default value: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_RESET_DEFAULT_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_RESET_DEFAULT_VALUE_1331", 1331);

    /**
     * Reset to the inherited default value: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_RESET_INHERITED_DEFAULT_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_RESET_INHERITED_DEFAULT_VALUE_1332", 1332);

    /**
     * Reset to the default values: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_RESET_DEFAULT_VALUES =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_RESET_DEFAULT_VALUES_1334", 1334);

    /**
     * Reset to the inherited default values: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_RESET_INHERITED_DEFAULT_VALUES =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_RESET_INHERITED_DEFAULT_VALUES_1335", 1335);

    /**
     * The "%s" property is undefined
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_HEADING_READ_ONLY_ALIAS_UNDEFINED =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_HEADING_READ_ONLY_ALIAS_UNDEFINED_1336", 1336);

    /**
     * The "%s" property is undefined: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> INFO_EDITOR_HEADING_READ_ONLY_ALIAS =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_HEADING_READ_ONLY_ALIAS_1337", 1337);

    /**
     * The "%s" property has the following value: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> INFO_EDITOR_HEADING_READ_ONLY_VALUE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_HEADING_READ_ONLY_VALUE_1338", 1338);

    /**
     * The "%s" property has the following values:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_HEADING_READ_ONLY_VALUES =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_HEADING_READ_ONLY_VALUES_1339", 1339);

    /**
     * This property is read-only and cannot be modified. Would you like to view its help documentation?
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_PROMPT_READ_ONLY =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_PROMPT_READ_ONLY_1340", 1340);

    /**
     * Change it to the default value: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_CHANGE_TO_DEFAULT_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_CHANGE_TO_DEFAULT_VALUE_1341", 1341);

    /**
     * Change it to the value: %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_CHANGE_TO_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_CHANGE_TO_VALUE_1342", 1342);

    /**
     * Change the value
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_OPTION_CHANGE_VALUE =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_CHANGE_VALUE_1343", 1343);

    /**
     * >>>> Configuring the "%s" property
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_HEADING_CONFIGURE_PROPERTY =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_HEADING_CONFIGURE_PROPERTY_1344", 1344);

    /**
     * Enter a value for the "%s" property:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_PROMPT_READ_FIRST_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_PROMPT_READ_FIRST_VALUE_1345", 1345);

    /**
     * Enter a value for the "%s" property [continue]:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_PROMPT_READ_FIRST_VALUE_OPTIONAL =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_PROMPT_READ_FIRST_VALUE_OPTIONAL_1346", 1346);

    /**
     * Enter another value for the "%s" property [continue]:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_PROMPT_READ_NEXT_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_PROMPT_READ_NEXT_VALUE_1347", 1347);

    /**
     * This property already contains the value "%s". Please enter a different value
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_EDITOR_READ_FIRST_DUPLICATE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_EDITOR_READ_FIRST_DUPLICATE_1348", 1348);

    /**
     * This property already contains the value "%s". Please enter a different value, or press RETURN to continue
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_EDITOR_READ_NEXT_DUPLICATE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_EDITOR_READ_NEXT_DUPLICATE_1349", 1349);

    /**
     * >>>> Configure the properties of the %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_HEADING_CONFIGURE_COMPONENT =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_HEADING_CONFIGURE_COMPONENT_1350", 1350);

    /**
     * finish - create the new %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_FINISH_CREATE_COMPONENT =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_FINISH_CREATE_COMPONENT_1351", 1351);

    /**
     * finish - apply any changes to the %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_OPTION_FINISH_MODIFY_COMPONENT =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_FINISH_MODIFY_COMPONENT_1352", 1352);

    /**
     * f
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_EDITOR_OPTION_FINISH_KEY =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_OPTION_FINISH_KEY_1353", 1353);

    /**
     * >>>> Configuring the "%s" property (Continued)
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_EDITOR_HEADING_CONFIGURE_PROPERTY_CONT =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_EDITOR_HEADING_CONFIGURE_PROPERTY_CONT_1354", 1354);

    /**
     * >>>> Specify a name for the %s. This name will be used as the value for the "%s" property which has the following description:
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> INFO_DSCFG_CREATE_NAME_PROMPT_NAMING =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_CREATE_NAME_PROMPT_NAMING_1355", 1355);

    /**
     * Enter a name for the %s that you want to create:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_CREATE_NAME_PROMPT_NAMING_CONT =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_CREATE_NAME_PROMPT_NAMING_CONT_1356", 1356);

    /**
     * >>>> OpenDJ configuration console main menu
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HEADING_MAIN_MENU_TITLE =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HEADING_MAIN_MENU_TITLE_1357", 1357);

    /**
     * What do you want to configure?
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HEADING_MAIN_MENU_PROMPT =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HEADING_MAIN_MENU_PROMPT_1358", 1358);

    /**
     * >>>> %s management menu
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_HEADING_COMPONENT_MENU_TITLE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HEADING_COMPONENT_MENU_TITLE_1359", 1359);

    /**
     * What would you like to do?
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_DSCFG_HEADING_COMPONENT_MENU_PROMPT =
                    new LocalizableMessageDescriptor.Arg0(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_HEADING_COMPONENT_MENU_PROMPT_1360", 1360);

    /**
     * Create a new %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_OPTION_COMPONENT_MENU_CREATE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_OPTION_COMPONENT_MENU_CREATE_1361", 1361);

    /**
     * View and edit the %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_OPTION_COMPONENT_MENU_MODIFY_SINGULAR =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_OPTION_COMPONENT_MENU_MODIFY_SINGULAR_1362", 1362);

    /**
     * View and edit an existing %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_OPTION_COMPONENT_MENU_MODIFY_PLURAL =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_OPTION_COMPONENT_MENU_MODIFY_PLURAL_1363", 1363);

    /**
     * Delete an existing %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_OPTION_COMPONENT_MENU_DELETE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_OPTION_COMPONENT_MENU_DELETE_1364", 1364);

    /**
     * List existing %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_OPTION_COMPONENT_MENU_LIST_PLURAL =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_OPTION_COMPONENT_MENU_LIST_PLURAL_1365", 1365);

    /**
     * Show the %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_OPTION_COMPONENT_MENU_LIST_SINGULAR =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_OPTION_COMPONENT_MENU_LIST_SINGULAR_1366", 1366);

    /**
     * Generic %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_GENERIC_TYPE_OPTION =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_GENERIC_TYPE_OPTION_1372", 1372);

    /**
     * The %s could not be created because of the following reason:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_CREATE_ORE_SINGLE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_CREATE_ORE_SINGLE_1384", 1384);

    /**
     * The %s could not be created because of the following reasons:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_CREATE_ORE_PLURAL =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_CREATE_ORE_PLURAL_1385", 1385);

    /**
     * The %s could not be deleted because of the following reason:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_DELETE_ORE_SINGLE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_DELETE_ORE_SINGLE_1386", 1386);

    /**
     * The %s could not be deleted because of the following reasons:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_DELETE_ORE_PLURAL =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_DELETE_ORE_PLURAL_1387", 1387);

    /**
     * The %s could not be modified because of the following reason:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_MODIFY_ORE_SINGLE =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_MODIFY_ORE_SINGLE_1388", 1388);

    /**
     * The %s could not be modified because of the following reasons:
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_DSCFG_ERROR_MODIFY_ORE_PLURAL =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_MODIFY_ORE_PLURAL_1389", 1389);

    /**
     * Would you like to edit the properties of the %s again in order to resolve this problem?
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> INFO_DSCFG_PROMPT_EDIT_AGAIN =
                    new LocalizableMessageDescriptor.Arg1<Object>(DsconfigMessages.class, RESOURCE, "INFO_DSCFG_PROMPT_EDIT_AGAIN_1393", 1393);

    /**
     * "%s" component type cannot be used with subcommand {%s}
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_DSCFG_ERROR_TYPE_UNRECOGNIZED_FOR_SUBCOMMAND =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(DsconfigMessages.class, RESOURCE, "ERR_DSCFG_ERROR_TYPE_UNRECOGNIZED_FOR_SUBCOMMAND_1394", 1394);

}
