package org.opends.messages;

import org.forgerock.i18n.LocalizableMessageDescriptor;

/**
 * This file contains localizable message descriptors having the resource
 * name {@code org.opends.messages.logger}. This file was generated
 * automatically by the {@code i18n-maven-plugin} from the property file
 * {@code org/opends/messages/logger.properties} and it should not be manually edited.
 */
public final class LoggerMessages {
    // The name of the resource bundle.
    private static final String RESOURCE = "org.opends.messages.logger";

    // Prevent instantiation.
    private LoggerMessages() {
        // Do nothing.
    }

    /**
     * Returns the name of the resource associated with the messages contained
     * in this class. The resource name may be used for obtaining named loggers,
     * e.g. using SLF4J's {@code org.slf4j.LoggerFactory#getLogger(String name)}.
     *
     * @return The name of the resource associated with the messages contained
     *         in this class.
     */
    public static String resourceName() {
        return RESOURCE;
    }

    /**
     * Error occurred while writing log record for logger %s: %s. Any further write errors will be ignored
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_LOGGER_ERROR_WRITING_RECORD =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(LoggerMessages.class, RESOURCE, "ERR_LOGGER_ERROR_WRITING_RECORD_1", 1);

    /**
     * Error occurred while opening log file %s for logger %s: %s
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> ERR_LOGGER_ERROR_OPENING_FILE =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(LoggerMessages.class, RESOURCE, "ERR_LOGGER_ERROR_OPENING_FILE_2", 2);

    /**
     * Error occurred while closing log file for logger %s: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_LOGGER_ERROR_CLOSING_FILE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(LoggerMessages.class, RESOURCE, "ERR_LOGGER_ERROR_CLOSING_FILE_3", 3);

    /**
     * Error occurred while flushing writer buffer for logger %s: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_LOGGER_ERROR_FLUSHING_BUFFER =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(LoggerMessages.class, RESOURCE, "ERR_LOGGER_ERROR_FLUSHING_BUFFER_4", 4);

    /**
     * Invalid error log severity "%s"
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_ERROR_LOGGER_INVALID_SEVERITY =
                    new LocalizableMessageDescriptor.Arg1<Object>(LoggerMessages.class, RESOURCE, "WARN_ERROR_LOGGER_INVALID_SEVERITY_5", 5);

    /**
     * Invalid error log category "%s"
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_ERROR_LOGGER_INVALID_CATEGORY =
                    new LocalizableMessageDescriptor.Arg1<Object>(LoggerMessages.class, RESOURCE, "WARN_ERROR_LOGGER_INVALID_CATEGORY_6", 6);

    /**
     * Invalid override of severity level "%s"
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_ERROR_LOGGER_INVALID_OVERRIDE_SEVERITY =
                    new LocalizableMessageDescriptor.Arg1<Object>(LoggerMessages.class, RESOURCE, "WARN_ERROR_LOGGER_INVALID_OVERRIDE_SEVERITY_7", 7);

    /**
     * Error occurred while setting file permissions for the log file %s: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_LOGGER_SET_PERMISSION_FAILED =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(LoggerMessages.class, RESOURCE, "WARN_LOGGER_SET_PERMISSION_FAILED_8", 8);

    /**
     * This platform does not support setting file permissions %s to the log file %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_LOGGER_UNABLE_SET_PERMISSIONS =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(LoggerMessages.class, RESOURCE, "WARN_LOGGER_UNABLE_SET_PERMISSIONS_9", 9);

    /**
     * Error occurred while listing log files named by policy with initial file name %s
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_LOGGER_ERROR_LISTING_FILES =
                    new LocalizableMessageDescriptor.Arg1<Object>(LoggerMessages.class, RESOURCE, "ERR_LOGGER_ERROR_LISTING_FILES_10", 10);

    /**
     * Error occurred while obtaining free disk space in the partition containing log file %s: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_LOGGER_ERROR_OBTAINING_FREE_SPACE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(LoggerMessages.class, RESOURCE, "ERR_LOGGER_ERROR_OBTAINING_FREE_SPACE_11", 11);

    /**
     * Error occurred while enforcing retention policy %s for logger %s: %s
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> ERR_LOGGER_ERROR_ENFORCING_RETENTION_POLICY =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(LoggerMessages.class, RESOURCE, "ERR_LOGGER_ERROR_ENFORCING_RETENTION_POLICY_12", 12);

}
