package org.opends.messages;

import org.forgerock.i18n.LocalizableMessageDescriptor;

/**
 * This file contains localizable message descriptors having the resource
 * name {@code org.opends.messages.schema}. This file was generated
 * automatically by the {@code i18n-maven-plugin} from the property file
 * {@code org/opends/messages/schema.properties} and it should not be manually edited.
 */
public final class SchemaMessages {
    // The name of the resource bundle.
    private static final String RESOURCE = "org.opends.messages.schema";

    // Prevent instantiation.
    private SchemaMessages() {
        // Do nothing.
    }

    /**
     * Returns the name of the resource associated with the messages contained
     * in this class. The resource name may be used for obtaining named loggers,
     * e.g. using SLF4J's {@code org.slf4j.LoggerFactory#getLogger(String name)}.
     *
     * @return The name of the resource associated with the messages contained
     *         in this class.
     */
    public static String resourceName() {
        return RESOURCE;
    }

    /**
     * Unable to retrieve approximate matching rule %s used as the default for the %s attribute syntax. Approximate matching will not be allowed by default for attributes with this syntax
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_UNKNOWN_APPROXIMATE_MATCHING_RULE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_UNKNOWN_APPROXIMATE_MATCHING_RULE_1", 1);

    /**
     * Unable to retrieve equality matching rule %s used as the default for the %s attribute syntax. Equality matching will not be allowed by default for attributes with this syntax
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE_2", 2);

    /**
     * Unable to retrieve ordering matching rule %s used as the default for the %s attribute syntax. Ordering matches will not be allowed by default for attributes with this syntax
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE_3", 3);

    /**
     * Unable to retrieve substring matching rule %s used as the default for the %s attribute syntax. Substring matching will not be allowed by default for attributes with this syntax
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE_4", 4);

    /**
     * The provided value "%s" is not allowed for attributes with a Boolean syntax. The only allowed values are 'TRUE' and 'FALSE'
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_ATTR_SYNTAX_ILLEGAL_BOOLEAN =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_ILLEGAL_BOOLEAN_5", 5);

    /**
     * The provided value "%s" is too short to be a valid bit string. A bit string must be a series of binary digits surrounded by single quotes and followed by a capital letter B
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_ATTR_SYNTAX_BIT_STRING_TOO_SHORT =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_BIT_STRING_TOO_SHORT_6", 6);

    /**
     * The provided value "%s" is not a valid bit string because it is not surrounded by single quotes and followed by a capital letter B
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_ATTR_SYNTAX_BIT_STRING_NOT_QUOTED =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_BIT_STRING_NOT_QUOTED_7", 7);

    /**
     * The provided value "%s" is not a valid bit string because '%s' is not a valid binary digit
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_BIT_STRING_INVALID_BIT =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_BIT_STRING_INVALID_BIT_8", 8);

    /**
     * The provided value "%s" is not a valid country string because the length is not exactly two characters
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_COUNTRY_STRING_INVALID_LENGTH =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_COUNTRY_STRING_INVALID_LENGTH_9", 9);

    /**
     * The provided value "%s" is not a valid country string because it contains one or more non-printable characters
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_COUNTRY_STRING_NOT_PRINTABLE =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_COUNTRY_STRING_NOT_PRINTABLE_10", 10);

    /**
     * The provided value "%s" is not a valid delivery method value because it does not contain any elements
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_DELIVERY_METHOD_NO_ELEMENTS =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DELIVERY_METHOD_NO_ELEMENTS_11", 11);

    /**
     * The provided value "%s" is not a valid delivery method value because "%s" is not a valid method
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_DELIVERY_METHOD_INVALID_ELEMENT =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DELIVERY_METHOD_INVALID_ELEMENT_12", 12);

    /**
     * The provided value "%s" is too short to be a valid generalized time value
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_ATTR_SYNTAX_GENERALIZED_TIME_TOO_SHORT =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_GENERALIZED_TIME_TOO_SHORT_13", 13);

    /**
     * The provided value "%s" is not a valid generalized time value because the '%s' character is not allowed in the century or year specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_YEAR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_YEAR_14", 14);

    /**
     * The provided value "%s" is not a valid generalized time value because "%s" is not a valid month specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_MONTH =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_MONTH_15", 15);

    /**
     * The provided value "%s" is not a valid generalized time value because "%s" is not a valid day specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_DAY =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_DAY_16", 16);

    /**
     * The provided value "%s" is not a valid generalized time value because "%s" is not a valid hour specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_HOUR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_HOUR_17", 17);

    /**
     * The provided value "%s" is not a valid generalized time value because "%s" is not a valid minute specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_MINUTE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_MINUTE_18", 18);

    /**
     * The provided value "%s" is not a valid generalized time value because "%s" is not a valid second specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_SECOND =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_SECOND_19", 19);

    /**
     * The provided value "%s" is not a valid generalized time value because "%s" is not a valid GMT offset
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET_22", 22);

    /**
     * The provided value "%s" is not a valid generalized time value because it contains an invalid character '%s' at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR_23", 23);

    /**
     * The provided value "%s" could not be parsed as a valid distinguished name: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_DN_INVALID =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DN_INVALID_25", 25);

    /**
     * The provided value "%s" could not be parsed as a valid distinguished name because the last non-space character was a comma or semicolon
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_DN_END_WITH_COMMA =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DN_END_WITH_COMMA_26", 26);

    /**
     * The provided value "%s" could not be parsed as a valid distinguished name because character '%c' at position %d is not allowed in an attribute name
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Character, Number> ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR =
                    new LocalizableMessageDescriptor.Arg3<Object, Character, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR_28", 28);

    /**
     * The provided value "%s" could not be parsed as a valid distinguished name because the underscore character is not allowed in an attribute name unless the %s configuration option is enabled
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_UNDERSCORE_CHAR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_UNDERSCORE_CHAR_29", 29);

    /**
     * The provided value "%s" could not be parsed as a valid distinguished name because the hyphen character is not allowed as the first character of an attribute name
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_INITIAL_DASH =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_INITIAL_DASH_30", 30);

    /**
     * The provided value "%s" could not be parsed as a valid distinguished name because the underscore character is not allowed as the first character of an attribute name even if the %s configuration option is enabled
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_INITIAL_UNDERSCORE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_INITIAL_UNDERSCORE_31", 31);

    /**
     * The provided value "%s" could not be parsed as a valid distinguished name because the digit '%c' is not allowed as the first character of an attribute name unless the name is specified as an OID or the %s configuration option is enabled
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Character, Object> ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_INITIAL_DIGIT =
                    new LocalizableMessageDescriptor.Arg3<Object, Character, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_INITIAL_DIGIT_32", 32);

    /**
     * The provided value "%s" could not be parsed as a valid distinguished name because it contained an RDN containing an empty attribute name
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_DN_ATTR_NO_NAME =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DN_ATTR_NO_NAME_33", 33);

    /**
     * The provided value "%s" could not be parsed as a valid distinguished name because the parsed attribute name %s included a period but that name did not appear to be a valid OID
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_PERIOD =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_PERIOD_34", 34);

    /**
     * The provided value "%s" could not be parsed as a valid distinguished name because the last non-space character was part of the attribute name '%s'
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_DN_END_WITH_ATTR_NAME =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DN_END_WITH_ATTR_NAME_35", 35);

    /**
     * The provided value "%s" could not be parsed as a valid distinguished name because the next non-space character after attribute name "%s" should have been an equal sign but instead was '%c'
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Character> ERR_ATTR_SYNTAX_DN_NO_EQUAL =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Character>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DN_NO_EQUAL_36", 36);

    /**
     * The provided value "%s" could not be parsed as a valid distinguished name because character '%c' at position %d is not valid
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Character, Number> ERR_ATTR_SYNTAX_DN_INVALID_CHAR =
                    new LocalizableMessageDescriptor.Arg3<Object, Character, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DN_INVALID_CHAR_37", 37);

    /**
     * The provided value "%s" could not be parsed as a valid distinguished name because an attribute value started with an octothorpe (#) but was not followed by a positive multiple of two hexadecimal digits
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_DN_HEX_VALUE_TOO_SHORT =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DN_HEX_VALUE_TOO_SHORT_38", 38);

    /**
     * The provided value "%s" could not be parsed as a valid distinguished name because an attribute value started with an octothorpe (#) but contained a character %c that was not a valid hexadecimal digit
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Character> ERR_ATTR_SYNTAX_DN_INVALID_HEX_DIGIT =
                    new LocalizableMessageDescriptor.Arg2<Object, Character>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DN_INVALID_HEX_DIGIT_39", 39);

    /**
     * The provided value "%s" could not be parsed as a valid distinguished name because an unexpected failure occurred while attempting to parse an attribute value from one of the RDN components: "%s"
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_DN_ATTR_VALUE_DECODE_FAILURE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DN_ATTR_VALUE_DECODE_FAILURE_40", 40);

    /**
     * The provided value "%s" could not be parsed as a valid distinguished name because one of the RDN components included a quoted value that did not have a corresponding closing quotation mark
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_DN_UNMATCHED_QUOTE =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DN_UNMATCHED_QUOTE_41", 41);

    /**
     * The provided value "%s" could not be parsed as a valid distinguished name because one of the RDN components included a value with an escaped hexadecimal digit that was not followed by a second hexadecimal digit
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_DN_ESCAPED_HEX_VALUE_INVALID =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DN_ESCAPED_HEX_VALUE_INVALID_42", 42);

    /**
     * The provided value "%s" could not be parsed as a valid integer because the first digit may not be zero unless it is the only digit
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_ATTR_SYNTAX_INTEGER_INITIAL_ZERO =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_INTEGER_INITIAL_ZERO_43", 43);

    /**
     * The provided value "%s" could not be parsed as a valid integer because the dash may only appear if it is the first character of the value followed by one or more digits
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_ATTR_SYNTAX_INTEGER_MISPLACED_DASH =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_INTEGER_MISPLACED_DASH_44", 44);

    /**
     * The provided value "%s" could not be parsed as a valid integer because character '%c' at position %d is not allowed in an integer value
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Character, Number> WARN_ATTR_SYNTAX_INTEGER_INVALID_CHARACTER =
                    new LocalizableMessageDescriptor.Arg3<Object, Character, Number>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_INTEGER_INVALID_CHARACTER_45", 45);

    /**
     * The provided value "%s" could not be parsed as a valid integer because it did not contain any digits
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_ATTR_SYNTAX_INTEGER_EMPTY_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_INTEGER_EMPTY_VALUE_46", 46);

    /**
     * The provided value "%s" could not be parsed as a valid integer because it contained only a dash not followed by an integer value
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_ATTR_SYNTAX_INTEGER_DASH_NEEDS_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_INTEGER_DASH_NEEDS_VALUE_47", 47);

    /**
     * The provided value could not be parsed as a valid attribute type description because it was empty or contained only whitespace
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_ATTRTYPE_EMPTY_VALUE =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ATTRTYPE_EMPTY_VALUE_52", 52);

    /**
     * The provided value "%s" could not be parsed as an attribute type description because an open parenthesis was expected at position %d but instead a '%s' character was found
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Number, Object> ERR_ATTR_SYNTAX_ATTRTYPE_EXPECTED_OPEN_PARENTHESIS =
                    new LocalizableMessageDescriptor.Arg3<Object, Number, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ATTRTYPE_EXPECTED_OPEN_PARENTHESIS_53", 53);

    /**
     * The provided value "%s" could not be parsed as an attribute type description because the end of the value was encountered while the Directory Server expected more data to be provided
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_ATTRTYPE_TRUNCATED_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ATTRTYPE_TRUNCATED_VALUE_54", 54);

    /**
     * The provided value "%s" could not be parsed as an attribute type description because the numeric OID contained two consecutive periods at position %d
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_ATTRTYPE_DOUBLE_PERIOD_IN_NUMERIC_OID =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ATTRTYPE_DOUBLE_PERIOD_IN_NUMERIC_OID_55", 55);

    /**
     * The provided value "%s" could not be parsed as an attribute type description because the numeric OID contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_CHAR_IN_NUMERIC_OID =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_CHAR_IN_NUMERIC_OID_56", 56);

    /**
     * The provided value "%s" could not be parsed as an attribute type description because the non-numeric OID contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_CHAR_IN_STRING_OID =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_CHAR_IN_STRING_OID_57", 57);

    /**
     * The provided value "%s" could not be parsed as an attribute type description because it contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_CHAR =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_CHAR_58", 58);

    /**
     * The provided value "%s" could not be parsed as an attribute type description because it contained an unexpected closing parenthesis at position %d
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_ATTRTYPE_UNEXPECTED_CLOSE_PARENTHESIS =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ATTRTYPE_UNEXPECTED_CLOSE_PARENTHESIS_59", 59);

    /**
     * The definition for the attribute type with OID %s declared a superior type with an OID of %s. No attribute type with this OID exists in the server schema
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_SUPERIOR_TYPE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_SUPERIOR_TYPE_61", 61);

    /**
     * The definition for the attribute type with OID %s declared that approximate matching should be performed using the matching rule "%s". No such approximate matching rule is configured for use in the Directory Server
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_APPROXIMATE_MR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_APPROXIMATE_MR_62", 62);

    /**
     * The definition for the attribute type with OID %s declared that equality matching should be performed using the matching rule "%s". No such equality matching rule is configured for use in the Directory Server
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_EQUALITY_MR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_EQUALITY_MR_63", 63);

    /**
     * The definition for the attribute type with OID %s declared that ordering matching should be performed using the matching rule "%s". No such ordering matching rule is configured for use in the Directory Server
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_ORDERING_MR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_ORDERING_MR_64", 64);

    /**
     * The definition for the attribute type with OID %s declared that substring matching should be performed using the matching rule "%s". No such substring matching rule is configured for use in the Directory Server
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_SUBSTRING_MR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_SUBSTRING_MR_65", 65);

    /**
     * The definition for the attribute type with OID %s declared that it should have a syntax with OID %s. No such syntax is configured for use in the Directory Server
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_SYNTAX =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_SYNTAX_66", 66);

    /**
     * The definition for the attribute type with OID %s declared that it should have an attribute usage of %s. This is an invalid usage
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_ATTRTYPE_INVALID_ATTRIBUTE_USAGE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_ATTRTYPE_INVALID_ATTRIBUTE_USAGE_67", 67);

    /**
     * The provided value "%s" could not be parsed as an attribute type description because a single quote was expected at position %d but the character %s was found instead
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Number, Object> WARN_ATTR_SYNTAX_ATTRTYPE_EXPECTED_QUOTE_AT_POS =
                    new LocalizableMessageDescriptor.Arg3<Object, Number, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_ATTRTYPE_EXPECTED_QUOTE_AT_POS_68", 68);

    /**
     * The provided value could not be parsed as a valid objectclass description because it was empty or contained only whitespace
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_OBJECTCLASS_EMPTY_VALUE =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_OBJECTCLASS_EMPTY_VALUE_69", 69);

    /**
     * The provided value "%s" could not be parsed as an objectclass description because an open parenthesis was expected at position %d but instead a '%s' character was found
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Number, Object> ERR_ATTR_SYNTAX_OBJECTCLASS_EXPECTED_OPEN_PARENTHESIS =
                    new LocalizableMessageDescriptor.Arg3<Object, Number, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_OBJECTCLASS_EXPECTED_OPEN_PARENTHESIS_70", 70);

    /**
     * The provided value "%s" could not be parsed as an objectclass description because the end of the value was encountered while the Directory Server expected more data to be provided
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_OBJECTCLASS_TRUNCATED_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_OBJECTCLASS_TRUNCATED_VALUE_71", 71);

    /**
     * The provided value "%s" could not be parsed as an objectclass description because the numeric OID contained two consecutive periods at position %d
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_OBJECTCLASS_DOUBLE_PERIOD_IN_NUMERIC_OID =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_OBJECTCLASS_DOUBLE_PERIOD_IN_NUMERIC_OID_72", 72);

    /**
     * The provided value "%s" could not be parsed as an objectclass description because the numeric OID contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_OBJECTCLASS_ILLEGAL_CHAR_IN_NUMERIC_OID =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_OBJECTCLASS_ILLEGAL_CHAR_IN_NUMERIC_OID_73", 73);

    /**
     * The provided value "%s" could not be parsed as an objectclass description because the non-numeric OID contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_OBJECTCLASS_ILLEGAL_CHAR_IN_STRING_OID =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_OBJECTCLASS_ILLEGAL_CHAR_IN_STRING_OID_74", 74);

    /**
     * The provided value "%s" could not be parsed as an objectclass description because it contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_OBJECTCLASS_ILLEGAL_CHAR =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_OBJECTCLASS_ILLEGAL_CHAR_75", 75);

    /**
     * The provided value "%s" could not be parsed as an objectclass description because it contained an unexpected closing parenthesis at position %d
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_OBJECTCLASS_UNEXPECTED_CLOSE_PARENTHESIS =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_OBJECTCLASS_UNEXPECTED_CLOSE_PARENTHESIS_76", 76);

    /**
     * The definition for the objectclass with OID %s declared a superior objectclass with an OID of %s. No objectclass with this OID exists in the server schema
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_OBJECTCLASS_UNKNOWN_SUPERIOR_CLASS =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_OBJECTCLASS_UNKNOWN_SUPERIOR_CLASS_78", 78);

    /**
     * The provided value "%s" could not be parsed as an objectclass description because a single quote was expected at position %d but the character %s was found instead
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Number, Object> WARN_ATTR_SYNTAX_OBJECTCLASS_EXPECTED_QUOTE_AT_POS =
                    new LocalizableMessageDescriptor.Arg3<Object, Number, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_OBJECTCLASS_EXPECTED_QUOTE_AT_POS_79", 79);

    /**
     * The definition for the objectclass with OID %s declared that it should include required attribute "%s". No attribute type matching this name or OID exists in the server schema
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_OBJECTCLASS_UNKNOWN_REQUIRED_ATTR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_OBJECTCLASS_UNKNOWN_REQUIRED_ATTR_80", 80);

    /**
     * The definition for the objectclass with OID %s declared that it should include optional attribute "%s". No attribute type matching this name or OID exists in the server schema
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_OBJECTCLASS_UNKNOWN_OPTIONAL_ATTR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_OBJECTCLASS_UNKNOWN_OPTIONAL_ATTR_81", 81);

    /**
     * The provided value "%s" cannot be parsed as a valid IA5 string because it contains an illegal character "%s" that is not allowed in the IA5 (ASCII) character set
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_IA5_ILLEGAL_CHARACTER =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_IA5_ILLEGAL_CHARACTER_82", 82);

    /**
     * The provided value is not a valid telephone number because it is empty or null
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_TELEPHONE_EMPTY =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_TELEPHONE_EMPTY_85", 85);

    /**
     * The provided value "%s" is not a valid telephone number because strict telephone number checking is enabled and the value does not start with a plus sign in compliance with the ITU-T E.123 specification
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_TELEPHONE_NO_PLUS =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_TELEPHONE_NO_PLUS_86", 86);

    /**
     * The provided value "%s" is not a valid telephone number because strict telephone number checking is enabled and the character %s at position %d is not allowed by the ITU-T E.123 specification
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_TELEPHONE_ILLEGAL_CHAR =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_TELEPHONE_ILLEGAL_CHAR_87", 87);

    /**
     * The provided value "%s" is not a valid telephone number because it does not contain any numeric digits
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_TELEPHONE_NO_DIGITS =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_TELEPHONE_NO_DIGITS_88", 88);

    /**
     * The provided value "%s" is not a valid numeric string because it contained character %s at position %d that was neither a digit nor a space
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> WARN_ATTR_SYNTAX_NUMERIC_STRING_ILLEGAL_CHAR =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_NUMERIC_STRING_ILLEGAL_CHAR_90", 90);

    /**
     * The provided value is not a valid numeric string because it did not contain any characters. A numeric string value must contain at least one numeric digit or space
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_NUMERIC_STRING_EMPTY_VALUE =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_NUMERIC_STRING_EMPTY_VALUE_91", 91);

    /**
     * The provided value could not be parsed as a printable string because it was null or empty. A printable string must contain at least one character
     */
    public static final LocalizableMessageDescriptor.Arg0 WARN_ATTR_SYNTAX_PRINTABLE_STRING_EMPTY_VALUE =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_PRINTABLE_STRING_EMPTY_VALUE_105", 105);

    /**
     * The provided value "%s" could not be parsed as a printable string because it contained an invalid character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> WARN_ATTR_SYNTAX_PRINTABLE_STRING_ILLEGAL_CHARACTER =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_PRINTABLE_STRING_ILLEGAL_CHARACTER_106", 106);

    /**
     * The provided value "*" could not be parsed as a substring assertion because it consists only of a wildcard character and zero-length substrings are not allowed
     */
    public static final LocalizableMessageDescriptor.Arg0 WARN_ATTR_SYNTAX_SUBSTRING_ONLY_WILDCARD =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_SUBSTRING_ONLY_WILDCARD_107", 107);

    /**
     * The provided value "%s" could not be parsed as a substring assertion because it contains consecutive wildcard characters at position %d and zero-length substrings are not allowed
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> WARN_ATTR_SYNTAX_SUBSTRING_CONSECUTIVE_WILDCARDS =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_SUBSTRING_CONSECUTIVE_WILDCARDS_108", 108);

    /**
     * The provided value %s is too short to be a valid UTC time value
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_UTC_TIME_TOO_SHORT =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_UTC_TIME_TOO_SHORT_109", 109);

    /**
     * The provided value %s is not a valid UTC time value because the %s character is not allowed in the century or year specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_UTC_TIME_INVALID_YEAR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_UTC_TIME_INVALID_YEAR_110", 110);

    /**
     * The provided value %s is not a valid UTC time value because %s is not a valid month specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_UTC_TIME_INVALID_MONTH =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_UTC_TIME_INVALID_MONTH_111", 111);

    /**
     * The provided value %s is not a valid UTC time value because %s is not a valid day specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_UTC_TIME_INVALID_DAY =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_UTC_TIME_INVALID_DAY_112", 112);

    /**
     * The provided value %s is not a valid UTC time value because %s is not a valid hour specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_UTC_TIME_INVALID_HOUR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_UTC_TIME_INVALID_HOUR_113", 113);

    /**
     * The provided value %s is not a valid UTC time value because %s is not a valid minute specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_UTC_TIME_INVALID_MINUTE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_UTC_TIME_INVALID_MINUTE_114", 114);

    /**
     * The provided value %s is not a valid UTC time value because it contains an invalid character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR_115", 115);

    /**
     * The provided value %s is not a valid UTC time value because %s is not a valid second specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_UTC_TIME_INVALID_SECOND =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_UTC_TIME_INVALID_SECOND_116", 116);

    /**
     * The provided value %s is not a valid UTC time value because %s is not a valid GMT offset
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_UTC_TIME_INVALID_OFFSET =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_UTC_TIME_INVALID_OFFSET_117", 117);

    /**
     * The provided value %s could not be parsed as a valid UTC time: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_UTC_TIME_CANNOT_PARSE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_UTC_TIME_CANNOT_PARSE_118", 118);

    /**
     * The provided value could not be parsed as a valid DIT content rule description because it was empty or contained only whitespace
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_DCR_EMPTY_VALUE =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DCR_EMPTY_VALUE_119", 119);

    /**
     * The provided value "%s" could not be parsed as a DIT content rule description because an open parenthesis was expected at position %d but instead a '%s' character was found
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Number, Object> ERR_ATTR_SYNTAX_DCR_EXPECTED_OPEN_PARENTHESIS =
                    new LocalizableMessageDescriptor.Arg3<Object, Number, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DCR_EXPECTED_OPEN_PARENTHESIS_120", 120);

    /**
     * The provided value "%s" could not be parsed as a DIT content rule description because the end of the value was encountered while the Directory Server expected more data to be provided
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_DCR_TRUNCATED_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DCR_TRUNCATED_VALUE_121", 121);

    /**
     * The provided value "%s" could not be parsed as a DIT content rule description because the numeric OID contained two consecutive periods at position %d
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_DCR_DOUBLE_PERIOD_IN_NUMERIC_OID =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DCR_DOUBLE_PERIOD_IN_NUMERIC_OID_122", 122);

    /**
     * The provided value "%s" could not be parsed as a DIT content rule description because the numeric OID contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_DCR_ILLEGAL_CHAR_IN_NUMERIC_OID =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DCR_ILLEGAL_CHAR_IN_NUMERIC_OID_123", 123);

    /**
     * The provided value "%s" could not be parsed as a DIT content rule description because the non-numeric OID contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_DCR_ILLEGAL_CHAR_IN_STRING_OID =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DCR_ILLEGAL_CHAR_IN_STRING_OID_124", 124);

    /**
     * The provided value "%s" could not be parsed as a DIT content rule description because it contained an unexpected closing parenthesis at position %d
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_DCR_UNEXPECTED_CLOSE_PARENTHESIS =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DCR_UNEXPECTED_CLOSE_PARENTHESIS_125", 125);

    /**
     * The provided value "%s" could not be parsed as a DIT content rule description because it contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_DCR_ILLEGAL_CHAR =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DCR_ILLEGAL_CHAR_126", 126);

    /**
     * The DIT content rule "%s" is associated with a structural objectclass %s that is not defined in the server schema
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_DCR_UNKNOWN_STRUCTURAL_CLASS =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DCR_UNKNOWN_STRUCTURAL_CLASS_127", 127);

    /**
     * The DIT content rule "%s" is associated with the objectclass with OID %s (%s). This objectclass exists in the server schema but is defined as %s rather than structural
     */
    public static final LocalizableMessageDescriptor.Arg4<Object, Object, Object, Object> ERR_ATTR_SYNTAX_DCR_STRUCTURAL_CLASS_NOT_STRUCTURAL =
                    new LocalizableMessageDescriptor.Arg4<Object, Object, Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DCR_STRUCTURAL_CLASS_NOT_STRUCTURAL_128", 128);

    /**
     * The DIT content rule "%s" is associated with an auxiliary objectclass %s that is not defined in the server schema
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_DCR_UNKNOWN_AUXILIARY_CLASS =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DCR_UNKNOWN_AUXILIARY_CLASS_129", 129);

    /**
     * The DIT content rule "%s" is associated with an auxiliary objectclass %s. This objectclass exists in the server schema but is defined as %s rather than auxiliary
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> ERR_ATTR_SYNTAX_DCR_AUXILIARY_CLASS_NOT_AUXILIARY =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DCR_AUXILIARY_CLASS_NOT_AUXILIARY_130", 130);

    /**
     * The DIT content rule "%s" is associated with a required attribute type %s that is not defined in the server schema
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_DCR_UNKNOWN_REQUIRED_ATTR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DCR_UNKNOWN_REQUIRED_ATTR_131", 131);

    /**
     * The DIT content rule "%s" is associated with an optional attribute type %s that is not defined in the server schema
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_DCR_UNKNOWN_OPTIONAL_ATTR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DCR_UNKNOWN_OPTIONAL_ATTR_132", 132);

    /**
     * The DIT content rule "%s" is associated with a prohibited attribute type %s that is not defined in the server schema
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_DCR_UNKNOWN_PROHIBITED_ATTR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DCR_UNKNOWN_PROHIBITED_ATTR_133", 133);

    /**
     * The provided value "%s" could not be parsed as a DIT content rule description because a single quote was expected at position %d but the %s character was found instead
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Number, Object> ERR_ATTR_SYNTAX_DCR_EXPECTED_QUOTE_AT_POS =
                    new LocalizableMessageDescriptor.Arg3<Object, Number, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DCR_EXPECTED_QUOTE_AT_POS_134", 134);

    /**
     * The provided value could not be parsed as a valid name form description because it was empty or contained only whitespace
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_NAME_FORM_EMPTY_VALUE =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_NAME_FORM_EMPTY_VALUE_135", 135);

    /**
     * The provided value "%s" could not be parsed as a name form description because an open parenthesis was expected at position %d but instead a '%c' character was found
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Number, Character> ERR_ATTR_SYNTAX_NAME_FORM_EXPECTED_OPEN_PARENTHESIS =
                    new LocalizableMessageDescriptor.Arg3<Object, Number, Character>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_NAME_FORM_EXPECTED_OPEN_PARENTHESIS_136", 136);

    /**
     * The provided value "%s" could not be parsed as a name form description because the end of the value was encountered while the Directory Server expected more data to be provided
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_NAME_FORM_TRUNCATED_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_NAME_FORM_TRUNCATED_VALUE_137", 137);

    /**
     * The provided value "%s" could not be parsed as a name form description because the numeric OID contained two consecutive periods at position %d
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_NAME_FORM_DOUBLE_PERIOD_IN_NUMERIC_OID =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_NAME_FORM_DOUBLE_PERIOD_IN_NUMERIC_OID_138", 138);

    /**
     * The provided value "%s" could not be parsed as a name form description because the numeric OID contained an illegal character %c at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Character, Number> ERR_ATTR_SYNTAX_NAME_FORM_ILLEGAL_CHAR_IN_NUMERIC_OID =
                    new LocalizableMessageDescriptor.Arg3<Object, Character, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_NAME_FORM_ILLEGAL_CHAR_IN_NUMERIC_OID_139", 139);

    /**
     * The provided value "%s" could not be parsed as a name form description because the non-numeric OID contained an illegal character %c at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Character, Number> ERR_ATTR_SYNTAX_NAME_FORM_ILLEGAL_CHAR_IN_STRING_OID =
                    new LocalizableMessageDescriptor.Arg3<Object, Character, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_NAME_FORM_ILLEGAL_CHAR_IN_STRING_OID_140", 140);

    /**
     * The provided value "%s" could not be parsed as a name form description because it contained an unexpected closing parenthesis at position %d
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_NAME_FORM_UNEXPECTED_CLOSE_PARENTHESIS =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_NAME_FORM_UNEXPECTED_CLOSE_PARENTHESIS_141", 141);

    /**
     * The provided value "%s" could not be parsed as a name form description because it contained an illegal character %c at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Character, Number> ERR_ATTR_SYNTAX_NAME_FORM_ILLEGAL_CHAR =
                    new LocalizableMessageDescriptor.Arg3<Object, Character, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_NAME_FORM_ILLEGAL_CHAR_142", 142);

    /**
     * The name form description "%s" is associated with a structural objectclass %s that is not defined in the server schema
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_NAME_FORM_UNKNOWN_STRUCTURAL_CLASS =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_NAME_FORM_UNKNOWN_STRUCTURAL_CLASS_143", 143);

    /**
     * The name form description "%s" is associated with the objectclass with OID %s (%s). This objectclass exists in the server schema but is defined as %s rather than structural
     */
    public static final LocalizableMessageDescriptor.Arg4<Object, Object, Object, Object> ERR_ATTR_SYNTAX_NAME_FORM_STRUCTURAL_CLASS_NOT_STRUCTURAL =
                    new LocalizableMessageDescriptor.Arg4<Object, Object, Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_NAME_FORM_STRUCTURAL_CLASS_NOT_STRUCTURAL_144", 144);

    /**
     * The definition for the name form with OID %s declared that it should include required attribute "%s". No attribute type matching this name or OID exists in the server schema
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_NAME_FORM_UNKNOWN_REQUIRED_ATTR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_NAME_FORM_UNKNOWN_REQUIRED_ATTR_145", 145);

    /**
     * The definition for the name form with OID %s declared that it should include optional attribute "%s". No attribute type matching this name or OID exists in the server schema
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_NAME_FORM_UNKNOWN_OPTIONAL_ATTR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_NAME_FORM_UNKNOWN_OPTIONAL_ATTR_146", 146);

    /**
     * The provided value "%s" could not be parsed as a name form description because it does not specify the structural objectclass with which it is associated
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_NAME_FORM_NO_STRUCTURAL_CLASS =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_NAME_FORM_NO_STRUCTURAL_CLASS_147", 147);

    /**
     * The provided value "%s" could not be parsed as a name form description because a single quote was expected at position %d but the %c character was found instead
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Number, Character> ERR_ATTR_SYNTAX_NAME_FORM_EXPECTED_QUOTE_AT_POS =
                    new LocalizableMessageDescriptor.Arg3<Object, Number, Character>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_NAME_FORM_EXPECTED_QUOTE_AT_POS_148", 148);

    /**
     * The provided value could not be parsed as a valid matching rule description because it was empty or contained only whitespace
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_MR_EMPTY_VALUE =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MR_EMPTY_VALUE_149", 149);

    /**
     * The provided value "%s" could not be parsed as a matching rule description because an open parenthesis was expected at position %d but instead a '%s' character was found
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Number, Object> ERR_ATTR_SYNTAX_MR_EXPECTED_OPEN_PARENTHESIS =
                    new LocalizableMessageDescriptor.Arg3<Object, Number, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MR_EXPECTED_OPEN_PARENTHESIS_150", 150);

    /**
     * The provided value "%s" could not be parsed as a matching rule description because the end of the value was encountered while the Directory Server expected more data to be provided
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_MR_TRUNCATED_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MR_TRUNCATED_VALUE_151", 151);

    /**
     * The provided value "%s" could not be parsed as a matching rule description because the numeric OID contained two consecutive periods at position %d
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_MR_DOUBLE_PERIOD_IN_NUMERIC_OID =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MR_DOUBLE_PERIOD_IN_NUMERIC_OID_152", 152);

    /**
     * The provided value "%s" could not be parsed as a matching rule description because the numeric OID contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_MR_ILLEGAL_CHAR_IN_NUMERIC_OID =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MR_ILLEGAL_CHAR_IN_NUMERIC_OID_153", 153);

    /**
     * The provided value "%s" could not be parsed as a matching rule description because the non-numeric OID contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_MR_ILLEGAL_CHAR_IN_STRING_OID =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MR_ILLEGAL_CHAR_IN_STRING_OID_154", 154);

    /**
     * The provided value "%s" could not be parsed as a matching rule description because it contained an unexpected closing parenthesis at position %d
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_MR_UNEXPECTED_CLOSE_PARENTHESIS =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MR_UNEXPECTED_CLOSE_PARENTHESIS_155", 155);

    /**
     * The provided value "%s" could not be parsed as a matching rule description because it contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_MR_ILLEGAL_CHAR =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MR_ILLEGAL_CHAR_156", 156);

    /**
     * The matching rule description "%s" is associated with attribute syntax %s that is not defined in the server schema
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_MR_UNKNOWN_SYNTAX =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MR_UNKNOWN_SYNTAX_157", 157);

    /**
     * The provided value "%s" could not be parsed as a matching rule description because it does not specify the attribute syntax with which it is associated
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_MR_NO_SYNTAX =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MR_NO_SYNTAX_158", 158);

    /**
     * The provided value "%s" could not be parsed as a matching rule description because a single quote was expected at position %d but the %s character was found instead
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Number, Object> ERR_ATTR_SYNTAX_MR_EXPECTED_QUOTE_AT_POS =
                    new LocalizableMessageDescriptor.Arg3<Object, Number, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MR_EXPECTED_QUOTE_AT_POS_159", 159);

    /**
     * The provided value could not be parsed as a valid matching rule use description because it was empty or contained only whitespace
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_MRUSE_EMPTY_VALUE =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MRUSE_EMPTY_VALUE_160", 160);

    /**
     * The provided value "%s" could not be parsed as a matching rule use description because an open parenthesis was expected at position %d but instead a '%s' character was found
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Number, Object> ERR_ATTR_SYNTAX_MRUSE_EXPECTED_OPEN_PARENTHESIS =
                    new LocalizableMessageDescriptor.Arg3<Object, Number, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MRUSE_EXPECTED_OPEN_PARENTHESIS_161", 161);

    /**
     * The provided value "%s" could not be parsed as a matching rule use description because the end of the value was encountered while the Directory Server expected more data to be provided
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_MRUSE_TRUNCATED_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MRUSE_TRUNCATED_VALUE_162", 162);

    /**
     * The provided value "%s" could not be parsed as a matching rule use description because the numeric OID contained two consecutive periods at position %d
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_MRUSE_DOUBLE_PERIOD_IN_NUMERIC_OID =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MRUSE_DOUBLE_PERIOD_IN_NUMERIC_OID_163", 163);

    /**
     * The provided value "%s" could not be parsed as a matching rule use description because the numeric OID contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_MRUSE_ILLEGAL_CHAR_IN_NUMERIC_OID =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MRUSE_ILLEGAL_CHAR_IN_NUMERIC_OID_164", 164);

    /**
     * The provided value "%s" could not be parsed as a matching rule use description because the non-numeric OID contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_MRUSE_ILLEGAL_CHAR_IN_STRING_OID =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MRUSE_ILLEGAL_CHAR_IN_STRING_OID_165", 165);

    /**
     * The provided value "%s" could not be parsed as a matching rule use description because the specified matching rule %s is unknown
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_MRUSE_UNKNOWN_MATCHING_RULE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MRUSE_UNKNOWN_MATCHING_RULE_166", 166);

    /**
     * The provided value "%s" could not be parsed as a matching rule use description because it contained an unexpected closing parenthesis at position %d
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_MRUSE_UNEXPECTED_CLOSE_PARENTHESIS =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MRUSE_UNEXPECTED_CLOSE_PARENTHESIS_167", 167);

    /**
     * The provided value "%s" could not be parsed as a matching rule use description because it contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_MRUSE_ILLEGAL_CHAR =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MRUSE_ILLEGAL_CHAR_168", 168);

    /**
     * The matching rule use description "%s" is associated with attribute type %s that is not defined in the server schema
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_MRUSE_UNKNOWN_ATTR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MRUSE_UNKNOWN_ATTR_169", 169);

    /**
     * The provided value "%s" could not be parsed as a matching rule description because it does not specify the set of attribute types that may be used with the associated OID
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_MRUSE_NO_ATTR =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MRUSE_NO_ATTR_170", 170);

    /**
     * The provided value "%s" could not be parsed as a matching rule use description because a single quote was expected at position %d but the %s character was found instead
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Number, Object> ERR_ATTR_SYNTAX_MRUSE_EXPECTED_QUOTE_AT_POS =
                    new LocalizableMessageDescriptor.Arg3<Object, Number, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_MRUSE_EXPECTED_QUOTE_AT_POS_171", 171);

    /**
     * The provided value could not be parsed as a valid DIT structure rule description because it was empty or contained only whitespace
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_DSR_EMPTY_VALUE =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DSR_EMPTY_VALUE_172", 172);

    /**
     * The provided value "%s" could not be parsed as a DIT structure rule description because an open parenthesis was expected at position %d but instead a '%s' character was found
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Number, Object> ERR_ATTR_SYNTAX_DSR_EXPECTED_OPEN_PARENTHESIS =
                    new LocalizableMessageDescriptor.Arg3<Object, Number, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DSR_EXPECTED_OPEN_PARENTHESIS_173", 173);

    /**
     * The provided value "%s" could not be parsed as a DIT structure rule description because the end of the value was encountered while the Directory Server expected more data to be provided
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE_174", 174);

    /**
     * The provided value "%s" could not be parsed as a DIT structure rule description because the rule ID contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_DSR_ILLEGAL_CHAR_IN_RULE_ID =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DSR_ILLEGAL_CHAR_IN_RULE_ID_175", 175);

    /**
     * The provided value "%s" could not be parsed as a DIT structure rule description because it contained an unexpected closing parenthesis at position %d
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_DSR_UNEXPECTED_CLOSE_PARENTHESIS =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DSR_UNEXPECTED_CLOSE_PARENTHESIS_176", 176);

    /**
     * The provided value "%s" could not be parsed as a DIT structure rule description because it contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_DSR_ILLEGAL_CHAR =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DSR_ILLEGAL_CHAR_177", 177);

    /**
     * The provided value "%s" could not be parsed as a DIT structure rule description because it referenced an unknown name form %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_DSR_UNKNOWN_NAME_FORM =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DSR_UNKNOWN_NAME_FORM_178", 178);

    /**
     * The provided value "%s" could not be parsed as a DIT structure rule description because it referenced an unknown rule ID %d for a superior DIT structure rule
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_DSR_UNKNOWN_RULE_ID =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DSR_UNKNOWN_RULE_ID_179", 179);

    /**
     * The provided value "%s" could not be parsed as a DIT structure rule description because it did not specify the name form for the rule
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_DSR_NO_NAME_FORM =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DSR_NO_NAME_FORM_180", 180);

    /**
     * The provided value "%s" could not be parsed as a DIT structure rule description because a single quote was expected at position %d but the %s character was found instead
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Number, Object> ERR_ATTR_SYNTAX_DSR_EXPECTED_QUOTE_AT_POS =
                    new LocalizableMessageDescriptor.Arg3<Object, Number, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DSR_EXPECTED_QUOTE_AT_POS_181", 181);

    /**
     * The provided value "%s" could not be parsed as a DIT structure rule description because the numeric OID contained two consecutive periods at position %d
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_DSR_DOUBLE_PERIOD_IN_NUMERIC_OID =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DSR_DOUBLE_PERIOD_IN_NUMERIC_OID_182", 182);

    /**
     * The provided value "%s" could not be parsed as a DIT structure rule description because the numeric OID contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_DSR_ILLEGAL_CHAR_IN_NUMERIC_OID =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DSR_ILLEGAL_CHAR_IN_NUMERIC_OID_183", 183);

    /**
     * The provided value "%s" could not be parsed as a DIT structure rule description because the non-numeric OID contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_DSR_ILLEGAL_CHAR_IN_STRING_OID =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DSR_ILLEGAL_CHAR_IN_STRING_OID_184", 184);

    /**
     * The provided value "%s" is too short to be a valid telex number value
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_TELEX_TOO_SHORT =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_TELEX_TOO_SHORT_185", 185);

    /**
     * The provided value "%s" does not hold a valid telex number because a character %s at position %d was not a valid printable string character
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_TELEX_NOT_PRINTABLE =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_TELEX_NOT_PRINTABLE_186", 186);

    /**
     * The provided value "%s" does not hold a valid telex number because character %s at position %d was neither a valid printable string character nor a dollar sign to separate the telex number components
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_TELEX_ILLEGAL_CHAR =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_TELEX_ILLEGAL_CHAR_187", 187);

    /**
     * The provided value "%s" does not hold a valid telex number because the end of the value was found before three dollar-delimited printable strings could be read
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_TELEX_TRUNCATED =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_TELEX_TRUNCATED_188", 188);

    /**
     * The provided value could not be parsed as a valid facsimile telephone number because it was empty
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_FAXNUMBER_EMPTY =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_FAXNUMBER_EMPTY_189", 189);

    /**
     * The provided value "%s" could not be parsed as a valid facsimile telephone number because character %s at position %d was not a valid printable string character
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_FAXNUMBER_NOT_PRINTABLE =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_FAXNUMBER_NOT_PRINTABLE_190", 190);

    /**
     * The provided value "%s" could not be parsed as a valid facsimile telephone number because it ends with a dollar sign, but that dollar sign should have been followed by a fax parameter
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_FAXNUMBER_END_WITH_DOLLAR =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_FAXNUMBER_END_WITH_DOLLAR_191", 191);

    /**
     * The provided value "%s" could not be parsed as a valid facsimile telephone number because the string "%s" between positions %d and %d was not a valid fax parameter
     */
    public static final LocalizableMessageDescriptor.Arg4<Object, Object, Number, Number> ERR_ATTR_SYNTAX_FAXNUMBER_ILLEGAL_PARAMETER =
                    new LocalizableMessageDescriptor.Arg4<Object, Object, Number, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_FAXNUMBER_ILLEGAL_PARAMETER_192", 192);

    /**
     * The provided value "%s" could not be parsed as a valid name and optional UID value because an error occurred while trying to parse the DN portion: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_NAMEANDUID_INVALID_DN =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_NAMEANDUID_INVALID_DN_193", 193);

    /**
     * The provided value "%s" could not be parsed as a valid name and optional UID value because the UID portion contained an illegal binary digit %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_NAMEANDUID_ILLEGAL_BINARY_DIGIT =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_NAMEANDUID_ILLEGAL_BINARY_DIGIT_194", 194);

    /**
     * The provided value could not be parsed as a valid teletex terminal identifier because it was empty
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_TELETEXID_EMPTY =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_TELETEXID_EMPTY_195", 195);

    /**
     * The provided value "%s" could not be parsed as a valid teletex terminal identifier because character %s at position %d was not a valid printable string character
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_TELETEXID_NOT_PRINTABLE =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_TELETEXID_NOT_PRINTABLE_196", 196);

    /**
     * The provided value "%s" could not be parsed as a valid teletex terminal identifier because it ends with a dollar sign, but that dollar sign should have been followed by a TTX parameter
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_TELETEXID_END_WITH_DOLLAR =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_TELETEXID_END_WITH_DOLLAR_197", 197);

    /**
     * The provided value "%s" could not be parsed as a valid teletex terminal identifier because the parameter string does not contain a colon to separate the name from the value
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_TELETEXID_PARAM_NO_COLON =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_TELETEXID_PARAM_NO_COLON_198", 198);

    /**
     * The provided value "%s" could not be parsed as a valid teletex terminal identifier because the string "%s" is not a valid TTX parameter name
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_TELETEXID_ILLEGAL_PARAMETER =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_TELETEXID_ILLEGAL_PARAMETER_199", 199);

    /**
     * The provided value could not be parsed as an other mailbox value because it was empty
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_OTHER_MAILBOX_EMPTY_VALUE =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_OTHER_MAILBOX_EMPTY_VALUE_200", 200);

    /**
     * The provided value "%s" could not be parsed as an other mailbox value because there was no mailbox type before the dollar sign
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_OTHER_MAILBOX_NO_MBTYPE =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_OTHER_MAILBOX_NO_MBTYPE_201", 201);

    /**
     * The provided value "%s" could not be parsed as an other mailbox value because the mailbox type contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_OTHER_MAILBOX_ILLEGAL_MBTYPE_CHAR =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_OTHER_MAILBOX_ILLEGAL_MBTYPE_CHAR_202", 202);

    /**
     * The provided value "%s" could not be parsed as an other mailbox value because there was no mailbox after the dollar sign
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_OTHER_MAILBOX_NO_MAILBOX =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_OTHER_MAILBOX_NO_MAILBOX_203", 203);

    /**
     * The provided value "%s" could not be parsed as an other mailbox value because the mailbox contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_OTHER_MAILBOX_ILLEGAL_MB_CHAR =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_OTHER_MAILBOX_ILLEGAL_MB_CHAR_204", 204);

    /**
     * The provided value "%s" could not be parsed as a guide value because it did not contain an objectclass name or OID before the octothorpe (#) character
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_GUIDE_NO_OC =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_GUIDE_NO_OC_205", 205);

    /**
     * The provided value "%s" could not be parsed as a guide value because the criteria portion %s contained an illegal character %c at position %d
     */
    public static final LocalizableMessageDescriptor.Arg4<Object, Object, Character, Number> ERR_ATTR_SYNTAX_GUIDE_ILLEGAL_CHAR =
                    new LocalizableMessageDescriptor.Arg4<Object, Object, Character, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_GUIDE_ILLEGAL_CHAR_206", 206);

    /**
     * The provided value "%s" could not be parsed as a guide value because the criteria portion %s did not contain a close parenthesis that corresponded to the initial open parenthesis
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_GUIDE_MISSING_CLOSE_PAREN =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_GUIDE_MISSING_CLOSE_PAREN_207", 207);

    /**
     * The provided value "%s" could not be parsed as a guide value because the criteria portion %s started with a question mark but was not followed by the string "true" or "false"
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_GUIDE_INVALID_QUESTION_MARK =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_GUIDE_INVALID_QUESTION_MARK_208", 208);

    /**
     * The provided value "%s" could not be parsed as a guide value because the criteria portion %s did not contain a dollar sign to separate the attribute type from the match type
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_GUIDE_NO_DOLLAR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_GUIDE_NO_DOLLAR_209", 209);

    /**
     * The provided value "%s" could not be parsed as a guide value because the criteria portion %s did not specify an attribute type before the dollar sign
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_GUIDE_NO_ATTR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_GUIDE_NO_ATTR_210", 210);

    /**
     * The provided value "%s" could not be parsed as a guide value because the criteria portion %s did not specify a match type after the dollar sign
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_GUIDE_NO_MATCH_TYPE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_GUIDE_NO_MATCH_TYPE_211", 211);

    /**
     * The provided value "%s" could not be parsed as a guide value because the criteria portion %s had an invalid match type starting at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_GUIDE_INVALID_MATCH_TYPE =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_GUIDE_INVALID_MATCH_TYPE_212", 212);

    /**
     * The provided value "%s" could not be parsed as an enhanced guide value because it did not contain an octothorpe (#) character to separate the objectclass from the criteria
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_SHARP =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_SHARP_213", 213);

    /**
     * The provided value "%s" could not be parsed as an enhanced guide value because it did not contain an objectclass name or OID before the octothorpe (#) character
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_OC =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_OC_214", 214);

    /**
     * The provided value "%s" could not be parsed as an enhanced guide value because it did not have an octothorpe (#) character to separate the criteria from the scope
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_FINAL_SHARP =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_FINAL_SHARP_218", 218);

    /**
     * The provided value "%s" could not be parsed as an enhanced guide value because no scope was provided after the final octothorpe (#) character
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_SCOPE =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_SCOPE_219", 219);

    /**
     * The provided value "%s" could not be parsed as an enhanced guide value because the specified scope %s was invalid
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_ENHANCEDGUIDE_INVALID_SCOPE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ENHANCEDGUIDE_INVALID_SCOPE_220", 220);

    /**
     * The provided value "%s" could not be parsed as an enhanced guide value because it did not specify any criteria between the octothorpe (#) characters
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_CRITERIA =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_CRITERIA_221", 221);

    /**
     * The provided value %s could not be parsed as a valid OID: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_OID_INVALID_VALUE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_OID_INVALID_VALUE_222", 222);

    /**
     * The provided value "%s" has an invalid length for a UUID. All UUID values must have a length of exactly 36 bytes, but the provided value had a length of %d bytes
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> WARN_ATTR_SYNTAX_UUID_INVALID_LENGTH =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_UUID_INVALID_LENGTH_236", 236);

    /**
     * The provided value "%s" should have had a dash at position %d, but the character '%s' was found instead
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Number, Object> WARN_ATTR_SYNTAX_UUID_EXPECTED_DASH =
                    new LocalizableMessageDescriptor.Arg3<Object, Number, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_UUID_EXPECTED_DASH_237", 237);

    /**
     * The provided value "%s" should have had a hexadecimal digit at position %d, but the character '%s' was found instead
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Number, Object> WARN_ATTR_SYNTAX_UUID_EXPECTED_HEX =
                    new LocalizableMessageDescriptor.Arg3<Object, Number, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_UUID_EXPECTED_HEX_238", 238);

    /**
     * The operation attempted to assign a zero-length value to an attribute with the directory string syntax
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_DIRECTORYSTRING_INVALID_ZEROLENGTH_VALUE =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DIRECTORYSTRING_INVALID_ZEROLENGTH_VALUE_241", 241);

    /**
     * The provided authPassword value had an invalid scheme character at position %d
     */
    public static final LocalizableMessageDescriptor.Arg1<Number> ERR_ATTR_SYNTAX_AUTHPW_INVALID_SCHEME_CHAR =
                    new LocalizableMessageDescriptor.Arg1<Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_AUTHPW_INVALID_SCHEME_CHAR_243", 243);

    /**
     * The provided authPassword value had a zero-length scheme element
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_AUTHPW_NO_SCHEME =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_AUTHPW_NO_SCHEME_244", 244);

    /**
     * The provided authPassword value was missing the separator character or had an illegal character between the scheme and authInfo elements
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_AUTHPW_NO_SCHEME_SEPARATOR =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_AUTHPW_NO_SCHEME_SEPARATOR_245", 245);

    /**
     * The provided authPassword value had an invalid authInfo character at position %d
     */
    public static final LocalizableMessageDescriptor.Arg1<Number> ERR_ATTR_SYNTAX_AUTHPW_INVALID_AUTH_INFO_CHAR =
                    new LocalizableMessageDescriptor.Arg1<Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_AUTHPW_INVALID_AUTH_INFO_CHAR_246", 246);

    /**
     * The provided authPassword value had a zero-length authInfo element
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_AUTHPW_NO_AUTH_INFO =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_AUTHPW_NO_AUTH_INFO_247", 247);

    /**
     * The provided authPassword value was missing the separator character or had an illegal character between the authInfo and authValue elements
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_AUTHPW_NO_AUTH_INFO_SEPARATOR =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_AUTHPW_NO_AUTH_INFO_SEPARATOR_248", 248);

    /**
     * The provided value "%s" could not be parsed by the integer first component matching rule because it did not start with a parenthesis
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_EMR_INTFIRSTCOMP_NO_INITIAL_PARENTHESIS =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_EMR_INTFIRSTCOMP_NO_INITIAL_PARENTHESIS_249", 249);

    /**
     * The provided value "%s" could not be parsed by the integer first component matching rule because it did not have any non-space characters after the opening parenthesis
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_EMR_INTFIRSTCOMP_NO_NONSPACE =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_EMR_INTFIRSTCOMP_NO_NONSPACE_250", 250);

    /**
     * The provided value "%s" could not be parsed by the integer first component matching rule because it did not have any space characters after the first component
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_EMR_INTFIRSTCOMP_NO_SPACE_AFTER_INT =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_EMR_INTFIRSTCOMP_NO_SPACE_AFTER_INT_251", 251);

    /**
     * The provided value "%s" could not be parsed by the integer first component matching rule because the first component does not appear to be an integer value
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_EMR_INTFIRSTCOMP_FIRST_COMPONENT_NOT_INT =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_EMR_INTFIRSTCOMP_FIRST_COMPONENT_NOT_INT_252", 252);

    /**
     * No value was given to decode by the user password attribute syntax
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_USERPW_NO_VALUE =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_USERPW_NO_VALUE_253", 253);

    /**
     * Unable to decode the provided value according to the user password syntax because the value does not start with the opening curly brace ("{") character
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_USERPW_NO_OPENING_BRACE =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_USERPW_NO_OPENING_BRACE_254", 254);

    /**
     * Unable to decode the provided value according to the user password syntax because the value does not contain a closing curly brace ("}") character
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_USERPW_NO_CLOSING_BRACE =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_USERPW_NO_CLOSING_BRACE_255", 255);

    /**
     * Unable to decode the provided value according to the user password syntax because the value does not contain a storage scheme name
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_USERPW_NO_SCHEME =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_USERPW_NO_SCHEME_256", 256);

    /**
     * The provided value "%s" could not be parsed as a valid RFC 3672 subtree specification
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_RFC3672_SUBTREE_SPECIFICATION_INVALID =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_RFC3672_SUBTREE_SPECIFICATION_INVALID_257", 257);

    /**
     * The provided value %s is not allowed for attributes with a Integer syntax
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_ATTR_SYNTAX_ILLEGAL_INTEGER =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_ILLEGAL_INTEGER_260", 260);

    /**
     * The provided authPassword value had an invalid authValue character at position %d
     */
    public static final LocalizableMessageDescriptor.Arg1<Number> ERR_ATTR_SYNTAX_AUTHPW_INVALID_AUTH_VALUE_CHAR =
                    new LocalizableMessageDescriptor.Arg1<Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_AUTHPW_INVALID_AUTH_VALUE_CHAR_261", 261);

    /**
     * The provided authPassword value had a zero-length authValue element
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_AUTHPW_NO_AUTH_VALUE =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_AUTHPW_NO_AUTH_VALUE_262", 262);

    /**
     * The provided authPassword value had an invalid trailing character at position %d
     */
    public static final LocalizableMessageDescriptor.Arg1<Number> ERR_ATTR_SYNTAX_AUTHPW_INVALID_TRAILING_CHAR =
                    new LocalizableMessageDescriptor.Arg1<Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_AUTHPW_INVALID_TRAILING_CHAR_263", 263);

    /**
     * The provided value "%s" could not be parsed as an attribute syntax extension because an invalid character was found at position %d
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_ATTRSYNTAX_EXTENSION_INVALID_CHARACTER =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ATTRSYNTAX_EXTENSION_INVALID_CHARACTER_264", 264);

    /**
     * The definition for objectclass %s is invalid because it has an objectclass type of %s but this is incompatible with the objectclass type %s for the superior class %s
     */
    public static final LocalizableMessageDescriptor.Arg4<Object, Object, Object, Object> WARN_ATTR_SYNTAX_OBJECTCLASS_INVALID_SUPERIOR_TYPE =
                    new LocalizableMessageDescriptor.Arg4<Object, Object, Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_OBJECTCLASS_INVALID_SUPERIOR_TYPE_266", 266);

    /**
     * The definition for objectclass %s is invalid because it is defined as a structural class but its superior chain does not include the "top" objectclass
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_ATTR_SYNTAX_OBJECTCLASS_STRUCTURAL_SUPERIOR_NOT_TOP =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_OBJECTCLASS_STRUCTURAL_SUPERIOR_NOT_TOP_267", 267);

    /**
     * The definition for attribute type %s is invalid because its attribute usage %s is not the same as the usage for its superior type %s
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> WARN_ATTR_SYNTAX_ATTRTYPE_INVALID_SUPERIOR_USAGE =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_ATTRTYPE_INVALID_SUPERIOR_USAGE_268", 268);

    /**
     * The provided value "%s" could not be parsed as a valid subtree specification
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_SUBTREE_SPECIFICATION_INVALID =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_SUBTREE_SPECIFICATION_INVALID_269", 269);

    /**
     * The definition for attribute type %s is invalid because it is not defined as a collective type but the superior type %s is collective
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_ATTRTYPE_NONCOLLECTIVE_FROM_COLLECTIVE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_ATTRTYPE_NONCOLLECTIVE_FROM_COLLECTIVE_270", 270);

    /**
     * The DIT content rule "%s" is not valid because it prohibits the use of attribute type %s which is required by the associated structural object class %s
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> ERR_ATTR_SYNTAX_DCR_PROHIBITED_REQUIRED_BY_STRUCTURAL =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DCR_PROHIBITED_REQUIRED_BY_STRUCTURAL_271", 271);

    /**
     * The DIT content rule "%s" is not valid because it prohibits the use of attribute type %s which is required by the associated auxiliary object class %s
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> ERR_ATTR_SYNTAX_DCR_PROHIBITED_REQUIRED_BY_AUXILIARY =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DCR_PROHIBITED_REQUIRED_BY_AUXILIARY_272", 272);

    /**
     * The definition for attribute type %s is invalid because it is declared NO-USER-MODIFICATION but does not have an operational usage
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_ATTR_SYNTAX_ATTRTYPE_NO_USER_MOD_NOT_OPERATIONAL =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_ATTRTYPE_NO_USER_MOD_NOT_OPERATIONAL_274", 274);

    /**
     * The provided value %s is not a valid generalized time value because it contains illegal character %s in the fraction component
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_FRACTION_CHAR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_FRACTION_CHAR_275", 275);

    /**
     * The provided value %s is not a valid generalized time value because it does not contain at least one digit after the period to use as the fractional component
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_ATTR_SYNTAX_GENERALIZED_TIME_EMPTY_FRACTION =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_GENERALIZED_TIME_EMPTY_FRACTION_276", 276);

    /**
     * The provided value %s is not a valid generalized time value because it does not end with 'Z' or a time zone offset
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_ATTR_SYNTAX_GENERALIZED_TIME_NO_TIME_ZONE_INFO =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_GENERALIZED_TIME_NO_TIME_ZONE_INFO_277", 277);

    /**
     * The provided value %s is not a valid generalized time value because it represents an invalid time (e.g., a date that does not exist): %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_TIME =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_TIME_278", 278);

    /**
     * A schema element could not be imported: %s, %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> NOTE_SCHEMA_IMPORT_FAILED =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "NOTE_SCHEMA_IMPORT_FAILED_279", 279);

    /**
     * The collation rule %s under matching rule entry %s is invalid as the locale %s is not supported by JVM
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Object> WARN_ATTR_INVALID_COLLATION_MATCHING_RULE_LOCALE =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_INVALID_COLLATION_MATCHING_RULE_LOCALE_280", 280);

    /**
     * The provided collation rule %s does not contain a valid format of OID:LOCALE
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_ATTR_INVALID_COLLATION_MATCHING_RULE_FORMAT =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_INVALID_COLLATION_MATCHING_RULE_FORMAT_281", 281);

    /**
     * The provided value "%s" could not be parsed as a valid distinguished name because an attribute value started with a character at position %d that needs to be escaped
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_DN_INVALID_REQUIRES_ESCAPE_CHAR =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_DN_INVALID_REQUIRES_ESCAPE_CHAR_282", 282);

    /**
     * The provided value "%s" could not be parsed as a valid attribute type definition because character '%c' at position %d is not allowed in an attribute type name
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Character, Number> ERR_ATTR_SYNTAX_ATTR_ILLEGAL_CHAR =
                    new LocalizableMessageDescriptor.Arg3<Object, Character, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ATTR_ILLEGAL_CHAR_283", 283);

    /**
     * The provided value "%s" could not be parsed as a valid attribute type definition because the underscore character is not allowed in an attribute type name unless the %s configuration option is enabled
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_ATTR_ILLEGAL_UNDERSCORE_CHAR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ATTR_ILLEGAL_UNDERSCORE_CHAR_284", 284);

    /**
     * The provided value "%s" could not be parsed as a valid attribute type definition because the hyphen character is not allowed as the first character of an attribute type name
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_ATTR_ILLEGAL_INITIAL_DASH =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ATTR_ILLEGAL_INITIAL_DASH_285", 285);

    /**
     * The provided value "%s" could not be parsed as a valid attribute type definition because the underscore character is not allowed as the first character of an attribute type name even if the %s configuration option is enabled
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_ATTR_ILLEGAL_INITIAL_UNDERSCORE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ATTR_ILLEGAL_INITIAL_UNDERSCORE_286", 286);

    /**
     * The provided value "%s" could not be parsed as a valid attribute type definition because the digit '%c' is not allowed as the first character of an attribute type name unless the name is specified as an OID or the %s configuration option is enabled
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Character, Object> ERR_ATTR_SYNTAX_ATTR_ILLEGAL_INITIAL_DIGIT =
                    new LocalizableMessageDescriptor.Arg3<Object, Character, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ATTR_ILLEGAL_INITIAL_DIGIT_287", 287);

    /**
     * The provided value "%s" could not be parsed as a valid object class definition because character '%c' at position %d is not allowed in an object class name
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Character, Number> ERR_OC_SYNTAX_ATTR_ILLEGAL_CHAR =
                    new LocalizableMessageDescriptor.Arg3<Object, Character, Number>(SchemaMessages.class, RESOURCE, "ERR_OC_SYNTAX_ATTR_ILLEGAL_CHAR_288", 288);

    /**
     * The provided value "%s" could not be parsed as a valid object class definition because the underscore character is not allowed in an object class name unless the %s configuration option is enabled
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_OC_SYNTAX_ATTR_ILLEGAL_UNDERSCORE_CHAR =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_OC_SYNTAX_ATTR_ILLEGAL_UNDERSCORE_CHAR_289", 289);

    /**
     * The provided value "%s" could not be parsed as a valid object class definition because the hyphen character is not allowed as the first character of an object class name
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_OC_SYNTAX_ATTR_ILLEGAL_INITIAL_DASH =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_OC_SYNTAX_ATTR_ILLEGAL_INITIAL_DASH_290", 290);

    /**
     * The provided value "%s" could not be parsed as a valid object class definition because the underscore character is not allowed as the first character of an object class name even if the %s configuration option is enabled
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_OC_SYNTAX_ATTR_ILLEGAL_INITIAL_UNDERSCORE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_OC_SYNTAX_ATTR_ILLEGAL_INITIAL_UNDERSCORE_291", 291);

    /**
     * The provided value "%s" could not be parsed as a valid object class definition because the digit '%c' is not allowed as the first character of an object class name unless the name is specified as an OID or the %s configuration option is enabled
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Character, Object> ERR_OC_SYNTAX_ATTR_ILLEGAL_INITIAL_DIGIT =
                    new LocalizableMessageDescriptor.Arg3<Object, Character, Object>(SchemaMessages.class, RESOURCE, "ERR_OC_SYNTAX_ATTR_ILLEGAL_INITIAL_DIGIT_292", 292);

    /**
     * The provided value "%s" could not be parsed as a valid assertion value because the character '%c' is not allowed. The acceptable values are s(second),m(minute), ,h(hour),d(day) and w(week)
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Character> WARN_ATTR_INVALID_RELATIVE_TIME_ASSERTION_FORMAT =
                    new LocalizableMessageDescriptor.Arg2<Object, Character>(SchemaMessages.class, RESOURCE, "WARN_ATTR_INVALID_RELATIVE_TIME_ASSERTION_FORMAT_294", 294);

    /**
     * The provided value "%s" could not be parsed as a valid assertion value because the character '%c' is not allowed. The acceptable values are s(second), m (minute), h (hour), D (date), M(month) and Y(year)
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Character> WARN_ATTR_INVALID_PARTIAL_TIME_ASSERTION_FORMAT =
                    new LocalizableMessageDescriptor.Arg2<Object, Character>(SchemaMessages.class, RESOURCE, "WARN_ATTR_INVALID_PARTIAL_TIME_ASSERTION_FORMAT_295", 295);

    /**
     * The provided value "%s" could not be parsed as a valid assertion value because "%d" is not a valid second specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> WARN_ATTR_INVALID_SECOND_ASSERTION_FORMAT =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "WARN_ATTR_INVALID_SECOND_ASSERTION_FORMAT_296", 296);

    /**
     * The provided value "%s" could not be parsed as a valid assertion value because "%d" is not a valid date specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> WARN_ATTR_INVALID_DATE_ASSERTION_FORMAT =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "WARN_ATTR_INVALID_DATE_ASSERTION_FORMAT_297", 297);

    /**
     * The provided value "%s" could not be parsed as a valid assertion value because "%d" is not a valid month specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> WARN_ATTR_INVALID_MONTH_ASSERTION_FORMAT =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "WARN_ATTR_INVALID_MONTH_ASSERTION_FORMAT_298", 298);

    /**
     * The provided value "%s" could not be parsed as a valid assertion value because "%d" is not a valid year specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> WARN_ATTR_INVALID_YEAR_ASSERTION_FORMAT =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "WARN_ATTR_INVALID_YEAR_ASSERTION_FORMAT_299", 299);

    /**
     * The provided value "%s" could not be parsed as a valid assertion value because there is conflicting value "%d" for DD(Date) specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> WARN_ATTR_DUPLICATE_DATE_ASSERTION_FORMAT =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "WARN_ATTR_DUPLICATE_DATE_ASSERTION_FORMAT_300", 300);

    /**
     * The provided value "%s" could not be parsed as a valid assertion value because there is conflicting value "%d" for MM(Month) specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> WARN_ATTR_DUPLICATE_MONTH_ASSERTION_FORMAT =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "WARN_ATTR_DUPLICATE_MONTH_ASSERTION_FORMAT_301", 301);

    /**
     * The provided value "%s" could not be parsed as a valid assertion value because there is conflicting value "%d" for YYYY(Year) specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> WARN_ATTR_DUPLICATE_YEAR_ASSERTION_FORMAT =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "WARN_ATTR_DUPLICATE_YEAR_ASSERTION_FORMAT_302", 302);

    /**
     * The provided value "%s" could not be parsed as a valid assertion value because more than one time units are not allowed
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_ATTR_CONFLICTING_ASSERTION_FORMAT =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_CONFLICTING_ASSERTION_FORMAT_304", 304);

    /**
     * The provided value "%s" could not be parsed as an ldap syntax because it contains an unrecognized extension %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_LDAPSYNTAX_UNKNOWN_EXT =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_LDAPSYNTAX_UNKNOWN_EXT_306", 306);

    /**
     * The provided value "%s" cannot be parsed as a valid regex syntax because it does not match the pattern "%s"
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_LDAPSYNTAX_REGEX_INVALID_VALUE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_LDAPSYNTAX_REGEX_INVALID_VALUE_307", 307);

    /**
     * The provided value "%s" could not be parsed as a regex syntax because it does not contain a regex pattern
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_ATTR_SYNTAX_LDAPSYNTAX_REGEX_NO_PATTERN =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_LDAPSYNTAX_REGEX_NO_PATTERN_308", 308);

    /**
     * The provided value "%s" could not be parsed as a regex syntax because the provided regex pattern "%s" is invalid
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_LDAPSYNTAX_REGEX_INVALID_PATTERN =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_LDAPSYNTAX_REGEX_INVALID_PATTERN_309", 309);

    /**
     * The provided value "%s" cannot be parsed because it is not allowed by enumeration syntax with OID "%s"
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> WARN_ATTR_SYNTAX_LDAPSYNTAX_ENUM_INVALID_VALUE =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_LDAPSYNTAX_ENUM_INVALID_VALUE_310", 310);

    /**
     * The provided value "%s" cannot be parsed as an enumeration syntax because it contains a duplicate value "%s" at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> WARN_ATTR_SYNTAX_LDAPSYNTAX_ENUM_DUPLICATE_VALUE =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "WARN_ATTR_SYNTAX_LDAPSYNTAX_ENUM_DUPLICATE_VALUE_311", 311);

    /**
     * The provided value "%s" could not be parsed as a valid assertion value because "%d" is not a valid minute specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> WARN_ATTR_INVALID_MINUTE_ASSERTION_FORMAT =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "WARN_ATTR_INVALID_MINUTE_ASSERTION_FORMAT_312", 312);

    /**
     * The provided value "%s" could not be parsed as a valid assertion value because "%d" is not a valid hour specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> WARN_ATTR_INVALID_HOUR_ASSERTION_FORMAT =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "WARN_ATTR_INVALID_HOUR_ASSERTION_FORMAT_313", 313);

    /**
     * The provided value "%s" could not be parsed as a valid assertion value because there is conflicting value "%d" for s(Second) specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> WARN_ATTR_DUPLICATE_SECOND_ASSERTION_FORMAT =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "WARN_ATTR_DUPLICATE_SECOND_ASSERTION_FORMAT_314", 314);

    /**
     * The provided value "%s" could not be parsed as a valid assertion value because there is conflicting value "%d" for m(Minute) specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> WARN_ATTR_DUPLICATE_MINUTE_ASSERTION_FORMAT =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "WARN_ATTR_DUPLICATE_MINUTE_ASSERTION_FORMAT_315", 315);

    /**
     * The provided value "%s" could not be parsed as a valid assertion value because there is conflicting value "%d" for h(Hour) specification
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> WARN_ATTR_DUPLICATE_HOUR_ASSERTION_FORMAT =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "WARN_ATTR_DUPLICATE_HOUR_ASSERTION_FORMAT_316", 316);

    /**
     * The provided value could not be parsed as a valid ldap syntax description because it was empty or contained only whitespace
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_ATTR_SYNTAX_LDAPSYNTAX_EMPTY_VALUE =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_LDAPSYNTAX_EMPTY_VALUE_317", 317);

    /**
     * The provided value "%s" could not be parsed as an ldap syntax description because an open parenthesis was expected at position %d but instead a '%s' character was found
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Number, Object> ERR_ATTR_SYNTAX_LDAPSYNTAX_EXPECTED_OPEN_PARENTHESIS =
                    new LocalizableMessageDescriptor.Arg3<Object, Number, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_LDAPSYNTAX_EXPECTED_OPEN_PARENTHESIS_318", 318);

    /**
     * The provided value "%s" could not be parsed as an ldap syntax description because the end of the value was encountered while the Directory Server expected more data to be provided
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_LDAPSYNTAX_TRUNCATED_VALUE =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_LDAPSYNTAX_TRUNCATED_VALUE_319", 319);

    /**
     * The provided value "%s" could not be parsed as an ldap syntax description because the numeric OID contained two consecutive periods at position %d
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_LDAPSYNTAX_DOUBLE_PERIOD_IN_NUMERIC_OID =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_LDAPSYNTAX_DOUBLE_PERIOD_IN_NUMERIC_OID_320", 320);

    /**
     * The provided value "%s" could not be parsed as an ldap syntax description because the numeric OID contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_LDAPSYNTAX_ILLEGAL_CHAR_IN_NUMERIC_OID =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_LDAPSYNTAX_ILLEGAL_CHAR_IN_NUMERIC_OID_321", 321);

    /**
     * The provided value "%s" could not be parsed as an ldap syntax description because the non-numeric OID contained an illegal character %s at position %d
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Object, Number> ERR_ATTR_SYNTAX_LDAPSYNTAX_ILLEGAL_CHAR_IN_STRING_OID =
                    new LocalizableMessageDescriptor.Arg3<Object, Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_LDAPSYNTAX_ILLEGAL_CHAR_IN_STRING_OID_322", 322);

    /**
     * The provided value "%s" could not be parsed as an ldap syntax description because it contained an unexpected closing parenthesis at position %d
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_LDAPSYNTAX_UNEXPECTED_CLOSE_PARENTHESIS =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_LDAPSYNTAX_UNEXPECTED_CLOSE_PARENTHESIS_323", 323);

    /**
     * The provided value "%s" could not be parsed as an ldap syntax description because it contains more than one form of constructor
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_LDAPSYNTAX_TOO_MANY_EXTENSIONS =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_LDAPSYNTAX_TOO_MANY_EXTENSIONS_324", 324);

    /**
     * The definition for the ldap syntax with OID %s declared that it's a substitute for a syntax with OID %s. No such syntax is configured for use in the Directory Server
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_ATTR_SYNTAX_LDAPSYNTAX_UNKNOWN_SYNTAX =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_LDAPSYNTAX_UNKNOWN_SYNTAX_325", 325);

    /**
     * The provided value "%s" could not be parsed as an enumeration syntax, because there is no value
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_LDAPSYNTAX_ENUM_NO_VALUES =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_LDAPSYNTAX_ENUM_NO_VALUES_326", 326);

    /**
     * The provided value "%s" could not be parsed as an ldap syntax extension because an invalid character was found at position %d
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Number> ERR_ATTR_SYNTAX_LDAPSYNTAX_EXTENSION_INVALID_CHARACTER =
                    new LocalizableMessageDescriptor.Arg2<Object, Number>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_LDAPSYNTAX_EXTENSION_INVALID_CHARACTER_327", 327);

    /**
     * The provided value "%s" could not be parsed as an ldap syntax description because a single quote was expected at position %d but the character %s was found instead
     */
    public static final LocalizableMessageDescriptor.Arg3<Object, Number, Object> ERR_ATTR_SYNTAX_LDAPSYNTAX_EXPECTED_QUOTE_AT_POS =
                    new LocalizableMessageDescriptor.Arg3<Object, Number, Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_LDAPSYNTAX_EXPECTED_QUOTE_AT_POS_329", 329);

    /**
     * The provided value is not a valid X.509 Certificate
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_SYNTAX_CERTIFICATE_NOTVALID =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_SYNTAX_CERTIFICATE_NOTVALID_330", 330);

    /**
     * The provided value is not a valid X.509 Certificate because it contains an invalid version number (%d)
     */
    public static final LocalizableMessageDescriptor.Arg1<Number> ERR_SYNTAX_CERTIFICATE_INVALID_VERSION =
                    new LocalizableMessageDescriptor.Arg1<Number>(SchemaMessages.class, RESOURCE, "ERR_SYNTAX_CERTIFICATE_INVALID_VERSION_331", 331);

    /**
     * The provided value is not a valid X.509 Certificate because it contains invalid DER encodings
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_SYNTAX_CERTIFICATE_INVALID_DER =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_SYNTAX_CERTIFICATE_INVALID_DER_332", 332);

    /**
     * The provided value "%s" is not a valid ISO 3166 country code
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_COUNTRY_NO_VALID_ISO_CODE =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_COUNTRY_NO_VALID_ISO_CODE_333", 333);

    /**
     * The provided value "%s" is not safe for X-SCHEMA-FILE
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_ATTR_SYNTAX_ILLEGAL_X_SCHEMA_FILE =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_ATTR_SYNTAX_ILLEGAL_X_SCHEMA_FILE_334", 334);

    /**
     * The value could not be parsed as an X.509 certificate: "%s"
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> WARN_CERTIFICATE_MATCH_PARSE_ERROR =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "WARN_CERTIFICATE_MATCH_PARSE_ERROR_335", 335);

    /**
     * The provided value "%s" could not be parsed as a valid distinguished name because an error occurred while trying to parse the DN portion: %s
     */
    public static final LocalizableMessageDescriptor.Arg2<Object, Object> ERR_CERTIFICATE_MATCH_INVALID_DN =
                    new LocalizableMessageDescriptor.Arg2<Object, Object>(SchemaMessages.class, RESOURCE, "ERR_CERTIFICATE_MATCH_INVALID_DN_336", 336);

    /**
     * The identifier "%s" could not be found at the correct position
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_CERTIFICATE_MATCH_IDENTIFIER_NOT_FOUND =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_CERTIFICATE_MATCH_IDENTIFIER_NOT_FOUND_337", 337);

    /**
     * The GSER value contains additional characters at the end of the assertion
     */
    public static final LocalizableMessageDescriptor.Arg0 ERR_CERTIFICATE_MATCH_EXPECTED_END =
                    new LocalizableMessageDescriptor.Arg0(SchemaMessages.class, RESOURCE, "ERR_CERTIFICATE_MATCH_EXPECTED_END_338", 338);

    /**
     * An error occurred while parsing the GSER String: "%s"
     */
    public static final LocalizableMessageDescriptor.Arg1<Object> ERR_CERTIFICATE_MATCH_GSER_INVALID =
                    new LocalizableMessageDescriptor.Arg1<Object>(SchemaMessages.class, RESOURCE, "ERR_CERTIFICATE_MATCH_GSER_INVALID_339", 339);

}
