package org.opends.messages;

import org.forgerock.i18n.LocalizableMessageDescriptor;

/**
 * This file contains localizable message descriptors having the resource
 * name {@code org.opends.messages.version}. This file was generated
 * automatically by the {@code i18n-maven-plugin} from the property file
 * {@code org/opends/messages/version.properties} and it should not be manually edited.
 */
public final class VersionMessages {
    // The name of the resource bundle.
    private static final String RESOURCE = "org.opends.messages.version";

    // Prevent instantiation.
    private VersionMessages() {
        // Do nothing.
    }

    /**
     * Returns the name of the resource associated with the messages contained
     * in this class. The resource name may be used for obtaining named loggers,
     * e.g. using SLF4J's {@code org.slf4j.LoggerFactory#getLogger(String name)}.
     *
     * @return The name of the resource associated with the messages contained
     *         in this class.
     */
    public static String resourceName() {
        return RESOURCE;
    }

    /**
     * With this upgrade, the Berkeley DB Java Edition JAR will be upgraded to version 3.2.13 which introduces incompatibilities to the data format. Consequently if at a later time you wish to revert this installation to its prior version you will have to export the data from this server and reimport it once the reversion has finished
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_890_UPGRADE =
                    new LocalizableMessageDescriptor.Arg0(VersionMessages.class, RESOURCE, "INFO_890_UPGRADE_1", 1);

    /**
     * With this reversion, the Berkeley DB Java Edition JAR will be downgraded to an older version which uses a different data format than the current version. In order to revert this server you will have to export the data from this server and reimport it after the reversion has finished
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_890_REVERSION =
                    new LocalizableMessageDescriptor.Arg0(VersionMessages.class, RESOURCE, "INFO_890_REVERSION_2", 2);

    /**
     * This upgrade introduces improvements to the data format which are not backward compatible with the current version. Consequently if at a later time you wish to revert this installation to its prior version you will have to export the data from this server and reimport it once the reversion has finished
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_1582_UPGRADE =
                    new LocalizableMessageDescriptor.Arg0(VersionMessages.class, RESOURCE, "INFO_1582_UPGRADE_3", 3);

    /**
     * With this reversion the data format used to store data by the server will be reverted to a prior version. In order to revert this server you will have to export the data from this server and reimport it after the reversion has finished
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_1582_REVERSION =
                    new LocalizableMessageDescriptor.Arg0(VersionMessages.class, RESOURCE, "INFO_1582_REVERSION_4", 4);

    /**
     * This upgrade introduces improvements to the data format which are not backward compatible with the current version. Consequently if at a later time you wish to revert this installation to its prior version you will have to export the data from this server and reimport it once the reversion has finished
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_2049_UPGRADE =
                    new LocalizableMessageDescriptor.Arg0(VersionMessages.class, RESOURCE, "INFO_2049_UPGRADE_5", 5);

    /**
     * With this reversion the data format used to store data by the server will be reverted to a prior version. In order to revert this server you will have to export the data from this server and reimport it after the reversion has finished
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_2049_REVERSION =
                    new LocalizableMessageDescriptor.Arg0(VersionMessages.class, RESOURCE, "INFO_2049_REVERSION_6", 6);

    /**
     * This upgrade introduces an incompatible property change for the default password storage scheme and deprecated password storage schemes associated with a password policy. The schemes are now referenced by DN rather than by name. Upgrade is not possible because the scheme name cannot be automatically translated into a DN
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_2974_UPGRADE =
                    new LocalizableMessageDescriptor.Arg0(VersionMessages.class, RESOURCE, "INFO_2974_UPGRADE_7", 7);

    /**
     * It is not possible to revert to a revision before 2974 because the default password storage scheme and deprecated password storage scheme references in the password policy have been converted from names to DNs, and it is not possible to revert from the DN back to the scheme name
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_2974_REVERSION =
                    new LocalizableMessageDescriptor.Arg0(VersionMessages.class, RESOURCE, "INFO_2974_REVERSION_8", 8);

    /**
     * This upgrade introduces a new security framework that is not backwards compatible. Upgrade is not possible
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_3294_UPGRADE =
                    new LocalizableMessageDescriptor.Arg0(VersionMessages.class, RESOURCE, "INFO_3294_UPGRADE_9", 9);

    /**
     * The revision 3294 introduces a new security framework. Revert is not possible
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_3294_REVERSION =
                    new LocalizableMessageDescriptor.Arg0(VersionMessages.class, RESOURCE, "INFO_3294_REVERSION_10", 10);

    /**
     * This upgrade introduces a change in the backend configuration that is not backwards compatible. Upgrade is not possible
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_3708_UPGRADE =
                    new LocalizableMessageDescriptor.Arg0(VersionMessages.class, RESOURCE, "INFO_3708_UPGRADE_11", 11);

    /**
     * The revision 3294 introduces a change in the backend configuration. Revert is not possible
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_3708_REVERSION =
                    new LocalizableMessageDescriptor.Arg0(VersionMessages.class, RESOURCE, "INFO_3708_REVERSION_12", 12);

    /**
     * This change introduces a change to the way in which distinguished names are normalized. In order to upgrade this server you will have to export the data from this server and reimport it after the upgrade has finished
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_3873_UPGRADE =
                    new LocalizableMessageDescriptor.Arg0(VersionMessages.class, RESOURCE, "INFO_3873_UPGRADE_13", 13);

    /**
     * With this reversion the normalized form of distinguished names will be reverted to a prior version. In order to revert this server you will have to export the data from this server and reimport it after the reversion has finished
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_3873_REVERSION =
                    new LocalizableMessageDescriptor.Arg0(VersionMessages.class, RESOURCE, "INFO_3873_REVERSION_14", 14);

    /**
     * The revision 5134 introduces a change to the way in which certain matching rules normalize an attribute or assertion value. In order to upgrade this server you will have to export the data from this server and reimport it after the upgrade has finished
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_5134_UPGRADE =
                    new LocalizableMessageDescriptor.Arg0(VersionMessages.class, RESOURCE, "INFO_5134_UPGRADE_15", 15);

    /**
     * With this reversion the normalization of attribute or assertion value will be reverted to a prior version. In order to revert this server you will have to export the data from this server and reimport it after the reversion has finished
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_5134_REVERSION =
                    new LocalizableMessageDescriptor.Arg0(VersionMessages.class, RESOURCE, "INFO_5134_REVERSION_16", 16);

    /**
     * Reversion from version 2.0 to a previous version is not supported
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_5278_REVERSION =
                    new LocalizableMessageDescriptor.Arg0(VersionMessages.class, RESOURCE, "INFO_5278_REVERSION_17", 17);

    /**
     * The revision 7635 introduces a change to the way in which the 'ds-sync-hist' attribute is normalized for indexing. In order to complete the upgrade of this server you will have to manually rebuild the 'ds-sync-hist' attribute index after the upgrade has finished
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_7635_UPGRADE =
                    new LocalizableMessageDescriptor.Arg0(VersionMessages.class, RESOURCE, "INFO_7635_UPGRADE_18", 18);

    /**
     * With this reversion the normalization of the 'ds-sync-hist' attribute will be reverted to the prior version. In order to complete the reversion of this server you will need to start the server and then perform an online rebuild of the 'ds-sync-hist' index
     */
    public static final LocalizableMessageDescriptor.Arg0 INFO_7635_REVERSION =
                    new LocalizableMessageDescriptor.Arg0(VersionMessages.class, RESOURCE, "INFO_7635_REVERSION_19", 19);

}
