/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2006-2008 Sun Microsystems, Inc.
 *      Portions Copyright 2014-2015 ForgeRock AS
 */
package org.opends.server.extensions;



import java.util.List;

import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import org.opends.server.TestCaseUtils;
import org.opends.server.admin.server.AdminTestCaseUtils;
import org.opends.server.admin.std.meta.RandomPasswordGeneratorCfgDefn;
import org.opends.server.admin.std.server.RandomPasswordGeneratorCfg;
import org.opends.server.config.ConfigEntry;
import org.forgerock.opendj.config.server.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;

import static org.testng.Assert.*;



/**
 * A set of test cases for the random password generator.
 */
public class RandomPasswordGeneratorTestCase
       extends ExtensionsTestCase
{
  /**
   * Ensures that the Directory Server is running.
   *
   * @throws  Exception  If an unexpected problem occurs.
   */
  @BeforeClass
  public void startServer()
         throws Exception
  {
    TestCaseUtils.startServer();
  }



  /**
   * Tests the password generator with the default configuration.
   *
   * @throws  Exception  If an unexpected problem occurs.
   */
  @Test
  public void testDefaultConfiguration()
         throws Exception
  {
    DN dn = DN.valueOf("cn=Random Password Generator,cn=Password Generators," +
                      "cn=config");
    ConfigEntry configEntry = DirectoryServer.getConfigEntry(dn);
    assertNotNull(configEntry);

    RandomPasswordGeneratorCfg configuration =
      AdminTestCaseUtils.getConfiguration(
          RandomPasswordGeneratorCfgDefn.getInstance(),
           configEntry.getEntry());

    RandomPasswordGenerator generator = new RandomPasswordGenerator();
    generator.initializePasswordGenerator(configuration);
    assertNotNull(generator.generatePassword(null));
    generator.finalizePasswordGenerator();
  }



  /**
   * Retrieves a set of LDIF representations for invalid configuration entries.
   *
   * @return  A set of LDIF representations for invalid configuration entries.
   *
   * @throws  Exception  If an unexpected problem occurs.
   */
  @DataProvider(name = "invalidConfigEntries")
  public Object[][] getInvalidConfigEntries()
         throws Exception
  {
    List<Entry> entries = TestCaseUtils.makeEntries(
      "dn: cn=Random Password Generator,cn=Password Generators,cn=config",
      "objectClass: top",
      "objectClass: ds-cfg-password-generator",
      "cn: Random Password Generator",
      "ds-cfg-java-class: " +
           "org.opends.server.extensions.RandomPasswordGenerator",
      "ds-cfg-enabled: true",
      "",
      "dn: cn=Random Password Generator,cn=Password Generators,cn=config",
      "objectClass: top",
      "objectClass: ds-cfg-password-generator",
      "objectClass: ds-cfg-random-password-generator",
      "cn: Random Password Generator",
      "ds-cfg-java-class: " +
           "org.opends.server.extensions.RandomPasswordGenerator",
      "ds-cfg-enabled: true",
      "ds-cfg-password-character-set:",
      "",
      "dn: cn=Random Password Generator,cn=Password Generators,cn=config",
      "objectClass: top",
      "objectClass: ds-cfg-password-generator",
      "objectClass: ds-cfg-random-password-generator",
      "cn: Random Password Generator",
      "ds-cfg-java-class: " +
           "org.opends.server.extensions.RandomPasswordGenerator",
      "ds-cfg-enabled: true",
      "ds-cfg-password-character-set: foo:",
      "ds-cfg-password-format: foo:8",
      "",
      "dn: cn=Random Password Generator,cn=Password Generators,cn=config",
      "objectClass: top",
      "objectClass: ds-cfg-password-generator",
      "objectClass: ds-cfg-random-password-generator",
      "cn: Random Password Generator",
      "ds-cfg-java-class: " +
           "org.opends.server.extensions.RandomPasswordGenerator",
      "ds-cfg-enabled: true",
      "ds-cfg-password-character-set: foo:abcd",
      "ds-cfg-password-character-set: foo:efgh",
      "ds-cfg-password-format: foo:8",
      "",
      "dn: cn=Random Password Generator,cn=Password Generators,cn=config",
      "objectClass: top",
      "objectClass: ds-cfg-password-generator",
      "objectClass: ds-cfg-random-password-generator",
      "cn: Random Password Generator",
      "ds-cfg-java-class: " +
           "org.opends.server.extensions.RandomPasswordGenerator",
      "ds-cfg-enabled: true",
      "ds-cfg-password-character-set: foo:abcd",
      "",
      "dn: cn=Random Password Generator,cn=Password Generators,cn=config",
      "objectClass: top",
      "objectClass: ds-cfg-password-generator",
      "objectClass: ds-cfg-random-password-generator",
      "cn: Random Password Generator",
      "ds-cfg-java-class: " +
           "org.opends.server.extensions.RandomPasswordGenerator",
      "ds-cfg-enabled: true",
      "ds-cfg-password-character-set: foo:abcd",
      "ds-cfg-password-format: bar:8",
      "",
      "dn: cn=Random Password Generator,cn=Password Generators,cn=config",
      "objectClass: top",
      "objectClass: ds-cfg-password-generator",
      "objectClass: ds-cfg-random-password-generator",
      "cn: Random Password Generator",
      "ds-cfg-java-class: " +
           "org.opends.server.extensions.RandomPasswordGenerator",
      "ds-cfg-enabled: true",
      "ds-cfg-password-character-set: foo:abcd",
      "ds-cfg-password-format: foo:abcd"
    );


    Object[][] entryObjects = new Object[entries.size()][1];
    for (int i=0; i < entryObjects.length; i++)
    {
      entryObjects[i] = new Object[] { entries.get(i) };
    }

    return entryObjects;
  }



  /**
   * Tests with an invalid configuration entry.
   *
   * @param  entry  The invalid configuration entry to use for testing.
   *
   * @throws  Exception  If an unexpected problem occurs.
   */
  @Test(dataProvider = "invalidConfigEntries",
        expectedExceptions = { ConfigException.class,
                               InitializationException.class })
  public void testInvalidConfigurations(Entry entry)
         throws Exception
  {
    RandomPasswordGeneratorCfg configuration =
      AdminTestCaseUtils.getConfiguration(
          RandomPasswordGeneratorCfgDefn.getInstance(),
           entry);

    RandomPasswordGenerator generator = new RandomPasswordGenerator();
    generator.initializePasswordGenerator(configuration);
  }
}

