/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.service.impl;

import com.google.common.collect.Sets;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWTParser;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mitre.oauth2.model.AuthenticationHolderEntity;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.mitre.oauth2.model.SavedUserAuthentication;
import org.mitre.oauth2.model.SystemScope;
import org.mitre.oauth2.repository.AuthenticationHolderRepository;
import org.mitre.oauth2.repository.OAuth2ClientRepository;
import org.mitre.oauth2.repository.OAuth2TokenRepository;
import org.mitre.oauth2.repository.SystemScopeRepository;
import org.mitre.openid.connect.model.ApprovedSite;
import org.mitre.openid.connect.model.BlacklistedSite;
import org.mitre.openid.connect.model.WhitelistedSite;
import org.mitre.openid.connect.repository.ApprovedSiteRepository;
import org.mitre.openid.connect.repository.BlacklistedSiteRepository;
import org.mitre.openid.connect.repository.WhitelistedSiteRepository;
import org.mitre.openid.connect.service.MITREidDataService;
import org.mitre.openid.connect.service.MITREidDataServiceExtension;
import org.mitre.openid.connect.service.MITREidDataServiceMaps;
import org.mitre.openid.connect.service.impl.MITREidDataServiceSupport;
import org.mitre.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.stereotype.Service;

@Service
public class MITREidDataService_1_1
extends MITREidDataServiceSupport
implements MITREidDataService {
    private static final Logger logger = LoggerFactory.getLogger(MITREidDataService_1_1.class);
    @Autowired
    private OAuth2ClientRepository clientRepository;
    @Autowired
    private ApprovedSiteRepository approvedSiteRepository;
    @Autowired
    private WhitelistedSiteRepository wlSiteRepository;
    @Autowired
    private BlacklistedSiteRepository blSiteRepository;
    @Autowired
    private AuthenticationHolderRepository authHolderRepository;
    @Autowired
    private OAuth2TokenRepository tokenRepository;
    @Autowired
    private SystemScopeRepository sysScopeRepository;
    @Autowired(required=false)
    private List<MITREidDataServiceExtension> extensions = Collections.emptyList();
    private static final String THIS_VERSION = "mitreid-connect-1.1";
    private MITREidDataServiceMaps maps = new MITREidDataServiceMaps();

    public boolean supportsVersion(String version) {
        return THIS_VERSION.equals(version);
    }

    public void exportData(JsonWriter writer) throws IOException {
        throw new UnsupportedOperationException("Can not export 1.1 format from this version.");
    }

    public void importData(JsonReader reader) throws IOException {
        logger.info("Reading configuration for 1.1");
        reader.beginObject();
        block4: while (reader.hasNext()) {
            JsonToken tok = reader.peek();
            switch (tok) {
                case NAME: {
                    String name = reader.nextName();
                    if (name.equals("clients")) {
                        this.readClients(reader);
                        continue block4;
                    }
                    if (name.equals("grants")) {
                        this.readGrants(reader);
                        continue block4;
                    }
                    if (name.equals("whitelistedSites")) {
                        this.readWhitelistedSites(reader);
                        continue block4;
                    }
                    if (name.equals("blacklistedSites")) {
                        this.readBlacklistedSites(reader);
                        continue block4;
                    }
                    if (name.equals("authenticationHolders")) {
                        this.readAuthenticationHolders(reader);
                        continue block4;
                    }
                    if (name.equals("accessTokens")) {
                        this.readAccessTokens(reader);
                        continue block4;
                    }
                    if (name.equals("refreshTokens")) {
                        this.readRefreshTokens(reader);
                        continue block4;
                    }
                    if (name.equals("systemScopes")) {
                        this.readSystemScopes(reader);
                        continue block4;
                    }
                    for (MITREidDataServiceExtension extension : this.extensions) {
                        if (!extension.supportsVersion(THIS_VERSION) || !extension.supportsVersion(THIS_VERSION)) continue;
                        extension.importExtensionData(name, reader);
                        break;
                    }
                    reader.skipValue();
                    continue block4;
                }
                case END_OBJECT: {
                    reader.endObject();
                    continue block4;
                }
            }
            logger.debug("Found unexpected entry");
            reader.skipValue();
        }
        this.fixObjectReferences();
        for (MITREidDataServiceExtension extension : this.extensions) {
            if (!extension.supportsVersion(THIS_VERSION)) continue;
            extension.fixExtensionObjectReferences(this.maps);
            break;
        }
        this.maps.clearAll();
    }

    private void readRefreshTokens(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            OAuth2RefreshTokenEntity token = new OAuth2RefreshTokenEntity();
            reader.beginObject();
            Long currentId = null;
            String clientId = null;
            Long authHolderId = null;
            block7: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block7;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue block7;
                        }
                        if (name.equals("id")) {
                            currentId = reader.nextLong();
                            continue block7;
                        }
                        if (name.equals("expiration")) {
                            Date date = this.utcToDate(reader.nextString());
                            token.setExpiration(date);
                            continue block7;
                        }
                        if (name.equals("value")) {
                            String value = reader.nextString();
                            try {
                                token.setJwt(JWTParser.parse((String)value));
                            }
                            catch (ParseException ex) {
                                logger.error("Unable to set refresh token value to {}", (Object)value, (Object)ex);
                            }
                            continue block7;
                        }
                        if (name.equals("clientId")) {
                            clientId = reader.nextString();
                            continue block7;
                        }
                        if (name.equals("authenticationHolderId")) {
                            authHolderId = reader.nextLong();
                            continue block7;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block7;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            Long newId = this.tokenRepository.saveRefreshToken(token).getId();
            this.maps.getRefreshTokenToClientRefs().put(currentId, clientId);
            this.maps.getRefreshTokenToAuthHolderRefs().put(currentId, authHolderId);
            this.maps.getRefreshTokenOldToNewIdMap().put(currentId, newId);
            logger.debug("Read refresh token {}", (Object)currentId);
        }
        reader.endArray();
        logger.info("Done reading refresh tokens");
    }

    private void readAccessTokens(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            OAuth2AccessTokenEntity token = new OAuth2AccessTokenEntity();
            reader.beginObject();
            Long currentId = null;
            String clientId = null;
            Long authHolderId = null;
            Long refreshTokenId = null;
            block7: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block7;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue block7;
                        }
                        if (name.equals("id")) {
                            currentId = reader.nextLong();
                            continue block7;
                        }
                        if (name.equals("expiration")) {
                            Date date = this.utcToDate(reader.nextString());
                            token.setExpiration(date);
                            continue block7;
                        }
                        if (name.equals("value")) {
                            String value = reader.nextString();
                            try {
                                token.setJwt(JWTParser.parse((String)value));
                            }
                            catch (ParseException ex) {
                                logger.error("Unable to set refresh token value to {}", (Object)value, (Object)ex);
                            }
                            continue block7;
                        }
                        if (name.equals("clientId")) {
                            clientId = reader.nextString();
                            continue block7;
                        }
                        if (name.equals("authenticationHolderId")) {
                            authHolderId = reader.nextLong();
                            continue block7;
                        }
                        if (name.equals("refreshTokenId")) {
                            refreshTokenId = reader.nextLong();
                            continue block7;
                        }
                        if (name.equals("scope")) {
                            Set scope = JsonUtils.readSet((JsonReader)reader);
                            token.setScope(scope);
                            continue block7;
                        }
                        if (name.equals("type")) {
                            token.setTokenType(reader.nextString());
                            continue block7;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block7;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            Long newId = this.tokenRepository.saveAccessToken(token).getId();
            this.maps.getAccessTokenToClientRefs().put(currentId, clientId);
            this.maps.getAccessTokenToAuthHolderRefs().put(currentId, authHolderId);
            if (refreshTokenId != null) {
                this.maps.getAccessTokenToRefreshTokenRefs().put(currentId, refreshTokenId);
            }
            this.maps.getAccessTokenOldToNewIdMap().put(currentId, newId);
            logger.debug("Read access token {}", (Object)currentId);
        }
        reader.endArray();
        logger.info("Done reading access tokens");
    }

    private void readAuthenticationHolders(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            AuthenticationHolderEntity ahe = new AuthenticationHolderEntity();
            reader.beginObject();
            Long currentId = null;
            block9: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block9;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue block9;
                        }
                        if (name.equals("id")) {
                            currentId = reader.nextLong();
                            continue block9;
                        }
                        if (name.equals("ownerId")) {
                            reader.skipValue();
                            continue block9;
                        }
                        if (name.equals("authentication")) {
                            OAuth2Request clientAuthorization = null;
                            SavedUserAuthentication userAuthentication = null;
                            reader.beginObject();
                            block10: while (reader.hasNext()) {
                                switch (reader.peek()) {
                                    case END_OBJECT: {
                                        continue block10;
                                    }
                                    case NAME: {
                                        String subName = reader.nextName();
                                        if (reader.peek() == JsonToken.NULL) {
                                            reader.skipValue();
                                            continue block10;
                                        }
                                        if (subName.equals("clientAuthorization")) {
                                            clientAuthorization = this.readAuthorizationRequest(reader);
                                            continue block10;
                                        }
                                        if (subName.equals("userAuthentication")) {
                                            reader.skipValue();
                                            continue block10;
                                        }
                                        if (subName.equals("savedUserAuthentication")) {
                                            userAuthentication = this.readSavedUserAuthentication(reader);
                                            continue block10;
                                        }
                                        logger.debug("Found unexpected entry");
                                        reader.skipValue();
                                        continue block10;
                                    }
                                }
                                logger.debug("Found unexpected entry");
                                reader.skipValue();
                            }
                            reader.endObject();
                            OAuth2Authentication auth = new OAuth2Authentication(clientAuthorization, userAuthentication);
                            ahe.setAuthentication(auth);
                            continue block9;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block9;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            Long newId = this.authHolderRepository.save(ahe).getId();
            this.maps.getAuthHolderOldToNewIdMap().put(currentId, newId);
            logger.debug("Read authentication holder {}", currentId);
        }
        reader.endArray();
        logger.info("Done reading authentication holders");
    }

    private OAuth2Request readAuthorizationRequest(JsonReader reader) throws IOException {
        Set scope = new LinkedHashSet();
        Set resourceIds = new HashSet();
        boolean approved = false;
        HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
        Map requestParameters = new HashMap();
        Set responseTypes = new HashSet();
        HashMap extensions = new HashMap();
        String redirectUri = null;
        String clientId = null;
        reader.beginObject();
        block4: while (reader.hasNext()) {
            switch (reader.peek()) {
                case END_OBJECT: {
                    continue block4;
                }
                case NAME: {
                    String name = reader.nextName();
                    if (reader.peek() == JsonToken.NULL) {
                        reader.skipValue();
                        continue block4;
                    }
                    if (name.equals("requestParameters")) {
                        requestParameters = JsonUtils.readMap((JsonReader)reader);
                        continue block4;
                    }
                    if (name.equals("clientId")) {
                        clientId = reader.nextString();
                        continue block4;
                    }
                    if (name.equals("scope")) {
                        scope = JsonUtils.readSet((JsonReader)reader);
                        continue block4;
                    }
                    if (name.equals("resourceIds")) {
                        resourceIds = JsonUtils.readSet((JsonReader)reader);
                        continue block4;
                    }
                    if (name.equals("authorities")) {
                        Set authorityStrs = JsonUtils.readSet((JsonReader)reader);
                        authorities = new HashSet();
                        for (String string : authorityStrs) {
                            SimpleGrantedAuthority ga = new SimpleGrantedAuthority(string);
                            authorities.add(ga);
                        }
                        continue block4;
                    }
                    if (name.equals("approved")) {
                        approved = reader.nextBoolean();
                        continue block4;
                    }
                    if (name.equals("denied")) {
                        if (approved) continue block4;
                        approved = !reader.nextBoolean();
                        continue block4;
                    }
                    if (name.equals("redirectUri")) {
                        redirectUri = reader.nextString();
                        continue block4;
                    }
                    if (name.equals("responseTypes")) {
                        responseTypes = JsonUtils.readSet((JsonReader)reader);
                        continue block4;
                    }
                    if (name.equals("extensions")) {
                        reader.skipValue();
                        continue block4;
                    }
                    if (name.equals("extensionStrings")) {
                        Map extEnc = JsonUtils.readMap((JsonReader)reader);
                        for (Map.Entry entry : extEnc.entrySet()) {
                            extensions.put(entry.getKey(), entry.getValue());
                        }
                        continue block4;
                    }
                    reader.skipValue();
                    continue block4;
                }
            }
            logger.debug("Found unexpected entry");
            reader.skipValue();
        }
        reader.endObject();
        return new OAuth2Request(requestParameters, clientId, authorities, approved, scope, resourceIds, redirectUri, responseTypes, extensions);
    }

    private SavedUserAuthentication readSavedUserAuthentication(JsonReader reader) throws IOException {
        SavedUserAuthentication savedUserAuth = new SavedUserAuthentication();
        reader.beginObject();
        block4: while (reader.hasNext()) {
            switch (reader.peek()) {
                case END_OBJECT: {
                    continue block4;
                }
                case NAME: {
                    String name = reader.nextName();
                    if (reader.peek() == JsonToken.NULL) {
                        reader.skipValue();
                        continue block4;
                    }
                    if (name.equals("name")) {
                        savedUserAuth.setName(reader.nextString());
                        continue block4;
                    }
                    if (name.equals("sourceClass")) {
                        savedUserAuth.setSourceClass(reader.nextString());
                        continue block4;
                    }
                    if (name.equals("authenticated")) {
                        savedUserAuth.setAuthenticated(reader.nextBoolean());
                        continue block4;
                    }
                    if (name.equals("authorities")) {
                        Set authorityStrs = JsonUtils.readSet((JsonReader)reader);
                        HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
                        for (String s : authorityStrs) {
                            SimpleGrantedAuthority ga = new SimpleGrantedAuthority(s);
                            authorities.add(ga);
                        }
                        savedUserAuth.setAuthorities(authorities);
                        continue block4;
                    }
                    logger.debug("Found unexpected entry");
                    reader.skipValue();
                    continue block4;
                }
            }
            logger.debug("Found unexpected entry");
            reader.skipValue();
        }
        reader.endObject();
        return savedUserAuth;
    }

    private void readGrants(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            ApprovedSite site = new ApprovedSite();
            Long currentId = null;
            Long whitelistedSiteId = null;
            Set tokenIds = null;
            reader.beginObject();
            block5: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block5;
                    }
                    case NAME: {
                        Date date;
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue block5;
                        }
                        if (name.equals("id")) {
                            currentId = reader.nextLong();
                            continue block5;
                        }
                        if (name.equals("accessDate")) {
                            date = this.utcToDate(reader.nextString());
                            site.setAccessDate(date);
                            continue block5;
                        }
                        if (name.equals("clientId")) {
                            site.setClientId(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("creationDate")) {
                            date = this.utcToDate(reader.nextString());
                            site.setCreationDate(date);
                            continue block5;
                        }
                        if (name.equals("timeoutDate")) {
                            date = this.utcToDate(reader.nextString());
                            site.setTimeoutDate(date);
                            continue block5;
                        }
                        if (name.equals("userId")) {
                            site.setUserId(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("allowedScopes")) {
                            Set allowedScopes = JsonUtils.readSet((JsonReader)reader);
                            site.setAllowedScopes(allowedScopes);
                            continue block5;
                        }
                        if (name.equals("whitelistedSiteId")) {
                            whitelistedSiteId = reader.nextLong();
                            continue block5;
                        }
                        if (name.equals("approvedAccessTokens")) {
                            tokenIds = JsonUtils.readSet((JsonReader)reader);
                            continue block5;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block5;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            Long newId = this.approvedSiteRepository.save(site).getId();
            this.maps.getGrantOldToNewIdMap().put(currentId, newId);
            if (whitelistedSiteId != null) {
                logger.debug("Ignoring whitelisted site marker on approved site.");
            }
            if (tokenIds != null) {
                this.maps.getGrantToAccessTokensRefs().put(currentId, tokenIds);
            }
            logger.debug("Read grant {}", (Object)currentId);
        }
        reader.endArray();
        logger.info("Done reading grants");
    }

    private void readWhitelistedSites(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            WhitelistedSite wlSite = new WhitelistedSite();
            Long currentId = null;
            reader.beginObject();
            block5: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block5;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (name.equals("id")) {
                            currentId = reader.nextLong();
                            continue block5;
                        }
                        if (name.equals("clientId")) {
                            wlSite.setClientId(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("creatorUserId")) {
                            wlSite.setCreatorUserId(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("allowedScopes")) {
                            Set allowedScopes = JsonUtils.readSet((JsonReader)reader);
                            wlSite.setAllowedScopes(allowedScopes);
                            continue block5;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block5;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            Long newId = this.wlSiteRepository.save(wlSite).getId();
            this.maps.getWhitelistedSiteOldToNewIdMap().put(currentId, newId);
        }
        reader.endArray();
        logger.info("Done reading whitelisted sites");
    }

    private void readBlacklistedSites(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            BlacklistedSite blSite = new BlacklistedSite();
            reader.beginObject();
            block5: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block5;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (name.equals("id")) {
                            reader.skipValue();
                            continue block5;
                        }
                        if (name.equals("uri")) {
                            blSite.setUri(reader.nextString());
                            continue block5;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block5;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            this.blSiteRepository.save(blSite);
        }
        reader.endArray();
        logger.info("Done reading blacklisted sites");
    }

    private void readClients(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            ClientDetailsEntity client = new ClientDetailsEntity();
            reader.beginObject();
            block5: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block5;
                    }
                    case NAME: {
                        JWSAlgorithm alg;
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue block5;
                        }
                        if (name.equals("clientId")) {
                            client.setClientId(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("resourceIds")) {
                            Set resourceIds = JsonUtils.readSet((JsonReader)reader);
                            client.setResourceIds(resourceIds);
                            continue block5;
                        }
                        if (name.equals("secret")) {
                            client.setClientSecret(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("scope")) {
                            Set scope = JsonUtils.readSet((JsonReader)reader);
                            client.setScope(scope);
                            continue block5;
                        }
                        if (name.equals("authorities")) {
                            Set authorityStrs = JsonUtils.readSet((JsonReader)reader);
                            HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
                            for (String s : authorityStrs) {
                                SimpleGrantedAuthority ga = new SimpleGrantedAuthority(s);
                                authorities.add(ga);
                            }
                            client.setAuthorities(authorities);
                            continue block5;
                        }
                        if (name.equals("accessTokenValiditySeconds")) {
                            client.setAccessTokenValiditySeconds(Integer.valueOf(reader.nextInt()));
                            continue block5;
                        }
                        if (name.equals("refreshTokenValiditySeconds")) {
                            client.setRefreshTokenValiditySeconds(Integer.valueOf(reader.nextInt()));
                            continue block5;
                        }
                        if (name.equals("redirectUris")) {
                            Set redirectUris = JsonUtils.readSet((JsonReader)reader);
                            client.setRedirectUris(redirectUris);
                            continue block5;
                        }
                        if (name.equals("name")) {
                            client.setClientName(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("uri")) {
                            client.setClientUri(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("logoUri")) {
                            client.setLogoUri(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("contacts")) {
                            Set contacts = JsonUtils.readSet((JsonReader)reader);
                            client.setContacts(contacts);
                            continue block5;
                        }
                        if (name.equals("tosUri")) {
                            client.setTosUri(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("tokenEndpointAuthMethod")) {
                            ClientDetailsEntity.AuthMethod am = ClientDetailsEntity.AuthMethod.getByValue((String)reader.nextString());
                            client.setTokenEndpointAuthMethod(am);
                            continue block5;
                        }
                        if (name.equals("grantTypes")) {
                            Set grantTypes = JsonUtils.readSet((JsonReader)reader);
                            client.setGrantTypes(grantTypes);
                            continue block5;
                        }
                        if (name.equals("responseTypes")) {
                            Set responseTypes = JsonUtils.readSet((JsonReader)reader);
                            client.setResponseTypes(responseTypes);
                            continue block5;
                        }
                        if (name.equals("policyUri")) {
                            client.setPolicyUri(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("applicationType")) {
                            ClientDetailsEntity.AppType appType = ClientDetailsEntity.AppType.getByValue((String)reader.nextString());
                            client.setApplicationType(appType);
                            continue block5;
                        }
                        if (name.equals("sectorIdentifierUri")) {
                            client.setSectorIdentifierUri(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("subjectType")) {
                            ClientDetailsEntity.SubjectType st = ClientDetailsEntity.SubjectType.getByValue((String)reader.nextString());
                            client.setSubjectType(st);
                            continue block5;
                        }
                        if (name.equals("jwks_uri")) {
                            client.setJwksUri(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("requestObjectSigningAlg")) {
                            alg = JWSAlgorithm.parse((String)reader.nextString());
                            client.setRequestObjectSigningAlg(alg);
                            continue block5;
                        }
                        if (name.equals("userInfoEncryptedResponseAlg")) {
                            alg = JWEAlgorithm.parse((String)reader.nextString());
                            client.setUserInfoEncryptedResponseAlg((JWEAlgorithm)alg);
                            continue block5;
                        }
                        if (name.equals("userInfoEncryptedResponseEnc")) {
                            alg = EncryptionMethod.parse((String)reader.nextString());
                            client.setUserInfoEncryptedResponseEnc((EncryptionMethod)alg);
                            continue block5;
                        }
                        if (name.equals("userInfoSignedResponseAlg")) {
                            alg = JWSAlgorithm.parse((String)reader.nextString());
                            client.setUserInfoSignedResponseAlg(alg);
                            continue block5;
                        }
                        if (name.equals("idTokenSignedResonseAlg")) {
                            alg = JWSAlgorithm.parse((String)reader.nextString());
                            client.setIdTokenSignedResponseAlg(alg);
                            continue block5;
                        }
                        if (name.equals("idTokenEncryptedResponseAlg")) {
                            alg = JWEAlgorithm.parse((String)reader.nextString());
                            client.setIdTokenEncryptedResponseAlg((JWEAlgorithm)alg);
                            continue block5;
                        }
                        if (name.equals("idTokenEncryptedResponseEnc")) {
                            alg = EncryptionMethod.parse((String)reader.nextString());
                            client.setIdTokenEncryptedResponseEnc((EncryptionMethod)alg);
                            continue block5;
                        }
                        if (name.equals("tokenEndpointAuthSigningAlg")) {
                            alg = JWSAlgorithm.parse((String)reader.nextString());
                            client.setTokenEndpointAuthSigningAlg(alg);
                            continue block5;
                        }
                        if (name.equals("defaultMaxAge")) {
                            client.setDefaultMaxAge(Integer.valueOf(reader.nextInt()));
                            continue block5;
                        }
                        if (name.equals("requireAuthTime")) {
                            client.setRequireAuthTime(Boolean.valueOf(reader.nextBoolean()));
                            continue block5;
                        }
                        if (name.equals("defaultACRValues")) {
                            Set defaultACRvalues = JsonUtils.readSet((JsonReader)reader);
                            client.setDefaultACRvalues(defaultACRvalues);
                            continue block5;
                        }
                        if (name.equals("initiateLoginUri")) {
                            client.setInitiateLoginUri(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("postLogoutRedirectUri")) {
                            HashSet postLogoutUris = Sets.newHashSet((Object[])new String[]{reader.nextString()});
                            client.setPostLogoutRedirectUris((Set)postLogoutUris);
                            continue block5;
                        }
                        if (name.equals("requestUris")) {
                            Set requestUris = JsonUtils.readSet((JsonReader)reader);
                            client.setRequestUris(requestUris);
                            continue block5;
                        }
                        if (name.equals("description")) {
                            client.setClientDescription(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("allowIntrospection")) {
                            client.setAllowIntrospection(reader.nextBoolean());
                            continue block5;
                        }
                        if (name.equals("reuseRefreshToken")) {
                            client.setReuseRefreshToken(reader.nextBoolean());
                            continue block5;
                        }
                        if (name.equals("dynamicallyRegistered")) {
                            client.setDynamicallyRegistered(reader.nextBoolean());
                            continue block5;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block5;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            this.clientRepository.saveClient(client);
        }
        reader.endArray();
        logger.info("Done reading clients");
    }

    private void readSystemScopes(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            SystemScope scope = new SystemScope();
            reader.beginObject();
            block5: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block5;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue block5;
                        }
                        if (name.equals("value")) {
                            scope.setValue(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("description")) {
                            scope.setDescription(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("allowDynReg")) {
                            scope.setRestricted(!reader.nextBoolean());
                            continue block5;
                        }
                        if (name.equals("defaultScope")) {
                            scope.setDefaultScope(reader.nextBoolean());
                            continue block5;
                        }
                        if (name.equals("structured")) {
                            logger.warn("Found a structured scope, ignoring structure");
                            continue block5;
                        }
                        if (name.equals("structuredParameter")) {
                            logger.warn("Found a structured scope, ignoring structure");
                            continue block5;
                        }
                        if (name.equals("icon")) {
                            scope.setIcon(reader.nextString());
                            continue block5;
                        }
                        logger.debug("found unexpected entry");
                        reader.skipValue();
                        continue block5;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            this.sysScopeRepository.save(scope);
        }
        reader.endArray();
        logger.info("Done reading system scopes");
    }

    private void fixObjectReferences() {
        OAuth2AccessTokenEntity accessToken;
        Long newAccessTokenId;
        AuthenticationHolderEntity authHolder;
        Long newAuthHolderId;
        Long oldAuthHolderId;
        ClientDetailsEntity client;
        String clientRef;
        for (Long oldRefreshTokenId : this.maps.getRefreshTokenToClientRefs().keySet()) {
            clientRef = (String)this.maps.getRefreshTokenToClientRefs().get(oldRefreshTokenId);
            client = this.clientRepository.getClientByClientId(clientRef);
            Long newRefreshTokenId = (Long)this.maps.getRefreshTokenOldToNewIdMap().get(oldRefreshTokenId);
            OAuth2RefreshTokenEntity refreshToken = this.tokenRepository.getRefreshTokenById(newRefreshTokenId);
            refreshToken.setClient(client);
            this.tokenRepository.saveRefreshToken(refreshToken);
        }
        for (Long oldRefreshTokenId : this.maps.getRefreshTokenToAuthHolderRefs().keySet()) {
            oldAuthHolderId = (Long)this.maps.getRefreshTokenToAuthHolderRefs().get(oldRefreshTokenId);
            newAuthHolderId = (Long)this.maps.getAuthHolderOldToNewIdMap().get(oldAuthHolderId);
            authHolder = this.authHolderRepository.getById(newAuthHolderId);
            Long newRefreshTokenId = (Long)this.maps.getRefreshTokenOldToNewIdMap().get(oldRefreshTokenId);
            OAuth2RefreshTokenEntity refreshToken = this.tokenRepository.getRefreshTokenById(newRefreshTokenId);
            refreshToken.setAuthenticationHolder(authHolder);
            this.tokenRepository.saveRefreshToken(refreshToken);
        }
        for (Long oldAccessTokenId : this.maps.getAccessTokenToClientRefs().keySet()) {
            clientRef = (String)this.maps.getAccessTokenToClientRefs().get(oldAccessTokenId);
            client = this.clientRepository.getClientByClientId(clientRef);
            Long newAccessTokenId2 = (Long)this.maps.getAccessTokenOldToNewIdMap().get(oldAccessTokenId);
            OAuth2AccessTokenEntity accessToken2 = this.tokenRepository.getAccessTokenById(newAccessTokenId2);
            accessToken2.setClient(client);
            this.tokenRepository.saveAccessToken(accessToken2);
        }
        this.maps.getAccessTokenToClientRefs().clear();
        for (Long oldAccessTokenId : this.maps.getAccessTokenToAuthHolderRefs().keySet()) {
            oldAuthHolderId = (Long)this.maps.getAccessTokenToAuthHolderRefs().get(oldAccessTokenId);
            newAuthHolderId = (Long)this.maps.getAuthHolderOldToNewIdMap().get(oldAuthHolderId);
            authHolder = this.authHolderRepository.getById(newAuthHolderId);
            newAccessTokenId = (Long)this.maps.getAccessTokenOldToNewIdMap().get(oldAccessTokenId);
            accessToken = this.tokenRepository.getAccessTokenById(newAccessTokenId);
            accessToken.setAuthenticationHolder(authHolder);
            this.tokenRepository.saveAccessToken(accessToken);
        }
        for (Long oldAccessTokenId : this.maps.getAccessTokenToRefreshTokenRefs().keySet()) {
            Long oldRefreshTokenId = (Long)this.maps.getAccessTokenToRefreshTokenRefs().get(oldAccessTokenId);
            Long newRefreshTokenId = (Long)this.maps.getRefreshTokenOldToNewIdMap().get(oldRefreshTokenId);
            OAuth2RefreshTokenEntity refreshToken = this.tokenRepository.getRefreshTokenById(newRefreshTokenId);
            newAccessTokenId = (Long)this.maps.getAccessTokenOldToNewIdMap().get(oldAccessTokenId);
            accessToken = this.tokenRepository.getAccessTokenById(newAccessTokenId);
            accessToken.setRefreshToken(refreshToken);
            this.tokenRepository.saveAccessToken(accessToken);
        }
        for (Long oldGrantId : this.maps.getGrantToAccessTokensRefs().keySet()) {
            Set oldAccessTokenIds = (Set)this.maps.getGrantToAccessTokensRefs().get(oldGrantId);
            Long newGrantId = (Long)this.maps.getGrantOldToNewIdMap().get(oldGrantId);
            ApprovedSite site = this.approvedSiteRepository.getById(newGrantId);
            for (Long oldTokenId : oldAccessTokenIds) {
                Long newTokenId = (Long)this.maps.getAccessTokenOldToNewIdMap().get(oldTokenId);
                OAuth2AccessTokenEntity token = this.tokenRepository.getAccessTokenById(newTokenId);
                token.setApprovedSite(site);
                this.tokenRepository.saveAccessToken(token);
            }
            this.approvedSiteRepository.save(site);
        }
    }
}

