/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.service.impl;

import com.google.common.base.Strings;
import java.util.Collection;
import org.mitre.openid.connect.model.BlacklistedSite;
import org.mitre.openid.connect.repository.BlacklistedSiteRepository;
import org.mitre.openid.connect.service.BlacklistedSiteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="defaultTransactionManager")
public class DefaultBlacklistedSiteService
implements BlacklistedSiteService {
    @Autowired
    private BlacklistedSiteRepository repository;

    public Collection<BlacklistedSite> getAll() {
        return this.repository.getAll();
    }

    public BlacklistedSite getById(Long id) {
        return this.repository.getById(id);
    }

    public void remove(BlacklistedSite blacklistedSite) {
        this.repository.remove(blacklistedSite);
    }

    public BlacklistedSite saveNew(BlacklistedSite blacklistedSite) {
        return this.repository.save(blacklistedSite);
    }

    public BlacklistedSite update(BlacklistedSite oldBlacklistedSite, BlacklistedSite blacklistedSite) {
        return this.repository.update(oldBlacklistedSite, blacklistedSite);
    }

    public boolean isBlacklisted(String uri) {
        if (Strings.isNullOrEmpty((String)uri)) {
            return false;
        }
        Collection<BlacklistedSite> sites = this.getAll();
        for (BlacklistedSite blacklistedSite : sites) {
            if (!Strings.nullToEmpty((String)blacklistedSite.getUri()).equals(uri)) continue;
            return true;
        }
        return false;
    }
}

