/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.uma.view;

import com.google.common.base.Strings;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.LongSerializationPolicy;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.mitre.openid.connect.view.JsonEntityView;
import org.mitre.uma.model.ResourceSet;
import org.mitre.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.web.servlet.view.AbstractView;

@Component(value="resourceSetEntityView")
public class ResourceSetEntityView
extends AbstractView {
    private static Logger logger = LoggerFactory.getLogger(JsonEntityView.class);
    public static final String VIEWNAME = "resourceSetEntityView";
    @Autowired
    private ConfigurationPropertiesBean config;
    private Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes f) {
            return false;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return clazz.equals(BeanPropertyBindingResult.class);
        }
    }}).serializeNulls().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").setLongSerializationPolicy(LongSerializationPolicy.STRING).create();

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/json");
        HttpStatus code = (HttpStatus)model.get("code");
        if (code == null) {
            code = HttpStatus.OK;
        }
        response.setStatus(code.value());
        String location = (String)model.get("location");
        if (!Strings.isNullOrEmpty((String)location)) {
            response.setHeader("Location", location);
        }
        try {
            PrintWriter out = response.getWriter();
            ResourceSet rs = (ResourceSet)model.get("entity");
            JsonObject o = new JsonObject();
            o.addProperty("_id", rs.getId().toString());
            o.addProperty("user_access_policy_uri", this.config.getIssuer() + "manage/resource/" + rs.getId());
            o.addProperty("name", rs.getName());
            o.addProperty("uri", rs.getUri());
            o.addProperty("type", rs.getType());
            o.add("scopes", JsonUtils.getAsArray((Set)rs.getScopes()));
            o.addProperty("icon_uri", rs.getIconUri());
            this.gson.toJson((JsonElement)o, (Appendable)out);
        }
        catch (IOException e) {
            logger.error("IOException in ResourceSetEntityView.java: ", (Throwable)e);
        }
    }
}

