/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.List;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;

public class ChannelAttributeFactory {
    private static final String OPT_REQUIRES_HTTP = "http";
    private static final String OPT_REQUIRES_HTTPS = "https";
    private static final String OPT_ANY_CHANNEL = "any";

    public static List<ConfigAttribute> createChannelAttributes(String requiredChannel) {
        String channelConfigAttribute;
        if (requiredChannel.equals(OPT_REQUIRES_HTTPS)) {
            channelConfigAttribute = "REQUIRES_SECURE_CHANNEL";
        } else if (requiredChannel.equals(OPT_REQUIRES_HTTP)) {
            channelConfigAttribute = "REQUIRES_INSECURE_CHANNEL";
        } else if (requiredChannel.equals(OPT_ANY_CHANNEL)) {
            channelConfigAttribute = "ANY_CHANNEL";
        } else {
            throw new BeanCreationException("Unknown channel attribute " + requiredChannel);
        }
        return SecurityConfig.createList((String[])new String[]{channelConfigAttribute});
    }
}

