/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.config;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.util.List;
import java.util.Locale;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.util.StringUtils;

public class ConfigurationPropertiesBean {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationPropertiesBean.class);
    private String issuer;
    private String topbarTitle;
    private String shortTopbarTitle;
    private String logoImageUrl;
    private Long regTokenLifeTime;
    private Long rqpTokenLifeTime;
    private boolean forceHttps = false;
    private Locale locale = Locale.ENGLISH;
    private List<String> languageNamespaces = Lists.newArrayList((Object[])new String[]{"messages"});
    private boolean dualClient = false;
    private boolean heartMode = false;
    private boolean allowCompleteDeviceCodeUri = false;

    @PostConstruct
    public void checkConfigConsistency() {
        if (!StringUtils.startsWithIgnoreCase((String)this.issuer, (String)"https")) {
            if (this.forceHttps) {
                logger.error("Configured issuer url is not using https scheme. Server will be shut down!");
                throw new BeanCreationException("Issuer is not using https scheme as required: " + this.issuer);
            }
            logger.warn("\n\n**\n** WARNING: Configured issuer url is not using https scheme.\n**\n\n");
        }
        if (this.languageNamespaces == null || this.languageNamespaces.isEmpty()) {
            logger.error("No configured language namespaces! Text rendering will fail!");
        }
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String iss) {
        this.issuer = iss;
    }

    public String getTopbarTitle() {
        return this.topbarTitle;
    }

    public void setTopbarTitle(String topbarTitle) {
        this.topbarTitle = topbarTitle;
    }

    public String getShortTopbarTitle() {
        return this.shortTopbarTitle == null ? this.topbarTitle : this.shortTopbarTitle;
    }

    public void setShortTopbarTitle(String shortTopbarTitle) {
        this.shortTopbarTitle = shortTopbarTitle;
    }

    public String getLogoImageUrl() {
        return this.logoImageUrl;
    }

    public void setLogoImageUrl(String logoImageUrl) {
        this.logoImageUrl = logoImageUrl;
    }

    public Long getRegTokenLifeTime() {
        return this.regTokenLifeTime;
    }

    public void setRegTokenLifeTime(Long regTokenLifeTime) {
        this.regTokenLifeTime = regTokenLifeTime;
    }

    public Long getRqpTokenLifeTime() {
        return this.rqpTokenLifeTime;
    }

    public void setRqpTokenLifeTime(Long rqpTokenLifeTime) {
        this.rqpTokenLifeTime = rqpTokenLifeTime;
    }

    public boolean isForceHttps() {
        return this.forceHttps;
    }

    public void setForceHttps(boolean forceHttps) {
        this.forceHttps = forceHttps;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public List<String> getLanguageNamespaces() {
        return this.languageNamespaces;
    }

    public void setLanguageNamespaces(List<String> languageNamespaces) {
        this.languageNamespaces = languageNamespaces;
    }

    public boolean isDualClient() {
        if (this.isHeartMode()) {
            return false;
        }
        return this.dualClient;
    }

    public void setDualClient(boolean dualClient) {
        this.dualClient = dualClient;
    }

    public String getLanguageNamespacesString() {
        return new Gson().toJson(this.getLanguageNamespaces());
    }

    public String getDefaultLanguageNamespace() {
        return this.getLanguageNamespaces().get(0);
    }

    public boolean isHeartMode() {
        return this.heartMode;
    }

    public void setHeartMode(boolean heartMode) {
        this.heartMode = heartMode;
    }

    public boolean isAllowCompleteDeviceCodeUri() {
        return this.allowCompleteDeviceCodeUri;
    }

    public void setAllowCompleteDeviceCodeUri(boolean allowCompleteDeviceCodeUri) {
        this.allowCompleteDeviceCodeUri = allowCompleteDeviceCodeUri;
    }
}

