/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.model;

import com.google.common.collect.ImmutableMap;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import org.mitre.openid.connect.config.ServerConfiguration;
import org.springframework.security.authentication.AbstractAuthenticationToken;

public class PendingOIDCAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 22100073066377804L;
    private final ImmutableMap<String, String> principal;
    private final String accessTokenValue;
    private final String refreshTokenValue;
    private transient JWT idToken;
    private final String issuer;
    private final String sub;
    private final transient ServerConfiguration serverConfiguration;

    public PendingOIDCAuthenticationToken(String subject, String issuer, ServerConfiguration serverConfiguration, JWT idToken, String accessTokenValue, String refreshTokenValue) {
        super(new ArrayList(0));
        this.principal = ImmutableMap.of((Object)"sub", (Object)subject, (Object)"iss", (Object)issuer);
        this.sub = subject;
        this.issuer = issuer;
        this.idToken = idToken;
        this.accessTokenValue = accessTokenValue;
        this.refreshTokenValue = refreshTokenValue;
        this.serverConfiguration = serverConfiguration;
        this.setAuthenticated(false);
    }

    public Object getCredentials() {
        return this.accessTokenValue;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public String getSub() {
        return this.sub;
    }

    public JWT getIdToken() {
        return this.idToken;
    }

    public String getAccessTokenValue() {
        return this.accessTokenValue;
    }

    public String getRefreshTokenValue() {
        return this.refreshTokenValue;
    }

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public String getIssuer() {
        return this.issuer;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.idToken == null) {
            out.writeObject(null);
        } else {
            out.writeObject(this.idToken.serialize());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, ParseException {
        in.defaultReadObject();
        Object o = in.readObject();
        if (o != null) {
            this.idToken = JWTParser.parse((String)((String)o));
        }
    }
}

