/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.model;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.mitre.oauth2.model.AuthenticationHolderEntity;

@Entity
@Table(name="device_code")
@NamedQueries(value={@NamedQuery(name="DeviceCode.queryByUserCode", query="select d from DeviceCode d where d.userCode = :userCode"), @NamedQuery(name="DeviceCode.queryByDeviceCode", query="select d from DeviceCode d where d.deviceCode = :deviceCode"), @NamedQuery(name="DeviceCode.queryExpiredByDate", query="select d from DeviceCode d where d.expiration <= :date")})
public class DeviceCode {
    public static final String QUERY_BY_USER_CODE = "DeviceCode.queryByUserCode";
    public static final String QUERY_BY_DEVICE_CODE = "DeviceCode.queryByDeviceCode";
    public static final String QUERY_EXPIRED_BY_DATE = "DeviceCode.queryExpiredByDate";
    public static final String PARAM_USER_CODE = "userCode";
    public static final String PARAM_DEVICE_CODE = "deviceCode";
    public static final String PARAM_DATE = "date";
    private Long id;
    private String deviceCode;
    private String userCode;
    private Set<String> scope;
    private Date expiration;
    private String clientId;
    private Map<String, String> requestParameters;
    private boolean approved;
    private AuthenticationHolderEntity authenticationHolder;

    public DeviceCode() {
    }

    public DeviceCode(String deviceCode, String userCode, Set<String> scope, String clientId, Map<String, String> params) {
        this.deviceCode = deviceCode;
        this.userCode = userCode;
        this.scope = scope;
        this.clientId = clientId;
        this.requestParameters = params;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Basic
    @Column(name="device_code")
    public String getDeviceCode() {
        return this.deviceCode;
    }

    public void setDeviceCode(String deviceCode) {
        this.deviceCode = deviceCode;
    }

    @Basic
    @Column(name="user_code")
    public String getUserCode() {
        return this.userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="device_code_scope", joinColumns={@JoinColumn(name="owner_id")})
    @Column(name="scope")
    public Set<String> getScope() {
        return this.scope;
    }

    public void setScope(Set<String> scope) {
        this.scope = scope;
    }

    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="expiration")
    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    @Basic
    @Column(name="client_id")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="device_code_request_parameter", joinColumns={@JoinColumn(name="owner_id")})
    @Column(name="val")
    @MapKeyColumn(name="param")
    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public void setRequestParameters(Map<String, String> params) {
        this.requestParameters = params;
    }

    @Basic
    @Column(name="approved")
    public boolean isApproved() {
        return this.approved;
    }

    public void setApproved(boolean approved) {
        this.approved = approved;
    }

    @ManyToOne
    @JoinColumn(name="auth_holder_id")
    public AuthenticationHolderEntity getAuthenticationHolder() {
        return this.authenticationHolder;
    }

    public void setAuthenticationHolder(AuthenticationHolderEntity authenticationHolder) {
        this.authenticationHolder = authenticationHolder;
    }
}

