/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.uma.web;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.openid.connect.model.OIDCAuthenticationToken;
import org.mitre.openid.connect.model.UserInfo;
import org.mitre.uma.model.Claim;
import org.mitre.uma.model.PermissionTicket;
import org.mitre.uma.service.PermissionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.oauth2.common.exceptions.RedirectMismatchException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@PreAuthorize(value="hasRole('ROLE_EXTERNAL_USER')")
@RequestMapping(value={"/rqp_claims"})
public class ClaimsCollectionEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(ClaimsCollectionEndpoint.class);
    public static final String URL = "rqp_claims";
    @Autowired
    private ClientDetailsEntityService clientService;
    @Autowired
    private PermissionService permissionService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(method={RequestMethod.GET})
    public String collectClaims(@RequestParam(value="client_id") String clientId, @RequestParam(value="redirect_uri", required=false) String redirectUri, @RequestParam(value="ticket") String ticketValue, @RequestParam(value="state", required=false) String state, Model m, OIDCAuthenticationToken auth) {
        ClientDetailsEntity client = this.clientService.loadClientByClientId(clientId);
        PermissionTicket ticket = this.permissionService.getByTicket(ticketValue);
        if (client == null || ticket == null) {
            logger.info("Client or ticket not found: " + clientId + " :: " + ticketValue);
            m.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
            return "httpCodeView";
        }
        HashSet claimsSupplied = Sets.newHashSet((Iterable)ticket.getClaimsSupplied());
        String issuer = auth.getIssuer();
        UserInfo userInfo = auth.getUserInfo();
        claimsSupplied.add(this.mkClaim(issuer, "sub", (JsonElement)new JsonPrimitive(auth.getSub())));
        if (userInfo.getEmail() != null) {
            claimsSupplied.add(this.mkClaim(issuer, "email", (JsonElement)new JsonPrimitive(userInfo.getEmail())));
        }
        if (userInfo.getEmailVerified() != null) {
            claimsSupplied.add(this.mkClaim(issuer, "email_verified", (JsonElement)new JsonPrimitive(userInfo.getEmailVerified())));
        }
        if (userInfo.getPhoneNumber() != null) {
            claimsSupplied.add(this.mkClaim(issuer, "phone_number", (JsonElement)new JsonPrimitive(auth.getUserInfo().getPhoneNumber())));
        }
        if (userInfo.getPhoneNumberVerified() != null) {
            claimsSupplied.add(this.mkClaim(issuer, "phone_number_verified", (JsonElement)new JsonPrimitive(auth.getUserInfo().getPhoneNumberVerified())));
        }
        if (userInfo.getPreferredUsername() != null) {
            claimsSupplied.add(this.mkClaim(issuer, "preferred_username", (JsonElement)new JsonPrimitive(auth.getUserInfo().getPreferredUsername())));
        }
        if (userInfo.getProfile() != null) {
            claimsSupplied.add(this.mkClaim(issuer, "profile", (JsonElement)new JsonPrimitive(auth.getUserInfo().getProfile())));
        }
        ticket.setClaimsSupplied((Collection)claimsSupplied);
        PermissionTicket updatedTicket = this.permissionService.updateTicket(ticket);
        if (Strings.isNullOrEmpty((String)redirectUri)) {
            if (client.getClaimsRedirectUris().size() != 1) throw new RedirectMismatchException("Unable to find redirect URI and none passed in.");
            redirectUri = (String)client.getClaimsRedirectUris().iterator().next();
            logger.info("No redirect URI passed in, using registered value: " + redirectUri);
        } else if (!client.getClaimsRedirectUris().contains(redirectUri)) {
            throw new RedirectMismatchException("Claims redirect did not match the registered values.");
        }
        UriComponentsBuilder template = UriComponentsBuilder.fromUriString((String)redirectUri);
        template.queryParam("authorization_state", new Object[]{"claims_submitted"});
        if (!Strings.isNullOrEmpty((String)state)) {
            template.queryParam("state", new Object[]{state});
        }
        String uriString = template.toUriString();
        logger.info("Redirecting to " + uriString);
        return "redirect:" + uriString;
    }

    private Claim mkClaim(String issuer, String name, JsonElement value) {
        Claim c = new Claim();
        c.setIssuer((Set)Sets.newHashSet((Object[])new String[]{issuer}));
        c.setName(name);
        c.setValue(value);
        return c;
    }
}

