/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.uma.web;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.Set;
import org.mitre.oauth2.service.SystemScopeService;
import org.mitre.oauth2.web.AuthenticationUtilities;
import org.mitre.uma.model.PermissionTicket;
import org.mitre.uma.model.ResourceSet;
import org.mitre.uma.service.PermissionService;
import org.mitre.uma.service.ResourceSetService;
import org.mitre.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/permission"})
@PreAuthorize(value="hasRole('ROLE_USER')")
public class PermissionRegistrationEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(PermissionRegistrationEndpoint.class);
    public static final String URL = "permission";
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private ResourceSetService resourceSetService;
    @Autowired
    private SystemScopeService scopeService;
    private JsonParser parser = new JsonParser();

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String getPermissionTicket(@RequestBody String jsonString, Model m, Authentication auth) {
        AuthenticationUtilities.ensureOAuthScope((Authentication)auth, (String)"uma_protection");
        try {
            JsonElement el = this.parser.parse(jsonString);
            if (el.isJsonObject()) {
                JsonObject o = el.getAsJsonObject();
                Long rsid = JsonUtils.getAsLong((JsonObject)o, (String)"resource_set_id");
                Set scopes = JsonUtils.getAsStringSet((JsonObject)o, (String)"scopes");
                if (rsid == null || scopes == null || scopes.isEmpty()) {
                    m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
                    m.addAttribute("errorMessage", (Object)"Missing required component of permission registration request.");
                    return "jsonErrorView";
                }
                Set scopesRequested = this.scopeService.fromStrings(scopes);
                scopesRequested = this.scopeService.removeRestrictedAndReservedScopes(scopesRequested);
                scopes = this.scopeService.toStrings(scopesRequested);
                ResourceSet resourceSet = this.resourceSetService.getById(rsid);
                if (resourceSet == null) {
                    m.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
                    m.addAttribute("errorMessage", (Object)("Requested resource set not found: " + rsid));
                    return "jsonErrorView";
                }
                if (!resourceSet.getOwner().equals(auth.getName())) {
                    m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
                    m.addAttribute("errorMessage", (Object)("Party requesting permission is not owner of resource set, expected " + resourceSet.getOwner() + " got " + auth.getName()));
                    return "jsonErrorView";
                }
                PermissionTicket permission = this.permissionService.createTicket(resourceSet, scopes);
                if (permission != null) {
                    JsonObject out = new JsonObject();
                    out.addProperty("ticket", permission.getTicket());
                    m.addAttribute("entity", (Object)out);
                    m.addAttribute("code", (Object)HttpStatus.CREATED);
                    return "jsonEntityView";
                }
                m.addAttribute("code", (Object)HttpStatus.INTERNAL_SERVER_ERROR);
                m.addAttribute("errorMessage", (Object)"Unable to save permission and generate ticket.");
                return "jsonErrorView";
            }
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Malformed JSON request.");
            return "jsonErrorView";
        }
        catch (JsonParseException e) {
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Malformed JSON request.");
            return "jsonErrorView";
        }
    }
}

