/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.uma.service.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.RegisteredClient;
import org.mitre.oauth2.repository.OAuth2TokenRepository;
import org.mitre.openid.connect.ClientDetailsEntityJsonProcessor;
import org.mitre.openid.connect.service.MITREidDataServiceExtension;
import org.mitre.openid.connect.service.MITREidDataServiceMaps;
import org.mitre.openid.connect.service.impl.MITREidDataServiceSupport;
import org.mitre.uma.model.Claim;
import org.mitre.uma.model.Permission;
import org.mitre.uma.model.PermissionTicket;
import org.mitre.uma.model.Policy;
import org.mitre.uma.model.ResourceSet;
import org.mitre.uma.model.SavedRegisteredClient;
import org.mitre.uma.repository.PermissionRepository;
import org.mitre.uma.repository.ResourceSetRepository;
import org.mitre.uma.service.SavedRegisteredClientService;
import org.mitre.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umaDataExtension_1_3")
public class UmaDataServiceExtension_1_3
extends MITREidDataServiceSupport
implements MITREidDataServiceExtension {
    private static final String THIS_VERSION = "mitreid-connect-1.3";
    private static final String REGISTERED_CLIENT = "registeredClient";
    private static final String URI = "uri";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String CLIENT_ID = "clientId";
    private static final String EXPIRATION = "expiration";
    private static final String ID = "id";
    private static final String ICON_URI = "iconUri";
    private static final String OWNER = "owner";
    private static final String POLICIES = "policies";
    private static final String SCOPES = "scopes";
    private static final String CLAIMS_REQUIRED = "claimsRequired";
    private static final String ISSUER = "issuer";
    private static final String CLAIM_TOKEN_FORMAT = "claimTokenFormat";
    private static final String CLAIM_TYPE = "claimType";
    private static final String FRIENDLY_NAME = "friendlyName";
    private static final String PERMISSIONS = "permissions";
    private static final String RESOURCE_SET = "resourceSet";
    private static final String PERMISSION_TICKETS = "permissionTickets";
    private static final String PERMISSION = "permission";
    private static final String TICKET = "ticket";
    private static final String CLAIMS_SUPPLIED = "claimsSupplied";
    private static final String SAVED_REGISTERED_CLIENTS = "savedRegisteredClients";
    private static final String RESOURCE_SETS = "resourceSets";
    private static final String TOKEN_PERMISSIONS = "tokenPermissions";
    private static final String TOKEN_ID = "tokenId";
    private static final Logger logger = LoggerFactory.getLogger(UmaDataServiceExtension_1_3.class);
    @Autowired
    private SavedRegisteredClientService registeredClientService;
    @Autowired
    private ResourceSetRepository resourceSetRepository;
    @Autowired
    private PermissionRepository permissionRepository;
    @Autowired
    private OAuth2TokenRepository tokenRepository;
    private Map<Long, Set<Long>> tokenToPermissionRefs = new HashMap<Long, Set<Long>>();
    private Map<Long, Long> permissionToResourceRefs = new HashMap<Long, Long>();
    private Map<Long, Long> resourceSetOldToNewIdMap = new HashMap<Long, Long>();

    public boolean supportsVersion(String version) {
        return THIS_VERSION.equals(version);
    }

    public void exportExtensionData(JsonWriter writer) throws IOException {
        writer.name(SAVED_REGISTERED_CLIENTS);
        writer.beginArray();
        this.writeSavedRegisteredClients(writer);
        writer.endArray();
        writer.name(RESOURCE_SETS);
        writer.beginArray();
        this.writeResourceSets(writer);
        writer.endArray();
        writer.name(PERMISSION_TICKETS);
        writer.beginArray();
        this.writePermissionTickets(writer);
        writer.endArray();
        writer.name(TOKEN_PERMISSIONS);
        writer.beginArray();
        this.writeTokenPermissions(writer);
        writer.endArray();
    }

    private void writeTokenPermissions(JsonWriter writer) throws IOException {
        for (OAuth2AccessTokenEntity token : this.tokenRepository.getAllAccessTokens()) {
            if (token.getPermissions().isEmpty()) continue;
            writer.beginObject();
            writer.name(TOKEN_ID).value((Number)token.getId());
            writer.name(PERMISSIONS);
            writer.beginArray();
            for (Permission p : token.getPermissions()) {
                writer.beginObject();
                writer.name(RESOURCE_SET).value((Number)p.getResourceSet().getId());
                writer.name(SCOPES);
                writer.beginArray();
                for (String s : p.getScopes()) {
                    writer.value(s);
                }
                writer.endArray();
                writer.endObject();
            }
            writer.endArray();
            writer.endObject();
        }
    }

    private void writePermissionTickets(JsonWriter writer) throws IOException {
        for (PermissionTicket ticket : this.permissionRepository.getAll()) {
            writer.beginObject();
            writer.name(CLAIMS_SUPPLIED);
            writer.beginArray();
            for (Claim claim : ticket.getClaimsSupplied()) {
                writer.beginObject();
                writer.name(ISSUER);
                writer.beginArray();
                for (String issuer : claim.getIssuer()) {
                    writer.value(issuer);
                }
                writer.endArray();
                writer.name(CLAIM_TOKEN_FORMAT);
                writer.beginArray();
                for (String format : claim.getClaimTokenFormat()) {
                    writer.value(format);
                }
                writer.endArray();
                writer.name(CLAIM_TYPE).value(claim.getClaimType());
                writer.name(FRIENDLY_NAME).value(claim.getFriendlyName());
                writer.name(NAME).value(claim.getName());
                writer.name(VALUE).value(claim.getValue().toString());
                writer.endObject();
            }
            writer.endArray();
            writer.name(EXPIRATION).value(this.toUTCString(ticket.getExpiration()));
            writer.name(PERMISSION);
            writer.beginObject();
            Permission p = ticket.getPermission();
            writer.name(RESOURCE_SET).value((Number)p.getResourceSet().getId());
            writer.name(SCOPES);
            writer.beginArray();
            for (String s : p.getScopes()) {
                writer.value(s);
            }
            writer.endArray();
            writer.endObject();
            writer.name(TICKET).value(ticket.getTicket());
            writer.endObject();
        }
    }

    private void writeResourceSets(JsonWriter writer) throws IOException {
        for (ResourceSet rs : this.resourceSetRepository.getAll()) {
            writer.beginObject();
            writer.name(ID).value((Number)rs.getId());
            writer.name(CLIENT_ID).value(rs.getClientId());
            writer.name(ICON_URI).value(rs.getIconUri());
            writer.name(NAME).value(rs.getName());
            writer.name(TYPE).value(rs.getType());
            writer.name(URI).value(rs.getUri());
            writer.name(OWNER).value(rs.getOwner());
            writer.name(POLICIES);
            writer.beginArray();
            for (Policy policy : rs.getPolicies()) {
                writer.beginObject();
                writer.name(NAME).value(policy.getName());
                writer.name(SCOPES);
                writer.beginArray();
                for (String scope : policy.getScopes()) {
                    writer.value(scope);
                }
                writer.endArray();
                writer.name(CLAIMS_REQUIRED);
                writer.beginArray();
                for (Claim claim : policy.getClaimsRequired()) {
                    writer.beginObject();
                    writer.name(ISSUER);
                    writer.beginArray();
                    for (String issuer : claim.getIssuer()) {
                        writer.value(issuer);
                    }
                    writer.endArray();
                    writer.name(CLAIM_TOKEN_FORMAT);
                    writer.beginArray();
                    for (String format : claim.getClaimTokenFormat()) {
                        writer.value(format);
                    }
                    writer.endArray();
                    writer.name(CLAIM_TYPE).value(claim.getClaimType());
                    writer.name(FRIENDLY_NAME).value(claim.getFriendlyName());
                    writer.name(NAME).value(claim.getName());
                    writer.name(VALUE).value(claim.getValue().toString());
                    writer.endObject();
                }
                writer.endArray();
                writer.endObject();
            }
            writer.endArray();
            writer.name(SCOPES);
            writer.beginArray();
            for (String scope : rs.getScopes()) {
                writer.value(scope);
            }
            writer.endArray();
            writer.endObject();
            logger.debug("Finished writing resource set {}", (Object)rs.getId());
        }
    }

    private void writeSavedRegisteredClients(JsonWriter writer) throws IOException {
        for (SavedRegisteredClient src : this.registeredClientService.getAll()) {
            writer.beginObject();
            writer.name(ISSUER).value(src.getIssuer());
            writer.name(REGISTERED_CLIENT).value(src.getRegisteredClient().getSource().toString());
            writer.endObject();
            logger.debug("Wrote saved registered client {}", (Object)src.getId());
        }
        logger.info("Done writing saved registered clients");
    }

    public boolean importExtensionData(String name, JsonReader reader) throws IOException {
        if (name.equals(SAVED_REGISTERED_CLIENTS)) {
            this.readSavedRegisteredClients(reader);
            return true;
        }
        if (name.equals(RESOURCE_SETS)) {
            this.readResourceSets(reader);
            return true;
        }
        if (name.equals(PERMISSION_TICKETS)) {
            this.readPermissionTickets(reader);
            return true;
        }
        if (name.equals(TOKEN_PERMISSIONS)) {
            this.readTokenPermissions(reader);
            return true;
        }
        return false;
    }

    private void readTokenPermissions(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            reader.beginObject();
            Long tokenId = null;
            HashSet<Long> permissions = new HashSet<Long>();
            block9: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block9;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (name.equals(TOKEN_ID)) {
                            tokenId = reader.nextLong();
                            continue block9;
                        }
                        if (!name.equals(PERMISSIONS)) continue block9;
                        reader.beginArray();
                        while (reader.hasNext()) {
                            Permission p = new Permission();
                            Long rsid = null;
                            Set scope = new HashSet();
                            reader.beginObject();
                            block11: while (reader.hasNext()) {
                                switch (reader.peek()) {
                                    case END_OBJECT: {
                                        continue block11;
                                    }
                                    case NAME: {
                                        String pname = reader.nextName();
                                        if (reader.peek() == JsonToken.NULL) {
                                            reader.skipValue();
                                            continue block11;
                                        }
                                        if (pname.equals(RESOURCE_SET)) {
                                            rsid = reader.nextLong();
                                            continue block11;
                                        }
                                        if (pname.equals(SCOPES)) {
                                            scope = JsonUtils.readSet((JsonReader)reader);
                                            continue block11;
                                        }
                                        logger.debug("Found unexpected entry");
                                        reader.skipValue();
                                        continue block11;
                                    }
                                }
                                logger.debug("Found unexpected entry");
                                reader.skipValue();
                            }
                            reader.endObject();
                            p.setScopes(scope);
                            Permission saved = this.permissionRepository.saveRawPermission(p);
                            this.permissionToResourceRefs.put(saved.getId(), rsid);
                            permissions.add(saved.getId());
                        }
                        reader.endArray();
                        continue block9;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            this.tokenToPermissionRefs.put(tokenId, permissions);
        }
        reader.endArray();
    }

    private void readPermissionTickets(JsonReader reader) throws IOException {
        JsonParser parser = new JsonParser();
        reader.beginArray();
        while (reader.hasNext()) {
            PermissionTicket ticket = new PermissionTicket();
            reader.beginObject();
            block13: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block13;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue block13;
                        }
                        if (name.equals(CLAIMS_SUPPLIED)) {
                            HashSet<Claim> claimsSupplied = new HashSet<Claim>();
                            reader.beginArray();
                            while (reader.hasNext()) {
                                Claim c = new Claim();
                                reader.beginObject();
                                block15: while (reader.hasNext()) {
                                    switch (reader.peek()) {
                                        case END_OBJECT: {
                                            continue block15;
                                        }
                                        case NAME: {
                                            String cname = reader.nextName();
                                            if (reader.peek() == JsonToken.NULL) {
                                                reader.skipValue();
                                                continue block15;
                                            }
                                            if (cname.equals(ISSUER)) {
                                                c.setIssuer(JsonUtils.readSet((JsonReader)reader));
                                                continue block15;
                                            }
                                            if (cname.equals(CLAIM_TOKEN_FORMAT)) {
                                                c.setClaimTokenFormat(JsonUtils.readSet((JsonReader)reader));
                                                continue block15;
                                            }
                                            if (cname.equals(CLAIM_TYPE)) {
                                                c.setClaimType(reader.nextString());
                                                continue block15;
                                            }
                                            if (cname.equals(FRIENDLY_NAME)) {
                                                c.setFriendlyName(reader.nextString());
                                                continue block15;
                                            }
                                            if (cname.equals(NAME)) {
                                                c.setName(reader.nextString());
                                                continue block15;
                                            }
                                            if (cname.equals(VALUE)) {
                                                JsonElement e = parser.parse(reader.nextString());
                                                c.setValue(e);
                                                continue block15;
                                            }
                                            logger.debug("Found unexpected entry");
                                            reader.skipValue();
                                            continue block15;
                                        }
                                    }
                                    logger.debug("Found unexpected entry");
                                    reader.skipValue();
                                }
                                reader.endObject();
                                claimsSupplied.add(c);
                            }
                            reader.endArray();
                            ticket.setClaimsSupplied(claimsSupplied);
                            continue block13;
                        }
                        if (name.equals(EXPIRATION)) {
                            ticket.setExpiration(this.utcToDate(reader.nextString()));
                            continue block13;
                        }
                        if (name.equals(PERMISSION)) {
                            Permission p = new Permission();
                            Long rsid = null;
                            reader.beginObject();
                            block16: while (reader.hasNext()) {
                                switch (reader.peek()) {
                                    case END_OBJECT: {
                                        continue block16;
                                    }
                                    case NAME: {
                                        String pname = reader.nextName();
                                        if (reader.peek() == JsonToken.NULL) {
                                            reader.skipValue();
                                            continue block16;
                                        }
                                        if (pname.equals(RESOURCE_SET)) {
                                            rsid = reader.nextLong();
                                            continue block16;
                                        }
                                        if (pname.equals(SCOPES)) {
                                            p.setScopes(JsonUtils.readSet((JsonReader)reader));
                                            continue block16;
                                        }
                                        logger.debug("Found unexpected entry");
                                        reader.skipValue();
                                        continue block16;
                                    }
                                }
                                logger.debug("Found unexpected entry");
                                reader.skipValue();
                            }
                            reader.endObject();
                            Permission saved = this.permissionRepository.saveRawPermission(p);
                            this.permissionToResourceRefs.put(saved.getId(), rsid);
                            ticket.setPermission(saved);
                            continue block13;
                        }
                        if (name.equals(TICKET)) {
                            ticket.setTicket(reader.nextString());
                            continue block13;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block13;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            this.permissionRepository.save(ticket);
        }
        reader.endArray();
    }

    private void readResourceSets(JsonReader reader) throws IOException {
        JsonParser parser = new JsonParser();
        reader.beginArray();
        while (reader.hasNext()) {
            Long oldId = null;
            ResourceSet rs = new ResourceSet();
            reader.beginObject();
            block13: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block13;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue block13;
                        }
                        if (name.equals(ID)) {
                            oldId = reader.nextLong();
                            continue block13;
                        }
                        if (name.equals(CLIENT_ID)) {
                            rs.setClientId(reader.nextString());
                            continue block13;
                        }
                        if (name.equals(ICON_URI)) {
                            rs.setIconUri(reader.nextString());
                            continue block13;
                        }
                        if (name.equals(NAME)) {
                            rs.setName(reader.nextString());
                            continue block13;
                        }
                        if (name.equals(TYPE)) {
                            rs.setType(reader.nextString());
                            continue block13;
                        }
                        if (name.equals(URI)) {
                            rs.setUri(reader.nextString());
                            continue block13;
                        }
                        if (name.equals(OWNER)) {
                            rs.setOwner(reader.nextString());
                            continue block13;
                        }
                        if (name.equals(POLICIES)) {
                            HashSet<Policy> policies = new HashSet<Policy>();
                            reader.beginArray();
                            while (reader.hasNext()) {
                                Policy p = new Policy();
                                reader.beginObject();
                                block15: while (reader.hasNext()) {
                                    switch (reader.peek()) {
                                        case END_OBJECT: {
                                            continue block15;
                                        }
                                        case NAME: {
                                            String pname = reader.nextName();
                                            if (reader.peek() == JsonToken.NULL) {
                                                reader.skipValue();
                                                continue block15;
                                            }
                                            if (pname.equals(NAME)) {
                                                p.setName(reader.nextString());
                                                continue block15;
                                            }
                                            if (pname.equals(SCOPES)) {
                                                p.setScopes(JsonUtils.readSet((JsonReader)reader));
                                                continue block15;
                                            }
                                            if (pname.equals(CLAIMS_REQUIRED)) {
                                                HashSet<Claim> claimsRequired = new HashSet<Claim>();
                                                reader.beginArray();
                                                while (reader.hasNext()) {
                                                    Claim c = new Claim();
                                                    reader.beginObject();
                                                    block17: while (reader.hasNext()) {
                                                        switch (reader.peek()) {
                                                            case END_OBJECT: {
                                                                continue block17;
                                                            }
                                                            case NAME: {
                                                                String cname = reader.nextName();
                                                                if (reader.peek() == JsonToken.NULL) {
                                                                    reader.skipValue();
                                                                    continue block17;
                                                                }
                                                                if (cname.equals(ISSUER)) {
                                                                    c.setIssuer(JsonUtils.readSet((JsonReader)reader));
                                                                    continue block17;
                                                                }
                                                                if (cname.equals(CLAIM_TOKEN_FORMAT)) {
                                                                    c.setClaimTokenFormat(JsonUtils.readSet((JsonReader)reader));
                                                                    continue block17;
                                                                }
                                                                if (cname.equals(CLAIM_TYPE)) {
                                                                    c.setClaimType(reader.nextString());
                                                                    continue block17;
                                                                }
                                                                if (cname.equals(FRIENDLY_NAME)) {
                                                                    c.setFriendlyName(reader.nextString());
                                                                    continue block17;
                                                                }
                                                                if (cname.equals(NAME)) {
                                                                    c.setName(reader.nextString());
                                                                    continue block17;
                                                                }
                                                                if (cname.equals(VALUE)) {
                                                                    JsonElement e = parser.parse(reader.nextString());
                                                                    c.setValue(e);
                                                                    continue block17;
                                                                }
                                                                logger.debug("Found unexpected entry");
                                                                reader.skipValue();
                                                                continue block17;
                                                            }
                                                        }
                                                        logger.debug("Found unexpected entry");
                                                        reader.skipValue();
                                                    }
                                                    reader.endObject();
                                                    claimsRequired.add(c);
                                                }
                                                reader.endArray();
                                                p.setClaimsRequired(claimsRequired);
                                                continue block15;
                                            }
                                            logger.debug("Found unexpected entry");
                                            reader.skipValue();
                                            continue block15;
                                        }
                                    }
                                    logger.debug("Found unexpected entry");
                                    reader.skipValue();
                                }
                                reader.endObject();
                                policies.add(p);
                            }
                            reader.endArray();
                            rs.setPolicies(policies);
                            continue block13;
                        }
                        if (name.equals(SCOPES)) {
                            rs.setScopes(JsonUtils.readSet((JsonReader)reader));
                            continue block13;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block13;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            Long newId = this.resourceSetRepository.save(rs).getId();
            this.resourceSetOldToNewIdMap.put(oldId, newId);
        }
        reader.endArray();
        logger.info("Done reading resource sets");
    }

    private void readSavedRegisteredClients(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            String issuer = null;
            String clientString = null;
            reader.beginObject();
            block5: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block5;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue block5;
                        }
                        if (name.equals(ISSUER)) {
                            issuer = reader.nextString();
                            continue block5;
                        }
                        if (name.equals(REGISTERED_CLIENT)) {
                            clientString = reader.nextString();
                            continue block5;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block5;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            RegisteredClient client = ClientDetailsEntityJsonProcessor.parseRegistered(clientString);
            this.registeredClientService.save(issuer, client);
            logger.debug("Saved registered client");
        }
        reader.endArray();
        logger.info("Done reading saved registered clients");
    }

    public void fixExtensionObjectReferences(MITREidDataServiceMaps maps) {
        for (Long permissionId : this.permissionToResourceRefs.keySet()) {
            Long oldResourceId = this.permissionToResourceRefs.get(permissionId);
            Long newResourceId = this.resourceSetOldToNewIdMap.get(oldResourceId);
            Permission p = this.permissionRepository.getById(permissionId);
            ResourceSet rs = this.resourceSetRepository.getById(newResourceId);
            p.setResourceSet(rs);
            this.permissionRepository.saveRawPermission(p);
            logger.debug("Mapping rsid " + oldResourceId + " to " + newResourceId + " for permission " + permissionId);
        }
        for (Long tokenId : this.tokenToPermissionRefs.keySet()) {
            Long newTokenId = (Long)maps.getAccessTokenOldToNewIdMap().get(tokenId);
            OAuth2AccessTokenEntity token = this.tokenRepository.getAccessTokenById(newTokenId);
            HashSet<Permission> permissions = new HashSet<Permission>();
            for (Long permissionId : this.tokenToPermissionRefs.get(tokenId)) {
                Permission p = this.permissionRepository.getById(permissionId);
                permissions.add(p);
            }
            token.setPermissions(permissions);
            this.tokenRepository.saveAccessToken(token);
        }
        this.permissionToResourceRefs.clear();
        this.resourceSetOldToNewIdMap.clear();
        this.tokenToPermissionRefs.clear();
    }
}

