/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.uma.web;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.mitre.openid.connect.client.model.IssuerServiceResponse;
import org.mitre.openid.connect.client.service.impl.WebfingerIssuerService;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.mitre.openid.connect.model.UserInfo;
import org.mitre.openid.connect.service.UserInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api/emailsearch"})
@PreAuthorize(value="hasRole('ROLE_USER')")
public class UserClaimSearchHelper {
    public static final String URL = "api/emailsearch";
    private WebfingerIssuerService webfingerIssuerService = new WebfingerIssuerService();
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private ConfigurationPropertiesBean config;

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    public String search(@RequestParam(value="identifier") String email, Model m, Authentication auth, HttpServletRequest req) {
        UserInfo localUser = this.userInfoService.getByEmailAddress(email);
        if (localUser != null) {
            HashMap<String, Object> e = new HashMap<String, Object>();
            e.put("issuer", ImmutableSet.of((Object)this.config.getIssuer()));
            e.put("name", "email");
            e.put("value", localUser.getEmail());
            HashMap<String, Object> ev = new HashMap<String, Object>();
            ev.put("issuer", ImmutableSet.of((Object)this.config.getIssuer()));
            ev.put("name", "email_verified");
            ev.put("value", localUser.getEmailVerified());
            HashMap<String, Object> s = new HashMap<String, Object>();
            s.put("issuer", ImmutableSet.of((Object)this.config.getIssuer()));
            s.put("name", "sub");
            s.put("value", localUser.getSub());
            m.addAttribute("entity", (Object)ImmutableSet.of(e, ev, s));
            return "jsonEntityView";
        }
        IssuerServiceResponse resp = this.webfingerIssuerService.getIssuer(req);
        if (resp != null && resp.getIssuer() != null) {
            HashMap<String, Object> e = new HashMap<String, Object>();
            e.put("issuer", ImmutableSet.of((Object)resp.getIssuer()));
            e.put("name", "email");
            e.put("value", email);
            HashMap<String, Object> ev = new HashMap<String, Object>();
            ev.put("issuer", ImmutableSet.of((Object)resp.getIssuer()));
            ev.put("name", "email_verified");
            ev.put("value", true);
            m.addAttribute("entity", (Object)ImmutableSet.of(e, ev));
            return "jsonEntityView";
        }
        m.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
        return "jsonErrorView";
    }
}

