# INNOQ Bootstrap 4 Theme

[Webjar](http://www.webjars.org/) mit dem neuen INNOQ Branding als Bootstrap 4 Theme.

Weitere Informationen über das neue INNOQ Styling gibt es [hier](https://innoq.style).

# Verwendung

Folgendes Repository muss hinzugefügt werden:

    https://nexus.innoq.io/repository/maven-public/
   
Dieses Repository ist auch ein Proxy für das globale Sonatype Maven Repository. 
Das Repository benötigt keine Credentials für den Zugriff.

Das Webjar enthält die folgenden Komponenten:

* css/src vom innoq-bootstrap-theme
* assets vom innoq-styleguide
* JS (normal/min/map) von bootstrap und jquery

## SBT

Hinzufügen vom Repository:

````
resolvers += (
  "nexus.innoq.io" at "https://nexus.innoq.io/repository/maven-public"
)
````
Hinzufügen der Abhängigkeit:

````
libraryDependencies ++= Seq(
    …
    "com.innoq.webjars" % "innoq-bootstrap-theme" % "1.0.0",
    …
)  
````

## Maven

In Maven (in der `~/.m2/settings.xml`, oder in der Project `pom.xml`)

Hinzufügen vom Repository:
````
…
<repositories>
    <repository>
        <id>nexus.innoq.io</id>
        <url>https://nexus.innoq.io/repository/maven-public</url>
    </repository>
</repositories>
…
````

Hinzufügen der Abhängigkeit:

````
…
<dependencies>
    …
    <dependency>
        <groupId>com.innoq.webjars</groupId>
        <artifactId>innoq-bootstrap-theme</artifactId>
        <version>1.0.0</version>
    </dependency>
    …
<dependencies>
…
````

# Hint

Solltet ihr das Problem haben, dass die Schriften nicht geladen werden, so lohnt ein Blick auf die [CSP](https://www.innoq.com/de/blog/content-security-policy-header/) Settings:

Es sollte da u.a. das hier zu finden sein:

```
font-src  *.cloudfront.net 'self'; 
style-src *.cloudfront.net 'self';
```

# Struktur

````
$ jar tf  target/innoq-bootstrap-theme-1.0.0.jar | sort

META-INF/
META-INF/MANIFEST.MF
META-INF/maven/
META-INF/maven/com.innoq.webjars/
META-INF/maven/com.innoq.webjars/innoq-bootstrap-theme/
META-INF/maven/com.innoq.webjars/innoq-bootstrap-theme/pom.properties
META-INF/maven/com.innoq.webjars/innoq-bootstrap-theme/pom.xml
META-INF/resources/
META-INF/resources/webjars/
META-INF/resources/webjars/innoq-bootstrap-theme/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/LICENSE
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/README.md
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/podcast/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/podcast/visual-podcastdetail-test-02.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/podcast/visual-podcastdetail-test-03.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/podcast/visual-podcastdetail-test-04.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/podcast/visual-podcastdetail-test_01.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/tower-spiderman.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/visual-header-girl-1444.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/visual-header-girl.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/visual-header-heads.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/visual-header-ice-1444.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/visual-header-ice.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/visual-header-igel-1444.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/visual-header-igel.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/visual-header-koralle-1444.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/visual-header-koralle.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/visual-header-landing-page.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/visual-header-medusa-1444.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/visual-header-medusa.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-01/visual-newsletter.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-canyon-01.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-canyon-02.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-canyon-03.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-canyon-04.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-canyon-05.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-cloth-01.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-cloth-02.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-cloth-03.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-cloth-04.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-data-01.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-data-02.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-data-03.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-data-04.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-data-05.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-data-06.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-human-01.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-human-02.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-human-03.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-human-04.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-human-05.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-human-06.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-human-07.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/edition-02/edition02-human-08.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-art-01.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-culture-01.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-culture-02.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-culture-03.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-culture-04.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-culture-05.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-podcast.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-staff-01.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-trainings-01.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-trainings-02.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-trainings-03.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-trainings-04.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-trainings-05.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-trainings-06.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-trainings-07.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-workshop-01.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-workshop-02.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-workshop-03.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-workshop-04.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-workshop-05.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-workshop-06.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-workshop-07.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-workshop-08.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-workshop-09.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-workshop-10.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-workshop-11.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-workshop-12.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-workshop-13.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-workshop-14.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-workshop-15.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-workshop-16.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/bg-images/general/visual-workshop-17.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/big_staff_member_default.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/big_staff_member_default.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/example-content/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/example-content/beispiel-talk.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/example-content/blockchain-primer.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/example-content/heribert-links.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/example-content/heribert-rechts.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/example-content/heribert.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/android-icon-192x192.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/apple-icon-114x114.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/apple-icon-120x120.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/apple-icon-144x144.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/apple-icon-152x152.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/apple-icon-180x180.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/apple-icon-57x57.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/apple-icon-60x60.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/apple-icon-72x72.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/apple-icon-76x76.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/favicon-16x16.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/favicon-256x256.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/favicon-32x32.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/favicon-96x96.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/favicon.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/ms-icon-144x144.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/ms-icon-150x150.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/ms-icon-310x310.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-blue/ms-icon-70x70.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/android-icon-192x192.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/apple-icon-114x114.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/apple-icon-120x120.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/apple-icon-144x144.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/apple-icon-152x152.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/apple-icon-180x180.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/apple-icon-57x57.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/apple-icon-60x60.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/apple-icon-72x72.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/apple-icon-76x76.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/favicon-16x16.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/favicon-256x256.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/favicon-32x32.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/favicon-96x96.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/favicon.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/ms-icon-144x144.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/ms-icon-150x150.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/ms-icon-310x310.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-01/favicon-red/ms-icon-70x70.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-02/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-02/favicon-apricot/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-02/favicon-apricot/favicon.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-02/favicon-petrol/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/favicons/edition-02/favicon-petrol/favicon.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/apple-itunes.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/arrow-long-down.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/arrow-long-right.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/arrow-medium-left.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/arrow-sync.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/bookshelf.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/certificate.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/email.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/facebook.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/feedback.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/flame.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/github.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/globe.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/group-idea.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/interactive.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/leanpub.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/learning.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/linkedin.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/minus.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/plus.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/rooms.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/rss-boxed.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/rss.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/spotify.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/support.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/text.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/trainer.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/twitter.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/virtual.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/xing.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/icons/youtube.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/business_technology.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-01/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-01/png/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-01/png/innoq-logo--bluered.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-01/png/innoq-logo--redblue.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-01/png/innoq-logo--whiteblue.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-01/png/innoq-logo--whitered.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-01/png/innoq-logo-square--bluered.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-01/png/innoq-logo-square--whiteblue.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-01/png/innoq-logo-square--whitered.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-01/svg/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-01/svg/innoq-logo--bluered.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-01/svg/innoq-logo--redblue.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-01/svg/innoq-logo--whiteblue.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-01/svg/innoq-logo--whitered.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-01/svg/innoq-logo-square--bluered.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-01/svg/innoq-logo-square--whiteblue.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-01/svg/innoq-logo-square--whitered.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-02/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-02/png/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-02/png/innoq-logo--apricotpetrol.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-02/png/innoq-logo--apricotwhite-boxed.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-02/png/innoq-logo--petrolapricot.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-02/png/innoq-logo--petrolwhite-boxed.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-02/png/innoq-logo--whiteapricot.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-02/png/innoq-logo--whitepetrol.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-02/png/innoq-logo-square--whiteapricot.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-02/png/innoq-logo-square--whitepetrol.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-02/svg/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-02/svg/innoq-logo--apricotpetrol.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-02/svg/innoq-logo--apricotwhite-boxed.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-02/svg/innoq-logo--petrolapricot.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-02/svg/innoq-logo--petrolwhite-boxed.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-02/svg/innoq-logo--whiteapricot.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-02/svg/innoq-logo--whitepetrol.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-02/svg/innoq-logo-square--whiteapricot.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/edition-02/svg/innoq-logo-square--whitepetrol.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/isaqb.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/monochrome/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/monochrome/png/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/monochrome/png/innoq-logo--black.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/monochrome/png/innoq-logo--monochrome.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/monochrome/png/innoq-logo--white.png
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/monochrome/svg/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/monochrome/svg/innoq-logo--black.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/monochrome/svg/innoq-logo--monochrome.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/logos/monochrome/svg/innoq-logo--white.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/ornaments/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/ornaments/zigzag--apricot.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/ornaments/zigzag--blue.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/ornaments/zigzag--petrol.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/ornaments/zigzag--red.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/ornaments/zigzag--white.svg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/podcast-channel-cover/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/podcast-channel-cover/podcast-channel-cover-01.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/assets/podcast-channel-cover/podcast-channel-cover-02.jpg
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/css/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/css/0.0.9/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/css/0.0.9/innoq-bootstrap-theme.css
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/css/0.1.0/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/css/0.1.0/innoq-bootstrap-theme.css
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/css/0.2.0/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/css/0.2.0/innoq-bootstrap-theme.css
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/css/1.0.0/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/css/1.0.0/innoq-bootstrap-theme.css
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/js/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/js/bootstrap.bundle.js.map
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/js/bootstrap.bundle.min.js
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/js/bootstrap.bundle.min.js.map
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/js/jquery.js
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/js/jquery.min.js
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/js/jquery.min.map
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/js/jquery.slim.js
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/js/jquery.slim.min.js
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/js/jquery.slim.min.map
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/src/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/src/styles/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/src/styles/_variables.scss
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/src/styles/index.scss
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/src/styles/overrides/
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/src/styles/overrides/.keep
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/src/styles/overrides/_buttons.scss
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/src/styles/overrides/_dropdowns.scss
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/src/styles/overrides/_forms.scss
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/src/styles/overrides/_list-groups.scss
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/src/styles/overrides/_modals.scss
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/src/styles/overrides/_navbar.scss
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/src/styles/overrides/_popovers.scss
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/src/styles/overrides/_tables.scss
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/src/styles/overrides/_type.scss
META-INF/resources/webjars/innoq-bootstrap-theme/1.0.0/src/styles/overrides/_various.scss
````
