/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.widgets;

import com.explodingpixels.widgets.TableUtils;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class TableHeaderUtils {
    private static final CellRendererPane CELL_RENDER_PANE = new CellRendererPane();
    public static final int NO_COLUMN = -1;
    private static final String PRESSED_COLUMN_KEY = "EPJTableHeader.pressedColumn";
    private static final String SELECTED_COLUMN_KEY = "EPJTableHeader.selectedColumn";
    private static final String SORT_DIRECTION_KEY = "EPJTableHeader.sortDirection";

    private TableHeaderUtils() {
    }

    public static JComponent createCornerComponent(final JTable table) {
        return new JComponent(){

            protected void paintComponent(Graphics g) {
                TableHeaderUtils.paintHeader(g, table, 0, this.getWidth());
            }
        };
    }

    public static void makeHeaderFillEmptySpace(JTable table) {
        table.getTableHeader().setBorder(TableHeaderUtils.createTableHeaderEmptyColumnPainter(table));
    }

    public static void paintHeader(Graphics graphics, JTable table, int x, int width) {
        TableCellRenderer renderer = table.getTableHeader().getDefaultRenderer();
        Component component = renderer.getTableCellRendererComponent(table, "", false, false, -1, table.getColumnCount());
        component.setBounds(0, 0, width, table.getTableHeader().getHeight());
        ((JComponent)component).setOpaque(false);
        CELL_RENDER_PANE.paintComponent(graphics, component, null, x, 0, width, table.getTableHeader().getHeight(), true);
    }

    private static Border createTableHeaderEmptyColumnPainter(final JTable table) {
        return new AbstractBorder(){

            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                JViewport viewport = (JViewport)table.getParent();
                if (viewport != null && table.getWidth() < viewport.getWidth()) {
                    int startX = table.getWidth();
                    int emptyColumnWidth = viewport.getWidth() - table.getWidth();
                    TableHeaderUtils.paintHeader(g, table, startX, emptyColumnWidth);
                }
            }
        };
    }

    public static int getPressedColumn(JTableHeader tableHeader) {
        Object pressedColumnValue = tableHeader.getClientProperty(PRESSED_COLUMN_KEY);
        return pressedColumnValue != null && pressedColumnValue instanceof Integer ? (Integer)pressedColumnValue : -1;
    }

    public static boolean isColumnPressed(JTableHeader tableHeader, int columnModelIndex) {
        int pressedColumn = TableHeaderUtils.getPressedColumn(tableHeader);
        return pressedColumn >= 0 && pressedColumn == columnModelIndex;
    }

    public static void setPressedColumn(JTableHeader tableHeader, int columnModelIndex) {
        tableHeader.putClientProperty(PRESSED_COLUMN_KEY, columnModelIndex);
    }

    public static int getSelectedColumn(JTableHeader tableHeader) {
        Object selectedColumnValue = tableHeader.getClientProperty(SELECTED_COLUMN_KEY);
        return selectedColumnValue != null && selectedColumnValue instanceof Integer ? (Integer)selectedColumnValue : -1;
    }

    public static boolean isColumnSelected(JTableHeader tableHeader, int columnModelIndex) {
        int selectedColumn = TableHeaderUtils.getSelectedColumn(tableHeader);
        return selectedColumn >= 0 && selectedColumn == columnModelIndex;
    }

    public static TableUtils.SortDirection getSortDirection(JTableHeader tableHeader, int columnModelIndex) {
        Object sortDirection = tableHeader.getClientProperty(SORT_DIRECTION_KEY);
        boolean isColumnSelected = TableHeaderUtils.isColumnSelected(tableHeader, columnModelIndex);
        return sortDirection != null && sortDirection instanceof String && isColumnSelected ? TableUtils.SortDirection.find((String)sortDirection) : TableUtils.SortDirection.NONE;
    }

    public static TableUtils.SortDirection toggleSortDirection(JTableHeader tableHeader, int columnModelIndex) {
        int oldSelectedColumn = TableHeaderUtils.getSelectedColumn(tableHeader);
        TableUtils.SortDirection oldSortDirection = TableHeaderUtils.getSortDirection(tableHeader, columnModelIndex);
        TableUtils.SortDirection newSortDirection = oldSelectedColumn != columnModelIndex || oldSortDirection == TableUtils.SortDirection.NONE ? TableUtils.SortDirection.ASCENDING : (oldSortDirection == TableUtils.SortDirection.ASCENDING ? TableUtils.SortDirection.DESCENDING : TableUtils.SortDirection.ASCENDING);
        TableHeaderUtils.setSortDirection(tableHeader, columnModelIndex, newSortDirection);
        return newSortDirection;
    }

    private static void setSortDirection(JTableHeader tableHeader, int columnModelIndex, TableUtils.SortDirection sortDirection) {
        tableHeader.putClientProperty(SELECTED_COLUMN_KEY, columnModelIndex);
        tableHeader.putClientProperty(SORT_DIRECTION_KEY, sortDirection.getValue());
    }
}

