/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets.plaf;

import com.explodingpixels.macwidgets.MacColorUtils;
import com.explodingpixels.macwidgets.MacFontUtils;
import com.explodingpixels.macwidgets.plaf.EmphasizedLabelUI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class UnifiedToolbarButtonUI
extends BasicButtonUI {
    private static final Color PRESSED_BUTTON_MASK_COLOR = new Color(0, 0, 0, 128);
    private static final Color DISABLED_BUTTON_MASK_COLOR = new Color(255, 255, 255, 128);

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setHorizontalTextPosition(0);
        b.setVerticalTextPosition(3);
        b.setIconTextGap(0);
        b.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        b.setOpaque(false);
        b.setFocusable(false);
        b.setFont(MacFontUtils.DEFAULT_BUTTON_FONT);
    }

    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        BufferedImage image = new BufferedImage(iconRect.width, iconRect.height, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        b.getIcon().paintIcon(c, graphics, 0, 0);
        graphics.setComposite(AlphaComposite.SrcAtop);
        if (!model.isEnabled()) {
            graphics.setColor(DISABLED_BUTTON_MASK_COLOR);
        } else if (model.isArmed()) {
            graphics.setColor(PRESSED_BUTTON_MASK_COLOR);
        } else {
            graphics.setColor(new Color(0, 0, 0, 0));
        }
        graphics.fillRect(0, 0, iconRect.width, iconRect.height);
        graphics.dispose();
        g.drawImage(image, iconRect.x, iconRect.y, null);
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        MacFontUtils.enableAntialiasing((Graphics2D)g);
        Graphics2D graphics = (Graphics2D)g.create();
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = c.getFontMetrics(c.getFont());
        graphics.setColor(model.isArmed() ? MacColorUtils.EMPTY_COLOR : EmphasizedLabelUI.DEFAULT_EMPHASIS_COLOR);
        BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, text, -1, textRect.x, textRect.y + 1 + fm.getAscent());
        graphics.setColor(model.isEnabled() ? EmphasizedLabelUI.DEFAULT_FOCUSED_FONT_COLOR : EmphasizedLabelUI.DEFAULT_DISABLED_FONT_COLOR);
        BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, text, -1, textRect.x, textRect.y + fm.getAscent());
        graphics.dispose();
    }
}

