/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.widgets.plaf;

import com.explodingpixels.painter.MacWidgetsPainter;
import com.explodingpixels.widgets.TabCloseListener;
import com.explodingpixels.widgets.plaf.EPTabPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPTabbedPaneUI
extends BasicTabbedPaneUI {
    public static final String TAB_CLOSE_LISTENER_KEY = "TabbedPane.closeListener";
    public static final String CLOSE_BUTTON_LOCATION_KEY = "TabbedPane.closeButtonLocation";
    public static final Object CLOSE_BUTTON_LOCATION_VALUE_LEFT = EPTabPainter.CloseButtonLocation.LEFT;
    public static final Object CLOSE_BUTTON_LOCATION_VALUE_RIGHT = EPTabPainter.CloseButtonLocation.RIGHT;
    private EPTabPainter fTabPainter = new EPTabPainter();
    private MacWidgetsPainter<Component> fContentBorderTopEdgeBackgroundPainter = this.createContentBorderTopEdgeBackgroundPainter();
    private boolean fPaintFullContentBorder = true;
    private int fCurrentDefaultTabWidth = 100;
    private int fMouseOverCloseButtonTabIndex = -1;
    private int fMousePressedCloseButtonTabIndex = -1;
    private TabCloseListener fTabCloseListener = new DefaultTabCloseListener();
    private Timer fTabCloseTimer = new Timer(10, null);
    private CustomLayoutManager fLayoutManager = new CustomLayoutManager();
    private static final Insets FULL_CONTENT_BORDER_INSETS = new Insets(6, 0, 0, 0);
    private static final Insets HAIRLINE_BORDER_INSETS = new Insets(2, 0, 0, 0);
    private static final int DEFAULT_TAB_WIDTH = 100;
    private static final int NO_TAB = -1;
    private static final int SMALLEST_TAB_WIDTH = 35;
    private static final int TAB_ANIMATION_DELTA = 7;
    private static final int OVERFLOW_BUTTON_AREA_WIDTH = 25;

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Font oldFont = this.tabPane.getFont();
        this.tabPane.setFont(oldFont.deriveFont((float)oldFont.getSize() - 2.0f));
        this.tabPane.setBorder(BorderFactory.createEmptyBorder());
        this.tabInsets = new Insets(2, 10, 2, 10);
        this.selectedTabPadInsets = new Insets(2, 0, 2, 0);
        this.doExtractTabCloseProperty();
        this.doExtractCloseButtonLocationProperty();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.tabPane.addMouseMotionListener(this.createCloseButtonMouseMotionListener());
        this.tabPane.addMouseListener(this.createCloseButtonMouseListener());
        this.tabPane.addContainerListener(this.createContainerListener());
        this.tabPane.addPropertyChangeListener(TAB_CLOSE_LISTENER_KEY, this.createTabCloseListenerPropertyChangeListener());
        this.tabPane.addPropertyChangeListener(CLOSE_BUTTON_LOCATION_KEY, this.createCloseButtonLocationPropertyChangeListener());
    }

    private MouseMotionListener createCloseButtonMouseMotionListener() {
        return new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                EPTabbedPaneUI.this.doMouseMoved(e.getPoint());
            }

            public void mouseDragged(MouseEvent e) {
                EPTabbedPaneUI.this.doMousePressed(e.getPoint());
                EPTabbedPaneUI.this.doMouseMoved(e.getPoint());
            }
        };
    }

    private void doMouseMoved(Point point) {
        int tabIndex = this.tabForCoordinate(this.tabPane, point.x, point.y);
        int oldMouseOverCloseButtonTabIndex = this.fMouseOverCloseButtonTabIndex;
        if (this.isTabIndexValid(tabIndex)) {
            Rectangle tabBounds = this.getTabBounds(this.tabPane, tabIndex);
            this.fMouseOverCloseButtonTabIndex = this.fTabPainter.isPointOverCloseButton(tabBounds, point) ? tabIndex : -1;
            this.repaintTab(this.fMouseOverCloseButtonTabIndex);
        }
        this.repaintTab(oldMouseOverCloseButtonTabIndex);
    }

    private MouseListener createCloseButtonMouseListener() {
        return new MouseAdapter(){

            public void mouseExited(MouseEvent e) {
                int oldMouseOverCloseButtonTabIndex = EPTabbedPaneUI.this.fMouseOverCloseButtonTabIndex;
                EPTabbedPaneUI.this.fMouseOverCloseButtonTabIndex = -1;
                EPTabbedPaneUI.this.repaintTab(oldMouseOverCloseButtonTabIndex);
            }

            public void mousePressed(MouseEvent e) {
                EPTabbedPaneUI.this.doMousePressed(e.getPoint());
            }

            public void mouseReleased(MouseEvent e) {
                EPTabbedPaneUI.this.closeTabUsingAnimationIfValid(EPTabbedPaneUI.this.fMousePressedCloseButtonTabIndex);
                int oldMousePressedOverCloseButtonTabIndex = EPTabbedPaneUI.this.fMouseOverCloseButtonTabIndex;
                EPTabbedPaneUI.this.fMousePressedCloseButtonTabIndex = -1;
                EPTabbedPaneUI.this.repaintTab(oldMousePressedOverCloseButtonTabIndex);
            }
        };
    }

    private void doMousePressed(Point point) {
        int tabIndex = this.tabForCoordinate(this.tabPane, point.x, point.y);
        int oldMousePressedCloseButtonIndex = this.fMousePressedCloseButtonTabIndex;
        if (this.isTabIndexValid(tabIndex)) {
            Rectangle tabBounds = this.getTabBounds(this.tabPane, tabIndex);
            this.fMousePressedCloseButtonTabIndex = this.fTabPainter.isPointOverCloseButton(tabBounds, point) ? tabIndex : -1;
            this.repaintTab(this.fMousePressedCloseButtonTabIndex);
        }
        this.repaintTab(oldMousePressedCloseButtonIndex);
    }

    private ContainerListener createContainerListener() {
        return new ContainerAdapter(){

            public void componentAdded(ContainerEvent e) {
                Component componentAdded = e.getChild();
                EPTabbedPaneUI.this.fLayoutManager.forceTabWidth(componentAdded, 35);
                EPTabbedPaneUI.this.animateTabBeingAdded(componentAdded);
            }
        };
    }

    private PropertyChangeListener createTabCloseListenerPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                EPTabbedPaneUI.this.doExtractTabCloseProperty();
            }
        };
    }

    private void doExtractTabCloseProperty() {
        Object closeListenerValue = this.tabPane.getClientProperty(TAB_CLOSE_LISTENER_KEY);
        if (closeListenerValue instanceof TabCloseListener) {
            this.fTabCloseListener = (TabCloseListener)closeListenerValue;
        }
    }

    private PropertyChangeListener createCloseButtonLocationPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                EPTabbedPaneUI.this.doExtractCloseButtonLocationProperty();
            }
        };
    }

    private void doExtractCloseButtonLocationProperty() {
        Object closeButtonLocationValue = this.tabPane.getClientProperty(CLOSE_BUTTON_LOCATION_KEY);
        if (closeButtonLocationValue instanceof EPTabPainter.CloseButtonLocation) {
            this.setCloseButtonLocation((EPTabPainter.CloseButtonLocation)((Object)closeButtonLocationValue));
        }
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return this.fLayoutManager;
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        return this.fPaintFullContentBorder ? FULL_CONTENT_BORDER_INSETS : HAIRLINE_BORDER_INSETS;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paint(g, c);
        this.paintContentBorder(g, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex());
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        Rectangle tabRect = rects[tabIndex];
        boolean isSelected = tabIndex == this.tabPane.getSelectedIndex();
        String title = this.tabPane.getTitleAt(tabIndex);
        Icon icon = this.getIconForTab(tabIndex);
        Graphics2D graphics = (Graphics2D)g;
        boolean isMouseOverCloseButton = this.fMouseOverCloseButtonTabIndex == tabIndex;
        boolean isMousePressedOverCloseButton = this.fMousePressedCloseButtonTabIndex == tabIndex;
        this.fTabPainter.paintTab(graphics, this.tabPane, tabRect, title, icon, isSelected, isMouseOverCloseButton, isMousePressedOverCloseButton);
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int width, int height) {
        Graphics2D graphics = (Graphics2D)g;
        graphics.translate(x, y);
        int borderHeight = this.getContentBorderInsets((int)this.tabPane.getTabPlacement()).top;
        this.fContentBorderTopEdgeBackgroundPainter.paint(graphics, this.tabPane, width, borderHeight);
        graphics.translate(-x, -y);
        if (this.tabPane.getSelectedIndex() >= 0) {
            graphics.setColor(Color.WHITE);
            Rectangle boundsOfSelectedTab = this.getTabBounds(this.tabPane, this.tabPane.getSelectedIndex());
            graphics.drawLine(boundsOfSelectedTab.x, y, boundsOfSelectedTab.x + boundsOfSelectedTab.width, y);
        }
        graphics.setColor(Color.RED);
        g.fillRect(x, y + height, x + width, y + height + 2);
    }

    private MacWidgetsPainter<Component> createContentBorderTopEdgeBackgroundPainter() {
        return new MacWidgetsPainter<Component>(){

            @Override
            public void paint(Graphics2D graphics, Component objectToPaint, int width, int height) {
                GradientPaint paint = new GradientPaint(0.0f, 0.0f, Color.WHITE, 0.0f, height - 1, new Color(0xF8F8F8));
                graphics.setPaint(paint);
                graphics.fillRect(0, 0, width, height - 1);
                graphics.setColor(EPTabPainter.SELECTED_BORDER_COLOR);
                graphics.drawLine(0, 0, width, 0);
                graphics.setColor(new Color(0x999999));
                graphics.drawLine(0, height - 2, width, height - 2);
            }
        };
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    public void setPaintsFullContentBorder(boolean paintsFullContentBorder) {
        this.fPaintFullContentBorder = paintsFullContentBorder;
        this.tabPane.repaint();
    }

    public void setCloseButtonLocation(EPTabPainter.CloseButtonLocation closeButtonLocation) {
        this.fTabPainter.setCloseButtonLocation(closeButtonLocation);
    }

    private void repaintTab(int tabIndex) {
        if (this.isTabIndexValid(tabIndex)) {
            Rectangle tabBounds = this.getTabBounds(this.tabPane, tabIndex);
            this.tabPane.repaint(tabBounds);
        }
    }

    private boolean isTabIndexValid(int tabIndex) {
        return tabIndex >= 0 && tabIndex < this.tabPane.getTabCount();
    }

    private void animateTabBeingAdded(Component tabComponent) {
        this.fTabCloseTimer.addActionListener(this.createTabAddedAnimation(tabComponent));
        this.fTabCloseTimer.start();
    }

    private void closeTabUsingAnimationIfValid(int tabIndex) {
        if (this.isTabIndexValid(tabIndex) && this.fTabCloseListener.tabAboutToBeClosed(tabIndex)) {
            Component tabComponentToClose = this.tabPane.getComponent(tabIndex);
            this.fTabCloseTimer.addActionListener(this.createTabRemovedAnimation(tabComponentToClose));
            this.fTabCloseTimer.start();
        }
    }

    private void closeTab(int tabIndex) {
        assert (this.isTabIndexValid(tabIndex)) : "The tab index should be valid.";
        String title = this.tabPane.getTitleAt(tabIndex);
        Component component = this.tabPane.getComponentAt(tabIndex);
        this.tabPane.removeTabAt(tabIndex);
        this.fTabCloseListener.tabClosed(title, component);
    }

    private ActionListener createTabAddedAnimation(final Component tabComponentAdded) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int currentTabWidth = EPTabbedPaneUI.this.fLayoutManager.getTabWidth(tabComponentAdded);
                int newTabWidth = Math.min(currentTabWidth + 7, EPTabbedPaneUI.this.fCurrentDefaultTabWidth);
                EPTabbedPaneUI.this.fLayoutManager.forceTabWidth(tabComponentAdded, newTabWidth);
                if (newTabWidth == EPTabbedPaneUI.this.fCurrentDefaultTabWidth) {
                    EPTabbedPaneUI.this.animationFinished(this, tabComponentAdded);
                }
                EPTabbedPaneUI.this.tabPane.doLayout();
                EPTabbedPaneUI.this.tabPane.repaint();
            }
        };
    }

    private ActionListener createTabRemovedAnimation(final Component tabComponentToClose) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int currentTabWidth = EPTabbedPaneUI.this.fLayoutManager.getTabWidth(tabComponentToClose);
                int newTabWidth = Math.max(currentTabWidth - 7, 35);
                EPTabbedPaneUI.this.fLayoutManager.forceTabWidth(tabComponentToClose, newTabWidth);
                if (newTabWidth == 35) {
                    EPTabbedPaneUI.this.animationFinished(this, tabComponentToClose);
                    int tabIndex = EPTabbedPaneUI.this.tabPane.indexOfComponent(tabComponentToClose);
                    EPTabbedPaneUI.this.closeTab(tabIndex);
                }
                EPTabbedPaneUI.this.tabPane.doLayout();
                EPTabbedPaneUI.this.tabPane.repaint();
            }
        };
    }

    private void animationFinished(ActionListener actionListenerToRemove, Component tabComponent) {
        this.fTabCloseTimer.removeActionListener(actionListenerToRemove);
        this.fLayoutManager.useDefaultTabWidth(tabComponent);
        if (this.fTabCloseTimer.getActionListeners().length == 0) {
            this.fTabCloseTimer.stop();
        }
    }

    private static class DefaultTabCloseListener
    implements TabCloseListener {
        private DefaultTabCloseListener() {
        }

        public boolean tabAboutToBeClosed(int tabIndex) {
            return true;
        }

        public void tabClosed(String title, Component component) {
        }
    }

    private class CustomLayoutManager
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        private Map<Component, Integer> fTabsBeingAnimatedToWidths;

        private CustomLayoutManager() {
            super(EPTabbedPaneUI.this);
            this.fTabsBeingAnimatedToWidths = new HashMap<Component, Integer>();
        }

        private void forceTabWidth(Component tabComponent, int width) {
            this.fTabsBeingAnimatedToWidths.put(tabComponent, width);
        }

        private void useDefaultTabWidth(Component tabComponent) {
            this.fTabsBeingAnimatedToWidths.remove(tabComponent);
        }

        private int getTabWidth(Component tabComponent) {
            Integer forcedTabWidth = this.fTabsBeingAnimatedToWidths.get(tabComponent);
            return forcedTabWidth == null ? EPTabbedPaneUI.this.fCurrentDefaultTabWidth : forcedTabWidth;
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            Insets tabAreaInsets = EPTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            int currentX = tabAreaInsets.left;
            int y = tabAreaInsets.top;
            int tabAreaWidth = EPTabbedPaneUI.this.tabPane.getWidth() - tabAreaInsets.left - tabAreaInsets.right;
            int requiredWidth = this.calculateRequiredWidth();
            boolean notEnoughRoom = requiredWidth > tabAreaWidth;
            int extraSpace = tabAreaWidth - requiredWidth;
            int numDefaultWidthTabs = this.getNumDefaultWidthTabs();
            System.out.println("tabbed pane width " + tabAreaWidth + ", extra space " + extraSpace);
            if (numDefaultWidthTabs > 0) {
                int extraSpacePerTab = extraSpace / numDefaultWidthTabs;
                int newDefaultTabWidth = EPTabbedPaneUI.this.fCurrentDefaultTabWidth + extraSpacePerTab;
                EPTabbedPaneUI.this.fCurrentDefaultTabWidth = Math.min(newDefaultTabWidth, 100);
                EPTabbedPaneUI.this.fCurrentDefaultTabWidth = Math.max(35, EPTabbedPaneUI.this.fCurrentDefaultTabWidth);
            }
            EPTabbedPaneUI.this.maxTabWidth = 0;
            EPTabbedPaneUI.this.maxTabHeight = EPTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
            EPTabbedPaneUI.this.runCount = 1;
            for (int i = 0; i < tabCount; ++i) {
                Rectangle rect = EPTabbedPaneUI.this.rects[i];
                rect.width = this.isTabBeingAnimated(i) ? this.getForcedTabWidth(i) : EPTabbedPaneUI.this.fCurrentDefaultTabWidth;
                EPTabbedPaneUI.this.maxTabWidth = Math.max(EPTabbedPaneUI.this.maxTabWidth, rect.width);
                rect.x = currentX;
                currentX += rect.width;
                rect.y = y;
                rect.height = EPTabbedPaneUI.this.maxTabHeight;
            }
        }

        private boolean isTabBeingAnimated(int tabIndex) {
            Component tabComponent = EPTabbedPaneUI.this.tabPane.getComponentAt(tabIndex);
            return this.fTabsBeingAnimatedToWidths.get(tabComponent) != null;
        }

        private int getForcedTabWidth(int tabIndex) {
            Component tabComponent = EPTabbedPaneUI.this.tabPane.getComponentAt(tabIndex);
            return this.fTabsBeingAnimatedToWidths.get(tabComponent);
        }

        private int getNumDefaultWidthTabs() {
            return EPTabbedPaneUI.this.tabPane.getTabCount() - this.fTabsBeingAnimatedToWidths.size();
        }

        private int sumOfForcedTabWidths() {
            int sum = 0;
            for (int width : this.fTabsBeingAnimatedToWidths.values()) {
                sum += width;
            }
            return sum;
        }

        private int calculateRequiredWidth() {
            int totalDefaultWidthTabsWidth = this.getNumDefaultWidthTabs() * EPTabbedPaneUI.this.fCurrentDefaultTabWidth;
            return totalDefaultWidthTabsWidth + this.sumOfForcedTabWidths();
        }
    }
}

