/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets.plaf;

import com.explodingpixels.macwidgets.MacFontUtils;
import com.explodingpixels.macwidgets.WidgetBaseColors;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;

public class HudPaintingUtils {
    public static final Color FONT_COLOR = Color.WHITE;
    public static final Color FONT_DISABLED_COLOR = new Color(0xAAAAAA);
    public static final Color PRESSED_MARK_COLOR = new Color(0, 0, 0, 225);
    public static final Color BORDER_COLOR = new Color(12961999);
    private static final int BORDER_WIDTH = 1;
    private static final Color LIGHT_SHADOW_COLOR = new Color(0, 0, 0, 145);
    private static final Color DARK_SHADOW_COLOR = new Color(0, 0, 0, 50);

    private HudPaintingUtils() {
    }

    public static void initHudComponent(JComponent component, boolean isDarkColorScheme) {
        component.setFont(HudPaintingUtils.getHudFont());
        if (isDarkColorScheme) {
            component.setForeground(WidgetBaseColors.DARK_FONT_COLOR);
        } else {
            component.setForeground(WidgetBaseColors.LIGHT_FONT_COLOR);
        }
        component.setOpaque(false);
    }

    public static Font getHudFont() {
        return MacFontUtils.HUD_BUTTON_FONT;
    }

    public static int getHudControlShadowSize(AbstractButton button) {
        return 2;
    }

    public static void paintHudControlBackground(Graphics2D graphics, AbstractButton button, int width, int height, Roundedness roundedness, boolean isDarkColorScheme) {
        Paint paint = HudPaintingUtils.createButtonPaint(button, 1, isDarkColorScheme);
        HudPaintingUtils.paintHudControlBackground(graphics, new Rectangle(0, 0, width, height), roundedness.getShapeProvider(), paint);
    }

    public static void paintHudControlBackground(Graphics2D graphics, Rectangle bounds, ShapeProvider shapeProvider, Paint paint) {
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        graphics.setColor(LIGHT_SHADOW_COLOR);
        graphics.draw(shapeProvider.createShape(x, y, width - 1, height));
        graphics.setColor(DARK_SHADOW_COLOR);
        graphics.draw(shapeProvider.createShape(x, y, width - 1, height + 1));
        graphics.setPaint(paint);
        graphics.fill(shapeProvider.createShape(x, y + 1, width, height - 1));
        graphics.setColor(BORDER_COLOR);
        graphics.draw(shapeProvider.createShape(x, y, width - 1, height - 1));
    }

    private static Paint createButtonPaint(AbstractButton button, int lineBorderWidth, boolean isDarkColorScheme) {
        boolean isPressed = button.getModel().isPressed();
        Color topPressedColor = isDarkColorScheme ? WidgetBaseColors.DARK_ACTIVE_SELECTED_TOP_COLOR : WidgetBaseColors.LIGHT_ACTIVE_SELECTED_TOP_COLOR;
        Color topUnpressedColor = isDarkColorScheme ? WidgetBaseColors.DARK_ACTIVE_TOP_COLOR : WidgetBaseColors.LIGHT_ACTIVE_TOP_COLOR;
        Color bottomPressedColor = isDarkColorScheme ? WidgetBaseColors.DARK_ACTIVE_SELECTED_BOTTOM_COLOR : WidgetBaseColors.LIGHT_ACTIVE_SELECTED_BOTTOM_COLOR;
        Color bottomUnpressedColor = isDarkColorScheme ? WidgetBaseColors.DARK_ACTIVE_BOTTOM_COLOR : WidgetBaseColors.LIGHT_ACTIVE_BOTTOM_COLOR;
        Color topColor = isPressed ? topPressedColor : topUnpressedColor;
        Color bottomColor = isPressed ? bottomPressedColor : bottomUnpressedColor;
        int bottomY = button.getHeight() - lineBorderWidth * 2;
        return new GradientPaint(0.0f, lineBorderWidth, topColor, 0.0f, bottomY, bottomColor);
    }

    public static void updateGraphicsToPaintDisabledControlIfNecessary(Graphics2D graphics, Component component) {
        if (!component.isEnabled()) {
            graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
    }

    public static interface ShapeProvider {
        public Shape createShape(double var1, double var3, double var5, double var7);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Roundedness {
        ROUNDED_BUTTON(0.95),
        COMBO_BUTTON(0.45),
        CHECK_BOX(0.4),
        RADIO(1.0),
        SLIDER_KNOB(1.0);

        private final double fRoundedPercentage;
        private final ShapeProvider fShapeProvider;

        private Roundedness(double roundedPercentage) {
            this.fRoundedPercentage = roundedPercentage;
            this.fShapeProvider = this.createShapeProvider();
        }

        private int getRoundedDiameter(int controlHeight) {
            int roundedDiameter = (int)((double)controlHeight * this.fRoundedPercentage);
            int makeItEven = roundedDiameter % 2;
            return roundedDiameter - makeItEven;
        }

        private ShapeProvider getShapeProvider() {
            return this.fShapeProvider;
        }

        private ShapeProvider createShapeProvider() {
            return new ShapeProvider(){

                public Shape createShape(double x, double y, double width, double height) {
                    double arcDiameter = Roundedness.this.getRoundedDiameter((int)height);
                    return new RoundRectangle2D.Double(x, y, width, height, arcDiameter, arcDiameter);
                }
            };
        }
    }
}

