/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleActionEvent;
import org.eclipse.swt.accessibility.AccessibleActionListener;
import org.eclipse.swt.accessibility.AccessibleAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleAttributeListener;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleHyperlinkListener;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTableCellEvent;
import org.eclipse.swt.accessibility.AccessibleTableCellListener;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.accessibility.AccessibleTextAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextExtendedListener;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.accessibility.AccessibleValueEvent;
import org.eclipse.swt.accessibility.AccessibleValueListener;
import org.eclipse.swt.accessibility.Relation;
import org.eclipse.swt.accessibility.SWTAccessibleDelegate;
import org.eclipse.swt.accessibility.TableAccessibleDelegate;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class Accessible {
    static final int MAX_RELATION_TYPES = 15;
    static NSString[] baseAttributes = new NSString[]{OS.NSAccessibilityRoleAttribute, OS.NSAccessibilitySubroleAttribute, OS.NSAccessibilityRoleDescriptionAttribute, OS.NSAccessibilityHelpAttribute, OS.NSAccessibilityFocusedAttribute, OS.NSAccessibilityParentAttribute, OS.NSAccessibilityChildrenAttribute, OS.NSAccessibilityPositionAttribute, OS.NSAccessibilitySizeAttribute, OS.NSAccessibilityWindowAttribute, OS.NSAccessibilityTopLevelUIElementAttribute};
    NSMutableArray attributeNames = null;
    NSMutableArray parameterizedAttributeNames = null;
    NSMutableArray actionNames = null;
    Vector accessibleListeners = new Vector();
    Vector accessibleControlListeners = new Vector();
    Vector accessibleTextListeners = new Vector();
    Vector accessibleActionListeners = new Vector();
    Vector accessibleHyperlinkListeners = new Vector();
    Vector accessibleTableListeners = new Vector();
    Vector accessibleTableCellListeners = new Vector();
    Vector accessibleTextExtendedListeners = new Vector();
    Vector accessibleValueListeners = new Vector();
    Vector accessibleAttributeListeners = new Vector();
    Relation[] relations = new Relation[15];
    Accessible parent;
    Control control;
    int currentRole = -1;
    Map childToIdMap = new HashMap();
    SWTAccessibleDelegate delegate;
    int index = -1;
    TableAccessibleDelegate tableDelegate;

    public Accessible(Accessible accessible) {
        if (accessible == null) {
            SWT.error(4);
        }
        this.parent = accessible;
        this.control = accessible.control;
        this.delegate = new SWTAccessibleDelegate(this, -1);
    }

    protected Accessible() {
    }

    Accessible(Control control) {
        this.control = control;
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control);
    }

    id accessibleHandle(Accessible accessible) {
        if (accessible.delegate != null) {
            return accessible.delegate;
        }
        if (accessible.control != null) {
            NSView nSView = accessible.control.view;
            int n = OS.objc_msgSend(nSView.id, OS.sel_accessibleHandle);
            return new id(n);
        }
        return null;
    }

    public void addAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.addElement(accessibleListener);
    }

    public void addAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.addElement(accessibleControlListener);
    }

    public void addAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        if (accessibleTextListener instanceof AccessibleTextExtendedListener) {
            this.accessibleTextExtendedListeners.addElement(accessibleTextListener);
        } else {
            this.accessibleTextListeners.addElement(accessibleTextListener);
        }
    }

    public void addAccessibleActionListener(AccessibleActionListener accessibleActionListener) {
        this.checkWidget();
        if (accessibleActionListener == null) {
            SWT.error(4);
        }
        this.accessibleActionListeners.addElement(accessibleActionListener);
    }

    public void addAccessibleHyperlinkListener(AccessibleHyperlinkListener accessibleHyperlinkListener) {
        this.checkWidget();
        if (accessibleHyperlinkListener == null) {
            SWT.error(4);
        }
        this.accessibleHyperlinkListeners.addElement(accessibleHyperlinkListener);
    }

    public void addAccessibleTableListener(AccessibleTableListener accessibleTableListener) {
        this.checkWidget();
        if (accessibleTableListener == null) {
            SWT.error(4);
        }
        this.accessibleTableListeners.addElement(accessibleTableListener);
    }

    public void addAccessibleTableCellListener(AccessibleTableCellListener accessibleTableCellListener) {
        this.checkWidget();
        if (accessibleTableCellListener == null) {
            SWT.error(4);
        }
        this.accessibleTableCellListeners.addElement(accessibleTableCellListener);
    }

    public void addAccessibleValueListener(AccessibleValueListener accessibleValueListener) {
        this.checkWidget();
        if (accessibleValueListener == null) {
            SWT.error(4);
        }
        this.accessibleValueListeners.addElement(accessibleValueListener);
    }

    public void addAccessibleAttributeListener(AccessibleAttributeListener accessibleAttributeListener) {
        this.checkWidget();
        if (accessibleAttributeListener == null) {
            SWT.error(4);
        }
        this.accessibleAttributeListeners.addElement(accessibleAttributeListener);
    }

    void addCGColor(float[] fArray, NSMutableAttributedString nSMutableAttributedString, NSString nSString, NSRange nSRange) {
        int n = OS.CGColorSpaceCreateDeviceRGB();
        int n2 = OS.CGColorCreate(n, fArray);
        OS.CGColorSpaceRelease(n);
        nSMutableAttributedString.addAttribute(nSString, new id(n2), nSRange);
        OS.CGColorRelease(n2);
    }

    public void addRelation(int n, Accessible accessible) {
        this.checkWidget();
        if (this.relations[n] == null) {
            this.relations[n] = new Relation(this, n);
        }
        this.relations[n].addTarget(accessible);
    }

    void checkRole(int n) {
        if (n != this.currentRole) {
            this.currentRole = n;
            if (this.attributeNames != null) {
                this.attributeNames.release();
                this.attributeNames = null;
            }
            if (this.parameterizedAttributeNames != null) {
                this.parameterizedAttributeNames.release();
                this.parameterizedAttributeNames = null;
            }
            if (this.actionNames != null) {
                this.actionNames.release();
                this.actionNames = null;
            }
        }
    }

    void createTableDelegate() {
        if (this.tableDelegate == null) {
            this.tableDelegate = new TableAccessibleDelegate(this);
        }
    }

    id getColumnIndexRangeAttribute(int n) {
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableCellListeners.size()) {
            AccessibleTableCellListener accessibleTableCellListener = (AccessibleTableCellListener)this.accessibleTableCellListeners.elementAt(n2);
            accessibleTableCellListener.getColumnIndex(accessibleTableCellEvent);
            accessibleTableCellListener.getColumnSpan(accessibleTableCellEvent);
            ++n2;
        }
        NSRange nSRange = new NSRange();
        nSRange.location = accessibleTableCellEvent.index;
        nSRange.length = accessibleTableCellEvent.count;
        return NSValue.valueWithRange(nSRange);
    }

    id getRowIndexRangeAttribute(int n) {
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableCellListeners.size()) {
            AccessibleTableCellListener accessibleTableCellListener = (AccessibleTableCellListener)this.accessibleTableCellListeners.elementAt(n2);
            accessibleTableCellListener.getRowIndex(accessibleTableCellEvent);
            accessibleTableCellListener.getRowSpan(accessibleTableCellEvent);
            ++n2;
        }
        NSRange nSRange = new NSRange();
        nSRange.location = accessibleTableCellEvent.index;
        nSRange.length = accessibleTableCellEvent.count;
        return NSValue.valueWithRange(nSRange);
    }

    id getSelectedAttribute(int n) {
        if (this.accessibleTableListeners.size() > 0) {
            AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
            accessibleTableEvent.row = this.index;
            int n2 = 0;
            while (n2 < this.accessibleTableListeners.size()) {
                AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n2);
                if (this.currentRole == 28) {
                    accessibleTableListener.isRowSelected(accessibleTableEvent);
                } else {
                    accessibleTableListener.isColumnSelected(accessibleTableEvent);
                }
                ++n2;
            }
            return NSNumber.numberWithBool(accessibleTableEvent.isSelected);
        }
        return NSNumber.numberWithBool(false);
    }

    id getIndexAttribute(int n) {
        return NSNumber.numberWithInt(this.index);
    }

    id getHeaderAttribute(int n) {
        SWTAccessibleDelegate sWTAccessibleDelegate = null;
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n2);
            accessibleTableListener.getColumnHeader(accessibleTableEvent);
            ++n2;
        }
        if (accessibleTableEvent.accessible != null) {
            sWTAccessibleDelegate = accessibleTableEvent.accessible.delegate;
        }
        return sWTAccessibleDelegate;
    }

    id getVisibleColumnsAttribute(int n) {
        Accessible[] accessibleArray;
        if (this.accessibleTableListeners.size() == 0) {
            return null;
        }
        NSMutableArray nSMutableArray = null;
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableListeners.size()) {
            accessibleArray = (Accessible[])this.accessibleTableListeners.elementAt(n2);
            accessibleArray.getVisibleColumns(accessibleTableEvent);
            ++n2;
        }
        if (accessibleTableEvent.accessibles != null) {
            NSMutableArray nSMutableArray2 = NSMutableArray.arrayWithCapacity(accessibleTableEvent.accessibles.length);
            accessibleArray = accessibleTableEvent.accessibles;
            int n3 = 0;
            while (n3 < accessibleArray.length) {
                Accessible accessible = accessibleArray[n3];
                nSMutableArray2.addObject(accessible.delegate);
                ++n3;
            }
            nSMutableArray = nSMutableArray2;
        }
        return nSMutableArray == null ? NSArray.array() : nSMutableArray;
    }

    id getVisibleRowsAttribute(int n) {
        Accessible[] accessibleArray;
        if (this.accessibleTableListeners.size() == 0) {
            return null;
        }
        NSMutableArray nSMutableArray = null;
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableListeners.size()) {
            accessibleArray = (Accessible[])this.accessibleTableListeners.elementAt(n2);
            accessibleArray.getVisibleRows(accessibleTableEvent);
            ++n2;
        }
        if (accessibleTableEvent.accessibles != null) {
            NSMutableArray nSMutableArray2 = NSMutableArray.arrayWithCapacity(accessibleTableEvent.accessibles.length);
            accessibleArray = accessibleTableEvent.accessibles;
            int n3 = 0;
            while (n3 < accessibleArray.length) {
                Accessible accessible = accessibleArray[n3];
                nSMutableArray2.addObject(accessible.delegate);
                ++n3;
            }
            nSMutableArray = nSMutableArray2;
        }
        return nSMutableArray == null ? NSArray.array() : nSMutableArray;
    }

    id getSelectedRowsAttribute(int n) {
        Object object;
        if (this.accessibleTableListeners.size() == 0) {
            return null;
        }
        Object object2 = null;
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableListeners.size()) {
            object = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n2);
            object.getSelectedRows(accessibleTableEvent);
            ++n2;
        }
        if (accessibleTableEvent.selected != null) {
            int[] nArray = accessibleTableEvent.selected;
            object = NSMutableArray.arrayWithCapacity(nArray.length);
            int n3 = 0;
            while (n3 < nArray.length) {
                accessibleTableEvent.row = nArray[n3];
                int n4 = 0;
                while (n4 < this.accessibleTableListeners.size()) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n4);
                    accessibleTableListener.getRow(accessibleTableEvent);
                    ++n4;
                }
                if (accessibleTableEvent.accessible != null) {
                    ((NSMutableArray)object).addObject(accessibleTableEvent.accessible.delegate);
                }
                ++n3;
            }
            object2 = object;
        }
        return object2 == null ? NSArray.array() : object2;
    }

    int getRowCount() {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n = 0;
        while (n < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n);
            accessibleTableListener.getRowCount(accessibleTableEvent);
            ++n;
        }
        return accessibleTableEvent.count;
    }

    id getRowsAttribute(int n) {
        Object object;
        if (this.accessibleTableListeners.size() == 0) {
            return null;
        }
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableListeners.size()) {
            object = (Accessible[])this.accessibleTableListeners.elementAt(n2);
            object.getRowCount(accessibleTableEvent);
            object.getRows(accessibleTableEvent);
            ++n2;
        }
        if (accessibleTableEvent.accessibles == null) {
            accessibleTableEvent.accessibles = new Accessible[0];
        }
        if (accessibleTableEvent.count != accessibleTableEvent.accessibles.length) {
            this.createTableDelegate();
            n2 = 0;
            while (n2 < this.accessibleTableListeners.size()) {
                object = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n2);
                object.getRowCount(accessibleTableEvent);
                object.getRows(accessibleTableEvent);
                ++n2;
            }
        }
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(accessibleTableEvent.accessibles.length);
        object = accessibleTableEvent.accessibles;
        int n3 = 0;
        while (n3 < ((Accessible[])object).length) {
            Accessible accessible = object[n3];
            accessible.index = n3++;
            nSMutableArray.addObject(accessible.delegate);
        }
        return nSMutableArray;
    }

    id getSelectedColumnsAttribute(int n) {
        Object object;
        if (this.accessibleTableListeners.size() == 0) {
            return null;
        }
        Object object2 = null;
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableListeners.size()) {
            object = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n2);
            object.getSelectedColumns(accessibleTableEvent);
            ++n2;
        }
        if (accessibleTableEvent.selected != null) {
            int[] nArray = accessibleTableEvent.selected;
            object = NSMutableArray.arrayWithCapacity(nArray.length);
            int n3 = 0;
            while (n3 < nArray.length) {
                accessibleTableEvent.column = nArray[n3];
                int n4 = 0;
                while (n4 < this.accessibleTableListeners.size()) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n4);
                    accessibleTableListener.getColumn(accessibleTableEvent);
                    ++n4;
                }
                if (accessibleTableEvent.accessible != null) {
                    ((NSMutableArray)object).addObject(accessibleTableEvent.accessible.delegate);
                }
                ++n3;
            }
            object2 = object;
        }
        return object2 == null ? NSArray.array() : object2;
    }

    int getColumnCount() {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n = 0;
        while (n < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n);
            accessibleTableListener.getColumnCount(accessibleTableEvent);
            ++n;
        }
        return accessibleTableEvent.count;
    }

    id getColumnsAttribute(int n) {
        Object object;
        if (this.accessibleTableListeners.size() == 0) {
            return null;
        }
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableListeners.size()) {
            object = (Accessible[])this.accessibleTableListeners.elementAt(n2);
            object.getColumnCount(accessibleTableEvent);
            object.getColumns(accessibleTableEvent);
            ++n2;
        }
        if (accessibleTableEvent.accessibles == null) {
            accessibleTableEvent.accessibles = new Accessible[0];
        }
        if (accessibleTableEvent.count != accessibleTableEvent.accessibles.length) {
            this.createTableDelegate();
            n2 = 0;
            while (n2 < this.accessibleTableListeners.size()) {
                object = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n2);
                object.getColumnCount(accessibleTableEvent);
                object.getColumns(accessibleTableEvent);
                ++n2;
            }
        }
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(accessibleTableEvent.accessibles.length);
        object = accessibleTableEvent.accessibles;
        int n3 = 0;
        while (n3 < ((Accessible[])object).length) {
            Accessible accessible = object[n3];
            accessible.index = n3++;
            nSMutableArray.addObject(accessible.delegate);
        }
        return nSMutableArray;
    }

    public id internal_accessibilityActionDescription(NSString nSString, int n) {
        NSString nSString2 = NSString.string();
        String string = nSString.getString();
        if (this.accessibleActionListeners.size() > 0) {
            AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(this);
            int n2 = 0;
            while (n2 < this.accessibleActionListeners.size()) {
                AccessibleActionListener accessibleActionListener = (AccessibleActionListener)this.accessibleActionListeners.elementAt(n2);
                accessibleActionListener.getActionCount(accessibleActionEvent);
                ++n2;
            }
            n2 = -1;
            int n3 = 0;
            while (n3 < accessibleActionEvent.count) {
                accessibleActionEvent.index = n3;
                int n4 = 0;
                while (n4 < this.accessibleActionListeners.size()) {
                    AccessibleActionListener accessibleActionListener = (AccessibleActionListener)this.accessibleActionListeners.elementAt(n4);
                    accessibleActionListener.getName(accessibleActionEvent);
                    ++n4;
                }
                if (string.equals(accessibleActionEvent.result)) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
            if (n2 != -1) {
                accessibleActionEvent.index = n2;
                accessibleActionEvent.result = null;
                n3 = 0;
                while (n3 < this.accessibleActionListeners.size()) {
                    AccessibleActionListener accessibleActionListener = (AccessibleActionListener)this.accessibleActionListeners.elementAt(n3);
                    accessibleActionListener.getDescription(accessibleActionEvent);
                    ++n3;
                }
                if (accessibleActionEvent.result != null) {
                    nSString2 = NSString.stringWith(accessibleActionEvent.result);
                }
            }
        }
        return nSString2;
    }

    public NSArray internal_accessibilityActionNames(int n) {
        if (this.accessibleActionListeners.size() > 0) {
            AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(this);
            int n2 = 0;
            while (n2 < this.accessibleActionListeners.size()) {
                AccessibleActionListener accessibleActionListener = (AccessibleActionListener)this.accessibleActionListeners.elementAt(n2);
                accessibleActionListener.getActionCount(accessibleActionEvent);
                ++n2;
            }
            NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(accessibleActionEvent.count);
            int n3 = 0;
            while (n3 < accessibleActionEvent.count) {
                accessibleActionEvent.index = n3;
                int n4 = 0;
                while (n4 < this.accessibleActionListeners.size()) {
                    AccessibleActionListener accessibleActionListener = (AccessibleActionListener)this.accessibleActionListeners.elementAt(n4);
                    accessibleActionListener.getName(accessibleActionEvent);
                    ++n4;
                }
                nSMutableArray.addObject(NSString.stringWith(accessibleActionEvent.result));
                ++n3;
            }
            return nSMutableArray;
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.detail = -1;
        int n5 = 0;
        while (n5 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
            accessibleControlListener.getRole(accessibleControlEvent);
            ++n5;
        }
        if (accessibleControlEvent.detail == -1) {
            return null;
        }
        this.checkRole(accessibleControlEvent.detail);
        if (n == -1 && this.actionNames != null) {
            return Accessible.retainedAutoreleased(this.actionNames);
        }
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(5);
        switch (accessibleControlEvent.detail) {
            case 30: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 62: 
            case 1027: 
            case 1073: {
                nSMutableArray.addObject(OS.NSAccessibilityPressAction);
                break;
            }
            case 46: {
                nSMutableArray.addObject(OS.NSAccessibilityConfirmAction);
                break;
            }
        }
        if (n == -1) {
            this.actionNames = nSMutableArray;
            this.actionNames.retain();
            return Accessible.retainedAutoreleased(this.actionNames);
        }
        return nSMutableArray;
    }

    public boolean internal_accessibilityIsAttributeSettable(NSString nSString, int n) {
        if (this.accessibleTextExtendedListeners.size() > 0) {
            if (nSString.isEqualToString(OS.NSAccessibilitySelectedTextRangeAttribute)) {
                return true;
            }
            if (nSString.isEqualToString(OS.NSAccessibilityVisibleCharacterRangeAttribute)) {
                return true;
            }
        }
        return this.accessibleValueListeners.size() > 0 && nSString.isEqualToString(OS.NSAccessibilityValueAttribute);
    }

    public NSArray internal_accessibilityAttributeNames(int n) {
        String string;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.detail = -1;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getRole(accessibleControlEvent);
            ++n2;
        }
        if (accessibleControlEvent.detail == -1) {
            return null;
        }
        this.checkRole(accessibleControlEvent.detail);
        if (this.attributeNames != null) {
            return Accessible.retainedAutoreleased(this.attributeNames);
        }
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(baseAttributes.length);
        int n3 = 0;
        while (n3 < baseAttributes.length) {
            nSMutableArray.addObject(baseAttributes[n3]);
            ++n3;
        }
        switch (accessibleControlEvent.detail) {
            case 10: {
                break;
            }
            case 9: {
                nSMutableArray.addObject(OS.NSAccessibilityTitleAttribute);
                break;
            }
            case 2: {
                nSMutableArray.addObject(OS.NSAccessibilitySelectedChildrenAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleChildrenAttribute);
                break;
            }
            case 11: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedChildrenAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleChildrenAttribute);
                break;
            }
            case 12: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                break;
            }
            case 21: {
                nSMutableArray.addObject(OS.NSAccessibilityMaxValueAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityMinValueAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 13: {
                nSMutableArray.addObject(OS.NSAccessibilityTitleAttribute);
                break;
            }
            case 3: {
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 18: {
                nSMutableArray.addObject(OS.NSAccessibilityTitleAttribute);
                break;
            }
            case 41: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 43: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityTitleAttribute);
                break;
            }
            case 44: 
            case 45: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityTitleAttribute);
                break;
            }
            case 62: {
                break;
            }
            case 46: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityExpandedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityNumberOfCharactersAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedTextAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedTextRangeAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleCharacterRangeAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 42: 
            case 1044: 
            case 1054: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityNumberOfCharactersAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedTextAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedTextRangeAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityInsertionPointLineNumberAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedTextRangesAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleCharacterRangeAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 22: {
                break;
            }
            case 33: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityHeaderAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleChildrenAttribute);
                break;
            }
            case 34: {
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 24: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityHeaderAttribute);
                break;
            }
            case 29: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 35: {
                nSMutableArray.addObject(OS.NSAccessibilityColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityHeaderAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleColumnsAttribute);
                break;
            }
            case 36: {
                nSMutableArray.addObject(OS.NSAccessibilityColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityHeaderAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleColumnsAttribute);
            }
            case 60: {
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityContentsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityTabsAttribute);
                break;
            }
            case 37: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityTitleAttribute);
                break;
            }
            case 48: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityMaxValueAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityMinValueAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 51: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityMaxValueAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityMinValueAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 30: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                break;
            }
            case 8: {
                break;
            }
            case 54: {
                break;
            }
            case 1025: {
                break;
            }
            case 27: {
                nSMutableArray.removeObject(OS.NSAccessibilityChildrenAttribute);
                nSMutableArray.removeObject(OS.NSAccessibilityFocusedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityIndexAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityHeaderAttribute);
                break;
            }
            case 15: {
                break;
            }
            case 40: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityTitleAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityDescriptionAttribute);
                break;
            }
            case 20: {
                break;
            }
            case 28: {
                nSMutableArray.addObject(OS.NSAccessibilityVisibleChildrenAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityIndexAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedAttribute);
                break;
            }
            case 52: {
                break;
            }
            case 23: {
                break;
            }
            case 1027: {
                break;
            }
            case 1073: {
                break;
            }
            case 61: {
                break;
            }
            case 1029: {
                break;
            }
            case 47: {
                break;
            }
            case 1038: {
                break;
            }
            case 1043: {
                break;
            }
            case 1040: {
                break;
            }
            case 1053: {
                break;
            }
        }
        if (accessibleControlEvent.detail != -1 && (string = this.roleToOs(accessibleControlEvent.detail)).indexOf(58) == -1) {
            nSMutableArray.removeObject(OS.NSAccessibilitySubroleAttribute);
        }
        if (n != -1) {
            nSMutableArray.removeObject(OS.NSAccessibilityChildrenAttribute);
        }
        if (n == -1) {
            this.attributeNames = nSMutableArray;
            this.attributeNames.retain();
            return Accessible.retainedAutoreleased(this.attributeNames);
        }
        return nSMutableArray;
    }

    public id internal_accessibilityAttributeValue(NSString nSString, int n) {
        if (nSString.isEqualToString(OS.NSAccessibilityRoleAttribute)) {
            return this.getRoleAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySubroleAttribute)) {
            return this.getSubroleAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityRoleDescriptionAttribute)) {
            return this.getRoleDescriptionAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityExpandedAttribute)) {
            return this.getExpandedAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityHelpAttribute)) {
            return this.getHelpAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityTitleAttribute)) {
            return this.getTitleAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityValueAttribute)) {
            return this.getValueAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityMaxValueAttribute)) {
            return this.getMaxValueAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityMinValueAttribute)) {
            return this.getMinValueAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityEnabledAttribute)) {
            return this.getEnabledAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityFocusedAttribute)) {
            return this.getFocusedAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityParentAttribute)) {
            return this.getParentAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityChildrenAttribute)) {
            return this.getChildrenAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityVisibleChildrenAttribute)) {
            return this.getChildrenAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityContentsAttribute)) {
            return this.getChildrenAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityTabsAttribute)) {
            return this.getTabsAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityWindowAttribute)) {
            return this.getWindowAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityTopLevelUIElementAttribute)) {
            return this.getTopLevelUIElementAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityPositionAttribute)) {
            return this.getPositionAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySizeAttribute)) {
            return this.getSizeAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityDescriptionAttribute)) {
            return this.getDescriptionAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityNumberOfCharactersAttribute)) {
            return this.getNumberOfCharactersAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySelectedTextAttribute)) {
            return this.getSelectedTextAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySelectedTextRangeAttribute)) {
            return this.getSelectedTextRangeAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityInsertionPointLineNumberAttribute)) {
            return this.getInsertionPointLineNumberAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySelectedTextRangesAttribute)) {
            return this.getSelectedTextRangesAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityVisibleCharacterRangeAttribute)) {
            return this.getVisibleCharacterRangeAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityServesAsTitleForUIElementsAttribute)) {
            return this.getServesAsTitleForUIElementsAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityTitleUIElementAttribute)) {
            return this.getTitleUIElementAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityColumnsAttribute)) {
            return this.getColumnsAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySelectedColumnsAttribute)) {
            return this.getSelectedColumnsAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityRowsAttribute)) {
            return this.getRowsAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySelectedRowsAttribute)) {
            return this.getSelectedRowsAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityVisibleRowsAttribute)) {
            return this.getVisibleRowsAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityVisibleColumnsAttribute)) {
            return this.getVisibleColumnsAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityHeaderAttribute)) {
            return this.getHeaderAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityIndexAttribute)) {
            return this.getIndexAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySelectedAttribute)) {
            return this.getSelectedAttribute(n);
        }
        if (OS.VERSION >= 4192 && nSString.isEqualToString(OS.NSAccessibilityRowIndexRangeAttribute)) {
            return this.getRowIndexRangeAttribute(n);
        }
        if (OS.VERSION >= 4192 && nSString.isEqualToString(OS.NSAccessibilityColumnIndexRangeAttribute)) {
            return this.getColumnIndexRangeAttribute(n);
        }
        return null;
    }

    public id internal_accessibilityAttributeValue_forParameter(NSString nSString, id id2, int n) {
        if (nSString.isEqualToString(OS.NSAccessibilityStringForRangeParameterizedAttribute)) {
            return this.getStringForRangeParameterizedAttribute(id2, n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityRangeForLineParameterizedAttribute)) {
            return this.getRangeForLineParameterizedAttribute(id2, n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityRangeForIndexParameterizedAttribute)) {
            return this.getRangeForIndexParameterizedAttribute(id2, n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityLineForIndexParameterizedAttribute)) {
            return this.getLineForIndexParameterizedAttribute(id2, n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityBoundsForRangeParameterizedAttribute)) {
            return this.getBoundsForRangeParameterizedAttribute(id2, n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityRangeForPositionParameterizedAttribute)) {
            return this.getRangeForPositionParameterizedAttribute(id2, n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityAttributedStringForRangeParameterizedAttribute)) {
            return this.getAttributedStringForRangeParameterizedAttribute(id2, n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityStyleRangeForIndexParameterizedAttribute)) {
            return this.getStyleRangeForIndexAttribute(id2, n);
        }
        if (OS.VERSION >= 4192 && nSString.isEqualToString(OS.NSAccessibilityCellForColumnAndRowParameterizedAttribute)) {
            return this.getCellForColumnAndRowParameter(id2, n);
        }
        return null;
    }

    public id internal_accessibilityFocusedUIElement(int n) {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = -3;
        accessibleControlEvent.accessible = null;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getFocus(accessibleControlEvent);
            ++n2;
        }
        if (accessibleControlEvent.childID == -3) {
            return null;
        }
        if (accessibleControlEvent.accessible != null) {
            return new id(OS.NSAccessibilityUnignoredAncestor(accessibleControlEvent.accessible.control.view.id));
        }
        if (accessibleControlEvent.childID == -1 || accessibleControlEvent.childID == -2) {
            return new id(OS.NSAccessibilityUnignoredAncestor(this.control.view.id));
        }
        return new id(OS.NSAccessibilityUnignoredAncestor(this.childIDToOs((int)accessibleControlEvent.childID).id));
    }

    public id internal_accessibilityHitTest(NSPoint nSPoint, int n) {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.x = (int)nSPoint.x;
        Monitor monitor = Display.getCurrent().getPrimaryMonitor();
        accessibleControlEvent.y = (int)((float)monitor.getBounds().height - nSPoint.y);
        accessibleControlEvent.childID = -3;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getChildAtPoint(accessibleControlEvent);
            ++n2;
        }
        if (accessibleControlEvent.childID == -3 && accessibleControlEvent.accessible == null) {
            return null;
        }
        if (accessibleControlEvent.accessible != null) {
            return new id(OS.NSAccessibilityUnignoredAncestor(accessibleControlEvent.accessible.delegate.id));
        }
        if (accessibleControlEvent.childID == -1 || accessibleControlEvent.childID == -2) {
            return new id(OS.NSAccessibilityUnignoredAncestor(this.control.view.id));
        }
        return new id(OS.NSAccessibilityUnignoredAncestor(this.childIDToOs((int)accessibleControlEvent.childID).id));
    }

    public boolean internal_accessibilityIsIgnored(int n) {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.detail = -1;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getRole(accessibleControlEvent);
            ++n2;
        }
        int n3 = n2 = accessibleControlEvent.detail == -1 ? 1 : 0;
        if (n2 != 0) {
            n2 = this.getTitleAttribute(n) == null && this.getHelpAttribute(n) == null && this.getDescriptionAttribute(n) == null ? 1 : 0;
        }
        return n2 != 0;
    }

    public NSArray internal_accessibilityParameterizedAttributeNames(int n) {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.detail = -1;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getRole(accessibleControlEvent);
            ++n2;
        }
        if (accessibleControlEvent.detail == -1) {
            return null;
        }
        this.checkRole(accessibleControlEvent.detail);
        if (n == -1 && this.parameterizedAttributeNames != null) {
            return Accessible.retainedAutoreleased(this.parameterizedAttributeNames);
        }
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(4);
        switch (accessibleControlEvent.detail) {
            case 42: 
            case 1044: 
            case 1054: {
                nSMutableArray.addObject(OS.NSAccessibilityStringForRangeParameterizedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityRangeForLineParameterizedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityRangeForIndexParameterizedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityLineForIndexParameterizedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityBoundsForRangeParameterizedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityRangeForPositionParameterizedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityAttributedStringForRangeParameterizedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityStyleRangeForIndexParameterizedAttribute);
                break;
            }
            case 24: {
                if (OS.VERSION < 4192) break;
                nSMutableArray.addObject(OS.NSAccessibilityCellForColumnAndRowParameterizedAttribute);
            }
        }
        if (n == -1) {
            this.parameterizedAttributeNames = nSMutableArray;
            this.parameterizedAttributeNames.retain();
            return Accessible.retainedAutoreleased(this.parameterizedAttributeNames);
        }
        return nSMutableArray;
    }

    public boolean internal_accessibilityPerformAction(NSString nSString, int n) {
        String string = nSString.getString();
        if (this.accessibleActionListeners.size() > 0) {
            AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(this);
            int n2 = 0;
            while (n2 < this.accessibleActionListeners.size()) {
                AccessibleActionListener accessibleActionListener = (AccessibleActionListener)this.accessibleActionListeners.elementAt(n2);
                accessibleActionListener.getActionCount(accessibleActionEvent);
                ++n2;
            }
            n2 = -1;
            int n3 = 0;
            while (n3 < accessibleActionEvent.count) {
                accessibleActionEvent.index = n3;
                int n4 = 0;
                while (n4 < this.accessibleActionListeners.size()) {
                    AccessibleActionListener accessibleActionListener = (AccessibleActionListener)this.accessibleActionListeners.elementAt(n4);
                    accessibleActionListener.getName(accessibleActionEvent);
                    ++n4;
                }
                if (string.equals(accessibleActionEvent.result)) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
            if (n2 != -1) {
                accessibleActionEvent.index = n2;
                accessibleActionEvent.result = null;
                n3 = 0;
                while (n3 < this.accessibleActionListeners.size()) {
                    AccessibleActionListener accessibleActionListener = (AccessibleActionListener)this.accessibleActionListeners.elementAt(n3);
                    accessibleActionListener.doAction(accessibleActionEvent);
                    ++n3;
                }
                return "OK".equals(accessibleActionEvent.result);
            }
        }
        return false;
    }

    public void internal_accessibilitySetValue_forAttribute(id id2, NSString nSString, int n) {
        if (nSString.isEqualToString(OS.NSAccessibilitySelectedTextRangeAttribute)) {
            this.setSelectedTextRangeAttribute(id2, n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityVisibleCharacterRangeAttribute)) {
            this.setVisibleCharacterRangeAttribute(id2, n);
        }
        if (this.accessibleValueListeners.size() > 0) {
            AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(this);
            NSNumber nSNumber = new NSNumber(id2);
            accessibleValueEvent.value = new Double(nSNumber.doubleValue());
            int n2 = 0;
            while (n2 < this.accessibleValueListeners.size()) {
                AccessibleValueListener accessibleValueListener = (AccessibleValueListener)this.accessibleValueListeners.elementAt(n2);
                accessibleValueListener.setCurrentValue(accessibleValueEvent);
                ++n2;
            }
        }
    }

    public void dispose() {
        if (this.parent == null) {
            return;
        }
        this.release(true);
        this.parent = null;
    }

    public Control getControl() {
        return this.control;
    }

    public void internal_dispose_Accessible() {
        this.release(true);
    }

    id getAttributedStringForRangeParameterizedAttribute(id id2, int n) {
        Object object;
        if (this.accessibleAttributeListeners.size() == 0) {
            return null;
        }
        id id3 = this.getStringForRangeParameterizedAttribute(id2, n);
        NSMutableAttributedString nSMutableAttributedString = (NSMutableAttributedString)new NSMutableAttributedString().alloc();
        nSMutableAttributedString.initWithString(new NSString(id3), null);
        nSMutableAttributedString.autorelease();
        NSValue nSValue = new NSValue(id2.id);
        NSRange nSRange = nSValue.rangeValue();
        AccessibleTextAttributeEvent accessibleTextAttributeEvent = new AccessibleTextAttributeEvent(this);
        accessibleTextAttributeEvent.offset = nSRange.location;
        accessibleTextAttributeEvent.end = -1;
        accessibleTextAttributeEvent.start = -1;
        NSRange nSRange2 = new NSRange();
        while (accessibleTextAttributeEvent.offset < nSRange.location + nSRange.length) {
            NSObject nSObject;
            Object object2;
            if (this.accessibleAttributeListeners.size() > 0) {
                int n2 = 0;
                while (n2 < this.accessibleAttributeListeners.size()) {
                    object2 = (AccessibleAttributeListener)this.accessibleAttributeListeners.elementAt(n2);
                    object2.getTextAttributes(accessibleTextAttributeEvent);
                    ++n2;
                }
            }
            if (accessibleTextAttributeEvent.start == -1 && accessibleTextAttributeEvent.end == -1) {
                return id3;
            }
            nSRange2.location = accessibleTextAttributeEvent.start - nSRange.location;
            nSRange2.length = accessibleTextAttributeEvent.end - accessibleTextAttributeEvent.start;
            if (nSRange2.location < 0) {
                nSRange2.length -= -nSRange2.location;
                nSRange2.location = 0;
            }
            if (nSRange2.location + nSRange2.length > nSRange.length) {
                nSRange2.length = nSRange.length - nSRange2.location;
            }
            accessibleTextAttributeEvent.offset = accessibleTextAttributeEvent.end;
            if (accessibleTextAttributeEvent.textStyle == null) continue;
            TextStyle textStyle = accessibleTextAttributeEvent.textStyle;
            if (textStyle.font != null) {
                object2 = NSMutableDictionary.dictionaryWithCapacity(4);
                object = textStyle.font.handle;
                nSObject = ((NSFont)object).fontName();
                ((NSMutableDictionary)object2).setValue(nSObject, OS.NSAccessibilityFontNameKey);
                NSString nSString = ((NSFont)object).familyName();
                ((NSMutableDictionary)object2).setValue(nSString, OS.NSAccessibilityFontFamilyKey);
                NSString nSString2 = ((NSFont)object).displayName();
                ((NSMutableDictionary)object2).setValue(nSString2, OS.NSAccessibilityVisibleNameKey);
                float f = ((NSFont)object).pointSize();
                ((NSMutableDictionary)object2).setValue(NSNumber.numberWithDouble(f), OS.NSAccessibilityFontSizeKey);
                nSMutableAttributedString.addAttribute(OS.NSAccessibilityFontTextAttribute, (id)object2, nSRange2);
            }
            if (textStyle.foreground != null) {
                this.addCGColor(textStyle.foreground.handle, nSMutableAttributedString, OS.NSAccessibilityForegroundColorTextAttribute, nSRange2);
            }
            if (textStyle.background != null) {
                this.addCGColor(textStyle.background.handle, nSMutableAttributedString, OS.NSAccessibilityBackgroundColorTextAttribute, nSRange2);
            }
            if (textStyle.underline) {
                int n3 = textStyle.underlineStyle;
                object = OS.NSAccessibilityUnderlineTextAttribute;
                nSObject = null;
                switch (n3) {
                    case 0: {
                        nSObject = NSNumber.numberWithInt(1);
                        break;
                    }
                    case 1: {
                        nSObject = NSNumber.numberWithInt(9);
                        break;
                    }
                    case 3: {
                        object = OS.NSAccessibilityMisspelledTextAttribute;
                        nSObject = NSNumber.numberWithBool(true);
                        break;
                    }
                    default: {
                        nSObject = NSNumber.numberWithInt(0);
                    }
                }
                nSMutableAttributedString.addAttribute((NSString)object, nSObject, nSRange2);
            }
            if (textStyle.underlineColor != null) {
                this.addCGColor(textStyle.underlineColor.handle, nSMutableAttributedString, OS.NSAccessibilityUnderlineColorTextAttribute, nSRange2);
            }
            if (textStyle.strikeout) {
                nSMutableAttributedString.addAttribute(OS.NSAccessibilityStrikethroughTextAttribute, NSNumber.numberWithBool(true), nSRange2);
                if (textStyle.strikeoutColor != null) {
                    this.addCGColor(textStyle.strikeoutColor.handle, nSMutableAttributedString, OS.NSAccessibilityStrikethroughColorTextAttribute, nSRange2);
                }
            }
            if (textStyle.data == null || !(textStyle.data instanceof URL)) continue;
            URL uRL = (URL)textStyle.data;
            object = NSURL.URLWithString(NSString.stringWith(uRL.toExternalForm()));
            nSMutableAttributedString.addAttribute(OS.NSAccessibilityLinkTextAttribute, (id)object, nSRange2);
        }
        AccessibleAttributeEvent accessibleAttributeEvent = new AccessibleAttributeEvent(this);
        accessibleAttributeEvent.indent = Integer.MAX_VALUE;
        if (this.accessibleAttributeListeners.size() > 0) {
            int n4 = 0;
            while (n4 < this.accessibleAttributeListeners.size()) {
                object = (AccessibleAttributeListener)this.accessibleAttributeListeners.elementAt(n4);
                object.getAttributes(accessibleAttributeEvent);
                ++n4;
            }
        }
        if (accessibleAttributeEvent.indent != Integer.MAX_VALUE) {
            NSMutableDictionary nSMutableDictionary = NSMutableDictionary.dictionaryWithCapacity(3);
            int n5 = 0;
            switch (accessibleAttributeEvent.alignment) {
                case 0x1000000: {
                    n5 = 2;
                    break;
                }
                case 131072: {
                    n5 = 1;
                    break;
                }
                default: {
                    n5 = 0;
                }
            }
            nSMutableDictionary.setValue(NSNumber.numberWithInt(n5), NSString.stringWith("AXTextAlignment"));
            nSRange.location = 0;
            nSMutableAttributedString.addAttribute(NSString.stringWith("AXParagraphStyle"), nSMutableDictionary, nSRange);
        }
        return nSMutableAttributedString;
    }

    id getBoundsForRangeParameterizedAttribute(id id2, int n) {
        if (this.accessibleTextExtendedListeners.size() == 0) {
            return null;
        }
        NSValue nSValue = null;
        NSValue nSValue2 = new NSValue(id2.id);
        NSRange nSRange = nSValue2.rangeValue();
        NSRect nSRect = new NSRect();
        if (this.accessibleTextExtendedListeners.size() > 0) {
            Object object;
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n;
            accessibleTextEvent.start = nSRange.location;
            accessibleTextEvent.end = nSRange.location + nSRange.length;
            int n2 = 0;
            while (n2 < this.accessibleTextExtendedListeners.size()) {
                object = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n2);
                object.getTextBounds(accessibleTextEvent);
                ++n2;
            }
            nSRect.x = accessibleTextEvent.x;
            NSArray nSArray = NSScreen.screens();
            object = new NSScreen(nSArray.objectAtIndex(0));
            NSRect nSRect2 = ((NSScreen)object).frame();
            nSRect.y = nSRect2.height - (float)accessibleTextEvent.y - (float)accessibleTextEvent.height;
            nSRect.width = accessibleTextEvent.width;
            nSRect.height = accessibleTextEvent.height;
            nSValue = NSValue.valueWithRect(nSRect);
        }
        return nSValue;
    }

    id getExpandedAttribute(int n) {
        return NSNumber.numberWithBool(false);
    }

    id getHelpAttribute(int n) {
        NSString nSString = null;
        AccessibleEvent accessibleEvent = new AccessibleEvent(this);
        accessibleEvent.childID = n;
        int n2 = 0;
        while (n2 < this.accessibleListeners.size()) {
            AccessibleListener accessibleListener = (AccessibleListener)this.accessibleListeners.elementAt(n2);
            accessibleListener.getHelp(accessibleEvent);
            ++n2;
        }
        if (accessibleEvent.result != null) {
            nSString = NSString.stringWith(accessibleEvent.result);
        }
        return nSString;
    }

    id getRangeForPositionParameterizedAttribute(id id2, int n) {
        NSValue nSValue = null;
        NSValue nSValue2 = new NSValue(id2.id);
        NSPoint nSPoint = nSValue2.pointValue();
        NSRange nSRange = new NSRange();
        if (this.accessibleTextExtendedListeners.size() > 0) {
            NSArray nSArray = NSScreen.screens();
            NSScreen nSScreen = new NSScreen(nSArray.objectAtIndex(0));
            NSRect nSRect = nSScreen.frame();
            nSPoint.y = nSRect.height - nSPoint.y;
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n;
            accessibleTextEvent.x = (int)nSPoint.x;
            accessibleTextEvent.y = (int)nSPoint.y;
            int n2 = 0;
            while (n2 < this.accessibleTextExtendedListeners.size()) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n2);
                accessibleTextExtendedListener.getOffsetAtPoint(accessibleTextEvent);
                ++n2;
            }
            nSRange.location = accessibleTextEvent.offset;
            nSRange.length = 1;
        }
        nSValue = NSValue.valueWithRange(nSRange);
        return nSValue;
    }

    NSString getRoleAttribute(int n) {
        NSString nSString = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.detail = -1;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getRole(accessibleControlEvent);
            ++n2;
        }
        if (accessibleControlEvent.detail != -1) {
            String string = this.roleToOs(accessibleControlEvent.detail);
            int n3 = string.indexOf(58);
            if (n3 != -1) {
                string = string.substring(0, n3);
            }
            nSString = NSString.stringWith(string);
        }
        return nSString;
    }

    id getSubroleAttribute(int n) {
        String string;
        int n2;
        NSString nSString = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.detail = -1;
        int n3 = 0;
        while (n3 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n3);
            accessibleControlListener.getRole(accessibleControlEvent);
            ++n3;
        }
        if (accessibleControlEvent.detail != -1 && (n2 = (string = this.roleToOs(accessibleControlEvent.detail)).indexOf(58)) != -1) {
            string = string.substring(n2 + 1);
            nSString = NSString.stringWith(string);
        }
        return nSString;
    }

    id getRoleDescriptionAttribute(int n) {
        Object object;
        NSString nSString = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.detail = -1;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            object.getRole(accessibleControlEvent);
            ++n2;
        }
        if (accessibleControlEvent.detail != -1) {
            if (accessibleControlEvent.detail == 37) {
                nSString = new NSString(OS.NSAccessibilityRoleDescription(NSString.stringWith((String)"AXTab").id, 0));
            } else {
                String string = this.roleToOs(accessibleControlEvent.detail);
                object = null;
                int n3 = string.indexOf(58);
                if (n3 != -1) {
                    object = string.substring(n3 + 1);
                    string = string.substring(0, n3);
                }
                NSString nSString2 = NSString.stringWith(string);
                NSString nSString3 = null;
                if (object != null) {
                    nSString3 = NSString.stringWith((String)object);
                }
                nSString = new NSString(OS.NSAccessibilityRoleDescription(nSString2 != null ? nSString2.id : 0, nSString3 != null ? nSString3.id : 0));
            }
        }
        return nSString;
    }

    id getTitleAttribute(int n) {
        NSString nSString = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.detail = -1;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getRole(accessibleControlEvent);
            ++n2;
        }
        if (accessibleControlEvent.detail != 41) {
            AccessibleEvent accessibleEvent = new AccessibleEvent(this);
            accessibleEvent.childID = n;
            accessibleEvent.result = null;
            int n3 = 0;
            while (n3 < this.accessibleListeners.size()) {
                AccessibleListener accessibleListener = (AccessibleListener)this.accessibleListeners.elementAt(n3);
                accessibleListener.getName(accessibleEvent);
                ++n3;
            }
            if (accessibleEvent.result != null) {
                nSString = NSString.stringWith(accessibleEvent.result);
            }
        }
        return nSString;
    }

    id getTitleUIElementAttribute(int n) {
        id id2 = null;
        Relation relation = this.relations[9];
        if (relation != null) {
            id2 = relation.getTitleUIElement();
        }
        return id2;
    }

    id getValueAttribute(int n) {
        id id2 = null;
        if (this.accessibleValueListeners.size() > 0) {
            AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(this);
            int n2 = 0;
            while (n2 < this.accessibleValueListeners.size()) {
                AccessibleValueListener accessibleValueListener = (AccessibleValueListener)this.accessibleValueListeners.elementAt(n2);
                accessibleValueListener.getCurrentValue(accessibleValueEvent);
                ++n2;
            }
            id2 = NSNumber.numberWithDouble(accessibleValueEvent.value.doubleValue());
        } else {
            Object object;
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n;
            accessibleControlEvent.detail = -1;
            accessibleControlEvent.result = null;
            int n3 = 0;
            while (n3 < this.accessibleControlListeners.size()) {
                object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n3);
                object.getRole(accessibleControlEvent);
                object.getValue(accessibleControlEvent);
                ++n3;
            }
            n3 = accessibleControlEvent.detail;
            object = accessibleControlEvent.result;
            switch (n3) {
                case 3: 
                case 44: 
                case 45: 
                case 48: 
                case 51: {
                    if (object != null) {
                        try {
                            int n4 = Integer.parseInt((String)object);
                            id2 = NSNumber.numberWithBool(n4 != 0);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (((String)object).equalsIgnoreCase("true")) {
                                id2 = NSNumber.numberWithBool(true);
                                break;
                            }
                            if (!((String)object).equalsIgnoreCase("false")) break;
                            id2 = NSNumber.numberWithBool(false);
                        }
                        break;
                    }
                    id2 = NSNumber.numberWithBool(false);
                    break;
                }
                case 37: 
                case 60: {
                    AccessibleControlEvent accessibleControlEvent2 = new AccessibleControlEvent(this);
                    accessibleControlEvent2.childID = -4;
                    int n5 = 0;
                    while (n5 < this.accessibleControlListeners.size()) {
                        AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
                        accessibleControlListener.getSelection(accessibleControlEvent2);
                        ++n5;
                    }
                    if (accessibleControlEvent2.childID >= -1) {
                        if (n3 == 37) {
                            id2 = NSNumber.numberWithBool(accessibleControlEvent2.childID == n);
                            break;
                        }
                        id2 = new id(OS.NSAccessibilityUnignoredAncestor(this.childIDToOs((int)accessibleControlEvent2.childID).id));
                        break;
                    }
                    id2 = NSNumber.numberWithBool(false);
                    break;
                }
                case 42: 
                case 46: 
                case 1044: 
                case 1054: {
                    if (object == null) break;
                    id2 = NSString.stringWith((String)object);
                    break;
                }
                case 29: 
                case 41: {
                    AccessibleEvent accessibleEvent = new AccessibleEvent(this);
                    accessibleEvent.childID = n;
                    accessibleEvent.result = null;
                    int n6 = 0;
                    while (n6 < this.accessibleListeners.size()) {
                        AccessibleListener accessibleListener = (AccessibleListener)this.accessibleListeners.elementAt(n6);
                        accessibleListener.getName(accessibleEvent);
                        ++n6;
                    }
                    if (accessibleEvent.result != null) {
                        id2 = NSString.stringWith(accessibleEvent.result);
                    } else if (object != null) {
                        id2 = NSString.stringWith((String)object);
                    }
                    id2 = id2 == null ? NSString.string() : id2;
                }
            }
        }
        return id2;
    }

    id getEnabledAttribute(int n) {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.detail = 0;
        accessibleControlEvent.childID = n;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getState(accessibleControlEvent);
            n2 += 1;
        }
        int n3 = n2 = (accessibleControlEvent.detail & 1) == 0 ? 1 : 0;
        if (!n2 && this.delegate == null) {
            n2 = this.control.isEnabled();
        }
        return NSNumber.numberWithBool(n2 != 0);
    }

    id getFocusedAttribute(int n) {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = -3;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getFocus(accessibleControlEvent);
            n2 += 1;
        }
        if (accessibleControlEvent.accessible != null) {
            n2 = accessibleControlEvent.accessible.index == n && accessibleControlEvent.accessible.control == this.control ? 1 : 0;
            return NSNumber.numberWithBool(n2 != 0);
        }
        if (accessibleControlEvent.childID == -1) {
            return NSNumber.numberWithBool(true);
        }
        if (accessibleControlEvent.childID == -2) {
            return NSNumber.numberWithBool(false);
        }
        if (accessibleControlEvent.childID != -3) {
            return NSNumber.numberWithBool(accessibleControlEvent.childID == n);
        }
        return null;
    }

    id getParentAttribute(int n) {
        id id2 = null;
        id2 = n == -1 ? (this.parent != null ? (this.parent.delegate != null ? this.parent.delegate : new id(OS.NSAccessibilityUnignoredAncestor(this.accessibleHandle((Accessible)this.parent).id))) : null) : new id(OS.NSAccessibilityUnignoredAncestor(this.accessibleHandle((Accessible)this).id));
        return id2;
    }

    id getChildrenAttribute(int n) {
        id id2 = null;
        if (n == -1) {
            if (this.currentRole == 24) {
                this.getRowsAttribute(n);
                this.getColumnsAttribute(n);
            }
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n;
            accessibleControlEvent.detail = -1;
            int n2 = 0;
            while (n2 < this.accessibleControlListeners.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
                accessibleControlListener.getChildCount(accessibleControlEvent);
                ++n2;
            }
            n2 = accessibleControlEvent.detail;
            if (n2 >= 0) {
                Object object;
                int n3 = 0;
                while (n3 < this.accessibleControlListeners.size()) {
                    object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n3);
                    object.getChildren(accessibleControlEvent);
                    ++n3;
                }
                Object[] objectArray = accessibleControlEvent.children;
                object = NSMutableArray.arrayWithCapacity(n2);
                int n4 = 0;
                while (n4 < n2) {
                    Object object2;
                    Object object3 = objectArray[n4];
                    if (object3 instanceof Accessible) {
                        object2 = (Accessible)object3;
                        if (((Accessible)object2).delegate != null) {
                            ((NSMutableArray)object).addObject(((Accessible)object2).delegate);
                        } else {
                            ((NSMutableArray)object).addObject(this.accessibleHandle((Accessible)object2));
                        }
                    } else if (object3 instanceof Integer) {
                        object2 = this.childIDToOs((Integer)object3);
                        ((NSMutableArray)object).addObject((id)object2);
                    }
                    ++n4;
                }
                id2 = new id(OS.NSAccessibilityUnignoredChildren(((NSMutableArray)object).id));
            }
        } else {
            id2 = NSArray.array();
        }
        return id2;
    }

    id getTabsAttribute(int n) {
        id id2 = null;
        if (n == -1) {
            Object object;
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n;
            accessibleControlEvent.detail = -1;
            int n2 = 0;
            while (n2 < this.accessibleControlListeners.size()) {
                object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
                object.getChildCount(accessibleControlEvent);
                ++n2;
            }
            if (accessibleControlEvent.detail > 0) {
                n2 = 0;
                while (n2 < this.accessibleControlListeners.size()) {
                    object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
                    object.getChildren(accessibleControlEvent);
                    ++n2;
                }
                Object[] objectArray = accessibleControlEvent.children;
                if (objectArray != null && objectArray.length > 0) {
                    object = NSMutableArray.arrayWithCapacity(objectArray.length);
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        Object object2 = objectArray[n3];
                        if (object2 instanceof Integer) {
                            int n4;
                            accessibleControlEvent.childID = n4 = ((Integer)object2).intValue();
                            accessibleControlEvent.detail = -1;
                            int n5 = 0;
                            while (n5 < this.accessibleControlListeners.size()) {
                                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
                                accessibleControlListener.getRole(accessibleControlEvent);
                                ++n5;
                            }
                            if (accessibleControlEvent.detail == 37) {
                                id id3 = this.childIDToOs((Integer)object2);
                                ((NSMutableArray)object).addObject(id3);
                            }
                        } else {
                            ((NSMutableArray)object).addObject(((Accessible)object2).control.view);
                        }
                        ++n3;
                    }
                    id2 = new id(OS.NSAccessibilityUnignoredChildren(((NSMutableArray)object).id));
                }
            }
        } else {
            id2 = NSArray.array();
        }
        return id2;
    }

    id getWindowAttribute(int n) {
        return this.control.view.window();
    }

    id getTopLevelUIElementAttribute(int n) {
        return this.control.view.window();
    }

    id getPositionAttribute(int n) {
        Object object;
        NSValue nSValue = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.width = -1;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            object.getLocation(accessibleControlEvent);
            ++n2;
        }
        Monitor monitor = Display.getCurrent().getPrimaryMonitor();
        object = new NSPoint();
        if (accessibleControlEvent.width != -1) {
            ((NSPoint)object).x = accessibleControlEvent.x;
            ((NSPoint)object).y = monitor.getBounds().height - accessibleControlEvent.y - accessibleControlEvent.height;
            nSValue = NSValue.valueWithPoint((NSPoint)object);
        } else if (n != -1) {
            Point point = null;
            Rectangle rectangle = this.control.getBounds();
            point = this.control.getParent() != null ? this.control.getParent().toDisplay(rectangle.x, rectangle.y) : ((Shell)this.control).toDisplay(rectangle.x, rectangle.y);
            ((NSPoint)object).x = point.x;
            ((NSPoint)object).y = point.y;
            nSValue = NSValue.valueWithPoint((NSPoint)object);
        }
        return nSValue;
    }

    id getSizeAttribute(int n) {
        NSValue nSValue = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.width = -1;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getLocation(accessibleControlEvent);
            ++n2;
        }
        NSSize nSSize = new NSSize();
        if (accessibleControlEvent.width != -1) {
            nSSize.width = accessibleControlEvent.width;
            nSSize.height = accessibleControlEvent.height;
            nSValue = NSValue.valueWithSize(nSSize);
        } else if (n != -1) {
            nSSize.height = 0.0f;
            nSSize.width = 0.0f;
            nSValue = NSValue.valueWithSize(nSSize);
        }
        return nSValue;
    }

    id getCellForColumnAndRowParameter(id id2, int n) {
        SWTAccessibleDelegate sWTAccessibleDelegate = null;
        NSArray nSArray = new NSArray(id2.id);
        if (nSArray.count() == 2) {
            AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
            accessibleTableEvent.column = new NSNumber(nSArray.objectAtIndex(0)).intValue();
            accessibleTableEvent.row = new NSNumber(nSArray.objectAtIndex(1)).intValue();
            int n2 = 0;
            while (n2 < this.accessibleTableListeners.size()) {
                AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n2);
                accessibleTableListener.getCell(accessibleTableEvent);
                sWTAccessibleDelegate = accessibleTableEvent.accessible.delegate;
                ++n2;
            }
        }
        return sWTAccessibleDelegate;
    }

    id getDescriptionAttribute(int n) {
        AccessibleEvent accessibleEvent = new AccessibleEvent(this);
        accessibleEvent.childID = n;
        accessibleEvent.result = null;
        NSString nSString = null;
        int n2 = 0;
        while (n2 < this.accessibleListeners.size()) {
            AccessibleListener accessibleListener = (AccessibleListener)this.accessibleListeners.elementAt(n2);
            accessibleListener.getDescription(accessibleEvent);
            ++n2;
        }
        NSString nSString2 = nSString = accessibleEvent.result != null ? NSString.stringWith(accessibleEvent.result) : null;
        if (nSString == null && this.control instanceof Composite) {
            nSString = NSString.string();
        }
        return nSString;
    }

    id getInsertionPointLineNumberAttribute(int n) {
        NSNumber nSNumber = null;
        if (this.accessibleTextExtendedListeners.size() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n;
            int n2 = 0;
            while (n2 < this.accessibleTextExtendedListeners.size()) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n2);
                accessibleTextExtendedListener.getCaretOffset(accessibleTextEvent);
                ++n2;
            }
            accessibleTextEvent.start = n2 = accessibleTextEvent.offset;
            accessibleTextEvent.end = n2;
            accessibleTextEvent.count = Integer.MIN_VALUE;
            accessibleTextEvent.type = 4;
            int n3 = 0;
            while (n3 < this.accessibleTextExtendedListeners.size()) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n3);
                accessibleTextExtendedListener.getText(accessibleTextEvent);
                ++n3;
            }
            nSNumber = NSNumber.numberWithInt(Math.max(0, -accessibleTextEvent.count));
        } else {
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n;
            accessibleControlEvent.result = null;
            int n4 = 0;
            while (n4 < this.accessibleControlListeners.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n4);
                accessibleControlListener.getValue(accessibleControlEvent);
                ++n4;
            }
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n;
            accessibleTextEvent.offset = -1;
            int n5 = 0;
            while (n5 < this.accessibleTextListeners.size()) {
                AccessibleTextListener accessibleTextListener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(n5);
                accessibleTextListener.getCaretOffset(accessibleTextEvent);
                ++n5;
            }
            if (accessibleControlEvent.result != null && accessibleTextEvent.offset != -1) {
                n5 = this.lineNumberForOffset(accessibleControlEvent.result, accessibleTextEvent.offset);
                nSNumber = NSNumber.numberWithInt(n5);
            }
        }
        return nSNumber;
    }

    id getLineForIndexParameterizedAttribute(id id2, int n) {
        NSNumber nSNumber = null;
        NSNumber nSNumber2 = new NSNumber(id2.id);
        int n2 = nSNumber2.intValue();
        if (this.accessibleTextExtendedListeners.size() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n;
            accessibleTextEvent.start = n2;
            accessibleTextEvent.end = n2;
            accessibleTextEvent.count = Integer.MIN_VALUE;
            accessibleTextEvent.type = 4;
            int n3 = 0;
            while (n3 < this.accessibleTextExtendedListeners.size()) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n3);
                accessibleTextExtendedListener.getText(accessibleTextEvent);
                ++n3;
            }
            nSNumber = NSNumber.numberWithInt(Math.max(0, -accessibleTextEvent.count));
        } else {
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n;
            accessibleControlEvent.result = null;
            int n4 = 0;
            while (n4 < this.accessibleControlListeners.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n4);
                accessibleControlListener.getValue(accessibleControlEvent);
                ++n4;
            }
            String string = accessibleControlEvent.result;
            if (string != null) {
                nSNumber = NSNumber.numberWithInt(this.lineNumberForOffset(string, n2));
            }
        }
        return nSNumber;
    }

    id getMaxValueAttribute(int n) {
        NSNumber nSNumber = null;
        if (this.accessibleValueListeners.size() > 0) {
            AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(this);
            int n2 = 0;
            while (n2 < this.accessibleValueListeners.size()) {
                AccessibleValueListener accessibleValueListener = (AccessibleValueListener)this.accessibleValueListeners.elementAt(n2);
                accessibleValueListener.getMaximumValue(accessibleValueEvent);
                ++n2;
            }
            nSNumber = NSNumber.numberWithDouble(accessibleValueEvent.value.doubleValue());
        }
        return nSNumber;
    }

    id getMinValueAttribute(int n) {
        NSNumber nSNumber = null;
        if (this.accessibleValueListeners.size() > 0) {
            AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(this);
            int n2 = 0;
            while (n2 < this.accessibleValueListeners.size()) {
                AccessibleValueListener accessibleValueListener = (AccessibleValueListener)this.accessibleValueListeners.elementAt(n2);
                accessibleValueListener.getMinimumValue(accessibleValueEvent);
                ++n2;
            }
            nSNumber = NSNumber.numberWithDouble(accessibleValueEvent.value.doubleValue());
        }
        return nSNumber;
    }

    id getNumberOfCharactersAttribute(int n) {
        NSNumber nSNumber = null;
        if (this.accessibleTextExtendedListeners.size() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n;
            int n2 = 0;
            while (n2 < this.accessibleTextExtendedListeners.size()) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n2);
                accessibleTextExtendedListener.getCharacterCount(accessibleTextEvent);
                ++n2;
            }
            nSNumber = NSNumber.numberWithInt(accessibleTextEvent.count);
        } else {
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n;
            accessibleControlEvent.result = null;
            int n3 = 0;
            while (n3 < this.accessibleControlListeners.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n3);
                accessibleControlListener.getValue(accessibleControlEvent);
                ++n3;
            }
            String string = accessibleControlEvent.result;
            if (string != null) {
                nSNumber = NSNumber.numberWithInt(string.length());
            }
        }
        return nSNumber;
    }

    id getRangeForLineParameterizedAttribute(id id2, int n) {
        NSValue nSValue = null;
        NSNumber nSNumber = new NSNumber(id2.id);
        int n2 = nSNumber.intValue();
        if (this.accessibleTextExtendedListeners.size() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n;
            accessibleTextEvent.end = 0;
            accessibleTextEvent.start = 0;
            accessibleTextEvent.count = n2;
            accessibleTextEvent.type = 4;
            int n3 = 0;
            while (n3 < this.accessibleTextExtendedListeners.size()) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n3);
                accessibleTextExtendedListener.getText(accessibleTextEvent);
                ++n3;
            }
            NSRange nSRange = new NSRange();
            nSRange.location = accessibleTextEvent.start;
            nSRange.length = accessibleTextEvent.end - accessibleTextEvent.start;
            nSValue = NSValue.valueWithRange(nSRange);
        } else if (this.accessibleControlListeners.size() > 0) {
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n;
            accessibleControlEvent.result = null;
            int n4 = 0;
            while (n4 < this.accessibleControlListeners.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n4);
                accessibleControlListener.getValue(accessibleControlEvent);
                ++n4;
            }
            if (accessibleControlEvent.result != null) {
                NSRange nSRange = this.rangeForLineNumber(n2, accessibleControlEvent.result);
                if (nSRange.location != -1) {
                    nSValue = NSValue.valueWithRange(nSRange);
                }
            }
        }
        return nSValue;
    }

    id getRangeForIndexParameterizedAttribute(id id2, int n) {
        NSValue nSValue = null;
        NSNumber nSNumber = new NSNumber(id2.id);
        int n2 = nSNumber.intValue();
        if (this.accessibleTextExtendedListeners.size() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n;
            accessibleTextEvent.end = 0;
            accessibleTextEvent.start = 0;
            accessibleTextEvent.count = n2;
            accessibleTextEvent.type = 0;
            int n3 = 0;
            while (n3 < this.accessibleTextExtendedListeners.size()) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n3);
                accessibleTextExtendedListener.getText(accessibleTextEvent);
                ++n3;
            }
            NSRange nSRange = new NSRange();
            nSRange.location = accessibleTextEvent.start;
            nSRange.length = accessibleTextEvent.end - accessibleTextEvent.start;
            nSValue = NSValue.valueWithRange(nSRange);
        } else {
            this.accessibleControlListeners.size();
        }
        return nSValue;
    }

    id getSelectedTextAttribute(int n) {
        NSString nSString = NSString.string();
        if (this.accessibleTextExtendedListeners.size() > 0) {
            String string;
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n;
            accessibleTextEvent.index = 0;
            int n2 = 0;
            while (n2 < this.accessibleTextExtendedListeners.size()) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n2);
                accessibleTextExtendedListener.getSelection(accessibleTextEvent);
                ++n2;
            }
            n2 = accessibleTextEvent.start;
            int n3 = accessibleTextEvent.end;
            if (n2 != n3) {
                accessibleTextEvent.type = 5;
                int n4 = 0;
                while (n4 < this.accessibleTextExtendedListeners.size()) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n4);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                    ++n4;
                }
            }
            if ((string = accessibleTextEvent.result) != null) {
                nSString = NSString.stringWith(string);
            }
        } else if (this.accessibleTextListeners.size() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n;
            accessibleTextEvent.offset = -1;
            accessibleTextEvent.length = -1;
            int n5 = 0;
            while (n5 < this.accessibleTextListeners.size()) {
                AccessibleTextListener accessibleTextListener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(n5);
                accessibleTextListener.getSelectionRange(accessibleTextEvent);
                ++n5;
            }
            n5 = accessibleTextEvent.offset;
            int n6 = accessibleTextEvent.length;
            if (n5 != -1 && n6 != -1 && n6 != 0) {
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
                accessibleControlEvent.childID = accessibleTextEvent.childID;
                accessibleControlEvent.result = null;
                int n7 = 0;
                while (n7 < this.accessibleControlListeners.size()) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n7);
                    accessibleControlListener.getValue(accessibleControlEvent);
                    ++n7;
                }
                String string = accessibleControlEvent.result;
                if (string != null) {
                    nSString = NSString.stringWith(string.substring(n5, n5 + n6));
                }
            }
        }
        return nSString;
    }

    id getSelectedTextRangeAttribute(int n) {
        NSValue nSValue = null;
        if (this.accessibleTextExtendedListeners.size() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n;
            accessibleTextEvent.index = 0;
            int n2 = 0;
            while (n2 < this.accessibleTextExtendedListeners.size()) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n2);
                accessibleTextExtendedListener.getSelection(accessibleTextEvent);
                ++n2;
            }
            NSRange nSRange = new NSRange();
            nSRange.location = accessibleTextEvent.start;
            nSRange.length = accessibleTextEvent.end - accessibleTextEvent.start;
            nSValue = NSValue.valueWithRange(nSRange);
        } else if (this.accessibleTextExtendedListeners.size() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n;
            accessibleTextEvent.offset = -1;
            accessibleTextEvent.length = 0;
            int n3 = 0;
            while (n3 < this.accessibleTextListeners.size()) {
                AccessibleTextListener accessibleTextListener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(n3);
                accessibleTextListener.getSelectionRange(accessibleTextEvent);
                ++n3;
            }
            if (accessibleTextEvent.offset != -1) {
                NSRange nSRange = new NSRange();
                nSRange.location = accessibleTextEvent.offset;
                nSRange.length = accessibleTextEvent.length;
                nSValue = NSValue.valueWithRange(nSRange);
            }
        }
        return nSValue;
    }

    id getServesAsTitleForUIElementsAttribute(int n) {
        id id2 = null;
        Relation relation = this.relations[8];
        if (relation != null) {
            id2 = relation.getServesAsTitleForUIElements();
        }
        return id2;
    }

    id getStringForRangeParameterizedAttribute(id id2, int n) {
        NSString nSString = null;
        NSValue nSValue = new NSValue(id2.id);
        NSRange nSRange = nSValue.rangeValue();
        if (this.accessibleTextExtendedListeners.size() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n;
            accessibleTextEvent.start = nSRange.location;
            accessibleTextEvent.end = nSRange.location + nSRange.length;
            accessibleTextEvent.type = 5;
            int n2 = 0;
            while (n2 < this.accessibleTextExtendedListeners.size()) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n2);
                accessibleTextExtendedListener.getText(accessibleTextEvent);
                ++n2;
            }
            if (accessibleTextEvent.result != null) {
                nSString = NSString.stringWith(accessibleTextEvent.result);
            }
        } else if (this.accessibleControlListeners.size() > 0) {
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n;
            accessibleControlEvent.result = null;
            int n3 = 0;
            while (n3 < this.accessibleControlListeners.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n3);
                accessibleControlListener.getValue(accessibleControlEvent);
                ++n3;
            }
            String string = accessibleControlEvent.result;
            if (string != null) {
                nSString = NSString.stringWith(string.substring(nSRange.location, nSRange.location + nSRange.length));
            }
        }
        return nSString;
    }

    id getSelectedTextRangesAttribute(int n) {
        NSMutableArray nSMutableArray = null;
        if (this.accessibleTextExtendedListeners.size() > 0) {
            Object object;
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n;
            int n2 = 0;
            while (n2 < this.accessibleTextExtendedListeners.size()) {
                object = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n2);
                object.getSelectionCount(accessibleTextEvent);
                ++n2;
            }
            if (accessibleTextEvent.count > 0) {
                nSMutableArray = NSMutableArray.arrayWithCapacity(accessibleTextEvent.count);
                n2 = 0;
                while (n2 < accessibleTextEvent.count) {
                    accessibleTextEvent.index = n2;
                    int n3 = 0;
                    while (n3 < this.accessibleTextExtendedListeners.size()) {
                        AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n3);
                        accessibleTextExtendedListener.getSelection(accessibleTextEvent);
                        ++n3;
                    }
                    object = new NSRange();
                    ((NSRange)object).location = accessibleTextEvent.start;
                    ((NSRange)object).length = accessibleTextEvent.end - accessibleTextEvent.start;
                    nSMutableArray.addObject(NSValue.valueWithRange((NSRange)object));
                    ++n2;
                }
            }
        } else if (this.accessibleTextListeners.size() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n;
            accessibleTextEvent.offset = -1;
            accessibleTextEvent.length = 0;
            int n4 = 0;
            while (n4 < this.accessibleTextListeners.size()) {
                AccessibleTextListener accessibleTextListener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(n4);
                accessibleTextListener.getSelectionRange(accessibleTextEvent);
                ++n4;
            }
            if (accessibleTextEvent.offset != -1) {
                nSMutableArray = NSMutableArray.arrayWithCapacity(1);
                NSRange nSRange = new NSRange();
                nSRange.location = accessibleTextEvent.offset;
                nSRange.length = accessibleTextEvent.length;
                nSMutableArray.addObject(NSValue.valueWithRange(nSRange));
            }
        }
        return nSMutableArray;
    }

    id getStyleRangeForIndexAttribute(id id2, int n) {
        if (this.accessibleAttributeListeners.size() == 0) {
            return null;
        }
        NSNumber nSNumber = new NSNumber(id2.id);
        int n2 = nSNumber.intValue();
        AccessibleTextAttributeEvent accessibleTextAttributeEvent = new AccessibleTextAttributeEvent(this);
        accessibleTextAttributeEvent.offset = n2;
        accessibleTextAttributeEvent.end = -1;
        accessibleTextAttributeEvent.start = -1;
        int n3 = 0;
        while (n3 < this.accessibleAttributeListeners.size()) {
            AccessibleAttributeListener accessibleAttributeListener = (AccessibleAttributeListener)this.accessibleAttributeListeners.elementAt(n3);
            accessibleAttributeListener.getTextAttributes(accessibleTextAttributeEvent);
            ++n3;
        }
        NSRange nSRange = new NSRange();
        if (accessibleTextAttributeEvent.start == -1 && accessibleTextAttributeEvent.end == -1) {
            nSRange.location = n2;
            nSRange.length = 0;
        } else {
            nSRange.location = accessibleTextAttributeEvent.start;
            nSRange.length = accessibleTextAttributeEvent.end - accessibleTextAttributeEvent.start;
        }
        return NSValue.valueWithRange(nSRange);
    }

    id getVisibleCharacterRangeAttribute(int n) {
        NSRange nSRange = null;
        if (this.accessibleTextExtendedListeners.size() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n;
            int n2 = 0;
            while (n2 < this.accessibleTextExtendedListeners.size()) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n2);
                accessibleTextExtendedListener.getVisibleRanges(accessibleTextEvent);
                ++n2;
            }
            nSRange = new NSRange();
            nSRange.location = accessibleTextEvent.start;
            nSRange.length = accessibleTextEvent.end - accessibleTextEvent.start;
        } else if (this.accessibleControlListeners.size() > 0) {
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n;
            accessibleControlEvent.result = null;
            int n3 = 0;
            while (n3 < this.accessibleControlListeners.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n3);
                accessibleControlListener.getValue(accessibleControlEvent);
                ++n3;
            }
            if (accessibleControlEvent.result != null) {
                nSRange = new NSRange();
                nSRange.location = 0;
                nSRange.length = accessibleControlEvent.result.length();
            }
        }
        return nSRange != null ? NSValue.valueWithRange(nSRange) : null;
    }

    int lineNumberForOffset(String string, int n) {
        int n2 = 1;
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n) {
            switch (string.charAt(n4)) {
                case '\r': {
                    if (n4 + 1 < n3 && string.charAt(n4 + 1) == '\n') {
                        ++n4;
                    }
                }
                case '\n': {
                    ++n2;
                }
            }
            ++n4;
        }
        return n2;
    }

    NSRange rangeForLineNumber(int n, String string) {
        NSRange nSRange = new NSRange();
        nSRange.location = -1;
        int n2 = 1;
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        while (n5 < n4) {
            if (n2 == n) {
                if (n3 == 0) {
                    nSRange.location = n5;
                }
                ++n3;
            }
            if (n2 > n) break;
            switch (string.charAt(n5)) {
                case '\r': {
                    if (n5 + 1 < n4 && string.charAt(n5 + 1) == '\n') {
                        ++n5;
                    }
                }
                case '\n': {
                    ++n2;
                }
            }
            ++n5;
        }
        nSRange.length = n3;
        return nSRange;
    }

    public void removeAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.removeElement(accessibleListener);
    }

    public void removeAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.removeElement(accessibleControlListener);
    }

    public void removeAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        if (accessibleTextListener instanceof AccessibleTextExtendedListener) {
            this.accessibleTextExtendedListeners.removeElement(accessibleTextListener);
        } else {
            this.accessibleTextListeners.removeElement(accessibleTextListener);
        }
    }

    public void removeAccessibleActionListener(AccessibleActionListener accessibleActionListener) {
        this.checkWidget();
        if (accessibleActionListener == null) {
            SWT.error(4);
        }
        this.accessibleActionListeners.removeElement(accessibleActionListener);
    }

    public void removeAccessibleHyperlinkListener(AccessibleHyperlinkListener accessibleHyperlinkListener) {
        this.checkWidget();
        if (accessibleHyperlinkListener == null) {
            SWT.error(4);
        }
        this.accessibleHyperlinkListeners.removeElement(accessibleHyperlinkListener);
    }

    public void removeAccessibleTableListener(AccessibleTableListener accessibleTableListener) {
        this.checkWidget();
        if (accessibleTableListener == null) {
            SWT.error(4);
        }
        this.accessibleTableListeners.removeElement(accessibleTableListener);
    }

    public void removeAccessibleTableCellListener(AccessibleTableCellListener accessibleTableCellListener) {
        this.checkWidget();
        if (accessibleTableCellListener == null) {
            SWT.error(4);
        }
        this.accessibleTableCellListeners.removeElement(accessibleTableCellListener);
    }

    public void removeAccessibleValueListener(AccessibleValueListener accessibleValueListener) {
        this.checkWidget();
        if (accessibleValueListener == null) {
            SWT.error(4);
        }
        this.accessibleValueListeners.removeElement(accessibleValueListener);
    }

    public void removeAccessibleAttributeListener(AccessibleAttributeListener accessibleAttributeListener) {
        this.checkWidget();
        if (accessibleAttributeListener == null) {
            SWT.error(4);
        }
        this.accessibleAttributeListeners.removeElement(accessibleAttributeListener);
    }

    public void removeRelation(int n, Accessible accessible) {
        this.checkWidget();
        if (this.relations[n] != null) {
            this.relations[n].removeTarget(accessible);
        }
    }

    void release(boolean bl) {
        if (this.actionNames != null) {
            this.actionNames.release();
        }
        this.actionNames = null;
        if (this.attributeNames != null) {
            this.attributeNames.release();
        }
        this.attributeNames = null;
        if (this.parameterizedAttributeNames != null) {
            this.parameterizedAttributeNames.release();
        }
        this.parameterizedAttributeNames = null;
        if (this.delegate != null) {
            this.delegate.internal_dispose_SWTAccessibleDelegate();
            this.delegate.release();
        }
        this.delegate = null;
        this.relations = null;
        if (this.childToIdMap != null) {
            Collection collection = this.childToIdMap.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SWTAccessibleDelegate sWTAccessibleDelegate = (SWTAccessibleDelegate)iterator.next();
                sWTAccessibleDelegate.internal_dispose_SWTAccessibleDelegate();
                sWTAccessibleDelegate.release();
            }
            this.childToIdMap.clear();
            this.childToIdMap = null;
        }
        if (this.tableDelegate != null) {
            this.tableDelegate.release();
        }
    }

    static NSArray retainedAutoreleased(NSArray nSArray) {
        id id2 = nSArray.retain();
        NSObject nSObject = new NSObject(id2.id).autorelease();
        return new NSArray(nSObject.id);
    }

    public void sendEvent(int n, Object object) {
        this.checkWidget();
        id id2 = this.accessibleHandle(this);
        switch (n) {
            case 256: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 269: 
            case 271: 
            case 273: 
            case 274: 
            case 285: 
            case 512: 
            case 515: 
            case 516: 
            case 517: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 524: 
            case 32778: 
            case 32782: {
                OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilityValueChangedNotification.id);
                break;
            }
            case 32777: {
                OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilitySelectedChildrenChangedNotification.id);
                break;
            }
            case 32788: {
                OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilitySelectedTextChangedNotification.id);
                break;
            }
            case 32779: {
                OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilityMovedNotification.id);
                break;
            }
            case 32780: 
            case 32781: {
                OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilityTitleChangedNotification.id);
                break;
            }
            case 283: {
                OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilitySelectedTextChangedNotification.id);
                break;
            }
            case 518: {
                if (this.tableDelegate != null) {
                    this.tableDelegate.reset();
                    this.getRowsAttribute(-1);
                    this.getColumnsAttribute(-1);
                }
                OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilityRowCountChangedNotification.id);
                break;
            }
        }
    }

    public void selectionChanged() {
        this.checkWidget();
        if (this.currentRole == 24) {
            OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilitySelectedRowsChangedNotification.id);
        } else {
            OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilitySelectedChildrenChangedNotification.id);
        }
    }

    public void setFocus(int n) {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilityFocusedUIElementChangedNotification.id);
    }

    void setSelectedTextRangeAttribute(id id2, int n) {
        NSRange nSRange = new NSValue(id2.id).rangeValue();
        if (this.accessibleTextExtendedListeners.size() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.index = 0;
            accessibleTextEvent.start = nSRange.location;
            accessibleTextEvent.end = nSRange.location + nSRange.length;
            int n2 = 0;
            while (n2 < this.accessibleTextExtendedListeners.size()) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n2);
                accessibleTextExtendedListener.removeSelection(accessibleTextEvent);
                accessibleTextExtendedListener.addSelection(accessibleTextEvent);
                ++n2;
            }
        }
    }

    void setVisibleCharacterRangeAttribute(id id2, int n) {
        NSRange nSRange = new NSValue(id2.id).rangeValue();
        if (this.accessibleTextExtendedListeners.size() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.type = 0;
            accessibleTextEvent.start = nSRange.location;
            accessibleTextEvent.end = nSRange.location + nSRange.length;
            int n2 = 0;
            while (n2 < this.accessibleTextExtendedListeners.size()) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n2);
                accessibleTextExtendedListener.scrollText(accessibleTextEvent);
                ++n2;
            }
        }
    }

    public void textCaretMoved(int n) {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilitySelectedTextChangedNotification.id);
    }

    public void textChanged(int n, int n2, int n3) {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilityValueChangedNotification.id);
    }

    public void textSelectionChanged() {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilitySelectedTextChangedNotification.id);
    }

    id childIDToOs(int n) {
        if (n == -1) {
            return this.control.view;
        }
        SWTAccessibleDelegate sWTAccessibleDelegate = (SWTAccessibleDelegate)this.childToIdMap.get(new Integer(n));
        if (sWTAccessibleDelegate == null) {
            sWTAccessibleDelegate = new SWTAccessibleDelegate(this, n);
            this.childToIdMap.put(new Integer(n), sWTAccessibleDelegate);
        }
        return sWTAccessibleDelegate;
    }

    NSString concatStringsAsRole(NSString nSString, NSString nSString2) {
        NSString nSString3 = nSString;
        nSString3 = nSString3.stringByAppendingString(NSString.stringWith(":"));
        nSString3 = nSString3.stringByAppendingString(nSString2);
        return nSString3;
    }

    String roleToOs(int n) {
        NSString nSString = null;
        switch (n) {
            case 10: {
                nSString = OS.NSAccessibilityGroupRole;
                break;
            }
            case 9: {
                nSString = OS.NSAccessibilityWindowRole;
                break;
            }
            case 2: {
                nSString = OS.NSAccessibilityMenuBarRole;
                break;
            }
            case 11: {
                nSString = OS.NSAccessibilityMenuRole;
                break;
            }
            case 12: {
                nSString = OS.NSAccessibilityMenuItemRole;
                break;
            }
            case 21: {
                nSString = OS.NSAccessibilitySplitterRole;
                break;
            }
            case 13: {
                nSString = OS.NSAccessibilityHelpTagRole;
                break;
            }
            case 3: {
                nSString = OS.NSAccessibilityScrollBarRole;
                break;
            }
            case 18: {
                nSString = this.concatStringsAsRole(OS.NSAccessibilityWindowRole, OS.NSAccessibilityDialogSubrole);
                break;
            }
            case 41: {
                nSString = OS.NSAccessibilityStaticTextRole;
                break;
            }
            case 43: {
                nSString = OS.NSAccessibilityButtonRole;
                break;
            }
            case 44: {
                nSString = OS.NSAccessibilityCheckBoxRole;
                break;
            }
            case 45: {
                nSString = OS.NSAccessibilityRadioButtonRole;
                break;
            }
            case 62: {
                nSString = OS.NSAccessibilityMenuButtonRole;
                break;
            }
            case 46: {
                nSString = OS.NSAccessibilityComboBoxRole;
                break;
            }
            case 42: {
                int n2 = this.control.getStyle();
                if ((n2 & 2) != 0) {
                    nSString = OS.NSAccessibilityTextAreaRole;
                    break;
                }
                nSString = OS.NSAccessibilityTextFieldRole;
                break;
            }
            case 22: {
                nSString = OS.NSAccessibilityToolbarRole;
                break;
            }
            case 33: {
                nSString = OS.NSAccessibilityOutlineRole;
                break;
            }
            case 34: {
                nSString = OS.NSAccessibilityStaticTextRole;
                break;
            }
            case 27: {
                nSString = OS.NSAccessibilityColumnRole;
                break;
            }
            case 28: {
                nSString = this.concatStringsAsRole(OS.NSAccessibilityRowRole, OS.NSAccessibilityTableRowSubrole);
                break;
            }
            case 24: {
                nSString = OS.NSAccessibilityTableRole;
                break;
            }
            case 29: {
                nSString = OS.NSAccessibilityStaticTextRole;
                break;
            }
            case 25: {
                nSString = OS.NSAccessibilityGroupRole;
                break;
            }
            case 26: {
                nSString = OS.NSAccessibilityGroupRole;
                break;
            }
            case 35: {
                nSString = OS.NSAccessibilityOutlineRole;
                break;
            }
            case 36: {
                nSString = this.concatStringsAsRole(OS.NSAccessibilityOutlineRole, OS.NSAccessibilityOutlineRowSubrole);
                break;
            }
            case 60: {
                nSString = OS.NSAccessibilityTabGroupRole;
                break;
            }
            case 37: {
                nSString = OS.NSAccessibilityRadioButtonRole;
                break;
            }
            case 48: {
                nSString = OS.NSAccessibilityProgressIndicatorRole;
                break;
            }
            case 51: {
                nSString = OS.NSAccessibilitySliderRole;
                break;
            }
            case 30: {
                nSString = OS.NSAccessibilityLinkRole;
                break;
            }
            case 1025: {
                nSString = OS.NSAccessibilityGroupRole;
                break;
            }
            case 40: {
                nSString = OS.NSAccessibilityImageRole;
                break;
            }
            case 20: {
                nSString = OS.NSAccessibilityGroupRole;
                break;
            }
            case 1027: {
                nSString = OS.NSAccessibilityMenuButtonRole;
                break;
            }
            case 1073: {
                nSString = OS.NSAccessibilityMenuButtonRole;
                break;
            }
            case 1038: 
            case 1040: 
            case 1043: 
            case 1053: 
            case 1060: {
                nSString = OS.NSAccessibilityGroupRole;
                break;
            }
            case 1044: 
            case 1054: {
                nSString = OS.NSAccessibilityTextAreaRole;
                break;
            }
            case 8: 
            case 15: 
            case 23: 
            case 47: 
            case 52: 
            case 54: 
            case 61: 
            case 1029: {
                nSString = OS.NSAccessibilityUnknownRole;
            }
        }
        return nSString.getString();
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }

    public int internal_addRelationAttributes(int n) {
        NSArray nSArray = new NSArray(n);
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(nSArray.count());
        nSMutableArray.addObjectsFromArray(nSArray);
        if (this.relations[8] != null) {
            if (!nSMutableArray.containsObject(OS.NSAccessibilityServesAsTitleForUIElementsAttribute)) {
                nSMutableArray.addObject(OS.NSAccessibilityServesAsTitleForUIElementsAttribute);
            }
            if (!nSMutableArray.containsObject(OS.NSAccessibilityTitleAttribute)) {
                nSMutableArray.addObject(OS.NSAccessibilityTitleAttribute);
            }
        } else {
            nSMutableArray.removeObject(OS.NSAccessibilityServesAsTitleForUIElementsAttribute);
        }
        if (this.relations[9] != null) {
            if (!nSMutableArray.containsObject(OS.NSAccessibilityTitleUIElementAttribute)) {
                nSMutableArray.addObject(OS.NSAccessibilityTitleUIElementAttribute);
            }
        } else {
            nSMutableArray.removeObject(OS.NSAccessibilityTitleUIElementAttribute);
        }
        return nSMutableArray.id;
    }
}

