/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Widget;

public class Caret
extends Widget {
    Canvas parent;
    int x;
    int y;
    int width;
    int height;
    boolean isVisible;
    boolean isShowing;
    int blinkRate;
    Image image;
    Font font;
    static final int DEFAULT_WIDTH = 1;

    public Caret(Canvas canvas, int n) {
        super(canvas, n);
        this.parent = canvas;
        this.createWidget();
    }

    boolean blinkCaret() {
        if (!this.isVisible) {
            return true;
        }
        if (!this.isShowing) {
            return this.showCaret();
        }
        if (this.blinkRate == 0) {
            return true;
        }
        return this.hideCaret();
    }

    void createWidget() {
        super.createWidget();
        this.blinkRate = this.display.getCaretBlinkTime();
        this.isVisible = true;
        if (this.parent.getCaret() == null) {
            this.parent.setCaret(this);
        }
    }

    boolean drawCaret() {
        Object object;
        if (this.parent == null) {
            return false;
        }
        if (this.parent.isDisposed()) {
            return false;
        }
        int n = this.width;
        int n2 = this.height;
        if (n <= 0) {
            n = 1;
        }
        if (this.image != null) {
            object = this.image.handle.size();
            n = (int)((NSSize)object).width;
            n2 = (int)((NSSize)object).height;
        }
        object = new NSRect();
        ((NSRect)object).x = this.x;
        ((NSRect)object).y = this.y;
        ((NSRect)object).width = n;
        ((NSRect)object).height = n2;
        this.parent.view.setNeedsDisplayInRect((NSRect)object);
        return true;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rectangle = this.image.getBounds();
            return new Rectangle(this.x, this.y, rectangle.width, rectangle.height);
        }
        if (this.width == 0) {
            return new Rectangle(this.x, this.y, 1, this.height);
        }
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Point getLocation() {
        this.checkWidget();
        return new Point(this.x, this.y);
    }

    public Canvas getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Point getSize() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rectangle = this.image.getBounds();
            return new Point(rectangle.width, rectangle.height);
        }
        if (this.width == 0) {
            return new Point(1, this.height);
        }
        return new Point(this.width, this.height);
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.isVisible;
    }

    boolean hideCaret() {
        if (!this.isShowing) {
            return true;
        }
        this.isShowing = false;
        return this.drawCaret();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.isVisible && this.parent.isVisible() && this.parent.hasFocus();
    }

    boolean isFocusCaret() {
        return this == this.display.currentCaret;
    }

    void killFocus() {
        if (this.display.currentCaret != this) {
            return;
        }
        this.display.setCurrentCaret(null);
        if (this.isVisible) {
            this.hideCaret();
        }
    }

    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getCaret()) {
            this.parent.setCaret(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.display.currentCaret == this) {
            this.hideCaret();
            this.display.setCurrentCaret(null);
        }
        this.parent = null;
        this.image = null;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.checkWidget();
        if (this.x == n && this.y == n2 && this.width == n3 && this.height == n4) {
            return;
        }
        boolean bl = this.isFocusCaret();
        if (bl && this.isVisible) {
            this.hideCaret();
        }
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        if (bl && this.isVisible) {
            this.showCaret();
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            this.error(4);
        }
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void setFocus() {
        if (this.display.currentCaret == this) {
            return;
        }
        this.display.setCurrentCaret(this);
        if (this.isVisible) {
            this.showCaret();
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
    }

    public void setImage(Image image) {
        boolean bl;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((bl = this.isFocusCaret()) && this.isVisible) {
            this.hideCaret();
        }
        this.image = image;
        if (bl && this.isVisible) {
            this.showCaret();
        }
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.setBounds(n, n2, this.width, this.height);
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setSize(int n, int n2) {
        this.checkWidget();
        this.setBounds(this.x, this.y, n, n2);
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSize(point.x, point.y);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (bl == this.isVisible) {
            return;
        }
        this.isVisible = bl;
        if (!this.isFocusCaret()) {
            return;
        }
        if (this.isVisible) {
            this.showCaret();
        } else {
            this.hideCaret();
        }
    }

    boolean showCaret() {
        if (this.isShowing) {
            return true;
        }
        this.isShowing = true;
        return this.drawCaret();
    }
}

