/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSColorPanel;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPanelDelegate;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;
    boolean selected;

    public ColorDialog(Shell shell) {
        this(shell, 65536);
    }

    public ColorDialog(Shell shell, int n) {
        super(shell, ColorDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    void changeColor(int n, int n2, int n3) {
        this.selected = true;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB open() {
        NSColor nSColor;
        NSObject nSObject;
        NSColorPanel nSColorPanel = NSColorPanel.sharedColorPanel();
        if (this.rgb != null) {
            nSObject = NSColor.colorWithDeviceRed((float)this.rgb.red / 255.0f, (float)this.rgb.green / 255.0f, (float)this.rgb.blue / 255.0f, 1.0f);
            nSColorPanel.setColor((NSColor)nSObject);
        }
        nSObject = (SWTPanelDelegate)new SWTPanelDelegate().alloc().init();
        int n = OS.NewGlobalRef(this);
        if (n == 0) {
            SWT.error(2);
        }
        OS.object_setInstanceVariable(((SWTPanelDelegate)nSObject).id, Display.SWT_OBJECT, n);
        nSColorPanel.setDelegate(nSObject);
        this.rgb = null;
        this.selected = false;
        nSColorPanel.orderFront(null);
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.setModalDialog(this);
        NSApplication.sharedApplication().runModalForWindow(nSColorPanel);
        display.setModalDialog(null);
        nSColorPanel.setDelegate(null);
        nSObject.release();
        OS.DeleteGlobalRef(n);
        if (this.selected && (nSColor = nSColorPanel.color()) != null) {
            nSColor = nSColor.colorUsingColorSpaceName(OS.NSCalibratedRGBColorSpace);
            this.rgb = new RGB((int)(nSColor.redComponent() * 255.0f), (int)(nSColor.greenComponent() * 255.0f), (int)(nSColor.blueComponent() * 255.0f));
        }
        return this.rgb;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }

    void windowWillClose(int n, int n2, int n3) {
        NSApplication.sharedApplication().stop(null);
    }
}

