/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSComboBox;
import org.eclipse.swt.internal.cocoa.NSComboBoxCell;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableString;
import org.eclipse.swt.internal.cocoa.NSNotification;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSPopUpButton;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSText;
import org.eclipse.swt.internal.cocoa.NSTextField;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSTextView;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTComboBox;
import org.eclipse.swt.internal.cocoa.SWTPopUpButton;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    String text;
    int textLimit = LIMIT;
    boolean receivingFocus;
    boolean ignoreSetObject;
    boolean ignoreSelection;
    NSRange selectionRange;
    boolean listVisible;
    static final int VISIBLE_COUNT = 5;
    public static final int LIMIT = Integer.MAX_VALUE;

    public Combo(Composite composite, int n) {
        super(composite, Combo.checkStyle(n));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        NSAttributedString nSAttributedString = this.createString(string);
        if ((this.style & 8) != 0) {
            NSPopUpButton nSPopUpButton = (NSPopUpButton)this.view;
            int n = nSPopUpButton.indexOfSelectedItem();
            NSMenu nSMenu = nSPopUpButton.menu();
            NSMenuItem nSMenuItem = (NSMenuItem)new NSMenuItem().alloc();
            NSString nSString = NSString.string();
            nSMenuItem.initWithTitle(nSString, 0, nSString);
            nSMenuItem.setAttributedTitle(nSAttributedString);
            nSMenu.addItem(nSMenuItem);
            nSMenuItem.release();
            if (n == -1) {
                nSPopUpButton.selectItemAtIndex(-1);
            }
        } else {
            ((NSComboBox)this.view).addItemWithObjectValue(nSAttributedString);
        }
    }

    public void add(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = this.getItemCount();
        if (n < 0 || n > n2) {
            this.error(6);
        }
        NSAttributedString nSAttributedString = this.createString(string);
        if ((this.style & 8) != 0) {
            NSPopUpButton nSPopUpButton = (NSPopUpButton)this.view;
            int n3 = nSPopUpButton.indexOfSelectedItem();
            NSMenu nSMenu = nSPopUpButton.menu();
            NSMenuItem nSMenuItem = (NSMenuItem)new NSMenuItem().alloc();
            NSString nSString = NSString.string();
            nSMenuItem.initWithTitle(nSString, 0, nSString);
            nSMenuItem.setAttributedTitle(nSAttributedString);
            nSMenu.insertItem(nSMenuItem, n);
            nSMenuItem.release();
            if (n3 == -1) {
                nSPopUpButton.selectItemAtIndex(-1);
            }
        } else {
            ((NSComboBox)this.view).insertItemWithObjectValue(nSAttributedString, n);
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    boolean becomeFirstResponder(int n, int n2) {
        this.receivingFocus = true;
        boolean bl = super.becomeFirstResponder(n, n2);
        this.receivingFocus = false;
        return bl;
    }

    static int checkStyle(int n) {
        n &= 0xFFFFF7FF;
        n &= 0xFFFFFCFF;
        if (((n = Combo.checkBits(n, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return n & 0xFFFFFFF7;
        }
        return n;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            Point point = this.getSelection();
            point.y = point.x;
            this.setSelection(point);
        }
    }

    void setObjectValue(int n, int n2, int n3) {
        super.setObjectValue(n, n2, this.ignoreSetObject ? n3 : this.createString((String)this.text).id);
    }

    void comboBoxSelectionDidChange(int n, int n2, int n3) {
        NSComboBox nSComboBox = (NSComboBox)this.view;
        int n4 = nSComboBox.indexOfSelectedItem();
        nSComboBox.selectItemAtIndex(n4);
        NSAttributedString nSAttributedString = new NSAttributedString(nSComboBox.itemObjectValueAtIndex(n4));
        NSString nSString = nSAttributedString.string();
        if (nSString != null) {
            this.setText(nSString.getString(), true);
        }
        if (!this.ignoreSelection) {
            this.sendSelectionEvent(13, null, this.display.trackingControl != this);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        NSControl nSControl = (NSControl)this.view;
        NSCell nSCell = nSControl.cell();
        NSSize nSSize = nSCell.cellSize();
        n3 = (int)Math.ceil(nSSize.width);
        n4 = (int)Math.ceil(nSSize.height);
        if ((this.style & 8) == 0) {
            this.ignoreSetObject = true;
            NSComboBoxCell nSComboBoxCell = new NSComboBoxCell(nSCell.id);
            NSArray nSArray = nSComboBoxCell.objectValues();
            int n5 = nSArray.count();
            if (n5 > 0) {
                nSComboBoxCell = new NSComboBoxCell(nSComboBoxCell.copy());
                int n6 = 0;
                while (n6 < n5) {
                    NSAttributedString nSAttributedString = new NSAttributedString(nSArray.objectAtIndex(n6));
                    nSComboBoxCell.setAttributedStringValue(nSAttributedString);
                    nSSize = nSComboBoxCell.cellSize();
                    n3 = Math.max(n3, (int)Math.ceil(nSSize.width));
                    ++n6;
                }
                nSComboBoxCell.release();
            }
            this.ignoreSetObject = false;
        }
        if (n2 != -1 && ((this.style & 8) != 0 || n2 < n4)) {
            n4 = n2;
        }
        if (n != -1) {
            n3 = n;
        }
        return new Point(n3, n4);
    }

    public void copy() {
        this.checkWidget();
        Point point = this.getSelection();
        if (point.x == point.y) {
            return;
        }
        this.copyToClipboard(this.getText(point.x, point.y));
    }

    void createHandle() {
        if ((this.style & 8) != 0) {
            NSPopUpButton nSPopUpButton = (NSPopUpButton)new SWTPopUpButton().alloc();
            nSPopUpButton.initWithFrame(new NSRect(), false);
            nSPopUpButton.menu().setAutoenablesItems(false);
            nSPopUpButton.setTarget(nSPopUpButton);
            nSPopUpButton.setAction(OS.sel_sendSelection);
            nSPopUpButton.menu().setDelegate(nSPopUpButton);
            this.view = nSPopUpButton;
        } else {
            NSComboBox nSComboBox = (NSComboBox)new SWTComboBox().alloc();
            nSComboBox.init();
            nSComboBox.setDelegate(nSComboBox);
            this.view = nSComboBox;
        }
    }

    NSAttributedString createString(String string) {
        NSAttributedString nSAttributedString = this.createString(string, null, this.foreground, 16384, false, true, false);
        nSAttributedString.autorelease();
        return nSAttributedString;
    }

    void createWidget() {
        this.text = "";
        super.createWidget();
        if ((this.style & 8) == 0) {
            NSComboBox nSComboBox = (NSComboBox)this.view;
            NSScreen nSScreen = nSComboBox.window().screen();
            NSRect nSRect = nSScreen != null ? nSScreen.frame() : NSScreen.mainScreen().frame();
            int n = Math.max(5, (int)(nSRect.height / 3.0f / nSComboBox.itemHeight()));
            nSComboBox.setNumberOfVisibleItems(n);
        }
    }

    void comboBoxWillDismiss(int n, int n2, int n3) {
        this.listVisible = false;
    }

    void comboBoxWillPopUp(int n, int n2, int n3) {
        this.listVisible = true;
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        Point point = this.getSelection();
        if (point.x == point.y) {
            return;
        }
        int n = point.x;
        int n2 = point.y;
        String string = this.getText();
        String string2 = string.substring(0, n);
        String string3 = string.substring(n2, string.length());
        String string4 = string.substring(n, n2);
        String string5 = "";
        if ((this.hooks(25) || this.filters(25)) && (string5 = this.verifyText(string5, n, n2, null)) == null) {
            return;
        }
        char[] cArray = new char[string4.length()];
        string4.getChars(0, cArray.length, cArray, 0);
        this.copyToClipboard(cArray);
        this.setText(String.valueOf(string2) + string5 + string3, false);
        this.setSelection(new Point(n += string5.length(), n));
        this.sendEvent(24);
    }

    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    NSFont defaultNSFont() {
        if ((this.style & 8) != 0) {
            return this.display.popUpButtonFont;
        }
        return this.display.comboBoxFont;
    }

    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(((NSControl)this.view).cell());
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n == -1) {
            return;
        }
        if (n == this.getSelectionIndex()) {
            if ((this.style & 8) != 0) {
                ((NSPopUpButton)this.view).selectItem(null);
                this.sendEvent(24);
            } else {
                ((NSComboBox)this.view).deselectItemAtIndex(n);
            }
        }
    }

    public void deselectAll() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).selectItem(null);
            this.sendEvent(24);
        } else {
            NSComboBox nSComboBox = (NSComboBox)this.view;
            int n = nSComboBox.indexOfSelectedItem();
            if (n != -1) {
                nSComboBox.deselectItemAtIndex(n);
            }
        }
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        if ((this.style & 8) == 0) {
            NSText nSText = ((NSControl)this.view).currentEditor();
            if (nSText != null) {
                NSRange nSRange = nSText.selectedRange();
                if (nSRange.length > 0) {
                    NSTextView nSTextView = new NSTextView(nSText);
                    NSPoint nSPoint = new NSPoint();
                    nSPoint.x = n;
                    nSPoint.y = n2;
                    int n3 = nSTextView.characterIndexForInsertionAtPoint(nSPoint);
                    if (n3 != Integer.MAX_VALUE && n3 >= nSRange.location && n3 < nSRange.location + nSRange.length && super.dragDetect(n, n2, bl, blArray)) {
                        if (blArray != null) {
                            blArray[0] = true;
                        }
                        return true;
                    }
                }
            }
            return false;
        }
        return super.dragDetect(n, n2, bl, blArray);
    }

    int getCharCount() {
        NSString nSString = (this.style & 8) != 0 ? ((NSPopUpButton)this.view).titleOfSelectedItem() : new NSCell(((NSComboBox)this.view).cell()).title();
        if (nSString == null) {
            return 0;
        }
        return nSString.length();
    }

    public String getItem(int n) {
        this.checkWidget();
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        NSString nSString = null;
        if ((this.style & 8) != 0) {
            nSString = ((NSPopUpButton)this.view).itemTitleAtIndex(n);
        } else {
            NSAttributedString nSAttributedString = new NSAttributedString(((NSComboBox)this.view).itemObjectValueAtIndex(n));
            nSString = nSAttributedString.string();
        }
        if (nSString == null) {
            this.error(8);
        }
        return nSString.getString();
    }

    public int getItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return ((NSPopUpButton)this.view).numberOfItems();
        }
        return ((NSComboBox)this.view).numberOfItems();
    }

    public int getItemHeight() {
        this.checkWidget();
        return 26;
    }

    public String[] getItems() {
        this.checkWidget();
        int n = this.getItemCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getItem(n2);
            ++n2;
        }
        return stringArray;
    }

    public boolean getListVisible() {
        this.checkWidget();
        return this.listVisible;
    }

    String getNameText() {
        return this.getText();
    }

    int getMininumHeight() {
        return this.getTextHeight();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return new Point(0, this.getCharCount());
        }
        if (this.selectionRange == null) {
            NSString nSString = new NSTextFieldCell(((NSTextField)this.view).cell()).title();
            return new Point(nSString.length(), nSString.length());
        }
        return new Point(this.selectionRange.location, this.selectionRange.location + this.selectionRange.length);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return ((NSPopUpButton)this.view).indexOfSelectedItem();
        }
        return ((NSComboBox)this.view).indexOfSelectedItem();
    }

    public String getText() {
        this.checkWidget();
        return new String(this.getText(0, -1));
    }

    char[] getText(int n, int n2) {
        NSString nSString = (this.style & 8) != 0 ? ((NSPopUpButton)this.view).titleOfSelectedItem() : new NSCell(((NSComboBox)this.view).cell()).title();
        if (nSString == null) {
            return new char[0];
        }
        NSRange nSRange = new NSRange();
        nSRange.location = n;
        if (n2 == -1) {
            int n3 = nSString.length();
            nSRange.length = n3 - n;
        } else {
            nSRange.length = n2 - n;
        }
        char[] cArray = new char[nSRange.length];
        nSString.getCharacters(cArray, nSRange);
        return cArray;
    }

    public int getTextHeight() {
        this.checkWidget();
        NSCell nSCell = (this.style & 8) != 0 ? ((NSPopUpButton)this.view).cell() : ((NSComboBox)this.view).cell();
        return (int)nSCell.cellSize().height;
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return this.getItemCount();
        }
        return ((NSComboBox)this.view).numberOfVisibleItems();
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            return -1;
        }
        int n3 = n;
        while (n3 < n2) {
            if (string.equals(this.getItem(n3))) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    boolean isEventView(int n) {
        return true;
    }

    void menuWillOpen(int n, int n2, int n3) {
        this.listVisible = true;
    }

    void menuDidClose(int n, int n2, int n3) {
        this.listVisible = false;
    }

    void mouseDown(int n, int n2, int n3) {
        NSView nSView = this.view;
        nSView.retain();
        super.mouseDown(n, n2, n3);
        nSView.release();
    }

    public void paste() {
        int n;
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        Point point = this.getSelection();
        int n2 = point.x;
        int n3 = point.y;
        String string = this.getText();
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n3, string.length());
        String string4 = this.getClipboardText();
        if (string4 == null) {
            return;
        }
        if ((this.hooks(25) || this.filters(25)) && (string4 = this.verifyText(string4, n2, n3, null)) == null) {
            return;
        }
        if (this.textLimit != LIMIT && (n = string.length()) - (n3 - n2) + string4.length() > this.textLimit) {
            string4 = string4.substring(0, this.textLimit - n + (n3 - n2));
        }
        this.setText(String.valueOf(string2) + string4 + string3, false);
        this.setSelection(new Point(n2 += string4.length(), n2));
        this.sendEvent(24);
    }

    void register() {
        super.register();
        this.display.addWidget(((NSControl)this.view).cell(), this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if ((this.style & 8) == 0) {
            ((NSControl)this.view).abortEditing();
        }
        this.text = null;
        this.selectionRange = null;
    }

    public void remove(int n) {
        this.checkWidget();
        if (n == -1) {
            this.error(6);
        }
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).removeItemAtIndex(n);
        } else {
            ((NSComboBox)this.view).removeItemAtIndex(n);
        }
    }

    public void remove(int n, int n2) {
        int n3;
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n4 = this.getItemCount();
        if (n < 0 || n > n2 || n2 >= n4) {
            this.error(6);
        }
        int n5 = n3 = Math.min(n2, n4 - 1);
        while (n5 >= n) {
            this.remove(n5);
            --n5;
        }
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void removeAll() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).removeAllItems();
        } else {
            this.setText("", true);
            ((NSComboBox)this.view).removeAllItems();
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void select(int n) {
        this.checkWidget();
        int n2 = this.getItemCount();
        this.ignoreSelection = true;
        if (n >= 0 && n < n2) {
            if ((this.style & 8) != 0) {
                ((NSPopUpButton)this.view).selectItemAtIndex(n);
                this.sendEvent(24);
            } else {
                NSComboBox nSComboBox = (NSComboBox)this.view;
                nSComboBox.deselectItemAtIndex(n);
                nSComboBox.selectItemAtIndex(n);
            }
        }
        this.ignoreSelection = false;
    }

    void sendSelection() {
        this.sendEvent(24);
        if (!this.ignoreSelection) {
            this.sendSelectionEvent(13);
        }
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n) {
        boolean bl = super.sendKeyEvent(nSEvent, n);
        if (!bl) {
            return bl;
        }
        int n2 = 0;
        int n3 = nSEvent.modifierFlags();
        if ((n3 & 0x80000) != 0) {
            n2 |= 0x10000;
        }
        if ((n3 & 0x20000) != 0) {
            n2 |= 0x20000;
        }
        if ((n3 & 0x40000) != 0) {
            n2 |= 0x40000;
        }
        if ((n3 & 0x100000) != 0) {
            n2 |= 0x400000;
        }
        if (n != 1) {
            return bl;
        }
        short s = nSEvent.keyCode();
        if (n2 == 0x400000) {
            switch (s) {
                case 7: {
                    this.cut();
                    return false;
                }
                case 8: {
                    this.copy();
                    return false;
                }
                case 9: {
                    this.paste();
                    return false;
                }
                case 0: {
                    if ((this.style & 8) != 0) break;
                    ((NSComboBox)this.view).selectText(null);
                    return false;
                }
            }
        }
        switch (s) {
            case 36: 
            case 76: {
                this.sendSelectionEvent(14);
            }
        }
        return bl;
    }

    void setBackgroundColor(NSColor nSColor) {
        if ((this.style & 8) == 0) {
            ((NSTextField)this.view).setBackgroundColor(nSColor);
        }
    }

    void setBackgroundImage(NSImage nSImage) {
    }

    void setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if ((this.style & 8) == 0) {
            NSControl nSControl = (NSControl)this.view;
            NSSize nSSize = nSControl.cell().cellSize();
            n4 = Math.min(n4, (int)Math.ceil(nSSize.height));
        }
        super.setBounds(n, n2, n3, n4, bl, bl2);
    }

    void setFont(NSFont nSFont) {
        super.setFont(nSFont);
        this.updateItems();
    }

    void setForeground(float[] fArray) {
        super.setForeground(fArray);
        this.updateItems();
        if ((this.style & 8) == 0) {
            NSColor nSColor = fArray == null ? NSColor.textColor() : NSColor.colorWithDeviceRed(fArray[0], fArray[1], fArray[2], 1.0f);
            ((NSTextField)this.view).setTextColor(nSColor);
        }
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        int n3 = this.getSelectionIndex();
        NSAttributedString nSAttributedString = this.createString(string);
        if ((this.style & 8) != 0) {
            NSMenuItem nSMenuItem = ((NSPopUpButton)this.view).itemAtIndex(n);
            nSMenuItem.setAttributedTitle(nSAttributedString);
            if (string.length() == 0) {
                nSMenuItem.setTitle(NSString.string());
            }
        } else {
            NSComboBox nSComboBox = (NSComboBox)this.view;
            nSComboBox.insertItemWithObjectValue(nSAttributedString, n);
            nSComboBox.removeItemAtIndex(n + 1);
        }
        if (n3 != -1) {
            this.select(n3);
        }
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                this.error(5);
            }
            ++n;
        }
        this.removeAll();
        if (stringArray.length == 0) {
            return;
        }
        n = 0;
        while (n < stringArray.length) {
            NSAttributedString nSAttributedString = this.createString(stringArray[n]);
            if ((this.style & 8) != 0) {
                NSMenu nSMenu = ((NSPopUpButton)this.view).menu();
                NSMenuItem nSMenuItem = (NSMenuItem)new NSMenuItem().alloc();
                NSString nSString = NSString.string();
                nSMenuItem.initWithTitle(nSString, 0, nSString);
                nSMenuItem.setAttributedTitle(nSAttributedString);
                nSMenu.addItem(nSMenuItem);
                nSMenuItem.release();
                ((NSPopUpButton)this.view).selectItemAtIndex(-1);
            } else {
                ((NSComboBox)this.view).addItemWithObjectValue(nSAttributedString);
            }
            ++n;
        }
    }

    public void setListVisible(boolean bl) {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).setPullsDown(bl);
        }
    }

    public void setOrientation(int n) {
        this.checkWidget();
    }

    void setOrientation() {
        int n = (this.style & 0x4000000) != 0 ? 1 : 0;
        ((NSControl)this.view).setBaseWritingDirection(n);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if ((this.style & 8) == 0) {
            NSComboBox nSComboBox = (NSComboBox)this.view;
            NSString nSString = new NSCell(nSComboBox.cell()).title();
            int n = nSString.length();
            int n2 = Math.min(Math.max(Math.min(point.x, point.y), 0), n);
            int n3 = Math.min(Math.max(Math.max(point.x, point.y), 0), n);
            this.selectionRange = new NSRange();
            this.selectionRange.location = n2;
            this.selectionRange.length = n3 - n2;
            NSText nSText = nSComboBox.currentEditor();
            if (nSText != null) {
                nSText.setSelectedRange(this.selectionRange);
            }
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.setText(string, true);
    }

    void setText(String string, boolean bl) {
        if (bl && (this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount(), null)) == null) {
            return;
        }
        if ((this.style & 8) != 0) {
            int n = this.indexOf(string);
            if (n != -1 && n != this.getSelectionIndex()) {
                this.select(n);
                if (bl) {
                    this.sendEvent(24);
                }
            }
        } else {
            char[] cArray = new char[Math.min(string.length(), this.textLimit)];
            string.getChars(0, cArray.length, cArray, 0);
            this.text = new String(cArray, 0, cArray.length);
            ((NSComboBox)this.view).cell().setAttributedStringValue(this.createString(this.text));
            if (bl) {
                this.sendEvent(24);
            }
        }
        this.selectionRange = null;
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        this.textLimit = n;
    }

    public void setVisibleItemCount(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if ((this.style & 8) == 0) {
            ((NSComboBox)this.view).setNumberOfVisibleItems(n);
        }
    }

    boolean shouldChangeTextInRange_replacementString(int n, int n2, int n3, int n4) {
        NSObject nSObject;
        Object object;
        NSRange nSRange = new NSRange();
        OS.memmove(nSRange, n3, NSRange.sizeof);
        boolean bl = this.callSuperBoolean(n, n2, nSRange, n4);
        if (this.hooks(25)) {
            String string;
            object = new NSString(n4).getString();
            nSObject = this.display.application.currentEvent();
            int n5 = ((NSEvent)nSObject).type();
            if (n5 != 10 && n5 != 11) {
                nSObject = null;
            }
            if ((string = this.verifyText((String)object, nSRange.location, nSRange.location + nSRange.length, (NSEvent)nSObject)) == null) {
                return false;
            }
            if (!((String)object).equals(string)) {
                int n6;
                int n7 = string.length();
                Point point = this.getSelection();
                if (this.textLimit != LIMIT && (n6 = this.getCharCount()) - (point.y - point.x) + n7 > this.textLimit) {
                    n7 = this.textLimit - n6 + (point.y - point.x);
                }
                char[] cArray = new char[n7];
                string.getChars(0, cArray.length, cArray, 0);
                NSString nSString = NSString.stringWithCharacters(cArray, cArray.length);
                NSText nSText = ((NSTextField)this.view).currentEditor();
                nSText.replaceCharactersInRange(nSText.selectedRange(), nSString);
                this.text = nSText.string().getString();
                this.sendEvent(24);
                bl = false;
            }
        }
        if (bl) {
            object = new char[this.text.length()];
            this.text.getChars(0, ((Object)object).length, (char[])object, 0);
            nSObject = (NSMutableString)NSMutableString.stringWithCharacters((char[])object, ((Object)object).length);
            ((NSMutableString)nSObject).replaceCharactersInRange(nSRange, new NSString(n4));
            this.text = ((NSString)nSObject).getString();
            this.selectionRange = null;
        }
        return bl;
    }

    void textViewDidChangeSelection(int n, int n2, int n3) {
        NSNotification nSNotification = new NSNotification(n3);
        NSText nSText = new NSText(nSNotification.object().id);
        this.selectionRange = nSText.selectedRange();
    }

    void textDidChange(int n, int n2, int n3) {
        super.textDidChange(n, n2, n3);
        this.postEvent(24);
    }

    NSRange textView_willChangeSelectionFromCharacterRange_toCharacterRange(int n, int n2, int n3, int n4, int n5) {
        if (this.receivingFocus && this.selectionRange != null) {
            return this.selectionRange;
        }
        NSRange nSRange = new NSRange();
        OS.memmove(nSRange, n5, NSRange.sizeof);
        return nSRange;
    }

    void updateItems() {
        if ((this.style & 8) != 0) {
            NSPopUpButton nSPopUpButton = (NSPopUpButton)this.view;
            int n = nSPopUpButton.numberOfItems();
            int n2 = 0;
            while (n2 < n) {
                NSMenuItem nSMenuItem = new NSMenuItem(nSPopUpButton.itemAtIndex(n2));
                NSAttributedString nSAttributedString = nSMenuItem.attributedTitle();
                String string = nSAttributedString.string().getString();
                nSMenuItem.setAttributedTitle(this.createString(string));
                ++n2;
            }
        } else {
            NSComboBox nSComboBox = (NSComboBox)this.view;
            int n = nSComboBox.numberOfItems();
            int n3 = 0;
            while (n3 < n) {
                NSAttributedString nSAttributedString = new NSAttributedString(nSComboBox.itemObjectValueAtIndex(n3));
                String string = nSAttributedString.string().getString();
                nSComboBox.insertItemWithObjectValue(this.createString(string), n3);
                nSComboBox.removeItemAtIndex(n3 + 1);
                ++n3;
            }
            nSComboBox.cell().setAttributedStringValue(this.createString(this.text));
        }
    }

    String verifyText(String string, int n, int n2, NSEvent nSEvent) {
        Event event = new Event();
        if (nSEvent != null) {
            this.setKeyState(event, 3, nSEvent);
        }
        event.text = string;
        event.start = n;
        event.end = n2;
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

