/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.COMBOBOXINFO;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MONITORINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    boolean noSelection;
    boolean ignoreDefaultSelection;
    boolean ignoreCharacter;
    boolean ignoreModify;
    boolean ignoreResize;
    boolean lockText;
    int scrollWidth;
    int visibleCount;
    int cbtHook;
    static final int VISIBLE_COUNT = 5;
    public static final int LIMIT = OS.IsWinNT ? Integer.MAX_VALUE : Short.MAX_VALUE;
    static final int CBID_LIST = 1000;
    static final int CBID_EDIT = 1001;
    static int EditProc;
    static int ListProc;
    static final int ComboProc;
    static final TCHAR ComboClass;

    static {
        ComboClass = new TCHAR(0, "COMBOBOX", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, ComboClass, wNDCLASS);
        ComboProc = wNDCLASS.lpfnWndProc;
    }

    public Combo(Composite composite, int n) {
        super(composite, Combo.checkStyle(n));
        this.style |= 0x100;
    }

    public void add(String string) {
        TCHAR tCHAR;
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = OS.SendMessage(this.handle, 323, 0, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -1) {
            this.error(14);
        }
        if (n == -2) {
            this.error(14);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void add(String string, int n) {
        TCHAR tCHAR;
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n3 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n < 0 || n > n3) {
            this.error(6);
        }
        if ((n2 = OS.SendMessage(this.handle, 330, n, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -2 || n2 == -1) {
            this.error(14);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    int callWindowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        if (n == this.handle) {
            switch (n2) {
                case 5: {
                    this.ignoreResize = true;
                    if ((this.style & 8) == 0) {
                        this.lockText = true;
                    }
                    int n5 = OS.CallWindowProc(ComboProc, n, n2, n3, n4);
                    if ((this.style & 8) == 0) {
                        this.lockText = false;
                    }
                    this.ignoreResize = false;
                    return n5;
                }
            }
            return OS.CallWindowProc(ComboProc, n, n2, n3, n4);
        }
        int n6 = OS.GetDlgItem(this.handle, 1001);
        if (n == n6) {
            if (this.lockText && n2 == 12) {
                return 0;
            }
            return OS.CallWindowProc(EditProc, n, n2, n3, n4);
        }
        int n7 = OS.GetDlgItem(this.handle, 1000);
        if (n == n7) {
            return OS.CallWindowProc(ListProc, n, n2, n3, n4);
        }
        return OS.DefWindowProc(n, n2, n3, n4);
    }

    int CBTProc(int n, int n2, int n3) {
        if (n == 3) {
            TCHAR tCHAR = new TCHAR(0, 128);
            OS.GetClassName(n2, tCHAR, tCHAR.length());
            String string = tCHAR.toString(0, tCHAR.strlen());
            if (string.equals("Edit") || string.equals("EDIT")) {
                int n4 = OS.GetWindowLong(n2, -16);
                OS.SetWindowLong(n2, -16, n4 & 0xFFFFFEFF);
            }
        }
        return OS.CallNextHookEx(this.cbtHook, n, n2, n3);
    }

    boolean checkHandle(int n) {
        return n == this.handle || n == OS.GetDlgItem(this.handle, 1001) || n == OS.GetDlgItem(this.handle, 1000);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int n) {
        n &= 0xFFFFF7FF;
        n &= 0xFFFFFCFF;
        if (((n = Combo.checkBits(n, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return n & 0xFFFFFFF7;
        }
        return n;
    }

    public void clearSelection() {
        this.checkWidget();
        OS.SendMessage(this.handle, 322, 0, -1);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        this.checkWidget();
        int n6 = 0;
        int n7 = 0;
        if (n == -1) {
            n5 = 0;
            n4 = OS.GetDC(this.handle);
            n3 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n3 != 0) {
                n5 = OS.SelectObject(n4, n3);
            }
            int n8 = OS.SendMessage(this.handle, 326, 0, 0);
            RECT rECT = new RECT();
            int n9 = 3072;
            if ((this.style & 8) == 0) {
                n9 |= 0x2000;
            }
            int n10 = OS.GetWindowTextLength(this.handle);
            int n11 = this.getCodePage();
            TCHAR tCHAR = new TCHAR(n11, n10 + 1);
            OS.GetWindowText(this.handle, tCHAR, n10 + 1);
            OS.DrawText(n4, tCHAR, n10, rECT, n9);
            n6 = Math.max(n6, rECT.right - rECT.left);
            if ((this.style & 0x100) != 0) {
                n6 = Math.max(n6, this.scrollWidth);
            } else {
                int n12 = 0;
                while (n12 < n8) {
                    n10 = OS.SendMessage(this.handle, 329, n12, 0);
                    if (n10 != -1) {
                        int n13;
                        if (n10 + 1 > tCHAR.length()) {
                            tCHAR = new TCHAR(n11, n10 + 1);
                        }
                        if ((n13 = OS.SendMessage(this.handle, 328, n12, tCHAR)) != -1) {
                            OS.DrawText(n4, tCHAR, n10, rECT, n9);
                            n6 = Math.max(n6, rECT.right - rECT.left);
                        }
                    }
                    ++n12;
                }
            }
            if (n3 != 0) {
                OS.SelectObject(n4, n5);
            }
            OS.ReleaseDC(this.handle, n4);
        }
        if (n2 == -1 && (this.style & 0x40) != 0) {
            n3 = OS.SendMessage(this.handle, 326, 0, 0);
            n5 = OS.SendMessage(this.handle, 340, 0, 0);
            n7 = n3 * n5;
        }
        if (n6 == 0) {
            n6 = 64;
        }
        if (n7 == 0) {
            n7 = 64;
        }
        if (n != -1) {
            n6 = n;
        }
        if (n2 != -1) {
            n7 = n2;
        }
        if ((this.style & 8) != 0) {
            n6 += 8;
        } else {
            n3 = OS.GetDlgItem(this.handle, 1001);
            if (n3 != 0) {
                n5 = OS.SendMessage(n3, 212, 0, 0);
                n4 = OS.LOWORD(n5) + OS.HIWORD(n5);
                n6 += n4 + 3;
            }
        }
        COMBOBOXINFO cOMBOBOXINFO = new COMBOBOXINFO();
        cOMBOBOXINFO.cbSize = COMBOBOXINFO.sizeof;
        if ((this.style & 0x40) == 0 && !OS.IsWinCE && OS.GetComboBoxInfo(this.handle, cOMBOBOXINFO)) {
            n6 += cOMBOBOXINFO.itemLeft + (cOMBOBOXINFO.buttonRight - cOMBOBOXINFO.buttonLeft);
            n7 = cOMBOBOXINFO.buttonBottom - cOMBOBOXINFO.buttonTop + cOMBOBOXINFO.buttonTop * 2;
        } else {
            n5 = OS.GetSystemMetrics(45);
            n6 += OS.GetSystemMetrics(2) + n5 * 2;
            n4 = OS.SendMessage(this.handle, 340, -1, 0);
            n7 = (this.style & 4) != 0 ? n4 + 6 : (n7 += n4 + 10);
        }
        if ((this.style & 0x40) != 0 && (this.style & 0x100) != 0) {
            n7 += OS.GetSystemMetrics(3);
        }
        return new Point(n6, n7);
    }

    public void copy() {
        this.checkWidget();
        OS.SendMessage(this.handle, 769, 0, 0);
    }

    void createHandle() {
        int n;
        int n2;
        int n3;
        if (OS.IsWinCE || (this.style & 0x48) != 0) {
            super.createHandle();
        } else {
            n3 = OS.GetCurrentThreadId();
            Callback callback = new Callback(this, "CBTProc", 3);
            n2 = callback.getAddress();
            if (n2 == 0) {
                this.error(3);
            }
            this.cbtHook = OS.SetWindowsHookEx(5, n2, 0, n3);
            super.createHandle();
            if (this.cbtHook != 0) {
                OS.UnhookWindowsHookEx(this.cbtHook);
            }
            this.cbtHook = 0;
            callback.dispose();
        }
        this.state &= 0xFFFFFEFD;
        n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 != 0 && EditProc == 0) {
            EditProc = OS.GetWindowLongPtr(n3, -4);
        }
        if ((n = OS.GetDlgItem(this.handle, 1000)) != 0 && ListProc == 0) {
            ListProc = OS.GetWindowLongPtr(n, -4);
        }
        if ((this.style & 0x40) != 0) {
            n2 = 52;
            this.SetWindowPos(this.handle, 0, 0, 0, 16383, 16383, n2);
            this.SetWindowPos(this.handle, 0, 0, 0, 0, 0, n2);
        }
    }

    void createWidget() {
        int n;
        super.createWidget();
        this.visibleCount = 5;
        if ((this.style & 0x40) == 0 && (n = OS.SendMessage(this.handle, 340, 0, 0)) != -1 && n != 0) {
            int n2 = 0;
            if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
                RECT rECT = new RECT();
                OS.SystemParametersInfo(48, 0, rECT, 0);
                n2 = (rECT.bottom - rECT.top) / 3;
            } else {
                int n3 = OS.MonitorFromWindow(this.handle, 2);
                MONITORINFO mONITORINFO = new MONITORINFO();
                mONITORINFO.cbSize = MONITORINFO.sizeof;
                OS.GetMonitorInfo(n3, mONITORINFO);
                n2 = (mONITORINFO.rcWork_bottom - mONITORINFO.rcWork_top) / 3;
            }
            this.visibleCount = Math.max(this.visibleCount, n2 / n);
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 768, 0, 0);
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    void deregister() {
        int n;
        super.deregister();
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n2 != 0) {
            this.display.removeControl(n2);
        }
        if ((n = OS.GetDlgItem(this.handle, 1000)) != 0) {
            this.display.removeControl(n);
        }
    }

    public void deselect(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 327, 0, 0);
        if (n != n2) {
            return;
        }
        OS.SendMessage(this.handle, 334, -1, 0);
        this.sendEvent(24);
    }

    public void deselectAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 334, -1, 0);
        this.sendEvent(24);
    }

    boolean dragDetect(int n, int n2, int n3, boolean bl, boolean[] blArray, boolean[] blArray2) {
        int n4;
        if (bl && (this.style & 8) == 0 && (n4 = OS.GetDlgItem(this.handle, 1001)) != 0) {
            int n5;
            int n6;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.SendMessage(this.handle, 320, nArray, nArray2);
            if (nArray[0] != nArray2[0] && nArray[0] <= (n6 = OS.LOWORD(OS.SendMessage(n4, 215, 0, n5 = OS.MAKELPARAM(n2, n3)))) && n6 < nArray2[0] && super.dragDetect(n, n2, n3, bl, blArray, blArray2)) {
                if (blArray2 != null) {
                    blArray2[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(n, n2, n3, bl, blArray, blArray2);
    }

    public String getItem(int n) {
        TCHAR tCHAR;
        int n2;
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 329, n, 0);
        if (n3 != -1 && (n2 = OS.SendMessage(this.handle, 328, n, tCHAR = new TCHAR(this.getCodePage(), n3 + 1))) != -1) {
            return tCHAR.toString(0, n3);
        }
        int n4 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n >= 0 && n < n4) {
            this.error(8);
        }
        this.error(6);
        return "";
    }

    public int getItemCount() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 326, 0, 0);
        if (n == -1) {
            this.error(36);
        }
        return n;
    }

    public int getItemHeight() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 340, 0, 0);
        if (n == -1) {
            this.error(11);
        }
        return n;
    }

    public String[] getItems() {
        this.checkWidget();
        int n = this.getItemCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getItem(n2);
            ++n2;
        }
        return stringArray;
    }

    public boolean getListVisible() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return OS.SendMessage(this.handle, 343, 0, 0) != 0;
        }
        return true;
    }

    String getNameText() {
        return this.getText();
    }

    public void setListVisible(boolean bl) {
        this.checkWidget();
        OS.SendMessage(this.handle, 335, bl ? 1 : 0, 0);
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0 && (this.style & 8) != 0) {
            return new Point(0, OS.GetWindowTextLength(this.handle));
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 320, nArray, nArray2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.mbcsToWcsPos(nArray[0]);
            nArray2[0] = this.mbcsToWcsPos(nArray2[0]);
        }
        return new Point(nArray[0], nArray2[0]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if (this.noSelection) {
            return -1;
        }
        return OS.SendMessage(this.handle, 327, 0, 0);
    }

    public String getText() {
        this.checkWidget();
        int n = OS.GetWindowTextLength(this.handle);
        if (n == 0) {
            return "";
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n + 1);
        OS.GetWindowText(this.handle, tCHAR, n + 1);
        return tCHAR.toString(0, n);
    }

    public int getTextHeight() {
        this.checkWidget();
        COMBOBOXINFO cOMBOBOXINFO = new COMBOBOXINFO();
        cOMBOBOXINFO.cbSize = COMBOBOXINFO.sizeof;
        if ((this.style & 0x40) == 0 && !OS.IsWinCE && OS.GetComboBoxInfo(this.handle, cOMBOBOXINFO)) {
            return cOMBOBOXINFO.buttonBottom - cOMBOBOXINFO.buttonTop + cOMBOBOXINFO.buttonTop * 2;
        }
        int n = OS.SendMessage(this.handle, 340, -1, 0);
        if (n == -1) {
            this.error(11);
        }
        return (this.style & 4) != 0 ? n + 6 : n + 10;
    }

    public int getTextLimit() {
        this.checkWidget();
        int n = OS.GetDlgItem(this.handle, 1001);
        if (n == 0) {
            return LIMIT;
        }
        return OS.SendMessage(n, 213, 0, 0) & Integer.MAX_VALUE;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    boolean hasFocus() {
        int n = OS.GetFocus();
        if (n == this.handle) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n == n2) {
            return true;
        }
        int n3 = OS.GetDlgItem(this.handle, 1000);
        return n == n3;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.length() == 0) {
            int n2 = this.getItemCount();
            int n3 = n;
            while (n3 < n2) {
                if (string.equals(this.getItem(n3))) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }
        int n4 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n < 0 || n >= n4) {
            return -1;
        }
        int n5 = n - 1;
        int n6 = 0;
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        do {
            if ((n5 = OS.SendMessage(this.handle, 344, n6 = n5, tCHAR)) != -1 && n5 > n6) continue;
            return -1;
        } while (!string.equals(this.getItem(n5)));
        return n5;
    }

    int mbcsToWcsPos(int n) {
        if (n <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n;
        }
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n2 == 0) {
            return n;
        }
        int n3 = OS.GetWindowTextLengthA(n2);
        if (n3 == 0) {
            return 0;
        }
        if (n >= n3) {
            return n3;
        }
        byte[] byArray = new byte[n3 + 1];
        OS.GetWindowTextA(n2, byArray, n3 + 1);
        return OS.MultiByteToWideChar(this.getCodePage(), 1, byArray, n, null, 0);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 770, 0, 0);
    }

    void register() {
        int n;
        super.register();
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n2 != 0) {
            this.display.addControl(n2, this);
        }
        if ((n = OS.GetDlgItem(this.handle, 1000)) != 0) {
            this.display.addControl(n, this);
        }
    }

    public void remove(int n) {
        this.checkWidget();
        this.remove(n, true);
    }

    void remove(int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        TCHAR tCHAR = null;
        if ((this.style & 0x100) != 0) {
            n4 = OS.SendMessage(this.handle, 329, n, 0);
            if (n4 == -1) {
                n3 = OS.SendMessage(this.handle, 326, 0, 0);
                if (n >= 0 && n < n3) {
                    this.error(15);
                }
                this.error(6);
            }
            if ((n3 = OS.SendMessage(this.handle, 328, n, tCHAR = new TCHAR(this.getCodePage(), n4 + 1))) == -1) {
                n2 = OS.SendMessage(this.handle, 326, 0, 0);
                if (n >= 0 && n < n2) {
                    this.error(15);
                }
                this.error(6);
            }
        }
        n4 = OS.GetWindowTextLength(this.handle);
        n3 = OS.SendMessage(this.handle, 324, n, 0);
        if (n3 == -1) {
            n2 = OS.SendMessage(this.handle, 326, 0, 0);
            if (n >= 0 && n < n2) {
                this.error(15);
            }
            this.error(6);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
        if (bl && n4 != OS.GetWindowTextLength(this.handle)) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return;
            }
        }
        if ((this.style & 8) != 0 && (n2 = OS.SendMessage(this.handle, 326, 0, 0)) == 0) {
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n3 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n < 0 || n > n2 || n2 >= n3) {
            this.error(6);
        }
        int n4 = OS.GetWindowTextLength(this.handle);
        RECT rECT = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            n5 = OS.GetDC(this.handle);
            n7 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n7 != 0) {
                n6 = OS.SelectObject(n5, n7);
            }
        }
        int n9 = this.getCodePage();
        int n10 = 3104;
        int n11 = n;
        while (n11 <= n2) {
            int n12;
            int n13;
            TCHAR tCHAR = null;
            if ((this.style & 0x100) != 0 && ((n13 = OS.SendMessage(this.handle, 329, n, 0)) == -1 || (n12 = OS.SendMessage(this.handle, 328, n, tCHAR = new TCHAR(n9, n13 + 1))) == -1)) break;
            n13 = OS.SendMessage(this.handle, 324, n, 0);
            if (n13 == -1) {
                this.error(15);
            }
            if ((this.style & 0x100) != 0) {
                OS.DrawText(n5, tCHAR, -1, rECT, n10);
                n8 = Math.max(n8, rECT.right - rECT.left);
            }
            ++n11;
        }
        if ((this.style & 0x100) != 0) {
            if (n7 != 0) {
                OS.SelectObject(n5, n6);
            }
            OS.ReleaseDC(this.handle, n5);
            this.setScrollWidth(n8, false);
        }
        if (n4 != OS.GetWindowTextLength(this.handle)) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return;
            }
        }
        if ((this.style & 8) != 0 && (n3 = OS.SendMessage(this.handle, 326, 0, 0)) == 0) {
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void removeAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 331, 0, 0);
        this.sendEvent(24);
        if (this.isDisposed()) {
            return;
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(0);
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    boolean sendKeyEvent(int n, int n2, int n3, int n4, Event event) {
        Object object;
        Object object2;
        if (!super.sendKeyEvent(n, n2, n3, n4, event)) {
            return false;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (n != 1) {
            return true;
        }
        if (n2 != 258 && n2 != 256 && n2 != 646) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return true;
        }
        char c = event.character;
        int n5 = event.stateMask;
        switch (n2) {
            case 258: {
                if (c != '\b' && c != '\u007f' && c != '\r' && c != '\t' && c != '\n') break;
            }
            case 256: {
                if ((n5 & 0x70000) == 0) break;
                return false;
            }
        }
        if (OS.GetKeyState(1) < 0 && OS.GetDlgItem(this.handle, 1001) == OS.GetCapture()) {
            return true;
        }
        String string = "";
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n6 = OS.GetDlgItem(this.handle, 1001);
        if (n6 == 0) {
            return true;
        }
        OS.SendMessage(n6, 176, nArray, nArray2);
        switch (c) {
            case '\b': {
                if (nArray[0] != nArray2[0]) break;
                if (nArray[0] == 0) {
                    return true;
                }
                nArray[0] = nArray[0] - 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object2 = new int[1];
                    object = new int[1];
                    OS.SendMessage(n6, 177, nArray[0], nArray2[0]);
                    OS.SendMessage(n6, 176, (int[])object2, object);
                    if (nArray[0] != object2[0]) {
                        nArray[0] = nArray[0] - 1;
                    }
                }
                nArray[0] = Math.max(nArray[0], 0);
                break;
            }
            case '\u007f': {
                if (nArray[0] != nArray2[0]) break;
                int n7 = OS.GetWindowTextLength(n6);
                if (nArray[0] == n7) {
                    return true;
                }
                nArray2[0] = nArray2[0] + 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object = new int[1];
                    int[] nArray3 = new int[1];
                    OS.SendMessage(n6, 177, nArray[0], nArray2[0]);
                    OS.SendMessage(n6, 176, object, nArray3);
                    if (nArray2[0] != nArray3[0]) {
                        nArray2[0] = nArray2[0] + 1;
                    }
                }
                nArray2[0] = Math.min(nArray2[0], n7);
                break;
            }
            case '\r': {
                return true;
            }
            default: {
                if (c != '\t' && c < ' ') {
                    return true;
                }
                string = new String(new char[]{c});
            }
        }
        if ((object2 = this.verifyText(string, nArray[0], nArray2[0], event)) == null) {
            return false;
        }
        if (object2 == string) {
            return true;
        }
        object = new TCHAR(this.getCodePage(), (String)object2, true);
        OS.SendMessage(n6, 177, nArray[0], nArray2[0]);
        OS.SendMessage(n6, 194, 0, (TCHAR)object);
        return false;
    }

    public void select(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n >= 0 && n < n2) {
            int n3 = OS.SendMessage(this.handle, 327, 0, 0);
            int n4 = OS.SendMessage(this.handle, 334, n, 0);
            if (n4 != -1 && n4 != n3) {
                this.sendEvent(24);
            }
        }
    }

    void setBackgroundImage(int n) {
        int n2;
        super.setBackgroundImage(n);
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 != 0) {
            OS.InvalidateRect(n3, null, true);
        }
        if ((n2 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.InvalidateRect(n2, null, true);
        }
    }

    void setBackgroundPixel(int n) {
        int n2;
        super.setBackgroundPixel(n);
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 != 0) {
            OS.InvalidateRect(n3, null, true);
        }
        if ((n2 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.InvalidateRect(n2, null, true);
        }
    }

    void setBounds(int n, int n2, int n3, int n4, int n5) {
        if ((this.style & 4) != 0) {
            int n6 = this.getItemCount() == 0 ? 5 : this.visibleCount;
            n4 = this.getTextHeight() + this.getItemHeight() * n6 + 2;
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            if (rECT.right - rECT.left != 0 && OS.SendMessage(this.handle, 338, 0, rECT) != 0) {
                int n7 = rECT.right - rECT.left;
                int n8 = rECT.bottom - rECT.top;
                if (n7 == n3 && n8 == n4) {
                    n5 |= 1;
                }
            }
            this.SetWindowPos(this.handle, 0, n, n2, n3, n4, n5);
        } else {
            super.setBounds(n, n2, n3, n4, n5);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth();
        }
    }

    void setForegroundPixel(int n) {
        int n2;
        super.setForegroundPixel(n);
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 != 0) {
            OS.InvalidateRect(n3, null, true);
        }
        if ((n2 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.InvalidateRect(n2, null, true);
        }
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = this.getSelectionIndex();
        this.remove(n, false);
        if (this.isDisposed()) {
            return;
        }
        this.add(string, n);
        if (n2 != -1) {
            this.select(n2);
        }
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                this.error(5);
            }
            ++n;
        }
        RECT rECT = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            n2 = OS.GetDC(this.handle);
            n4 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n4 != 0) {
                n3 = OS.SelectObject(n2, n4);
            }
            this.setScrollWidth(0);
        }
        OS.SendMessage(this.handle, 331, 0, 0);
        int n6 = this.getCodePage();
        int n7 = 0;
        while (n7 < stringArray.length) {
            String string = stringArray[n7];
            TCHAR tCHAR = new TCHAR(n6, string, true);
            int n8 = OS.SendMessage(this.handle, 323, 0, tCHAR);
            if (n8 == -1) {
                this.error(14);
            }
            if (n8 == -2) {
                this.error(14);
            }
            if ((this.style & 0x100) != 0) {
                int n9 = 3104;
                OS.DrawText(n2, tCHAR, -1, rECT, n9);
                n5 = Math.max(n5, rECT.right - rECT.left);
            }
            ++n7;
        }
        if ((this.style & 0x100) != 0) {
            if (n4 != 0) {
                OS.SelectObject(n2, n3);
            }
            OS.ReleaseDC(this.handle, n2);
            this.setScrollWidth(n5 + 3);
        }
        this.sendEvent(24);
    }

    public void setOrientation(int n) {
        int n2;
        this.checkWidget();
        if (OS.IsWinCE) {
            return;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return;
        }
        int n3 = 0x6000000;
        if ((n & n3) == 0 || (n & n3) == n3) {
            return;
        }
        this.style &= ~n3;
        this.style |= n & n3;
        int n4 = OS.GetWindowLong(this.handle, -20);
        if ((this.style & 0x4000000) != 0) {
            this.style |= 0x8000000;
            n4 |= 0x400000;
        } else {
            this.style &= 0xF7FFFFFF;
            n4 &= 0xFFBFFFFF;
        }
        OS.SetWindowLong(this.handle, -20, n4);
        int n5 = 0;
        int n6 = 0;
        COMBOBOXINFO cOMBOBOXINFO = new COMBOBOXINFO();
        cOMBOBOXINFO.cbSize = COMBOBOXINFO.sizeof;
        if (OS.GetComboBoxInfo(this.handle, cOMBOBOXINFO)) {
            n5 = cOMBOBOXINFO.hwndItem;
            n6 = cOMBOBOXINFO.hwndList;
        }
        if (n5 != 0) {
            n2 = OS.GetWindowLong(n5, -20);
            int n7 = OS.GetWindowLong(n5, -16);
            if ((this.style & 0x4000000) != 0) {
                n2 |= 0x3000;
                n7 |= 2;
            } else {
                n2 &= 0xFFFFCFFF;
                n7 &= 0xFFFFFFFD;
            }
            OS.SetWindowLong(n5, -20, n2);
            OS.SetWindowLong(n5, -16, n7);
            RECT rECT = new RECT();
            OS.GetWindowRect(n5, rECT);
            int n8 = rECT.right - rECT.left;
            int n9 = rECT.bottom - rECT.top;
            OS.GetWindowRect(this.handle, rECT);
            int n10 = rECT.right - rECT.left;
            int n11 = rECT.bottom - rECT.top;
            int n12 = 22;
            this.SetWindowPos(n5, 0, 0, 0, n8 - 1, n9 - 1, n12);
            this.SetWindowPos(this.handle, 0, 0, 0, n10 - 1, n11 - 1, n12);
            this.SetWindowPos(n5, 0, 0, 0, n8, n9, n12);
            this.SetWindowPos(this.handle, 0, 0, 0, n10, n11, n12);
            OS.InvalidateRect(this.handle, null, true);
        }
        if (n6 != 0) {
            n2 = OS.GetWindowLong(n6, -20);
            n2 = (this.style & 0x4000000) != 0 ? (n2 |= 0x400000) : (n2 &= 0xFFBFFFFF);
            OS.SetWindowLong(n6, -20, n2);
        }
    }

    void setScrollWidth() {
        int n = 0;
        RECT rECT = new RECT();
        int n2 = 0;
        int n3 = OS.GetDC(this.handle);
        int n4 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n4 != 0) {
            n2 = OS.SelectObject(n3, n4);
        }
        int n5 = this.getCodePage();
        int n6 = OS.SendMessage(this.handle, 326, 0, 0);
        int n7 = 3104;
        int n8 = 0;
        while (n8 < n6) {
            TCHAR tCHAR;
            int n9;
            int n10 = OS.SendMessage(this.handle, 329, n8, 0);
            if (n10 != -1 && (n9 = OS.SendMessage(this.handle, 328, n8, tCHAR = new TCHAR(n5, n10 + 1))) != -1) {
                OS.DrawText(n3, tCHAR, -1, rECT, n7);
                n = Math.max(n, rECT.right - rECT.left);
            }
            ++n8;
        }
        if (n4 != 0) {
            OS.SelectObject(n3, n2);
        }
        OS.ReleaseDC(this.handle, n3);
        this.setScrollWidth(n + 3);
    }

    void setScrollWidth(int n) {
        this.scrollWidth = n;
        if ((this.style & 0x40) != 0) {
            OS.SendMessage(this.handle, 350, n, 0);
            return;
        }
        boolean bl = false;
        int n2 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n2 > 3) {
            int n3 = 0;
            if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
                RECT rECT = new RECT();
                OS.SystemParametersInfo(48, 0, rECT, 0);
                n3 = (rECT.right - rECT.left) / 4;
            } else {
                int n4 = OS.MonitorFromWindow(this.handle, 2);
                MONITORINFO mONITORINFO = new MONITORINFO();
                mONITORINFO.cbSize = MONITORINFO.sizeof;
                OS.GetMonitorInfo(n4, mONITORINFO);
                n3 = (mONITORINFO.rcWork_right - mONITORINFO.rcWork_left) / 4;
            }
            boolean bl2 = bl = n > n3;
        }
        if ((this.style & 8) == 0) {
            this.lockText = true;
        }
        if (bl) {
            OS.SendMessage(this.handle, 352, 0, 0);
            OS.SendMessage(this.handle, 350, n, 0);
        } else {
            OS.SendMessage(this.handle, 352, n += OS.GetSystemMetrics(3), 0);
            OS.SendMessage(this.handle, 350, 0, 0);
        }
        if ((this.style & 8) == 0) {
            this.lockText = false;
        }
    }

    void setScrollWidth(TCHAR tCHAR, boolean bl) {
        RECT rECT = new RECT();
        int n = 0;
        int n2 = OS.GetDC(this.handle);
        int n3 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n3 != 0) {
            n = OS.SelectObject(n2, n3);
        }
        int n4 = 3104;
        OS.DrawText(n2, tCHAR, -1, rECT, n4);
        if (n3 != 0) {
            OS.SelectObject(n2, n);
        }
        OS.ReleaseDC(this.handle, n2);
        this.setScrollWidth(rECT.right - rECT.left, bl);
    }

    void setScrollWidth(int n, boolean bl) {
        if (bl) {
            if (n <= this.scrollWidth) {
                return;
            }
            this.setScrollWidth(n + 3);
        } else {
            if (n < this.scrollWidth) {
                return;
            }
            this.setScrollWidth();
        }
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n = point.x;
        int n2 = point.y;
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n = this.wcsToMbcsPos(n);
            n2 = this.wcsToMbcsPos(n2);
        }
        int n3 = OS.MAKELPARAM(n, n2);
        OS.SendMessage(this.handle, 322, 0, n3);
    }

    public void setText(String string) {
        TCHAR tCHAR;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int n = this.indexOf(string);
            if (n != -1) {
                this.select(n);
            }
            return;
        }
        int n = LIMIT;
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n2 != 0) {
            n = OS.SendMessage(n2, 213, 0, 0) & Integer.MAX_VALUE;
        }
        if (string.length() > n) {
            string = string.substring(0, n);
        }
        if (OS.SetWindowText(this.handle, tCHAR = new TCHAR(this.getCodePage(), string, true))) {
            this.sendEvent(24);
        }
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        OS.SendMessage(this.handle, 321, n, 0);
    }

    void setToolTipText(Shell shell, String string) {
        int n = OS.GetDlgItem(this.handle, 1001);
        int n2 = OS.GetDlgItem(this.handle, 1000);
        if (n != 0) {
            shell.setToolTipText(n, string);
        }
        if (n2 != 0) {
            shell.setToolTipText(n2, string);
        }
        shell.setToolTipText(this.handle, string);
    }

    public void setVisibleItemCount(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.visibleCount = n;
        this.updateDropDownHeight();
    }

    void subclass() {
        int n;
        super.subclass();
        int n2 = this.display.windowProc;
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 != 0) {
            OS.SetWindowLongPtr(n3, -4, n2);
        }
        if ((n = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.SetWindowLongPtr(n, -4, n2);
        }
    }

    boolean translateTraversal(MSG mSG) {
        switch (mSG.wParam) {
            case 13: 
            case 27: {
                if ((this.style & 4) == 0 || OS.SendMessage(this.handle, 343, 0, 0) == 0) break;
                return false;
            }
        }
        return super.translateTraversal(mSG);
    }

    boolean traverseEscape() {
        if ((this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0, 0) != 0) {
            OS.SendMessage(this.handle, 335, 0, 0);
            return true;
        }
        return super.traverseEscape();
    }

    boolean traverseReturn() {
        if ((this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0, 0) != 0) {
            OS.SendMessage(this.handle, 335, 0, 0);
            return true;
        }
        return super.traverseReturn();
    }

    void unsubclass() {
        int n;
        super.unsubclass();
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n2 != 0 && EditProc != 0) {
            OS.SetWindowLongPtr(n2, -4, EditProc);
        }
        if ((n = OS.GetDlgItem(this.handle, 1000)) != 0 && ListProc != 0) {
            OS.SetWindowLongPtr(n, -4, ListProc);
        }
    }

    void updateDropDownHeight() {
        if ((this.style & 4) != 0) {
            RECT rECT = new RECT();
            OS.SendMessage(this.handle, 338, 0, rECT);
            int n = this.getItemCount() == 0 ? 5 : this.visibleCount;
            int n2 = this.getTextHeight() + this.getItemHeight() * n + 2;
            if (n2 != rECT.bottom - rECT.top) {
                this.forceResize();
                OS.GetWindowRect(this.handle, rECT);
                int n3 = 54;
                this.SetWindowPos(this.handle, 0, 0, 0, rECT.right - rECT.left, n2, n3);
            }
        }
    }

    String verifyText(String string, int n, int n2, Event event) {
        Event event2 = new Event();
        event2.text = string;
        event2.start = n;
        event2.end = n2;
        if (event != null) {
            event2.character = event.character;
            event2.keyCode = event.keyCode;
            event2.stateMask = event.stateMask;
        }
        if (!OS.IsUnicode && OS.IsDBLocale) {
            event2.start = this.mbcsToWcsPos(n);
            event2.end = this.mbcsToWcsPos(n2);
        }
        this.sendEvent(25, event2);
        if (!event2.doit || this.isDisposed()) {
            return null;
        }
        return event2.text;
    }

    int wcsToMbcsPos(int n) {
        if (n <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n;
        }
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n2 == 0) {
            return n;
        }
        int n3 = OS.GetWindowTextLengthA(n2);
        if (n3 == 0) {
            return 0;
        }
        byte[] byArray = new byte[n3 + 1];
        OS.GetWindowTextA(n2, byArray, n3 + 1);
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            if (n == n5) break;
            if (OS.IsDBCSLeadByte(byArray[n4++])) {
                ++n4;
            }
            ++n5;
        }
        return n4;
    }

    int widgetExtStyle() {
        return super.widgetExtStyle() & 0xFFEFFFFF;
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 0x40 | 0x400 | 0x100000 | 0x200000;
        if ((this.style & 0x40) != 0) {
            return n | 1;
        }
        if ((this.style & 8) != 0) {
            return n | 3;
        }
        return n | 2;
    }

    TCHAR windowClass() {
        return ComboClass;
    }

    int windowProc() {
        return ComboProc;
    }

    int windowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        if (n != this.handle) {
            int n5 = OS.GetDlgItem(this.handle, 1001);
            int n6 = OS.GetDlgItem(this.handle, 1000);
            if (n5 != 0 && n == n5 || n6 != 0 && n == n6) {
                LRESULT lRESULT = null;
                switch (n2) {
                    case 258: {
                        lRESULT = this.wmChar(n, n3, n4);
                        break;
                    }
                    case 646: {
                        lRESULT = this.wmIMEChar(n, n3, n4);
                        break;
                    }
                    case 256: {
                        lRESULT = this.wmKeyDown(n, n3, n4);
                        break;
                    }
                    case 257: {
                        lRESULT = this.wmKeyUp(n, n3, n4);
                        break;
                    }
                    case 262: {
                        lRESULT = this.wmSysChar(n, n3, n4);
                        break;
                    }
                    case 260: {
                        lRESULT = this.wmSysKeyDown(n, n3, n4);
                        break;
                    }
                    case 261: {
                        lRESULT = this.wmSysKeyUp(n, n3, n4);
                        break;
                    }
                    case 533: {
                        lRESULT = this.wmCaptureChanged(n, n3, n4);
                        break;
                    }
                    case 515: {
                        lRESULT = this.wmLButtonDblClk(n, n3, n4);
                        break;
                    }
                    case 513: {
                        lRESULT = this.wmLButtonDown(n, n3, n4);
                        break;
                    }
                    case 514: {
                        lRESULT = this.wmLButtonUp(n, n3, n4);
                        break;
                    }
                    case 521: {
                        lRESULT = this.wmMButtonDblClk(n, n3, n4);
                        break;
                    }
                    case 519: {
                        lRESULT = this.wmMButtonDown(n, n3, n4);
                        break;
                    }
                    case 520: {
                        lRESULT = this.wmMButtonUp(n, n3, n4);
                        break;
                    }
                    case 673: {
                        lRESULT = this.wmMouseHover(n, n3, n4);
                        break;
                    }
                    case 675: {
                        lRESULT = this.wmMouseLeave(n, n3, n4);
                        break;
                    }
                    case 512: {
                        lRESULT = this.wmMouseMove(n, n3, n4);
                        break;
                    }
                    case 518: {
                        lRESULT = this.wmRButtonDblClk(n, n3, n4);
                        break;
                    }
                    case 516: {
                        lRESULT = this.wmRButtonDown(n, n3, n4);
                        break;
                    }
                    case 517: {
                        lRESULT = this.wmRButtonUp(n, n3, n4);
                        break;
                    }
                    case 525: {
                        lRESULT = this.wmXButtonDblClk(n, n3, n4);
                        break;
                    }
                    case 523: {
                        lRESULT = this.wmXButtonDown(n, n3, n4);
                        break;
                    }
                    case 524: {
                        lRESULT = this.wmXButtonUp(n, n3, n4);
                        break;
                    }
                    case 15: {
                        lRESULT = this.wmPaint(n, n3, n4);
                        break;
                    }
                    case 123: {
                        lRESULT = this.wmContextMenu(n, n3, n4);
                        break;
                    }
                    case 12: 
                    case 199: 
                    case 768: 
                    case 770: 
                    case 771: 
                    case 772: {
                        if (n != n5) break;
                        lRESULT = this.wmClipboard(n, n2, n3, n4);
                    }
                }
                if (lRESULT != null) {
                    return lRESULT.value;
                }
                return this.callWindowProc(n, n2, n3, n4);
            }
        }
        if (n2 == 334 && (this.style & 8) != 0 && (this.hooks(25) || this.filters(25))) {
            String string = this.getText();
            String string2 = null;
            if (n3 == -1) {
                string2 = "";
            } else if (n3 >= 0 && n3 < this.getItemCount()) {
                string2 = this.getItem(n3);
            }
            if (string2 != null && !string2.equals(string)) {
                int n7;
                int n8 = OS.GetWindowTextLength(this.handle);
                string = string2;
                if ((string2 = this.verifyText(string2, 0, n8, null)) == null) {
                    return 0;
                }
                if (!string2.equals(string) && (n7 = this.indexOf(string2)) != -1 && n7 != n3) {
                    return this.callWindowProc(this.handle, 334, n7, n4);
                }
            }
        }
        return super.windowProc(n, n2, n3, n4);
    }

    LRESULT WM_CTLCOLOR(int n, int n2) {
        return this.wmColorChild(n, n2);
    }

    LRESULT WM_GETDLGCODE(int n, int n2) {
        int n3 = this.callWindowProc(this.handle, 135, n, n2);
        return new LRESULT(n3 | 1);
    }

    LRESULT WM_KILLFOCUS(int n, int n2) {
        if ((this.style & 8) != 0) {
            return super.WM_KILLFOCUS(n, n2);
        }
        return null;
    }

    LRESULT WM_LBUTTONDOWN(int n, int n2) {
        int n3;
        int n4 = OS.SendMessage(this.handle, 327, 0, 0);
        LRESULT lRESULT = super.WM_LBUTTONDOWN(n, n2);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if ((this.style & 8) == 0 && n4 != (n3 = OS.SendMessage(this.handle, 327, 0, 0))) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            this.sendSelectionEvent(13, null, true);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT WM_SETFOCUS(int n, int n2) {
        return null;
    }

    LRESULT WM_SIZE(int n, int n2) {
        if (this.ignoreResize) {
            return null;
        }
        if ((this.style & 0x40) != 0) {
            LRESULT lRESULT = super.WM_SIZE(n, n2);
            if (OS.IsWindowVisible(this.handle)) {
                if (OS.IsWinCE) {
                    int n3;
                    int n4 = OS.GetDlgItem(this.handle, 1001);
                    if (n4 != 0) {
                        OS.InvalidateRect(n4, null, true);
                    }
                    if ((n3 = OS.GetDlgItem(this.handle, 1000)) != 0) {
                        OS.InvalidateRect(n3, null, true);
                    }
                } else {
                    int n5 = 133;
                    OS.RedrawWindow(this.handle, null, 0, n5);
                }
            }
            return lRESULT;
        }
        if ((this.style & 8) == 0) {
            this.lockText = true;
        }
        LRESULT lRESULT = super.WM_SIZE(n, n2);
        if ((this.style & 8) == 0) {
            this.lockText = false;
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(this.scrollWidth);
        }
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGING(int n, int n2) {
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.IsWinCE) {
            return lRESULT;
        }
        if (!this.getDrawing()) {
            return lRESULT;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return lRESULT;
        }
        if (this.ignoreResize) {
            WINDOWPOS wINDOWPOS = new WINDOWPOS();
            OS.MoveMemory(wINDOWPOS, n2, WINDOWPOS.sizeof);
            if ((wINDOWPOS.flags & 1) == 0) {
                wINDOWPOS.flags |= 8;
                OS.MoveMemory(n2, wINDOWPOS, WINDOWPOS.sizeof);
                OS.InvalidateRect(this.handle, null, true);
                RECT rECT = new RECT();
                OS.GetWindowRect(this.handle, rECT);
                int n3 = rECT.right - rECT.left;
                int n4 = rECT.bottom - rECT.top;
                if (n3 != 0 && n4 != 0) {
                    int n5;
                    int n6 = this.parent.handle;
                    int n7 = OS.GetWindow(n6, 5);
                    OS.MapWindowPoints(0, n6, rECT, 2);
                    int n8 = OS.CreateRectRgn(rECT.left, rECT.top, rECT.right, rECT.bottom);
                    while (n7 != 0) {
                        if (n7 != this.handle) {
                            OS.GetWindowRect(n7, rECT);
                            OS.MapWindowPoints(0, n6, rECT, 2);
                            n5 = OS.CreateRectRgn(rECT.left, rECT.top, rECT.right, rECT.bottom);
                            OS.CombineRgn(n8, n8, n5, 4);
                            OS.DeleteObject(n5);
                        }
                        n7 = OS.GetWindow(n7, 2);
                    }
                    n5 = 1029;
                    OS.RedrawWindow(n6, null, n8, n5);
                    OS.DeleteObject(n8);
                }
            }
        }
        return lRESULT;
    }

    LRESULT wmChar(int n, int n2, int n3) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT lRESULT = super.wmChar(n, n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n2) {
            case 9: {
                return LRESULT.ZERO;
            }
            case 13: {
                if (!this.ignoreDefaultSelection) {
                    this.sendSelectionEvent(14);
                }
                this.ignoreDefaultSelection = false;
            }
            case 27: {
                if ((this.style & 4) == 0 || OS.SendMessage(this.handle, 343, 0, 0) != 0) break;
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT wmClipboard(int n, int n2, int n3, int n4) {
        Object object;
        if ((this.style & 8) != 0) {
            return null;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return null;
        }
        boolean bl = false;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        String string = null;
        switch (n2) {
            case 768: 
            case 771: {
                OS.SendMessage(n, 176, nArray, nArray2);
                if (nArray[0] == nArray2[0]) break;
                string = "";
                bl = true;
                break;
            }
            case 770: {
                OS.SendMessage(n, 176, nArray, nArray2);
                string = this.getClipboardText();
                break;
            }
            case 199: 
            case 772: {
                if (OS.SendMessage(n, 198, 0, 0) == 0) break;
                this.ignoreModify = true;
                OS.CallWindowProc(EditProc, n, n2, n3, n4);
                int n5 = OS.GetWindowTextLength(n);
                object = new int[1];
                int[] nArray3 = new int[1];
                OS.SendMessage(n, 176, (int[])object, nArray3);
                if (n5 != 0 && object[0] != nArray3[0]) {
                    TCHAR tCHAR = new TCHAR(this.getCodePage(), n5 + 1);
                    OS.GetWindowText(n, tCHAR, n5 + 1);
                    string = tCHAR.toString((int)object[0], nArray3[0] - object[0]);
                } else {
                    string = "";
                }
                OS.CallWindowProc(EditProc, n, n2, n3, n4);
                OS.SendMessage(n, 176, nArray, nArray2);
                this.ignoreModify = false;
                break;
            }
            case 12: {
                nArray2[0] = OS.GetWindowTextLength(n);
                int n5 = OS.IsUnicode ? OS.wcslen(n4) : OS.strlen(n4);
                object = new TCHAR(this.getCodePage(), n5);
                int n6 = ((TCHAR)object).length() * TCHAR.sizeof;
                OS.MoveMemory((TCHAR)object, n4, n6);
                string = ((TCHAR)object).toString(0, n5);
            }
        }
        if (string != null) {
            String string2 = string;
            if ((string = this.verifyText(string, nArray[0], nArray2[0], null)) == null) {
                return LRESULT.ZERO;
            }
            if (!string.equals(string2)) {
                if (bl) {
                    OS.CallWindowProc(EditProc, n, n2, n3, n4);
                }
                object = new TCHAR(this.getCodePage(), string, true);
                if (n2 == 12) {
                    int n7 = OS.GetProcessHeap();
                    int n8 = ((TCHAR)object).length() * TCHAR.sizeof;
                    int n9 = OS.HeapAlloc(n7, 8, n8);
                    OS.MoveMemory(n9, (TCHAR)object, n8);
                    int n10 = OS.CallWindowProc(EditProc, n, n2, n3, n9);
                    OS.HeapFree(n7, 0, n9);
                    return new LRESULT(n10);
                }
                OS.SendMessage(n, 194, 0, (TCHAR)object);
                return LRESULT.ZERO;
            }
        }
        return null;
    }

    LRESULT wmCommandChild(int n, int n2) {
        int n3 = OS.HIWORD(n);
        switch (n3) {
            case 5: {
                if (this.ignoreModify) break;
                this.noSelection = true;
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.noSelection = false;
                break;
            }
            case 1: {
                int n4 = OS.SendMessage(this.handle, 327, 0, 0);
                if (n4 != -1) {
                    OS.SendMessage(this.handle, 334, n4, 0);
                }
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.sendSelectionEvent(13);
                break;
            }
            case 3: {
                this.sendFocusEvent(15);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
            case 7: {
                this.setCursor();
                this.updateDropDownHeight();
                break;
            }
            case 4: {
                if ((this.style & 8) != 0) break;
                this.sendFocusEvent(16);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
            case 1792: 
            case 1793: {
                Event event = new Event();
                event.doit = true;
                this.sendEvent(44, event);
                if (event.doit) break;
                int n5 = n2;
                int n6 = OS.GetWindowLong(n5, -20);
                int n7 = OS.GetWindowLong(n5, -16);
                if (n3 == 1792) {
                    n6 |= 0x3000;
                    n7 |= 2;
                } else {
                    n6 &= 0xFFFFCFFF;
                    n7 &= 0xFFFFFFFD;
                }
                OS.SetWindowLong(n5, -20, n6);
                OS.SetWindowLong(n5, -16, n7);
            }
        }
        return super.wmCommandChild(n, n2);
    }

    LRESULT wmIMEChar(int n, int n2, int n3) {
        Display display = this.display;
        display.lastKey = 0;
        display.lastAscii = n2;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        if (!this.sendKeyEvent(1, 646, n2, n3)) {
            return LRESULT.ZERO;
        }
        this.ignoreCharacter = true;
        int n4 = this.callWindowProc(n, 646, n2, n3);
        MSG mSG = new MSG();
        int n5 = 10420227;
        while (OS.PeekMessage(mSG, n, 258, 258, n5)) {
            OS.TranslateMessage(mSG);
            OS.DispatchMessage(mSG);
        }
        this.ignoreCharacter = false;
        this.sendKeyEvent(2, 646, n2, n3);
        display.lastAscii = 0;
        display.lastKey = 0;
        return new LRESULT(n4);
    }

    LRESULT wmKeyDown(int n, int n2, int n3) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT lRESULT = super.wmKeyDown(n, n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        this.ignoreDefaultSelection = false;
        if (n2 == 13 && (this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0, 0) != 0) {
            this.ignoreDefaultSelection = true;
        }
        return lRESULT;
    }

    LRESULT wmSysKeyDown(int n, int n2, int n3) {
        int n4 = OS.SendMessage(this.handle, 327, 0, 0);
        LRESULT lRESULT = super.wmSysKeyDown(n, n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.style & 8) == 0 && n2 == 40) {
            int n5 = this.callWindowProc(n, 260, n2, n3);
            int n6 = OS.SendMessage(this.handle, 327, 0, 0);
            if (n4 != n6) {
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.sendSelectionEvent(13, null, true);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
            }
            return new LRESULT(n5);
        }
        return lRESULT;
    }
}

