/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class IME
extends Widget {
    Canvas parent;
    int caretOffset;
    int startOffset;
    int commitCount;
    String text;
    int[] ranges;
    TextStyle[] styles;
    static final int UNDERLINE_THICK = 65536;

    IME() {
    }

    public IME(Canvas canvas, int n) {
        super(canvas, n);
        this.parent = canvas;
        this.createWidget();
    }

    long attributedSubstringFromRange(long l, long l2, long l3) {
        Event event = new Event();
        event.detail = 3;
        this.sendEvent(43, event);
        NSRange nSRange = new NSRange();
        OS.memmove(nSRange, l3, (long)NSRange.sizeof);
        int n = (int)nSRange.location;
        int n2 = (int)(nSRange.location + nSRange.length);
        if (event.start <= n && n <= event.end && event.start <= n2 && n2 <= event.end) {
            NSString nSString = (NSString)new NSString().alloc();
            nSString = nSString.initWithString(event.text.substring(n - event.start, n2 - event.start));
            NSAttributedString nSAttributedString = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(nSString, null);
            nSString.release();
            nSAttributedString.autorelease();
            return nSAttributedString.id;
        }
        return 0L;
    }

    long characterIndexForPoint(long l, long l2, long l3) {
        if (!this.isInlineEnabled()) {
            return Integer.MAX_VALUE;
        }
        NSPoint nSPoint = new NSPoint();
        OS.memmove(nSPoint, l3, (long)NSPoint.sizeof);
        NSView nSView = this.parent.view;
        nSPoint = nSView.window().convertScreenToBase(nSPoint);
        nSPoint = nSView.convertPoint_fromView_(nSPoint, null);
        Event event = new Event();
        event.detail = 2;
        event.x = (int)nSPoint.x;
        event.y = (int)nSPoint.y;
        this.sendEvent(43, event);
        int n = event.index + event.count;
        return n != -1 ? n : Integer.MAX_VALUE;
    }

    void createWidget() {
        this.text = "";
        this.startOffset = -1;
        if (this.parent.getIME() == null) {
            this.parent.setIME(this);
        }
    }

    NSRect firstRectForCharacterRange(long l, long l2, long l3) {
        NSRect nSRect = new NSRect();
        Caret caret = this.parent.caret;
        if (caret != null) {
            NSView nSView = this.parent.view;
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = caret.x;
            nSPoint.y = caret.y + caret.height;
            nSPoint = nSView.convertPoint_toView_(nSPoint, null);
            nSPoint = nSView.window().convertBaseToScreen(nSPoint);
            nSRect.x = nSPoint.x;
            nSRect.y = nSPoint.y;
            nSRect.width = caret.width;
            nSRect.height = caret.height;
        }
        return nSRect;
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.startOffset + this.caretOffset;
    }

    public int getCommitCount() {
        this.checkWidget();
        return this.commitCount;
    }

    public int getCompositionOffset() {
        this.checkWidget();
        return this.startOffset;
    }

    public int[] getRanges() {
        this.checkWidget();
        if (this.ranges == null) {
            return new int[0];
        }
        int[] nArray = new int[this.ranges.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.ranges[n] + this.startOffset;
            ++n;
        }
        return nArray;
    }

    public TextStyle[] getStyles() {
        this.checkWidget();
        if (this.styles == null) {
            return new TextStyle[0];
        }
        TextStyle[] textStyleArray = new TextStyle[this.styles.length];
        System.arraycopy(this.styles, 0, textStyleArray, 0, this.styles.length);
        return textStyleArray;
    }

    TextStyle getStyle(NSDictionary nSDictionary) {
        NSArray nSArray = nSDictionary.allKeys();
        long l = nSArray.count();
        TextStyle textStyle = new TextStyle();
        int n = 0;
        while ((long)n < l) {
            double[] dArray;
            NSObject nSObject;
            NSString nSString = new NSString(nSArray.objectAtIndex(n));
            if (nSString.isEqualTo(OS.NSBackgroundColorAttributeName)) {
                nSObject = new NSColor(nSDictionary.objectForKey(nSString)).colorUsingColorSpaceName(OS.NSCalibratedRGBColorSpace);
                dArray = new double[]{((NSColor)nSObject).redComponent(), ((NSColor)nSObject).greenComponent(), ((NSColor)nSObject).blueComponent(), ((NSColor)nSObject).alphaComponent()};
                textStyle.background = Color.cocoa_new(this.display, dArray);
            } else if (nSString.isEqualTo(OS.NSForegroundColorAttributeName)) {
                nSObject = new NSColor(nSDictionary.objectForKey(nSString)).colorUsingColorSpaceName(OS.NSCalibratedRGBColorSpace);
                dArray = new double[]{((NSColor)nSObject).redComponent(), ((NSColor)nSObject).greenComponent(), ((NSColor)nSObject).blueComponent(), ((NSColor)nSObject).alphaComponent()};
                textStyle.foreground = Color.cocoa_new(this.display, dArray);
            } else if (nSString.isEqualTo(OS.NSUnderlineColorAttributeName)) {
                nSObject = new NSColor(nSDictionary.objectForKey(nSString)).colorUsingColorSpaceName(OS.NSCalibratedRGBColorSpace);
                dArray = new double[]{((NSColor)nSObject).redComponent(), ((NSColor)nSObject).greenComponent(), ((NSColor)nSObject).blueComponent(), ((NSColor)nSObject).alphaComponent()};
                textStyle.underlineColor = Color.cocoa_new(this.display, dArray);
            } else if (nSString.isEqualTo(OS.NSUnderlineStyleAttributeName)) {
                nSObject = new NSNumber(nSDictionary.objectForKey(nSString));
                switch (((NSNumber)nSObject).intValue()) {
                    case 1: {
                        textStyle.underlineStyle = 0;
                        break;
                    }
                    case 9: {
                        textStyle.underlineStyle = 1;
                        break;
                    }
                    case 2: {
                        textStyle.underlineStyle = 65536;
                    }
                }
                textStyle.underline = ((NSNumber)nSObject).intValue() != 0;
            } else if (nSString.isEqualTo(OS.NSStrikethroughColorAttributeName)) {
                nSObject = new NSColor(nSDictionary.objectForKey(nSString)).colorUsingColorSpaceName(OS.NSCalibratedRGBColorSpace);
                dArray = new double[]{((NSColor)nSObject).redComponent(), ((NSColor)nSObject).greenComponent(), ((NSColor)nSObject).blueComponent(), ((NSColor)nSObject).alphaComponent()};
                textStyle.strikeoutColor = Color.cocoa_new(this.display, dArray);
            } else if (nSString.isEqualTo(OS.NSStrikethroughStyleAttributeName)) {
                nSObject = new NSNumber(nSDictionary.objectForKey(nSString));
                textStyle.strikeout = ((NSNumber)nSObject).intValue() != 0;
            } else if (nSString.isEqualTo(OS.NSFontAttributeName)) {
                nSObject = new NSFont(nSDictionary.objectForKey(nSString));
                nSObject.retain();
                textStyle.font = Font.cocoa_new(this.display, (NSFont)nSObject);
            }
            ++n;
        }
        return textStyle;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getWideCaret() {
        return false;
    }

    boolean hasMarkedText(long l, long l2) {
        return this.text.length() != 0;
    }

    boolean insertText(long l, long l2, long l3) {
        if (this.startOffset == -1) {
            return true;
        }
        NSString nSString = new NSString(l3);
        if (nSString.isKindOfClass(OS.class_NSAttributedString)) {
            nSString = new NSAttributedString(l3).string();
        }
        int n = (int)nSString.length();
        int n2 = this.startOffset + this.text.length();
        this.resetStyles();
        this.caretOffset = this.commitCount = n;
        Event event = new Event();
        event.detail = 1;
        event.start = this.startOffset;
        event.end = n2;
        event.text = this.text = nSString.getString();
        this.sendEvent(43, event);
        this.text = "";
        this.commitCount = 0;
        this.caretOffset = 0;
        this.startOffset = -1;
        return event.doit;
    }

    boolean isInlineEnabled() {
        return this.hooks(43);
    }

    NSRange markedRange(long l, long l2) {
        NSRange nSRange = new NSRange();
        if (this.startOffset != -1) {
            nSRange.location = this.startOffset;
            nSRange.length = this.text.length();
        } else {
            nSRange.location = Integer.MAX_VALUE;
        }
        return nSRange;
    }

    void resetStyles() {
        if (this.styles != null) {
            int n = 0;
            while (n < this.styles.length) {
                TextStyle textStyle = this.styles[n];
                Font font = textStyle.font;
                if (font != null) {
                    font.handle.release();
                }
                ++n;
            }
        }
        this.styles = null;
        this.ranges = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getIME()) {
            this.parent.setIME(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.text = null;
        this.resetStyles();
    }

    NSRange selectedRange(long l, long l2) {
        Event event = new Event();
        event.detail = 3;
        this.sendEvent(43, event);
        NSRange nSRange = new NSRange();
        nSRange.location = event.start;
        nSRange.length = event.text.length();
        return nSRange;
    }

    public void setCompositionOffset(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (this.startOffset != -1) {
            this.startOffset = n;
        }
    }

    boolean setMarkedText_selectedRange(long l, long l2, long l3, long l4) {
        Object object;
        Object object2;
        Object object3;
        if (!this.isInlineEnabled()) {
            return true;
        }
        this.resetStyles();
        this.commitCount = 0;
        this.caretOffset = 0;
        int n = this.startOffset + this.text.length();
        if (this.startOffset == -1) {
            object3 = new Event();
            ((Event)object3).detail = 3;
            this.sendEvent(43, (Event)object3);
            this.startOffset = ((Event)object3).start;
            n = ((Event)object3).end;
        }
        if (((NSObject)(object3 = new NSString(l3))).isKindOfClass(OS.class_NSAttributedString)) {
            Object object4;
            NSAttributedString nSAttributedString = new NSAttributedString(l3);
            object3 = nSAttributedString.string();
            int n2 = (int)((NSString)object3).length();
            this.styles = new TextStyle[n2];
            this.ranges = new int[n2 * 2];
            object2 = new NSRange();
            object = new NSRange();
            ((NSRange)object2).length = n2;
            int n3 = 0;
            long l5 = OS.malloc(NSRange.sizeof);
            int n4 = 0;
            while (n4 < n2) {
                object4 = nSAttributedString.attributesAtIndex(n4, l5, (NSRange)object2);
                OS.memmove((NSRange)object, l5, (long)NSRange.sizeof);
                n4 = (int)(((NSRange)object).location + ((NSRange)object).length);
                this.ranges[n3 * 2] = (int)((NSRange)object).location;
                this.ranges[n3 * 2 + 1] = (int)(((NSRange)object).location + ((NSRange)object).length - 1L);
                this.styles[n3++] = this.getStyle((NSDictionary)object4);
            }
            OS.free(l5);
            if (n3 != this.styles.length) {
                TextStyle[] textStyleArray = new TextStyle[n3];
                System.arraycopy(this.styles, 0, textStyleArray, 0, textStyleArray.length);
                this.styles = textStyleArray;
                object4 = new int[n3 * 2];
                System.arraycopy(this.ranges, 0, object4, 0, ((Object)object4).length);
                this.ranges = (int[])object4;
            }
        }
        int n5 = (int)((NSString)object3).length();
        if (this.ranges == null && n5 > 0) {
            this.styles = new TextStyle[]{this.getStyle(this.display.markedAttributes)};
            int[] nArray = new int[2];
            nArray[1] = n5 - 1;
            this.ranges = nArray;
        }
        NSRange nSRange = new NSRange();
        OS.memmove(nSRange, l4, (long)NSRange.sizeof);
        this.caretOffset = (int)nSRange.location;
        object2 = new Event();
        ((Event)object2).detail = 1;
        ((Event)object2).start = this.startOffset;
        ((Event)object2).end = n;
        ((Event)object2).text = this.text = ((NSString)object3).getString();
        this.sendEvent(43, (Event)object2);
        if (this.isDisposed()) {
            return false;
        }
        if (this.text.length() == 0) {
            object = this.parent.getShell();
            ((Shell)object).keyInputHappened = true;
            this.startOffset = -1;
            this.resetStyles();
        }
        return true;
    }

    long validAttributesForMarkedText(long l, long l2) {
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(6L);
        nSMutableArray.addObject(new NSString(OS.NSForegroundColorAttributeName()));
        nSMutableArray.addObject(new NSString(OS.NSBackgroundColorAttributeName()));
        nSMutableArray.addObject(new NSString(OS.NSUnderlineStyleAttributeName()));
        nSMutableArray.addObject(new NSString(OS.NSUnderlineColorAttributeName()));
        nSMutableArray.addObject(new NSString(OS.NSStrikethroughStyleAttributeName()));
        nSMutableArray.addObject(new NSString(OS.NSStrikethroughColorAttributeName()));
        return nSMutableArray.id;
    }
}

