/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ForwardedTCPIPDaemon;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import java.net.Socket;
import java.util.Vector;

public class ChannelForwardedTCPIP
extends Channel {
    static Vector pool = new Vector();
    private static final int LOCAL_WINDOW_SIZE_MAX = 131072;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    SocketFactory factory = null;
    String target;
    int lport;
    int rport;

    ChannelForwardedTCPIP() {
        this.setLocalWindowSizeMax(131072);
        this.setLocalWindowSize(131072);
        this.setLocalPacketSize(16384);
    }

    void init() {
        try {
            this.io = new IO();
            if (this.lport == -1) {
                Class<?> clazz = Class.forName(this.target);
                ForwardedTCPIPDaemon forwardedTCPIPDaemon = (ForwardedTCPIPDaemon)clazz.newInstance();
                forwardedTCPIPDaemon.setChannel(this);
                Object[] objectArray = ChannelForwardedTCPIP.getPort(this.session, this.rport);
                forwardedTCPIPDaemon.setArg((Object[])objectArray[3]);
                new Thread(forwardedTCPIPDaemon).start();
                this.connected = true;
                return;
            }
            Socket socket = this.factory == null ? new Socket(this.target, this.lport) : this.factory.createSocket(this.target, this.lport);
            socket.setTcpNoDelay(true);
            this.io.setInputStream(socket.getInputStream());
            this.io.setOutputStream(socket.getOutputStream());
            this.connected = true;
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void run() {
        this.thread = Thread.currentThread();
        Buffer buffer = new Buffer(this.rmpsize);
        Packet packet = new Packet(buffer);
        int n = 0;
        try {
            while (this.thread != null && this.io != null && this.io.in != null) {
                n = this.io.in.read(buffer.buffer, 14, buffer.buffer.length - 14 - 32 - 20);
                if (n <= 0) {
                    this.eof();
                } else {
                    packet.reset();
                    if (!this.close) {
                        buffer.putByte((byte)94);
                        buffer.putInt(this.recipient);
                        buffer.putInt(n);
                        buffer.skip(n);
                        this.session.write(packet, this, n);
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getData(Buffer buffer) {
        this.setRecipient(buffer.getInt());
        this.setRemoteWindowSize(buffer.getInt());
        this.setRemotePacketSize(buffer.getInt());
        byte[] byArray = buffer.getString();
        int n = buffer.getInt();
        byte[] byArray2 = buffer.getString();
        int n2 = buffer.getInt();
        Vector vector = pool;
        synchronized (vector) {
            for (int i = 0; i < pool.size(); ++i) {
                Object[] objectArray = (Object[])pool.elementAt(i);
                if (objectArray[0] != this.session || (Integer)objectArray[1] != n) continue;
                this.rport = n;
                this.target = (String)objectArray[2];
                this.lport = objectArray[3] == null || objectArray[3] instanceof Object[] ? -1 : (Integer)objectArray[3];
                if (objectArray.length < 5) break;
                this.factory = (SocketFactory)objectArray[4];
                break;
            }
            if (this.target == null) {
                System.out.println("??");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object[] getPort(Session session, int n) {
        Vector vector = pool;
        synchronized (vector) {
            for (int i = 0; i < pool.size(); ++i) {
                Object[] objectArray = (Object[])pool.elementAt(i);
                if (objectArray[0] != session || (Integer)objectArray[1] != n) continue;
                return objectArray;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getPortForwarding(Session session) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = pool;
        synchronized (pool) {
            int n;
            for (n = 0; n < pool.size(); ++n) {
                Object[] objectArray = (Object[])pool.elementAt(n);
                if (objectArray[0] != session) continue;
                if (objectArray[3] == null) {
                    vector.addElement(objectArray[1] + ":" + objectArray[2] + ":");
                    continue;
                }
                vector.addElement(objectArray[1] + ":" + objectArray[2] + ":" + objectArray[3]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            stringArray = new String[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                stringArray[n] = (String)vector.elementAt(n);
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addPort(Session session, int n, String string, int n2, SocketFactory socketFactory) throws JSchException {
        Vector vector = pool;
        synchronized (vector) {
            if (ChannelForwardedTCPIP.getPort(session, n) != null) {
                throw new JSchException("PortForwardingR: remote port " + n + " is already registered.");
            }
            Object[] objectArray = new Object[]{session, new Integer(n), string, new Integer(n2), socketFactory};
            pool.addElement(objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addPort(Session session, int n, String string, Object[] objectArray) throws JSchException {
        Vector vector = pool;
        synchronized (vector) {
            if (ChannelForwardedTCPIP.getPort(session, n) != null) {
                throw new JSchException("PortForwardingR: remote port " + n + " is already registered.");
            }
            Object[] objectArray2 = new Object[]{session, new Integer(n), string, objectArray};
            pool.addElement(objectArray2);
        }
    }

    static void delPort(ChannelForwardedTCPIP channelForwardedTCPIP) {
        ChannelForwardedTCPIP.delPort(channelForwardedTCPIP.session, channelForwardedTCPIP.rport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session, int n) {
        Object[] objectArray;
        Object object = pool;
        synchronized (object) {
            objectArray = null;
            for (int i = 0; i < pool.size(); ++i) {
                Object[] objectArray2 = (Object[])pool.elementAt(i);
                if (objectArray2[0] != session || (Integer)objectArray2[1] != n) continue;
                objectArray = objectArray2;
                break;
            }
            if (objectArray == null) {
                return;
            }
            pool.removeElement(objectArray);
        }
        object = new Buffer(100);
        objectArray = new Packet((Buffer)object);
        try {
            objectArray.reset();
            ((Buffer)object).putByte((byte)80);
            ((Buffer)object).putString("cancel-tcpip-forward".getBytes());
            ((Buffer)object).putByte((byte)0);
            ((Buffer)object).putString("0.0.0.0".getBytes());
            ((Buffer)object).putInt(n);
            session.write((Packet)objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session) {
        int[] nArray = null;
        int n = 0;
        Vector vector = pool;
        synchronized (vector) {
            nArray = new int[pool.size()];
            for (int i = 0; i < pool.size(); ++i) {
                Object[] objectArray = (Object[])pool.elementAt(i);
                if (objectArray[0] != session) continue;
                nArray[n++] = (Integer)objectArray[1];
            }
        }
        for (int i = 0; i < n; ++i) {
            ChannelForwardedTCPIP.delPort(session, nArray[i]);
        }
    }

    public int getRemotePort() {
        return this.rport;
    }

    void setSocketFactory(SocketFactory socketFactory) {
        this.factory = socketFactory;
    }
}

