/*
 * Decompiled with CFR 0.152.
 */
package org.ccil.cowan.tagsoup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Writer;
import org.ccil.cowan.tagsoup.PYXWriter;
import org.ccil.cowan.tagsoup.ScanHandler;
import org.ccil.cowan.tagsoup.Scanner;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class HTMLScanner
implements Scanner,
Locator {
    private static final int S_ANAME = 1;
    private static final int S_APOS = 2;
    private static final int S_AVAL = 3;
    private static final int S_BB = 4;
    private static final int S_BBC = 5;
    private static final int S_BBCD = 6;
    private static final int S_BBCDA = 7;
    private static final int S_BBCDAT = 8;
    private static final int S_BBCDATA = 9;
    private static final int S_CCRLF = 10;
    private static final int S_CDATA = 11;
    private static final int S_CDATA2 = 12;
    private static final int S_CDSECT = 13;
    private static final int S_CDSECT1 = 14;
    private static final int S_CDSECT2 = 15;
    private static final int S_COM = 16;
    private static final int S_COM2 = 17;
    private static final int S_COM3 = 18;
    private static final int S_COM4 = 19;
    private static final int S_COMCRLF = 20;
    private static final int S_CRLF = 21;
    private static final int S_DECL = 22;
    private static final int S_DECL2 = 23;
    private static final int S_DONE = 24;
    private static final int S_EMPTYTAG = 25;
    private static final int S_ENT = 26;
    private static final int S_EQ = 27;
    private static final int S_ETAG = 28;
    private static final int S_GI = 29;
    private static final int S_NCR = 30;
    private static final int S_PCDATA = 31;
    private static final int S_PI = 32;
    private static final int S_PICRLF = 33;
    private static final int S_PITARGET = 34;
    private static final int S_QUOT = 35;
    private static final int S_STAGC = 36;
    private static final int S_TAG = 37;
    private static final int S_TAGWS = 38;
    private static final int S_XNCR = 39;
    private static final int A_ADUP = 1;
    private static final int A_ADUP_SAVE = 2;
    private static final int A_ADUP_STAGC = 3;
    private static final int A_ANAME = 4;
    private static final int A_ANAME_ADUP = 5;
    private static final int A_ANAME_ADUP_STAGC = 6;
    private static final int A_AVAL = 7;
    private static final int A_AVAL_STAGC = 8;
    private static final int A_CDATA = 9;
    private static final int A_CMNT = 10;
    private static final int A_DECL = 11;
    private static final int A_EMPTYTAG = 12;
    private static final int A_ENTITY = 13;
    private static final int A_ETAG = 14;
    private static final int A_GI = 15;
    private static final int A_GI_STAGC = 16;
    private static final int A_LF = 17;
    private static final int A_LT = 18;
    private static final int A_LT_PCDATA = 19;
    private static final int A_MINUS = 20;
    private static final int A_MINUS2 = 21;
    private static final int A_MINUS3 = 22;
    private static final int A_PCDATA = 23;
    private static final int A_PCDATA_SAVE_PUSH = 24;
    private static final int A_PI = 25;
    private static final int A_PITARGET = 26;
    private static final int A_PITARGET_PI = 27;
    private static final int A_SAVE = 28;
    private static final int A_SAVE_PUSH = 29;
    private static final int A_SKIP = 30;
    private static final int A_SP = 31;
    private static final int A_STAGC = 32;
    private static final int A_UNGET = 33;
    private static final int A_UNSAVE_PCDATA = 34;
    private static int[] statetable = new int[]{1, 47, 5, 25, 1, 61, 4, 3, 1, 62, 6, 31, 1, 0, 28, 1, 1, -1, 6, 24, 1, 32, 4, 27, 1, 13, 4, 27, 1, 10, 4, 27, 1, 9, 4, 27, 2, 38, 29, 26, 2, 39, 7, 38, 2, 0, 28, 2, 2, -1, 8, 24, 2, 32, 31, 2, 2, 13, 31, 2, 2, 10, 31, 2, 2, 9, 31, 2, 3, 34, 30, 35, 3, 39, 30, 2, 3, 62, 8, 31, 3, 0, 28, 36, 3, -1, 8, 24, 3, 32, 30, 3, 3, 13, 30, 3, 3, 10, 30, 3, 3, 9, 30, 3, 4, 67, 30, 5, 4, 0, 30, 22, 4, -1, 30, 24, 5, 68, 30, 6, 5, 0, 30, 22, 5, -1, 30, 24, 6, 65, 30, 7, 6, 0, 30, 22, 6, -1, 30, 24, 7, 84, 30, 8, 7, 0, 30, 22, 7, -1, 30, 24, 8, 65, 30, 9, 8, 0, 30, 22, 8, -1, 30, 24, 9, 91, 30, 13, 9, 0, 30, 22, 9, -1, 30, 24, 10, 0, 33, 11, 10, -1, 30, 24, 10, 10, 30, 11, 11, 60, 28, 12, 11, 13, 17, 10, 11, 0, 28, 11, 11, -1, 23, 24, 12, 47, 34, 28, 12, 0, 28, 11, 12, -1, 34, 24, 13, 93, 28, 14, 13, 0, 28, 13, 13, -1, 30, 24, 14, 93, 28, 15, 14, 0, 28, 13, 14, -1, 30, 24, 15, 62, 9, 31, 15, 0, 28, 13, 15, -1, 30, 24, 16, 45, 30, 17, 16, 13, 17, 20, 16, 0, 28, 17, 16, -1, 10, 24, 17, 45, 30, 18, 17, 13, 17, 20, 17, 0, 28, 17, 17, -1, 10, 24, 18, 45, 30, 19, 18, 13, 17, 20, 18, 0, 20, 17, 18, -1, 10, 24, 19, 45, 22, 19, 19, 62, 10, 31, 19, 13, 17, 20, 19, 0, 21, 17, 19, -1, 10, 24, 20, 0, 33, 16, 20, -1, 10, 24, 20, 10, 30, 16, 21, 0, 33, 31, 21, -1, 30, 24, 21, 10, 30, 31, 22, 45, 30, 16, 22, 62, 30, 31, 22, 91, 30, 4, 22, 0, 28, 23, 22, -1, 30, 24, 23, 62, 11, 31, 23, 0, 28, 23, 23, -1, 30, 24, 25, 62, 12, 31, 25, 0, 28, 1, 25, 32, 30, 38, 25, 13, 30, 38, 25, 10, 30, 38, 25, 9, 30, 38, 26, 0, 13, 26, 26, -1, 13, 24, 27, 61, 30, 3, 27, 62, 3, 31, 27, 0, 2, 1, 27, -1, 3, 24, 27, 32, 30, 27, 27, 13, 30, 27, 27, 10, 30, 27, 27, 9, 30, 27, 28, 62, 14, 31, 28, 0, 28, 28, 28, -1, 14, 24, 28, 32, 30, 28, 28, 13, 30, 28, 28, 10, 30, 28, 28, 9, 30, 28, 29, 47, 30, 25, 29, 62, 16, 31, 29, 0, 28, 29, 29, -1, 30, 24, 29, 32, 15, 38, 29, 13, 15, 38, 29, 10, 15, 38, 29, 9, 15, 38, 30, 0, 13, 30, 30, -1, 13, 24, 31, 38, 24, 26, 31, 60, 23, 37, 31, 13, 17, 21, 31, 0, 28, 31, 31, -1, 23, 24, 32, 62, 25, 31, 32, 13, 17, 33, 32, 0, 28, 32, 32, -1, 25, 24, 33, 0, 33, 32, 33, -1, 25, 24, 33, 10, 30, 32, 34, 62, 27, 31, 34, 0, 28, 34, 34, -1, 27, 24, 34, 32, 26, 32, 34, 13, 26, 32, 34, 10, 26, 32, 34, 9, 26, 32, 35, 34, 7, 38, 35, 38, 29, 26, 35, 0, 28, 35, 35, -1, 8, 24, 35, 32, 31, 35, 35, 13, 31, 35, 35, 10, 31, 35, 35, 9, 31, 35, 36, 62, 8, 31, 36, 0, 28, 36, 36, -1, 8, 24, 36, 32, 7, 38, 36, 13, 7, 38, 36, 10, 7, 38, 36, 9, 7, 38, 37, 33, 30, 22, 37, 47, 30, 28, 37, 63, 30, 34, 37, 0, 28, 29, 37, -1, 19, 24, 37, 32, 18, 31, 37, 13, 18, 31, 37, 10, 18, 31, 37, 9, 18, 31, 38, 47, 30, 25, 38, 62, 32, 31, 38, 0, 28, 1, 38, -1, 32, 24, 38, 32, 30, 38, 38, 13, 30, 38, 38, 10, 30, 38, 38, 9, 30, 38, 39, 0, 13, 39, 39, -1, 13, 24};
    private static final String[] debug_actionnames = new String[]{"", "A_ADUP", "A_ADUP_SAVE", "A_ADUP_STAGC", "A_ANAME", "A_ANAME_ADUP", "A_ANAME_ADUP_STAGC", "A_AVAL", "A_AVAL_STAGC", "A_CDATA", "A_CMNT", "A_DECL", "A_EMPTYTAG", "A_ENTITY", "A_ETAG", "A_GI", "A_GI_STAGC", "A_LF", "A_LT", "A_LT_PCDATA", "A_MINUS", "A_MINUS2", "A_MINUS3", "A_PCDATA", "A_PCDATA_SAVE_PUSH", "A_PI", "A_PITARGET", "A_PITARGET_PI", "A_SAVE", "A_SAVE_PUSH", "A_SKIP", "A_SP", "A_STAGC", "A_UNGET", "A_UNSAVE_PCDATA"};
    private static final String[] debug_statenames = new String[]{"", "S_ANAME", "S_APOS", "S_AVAL", "S_BB", "S_BBC", "S_BBCD", "S_BBCDA", "S_BBCDAT", "S_BBCDATA", "S_CCRLF", "S_CDATA", "S_CDATA2", "S_CDSECT", "S_CDSECT1", "S_CDSECT2", "S_COM", "S_COM2", "S_COM3", "S_COM4", "S_COMCRLF", "S_CRLF", "S_DECL", "S_DECL2", "S_DONE", "S_EMPTYTAG", "S_ENT", "S_EQ", "S_ETAG", "S_GI", "S_NCR", "S_PCDATA", "S_PI", "S_PICRLF", "S_PITARGET", "S_QUOT", "S_STAGC", "S_TAG", "S_TAGWS", "S_XNCR"};
    private String thePublicid;
    private String theSystemid;
    private int theLastLine;
    private int theLastColumn;
    private int theCurrentLine;
    private int theCurrentColumn;
    int theState;
    int theNextState;
    char[] theOutputBuffer = new char[200];
    int theSize;
    int[] theWinMap = new int[]{8364, 65533, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 352, 8249, 338, 65533, 381, 65533, 65533, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 732, 8482, 353, 8250, 339, 65533, 382, 376};

    private void unread(PushbackReader r, int c) throws IOException {
        if (c != -1) {
            r.unread(c);
        }
    }

    public int getLineNumber() {
        return this.theLastLine;
    }

    public int getColumnNumber() {
        return this.theLastColumn;
    }

    public String getPublicId() {
        return this.thePublicid;
    }

    public String getSystemId() {
        return this.theSystemid;
    }

    public void resetDocumentLocator(String publicid, String systemid) {
        this.thePublicid = publicid;
        this.theSystemid = systemid;
        this.theCurrentColumn = 0;
        this.theCurrentLine = 0;
        this.theLastColumn = 0;
        this.theLastLine = 0;
    }

    public void scan(Reader r0, ScanHandler h) throws IOException, SAXException {
        this.theState = 31;
        int savedState = 0;
        int savedSize = 0;
        PushbackReader r = r0 instanceof PushbackReader ? (PushbackReader)r0 : (r0 instanceof BufferedReader ? new PushbackReader(r0) : new PushbackReader(new BufferedReader(r0)));
        int firstChar = r.read();
        if (firstChar != 65279 && firstChar != -1) {
            r.unread(firstChar);
        }
        while (this.theState != 24) {
            int ch = r.read();
            if (ch >= 128 && ch <= 159) {
                ch = this.theWinMap[ch - 128];
            }
            if (ch == 10) {
                ++this.theCurrentLine;
                this.theCurrentColumn = 0;
            } else {
                ++this.theCurrentColumn;
            }
            if (ch < 32 && ch != 10 && ch != 13 && ch != 9 && ch != -1) continue;
            int action = 0;
            for (int i = 0; i < statetable.length; i += 4) {
                if (this.theState != statetable[i]) {
                    if (action == 0) continue;
                    break;
                }
                if (statetable[i + 1] == 0) {
                    action = statetable[i + 2];
                    this.theNextState = statetable[i + 3];
                    continue;
                }
                if (statetable[i + 1] != ch) continue;
                action = statetable[i + 2];
                this.theNextState = statetable[i + 3];
                break;
            }
            switch (action) {
                case 0: {
                    throw new Error("HTMLScanner can't cope with " + Integer.toString(ch) + " in state " + Integer.toString(this.theState));
                }
                case 1: {
                    h.adup(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 2: {
                    h.adup(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    this.save(ch, h);
                    break;
                }
                case 3: {
                    h.adup(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    h.stagc(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 4: {
                    h.aname(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 5: {
                    h.aname(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    h.adup(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 6: {
                    h.aname(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    h.adup(this.theOutputBuffer, 0, this.theSize);
                    h.stagc(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 7: {
                    h.aval(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 8: {
                    h.aval(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    h.stagc(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 9: {
                    this.mark();
                    if (this.theSize > 1) {
                        this.theSize -= 2;
                    }
                    h.pcdata(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 13: {
                    this.mark();
                    char ch1 = (char)ch;
                    if (this.theState == 26 && ch1 == '#') {
                        this.theNextState = 30;
                        this.save(ch, h);
                        break;
                    }
                    if (this.theState == 30 && (ch1 == 'x' || ch1 == 'X')) {
                        this.theNextState = 39;
                        this.save(ch, h);
                        break;
                    }
                    if (this.theState == 26 && Character.isLetterOrDigit(ch1)) {
                        this.save(ch, h);
                        break;
                    }
                    if (this.theState == 30 && Character.isDigit(ch1)) {
                        this.save(ch, h);
                        break;
                    }
                    if (this.theState == 39 && (Character.isDigit(ch1) || "abcdefABCDEF".indexOf(ch1) != -1)) {
                        this.save(ch, h);
                        break;
                    }
                    h.entity(this.theOutputBuffer, savedSize + 1, this.theSize - savedSize - 1);
                    int ent = h.getEntity();
                    if (ent != 0) {
                        this.theSize = savedSize;
                        if (ent >= 128 && ent <= 159) {
                            ent = this.theWinMap[ent - 128];
                        }
                        if (ent < 32) {
                            ent = 32;
                        }
                        if (ent < 65536) {
                            this.save(ent, h);
                        } else {
                            this.save(((ent -= 65536) >> 10) + 55296, h);
                            this.save((ent & 0x3FF) + 56320, h);
                        }
                        if (ch != 59) {
                            this.unread(r, ch);
                            --this.theCurrentColumn;
                        }
                    } else {
                        this.unread(r, ch);
                        --this.theCurrentColumn;
                    }
                    this.theNextState = savedState;
                    break;
                }
                case 14: {
                    h.etag(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 11: {
                    h.decl(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 15: {
                    h.gi(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 16: {
                    h.gi(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    h.stagc(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 17: {
                    this.save(10, h);
                    break;
                }
                case 18: {
                    this.mark();
                    this.save(60, h);
                    break;
                }
                case 19: {
                    this.mark();
                    this.save(60, h);
                    h.pcdata(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 23: {
                    this.mark();
                    h.pcdata(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 10: {
                    this.mark();
                    h.cmnt(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 22: {
                    this.save(45, h);
                    this.save(32, h);
                    break;
                }
                case 21: {
                    this.save(45, h);
                    this.save(32, h);
                }
                case 20: {
                    this.save(45, h);
                    this.save(ch, h);
                    break;
                }
                case 25: {
                    this.mark();
                    h.pi(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 26: {
                    h.pitarget(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 27: {
                    h.pitarget(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    h.pi(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 24: {
                    h.pcdata(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                }
                case 29: {
                    savedState = this.theState;
                    savedSize = this.theSize;
                }
                case 28: {
                    this.save(ch, h);
                    break;
                }
                case 30: {
                    break;
                }
                case 31: {
                    this.save(32, h);
                    break;
                }
                case 32: {
                    h.stagc(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 12: {
                    this.mark();
                    if (this.theSize > 0) {
                        h.gi(this.theOutputBuffer, 0, this.theSize);
                    }
                    this.theSize = 0;
                    h.stage(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 33: {
                    this.unread(r, ch);
                    --this.theCurrentColumn;
                    break;
                }
                case 34: {
                    if (this.theSize > 0) {
                        --this.theSize;
                    }
                    h.pcdata(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                default: {
                    throw new Error("Can't process state " + action);
                }
            }
            this.theState = this.theNextState;
        }
        h.eof(this.theOutputBuffer, 0, 0);
    }

    private void mark() {
        this.theLastColumn = this.theCurrentColumn;
        this.theLastLine = this.theCurrentLine;
    }

    public void startCDATA() {
        this.theNextState = 11;
    }

    private void save(int ch, ScanHandler h) throws IOException, SAXException {
        if (this.theSize >= this.theOutputBuffer.length - 20) {
            if (this.theState == 31 || this.theState == 11) {
                h.pcdata(this.theOutputBuffer, 0, this.theSize);
                this.theSize = 0;
            } else {
                char[] newOutputBuffer = new char[this.theOutputBuffer.length * 2];
                System.arraycopy(this.theOutputBuffer, 0, newOutputBuffer, 0, this.theSize + 1);
                this.theOutputBuffer = newOutputBuffer;
            }
        }
        this.theOutputBuffer[this.theSize++] = (char)ch;
    }

    public static void main(String[] argv) throws IOException, SAXException {
        HTMLScanner s = new HTMLScanner();
        InputStreamReader r = new InputStreamReader(System.in, "UTF-8");
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
        PYXWriter pw = new PYXWriter(w);
        s.scan(r, pw);
        ((Writer)w).close();
    }

    private static final String nicechar(int in) {
        if (in == 10) {
            return "\n";
        }
        if (in == 13) {
            return "\r";
        }
        if (in < 32) {
            return "0x" + Integer.toHexString(in);
        }
        return "'" + (char)in + "'";
    }
}

