/*
 * Decompiled with CFR 0.152.
 */
package com.centeredwork.xilize;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.ParseException;
import bsh.TargetError;
import com.centeredwork.xilize.Task;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BeanShell {
    private Interpreter interpreter;

    public BeanShell() {
        this.init();
    }

    public BeanShell newInstance() {
        return new BeanShell();
    }

    protected void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    protected void init() {
        this.interpreter = new Interpreter();
        NameSpace nameSpace = this.interpreter.getNameSpace();
        nameSpace.importPackage("com.centeredwork.xilize");
        nameSpace.importPackage("java.util.regex");
    }

    void set(String string, Object object) {
        try {
            this.interpreter.set(string, object);
        }
        catch (EvalError evalError) {
            evalError.printStackTrace();
        }
    }

    void source(Task task, File file) {
        try {
            this.interpreter.source(file.getAbsolutePath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (EvalError evalError) {
            String string = null;
            String string2 = "0";
            String string3 = file.getAbsolutePath();
            if (evalError instanceof TargetError) {
                TargetError targetError = (TargetError)evalError;
                string = targetError.printTargetError(targetError.getTarget());
            } else if (evalError instanceof ParseException) {
                ParseException parseException = (ParseException)evalError;
                string = parseException.getMessage();
                Matcher matcher = Pattern.compile("Parse error at line (\\d+)").matcher(string);
                if (matcher.find()) {
                    string2 = matcher.group(1);
                }
            } else {
                string = evalError.getMessage();
            }
            task.report(string3 + ":" + string2 + ":" + string);
        }
    }

    Object eval(String string) throws EvalError {
        return this.interpreter.eval(string);
    }

    String exec(Task task, int n, String string) throws EvalError {
        Object object = null;
        try {
            object = this.interpreter.eval(string);
        }
        catch (EvalError evalError) {
            Object object2;
            String string2 = evalError.getMessage();
            int n2 = -1;
            if (evalError instanceof TargetError) {
                object2 = (TargetError)evalError;
                string2 = object2.getTarget().getMessage();
                n2 = evalError.getErrorLineNumber();
            } else if (evalError instanceof ParseException) {
                object2 = Pattern.compile("^Parse error at line (\\d+)").matcher(string2);
                if (((Matcher)object2).find()) {
                    n2 = new Integer(((Matcher)object2).group(1));
                }
            } else {
                n2 = evalError.getErrorLineNumber();
                if (string2.startsWith("Sourced file: inline evaluation of: ``")) {
                    int n3 = string2.indexOf(";'' : ");
                    string2 = string2.substring(n3 + ";'' : ".length());
                }
            }
            int n4 = n + n2;
            task.error(n4, string2);
            throw evalError;
        }
        return object == null ? "" : object.toString();
    }
}

