/*
 * Decompiled with CFR 0.152.
 */
package com.centeredwork.xilize;

import com.centeredwork.xilize.Key;
import com.centeredwork.xilize.Modifiers;
import com.centeredwork.xilize.SigList;
import com.centeredwork.xilize.SigTable;
import com.centeredwork.xilize.Signature;
import com.centeredwork.xilize.Task;
import com.centeredwork.xilize.XilizeException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Block {
    private Signature sig;
    private ArrayList<String> lines = new ArrayList();
    private ArrayList<Block> children;
    private Block parent;
    private int trailingBlankLineCount;
    private boolean extended;
    private boolean startBlock;
    private boolean endBlock;
    private boolean signed;
    private boolean writeChildren = true;
    private Task task;
    private int startLineNumber;
    private ArrayList<Integer> lineNumbers = new ArrayList();
    private String translation = "";
    private static final String SIGNATURE_REGEX = "^\\s*(\\w+)((?:\\(((\\w|[#,-]|\\d)+)\\)|\\{([\\S &&[^}]]+)\\}|\\[([a-zA-Z0-9-]+)\\]|\\{\\{([\\S &&[^}]]+)\\}\\}|\\\\(\\d+)|/(\\d+)|_|-|\\^|~|>|<|=|\\(+|\\)+)*)(\\.|\\.\\.)(?:$|(?: (.*)))$";
    private static final Pattern SIGNATURE_PATTERN = Pattern.compile("^\\s*(\\w+)((?:\\(((\\w|[#,-]|\\d)+)\\)|\\{([\\S &&[^}]]+)\\}|\\[([a-zA-Z0-9-]+)\\]|\\{\\{([\\S &&[^}]]+)\\}\\}|\\\\(\\d+)|/(\\d+)|_|-|\\^|~|>|<|=|\\(+|\\)+)*)(\\.|\\.\\.)(?:$|(?: (.*)))$");
    private static final Pattern FN_SIG_PATTERN = Pattern.compile("fn(\\d+)");
    private static final Pattern NOT_SIG_PATTERN = Pattern.compile("\\d+");
    private static final String SYMBOL_SIG_REGEX = "^ *((?:\\(((\\w|[#,-]|\\d)+)\\)|\\{([\\S &&[^}]]+)\\}|\\[([a-zA-Z0-9-]+)\\]|\\{\\{([\\S &&[^}]]+)\\}\\}|\\\\(\\d+)|/(\\d+)|_|-|\\^|~|>|<|=|\\(+|\\)+)*)(\\*+|#+|\\|)(?:(?:\\(((\\w|[#,-]|\\d)+)\\)|\\{([\\S &&[^}]]+)\\}|\\[([a-zA-Z0-9-]+)\\]|\\{\\{([\\S &&[^}]]+)\\}\\}|\\\\(\\d+)|/(\\d+)|_|-|\\^|~|>|<|=|\\(+|\\)+)*)(?: *$| .*$)";
    private static final Pattern SYMBOL_SIG_PATTERN = Pattern.compile("^ *((?:\\(((\\w|[#,-]|\\d)+)\\)|\\{([\\S &&[^}]]+)\\}|\\[([a-zA-Z0-9-]+)\\]|\\{\\{([\\S &&[^}]]+)\\}\\}|\\\\(\\d+)|/(\\d+)|_|-|\\^|~|>|<|=|\\(+|\\)+)*)(\\*+|#+|\\|)(?:(?:\\(((\\w|[#,-]|\\d)+)\\)|\\{([\\S &&[^}]]+)\\}|\\[([a-zA-Z0-9-]+)\\]|\\{\\{([\\S &&[^}]]+)\\}\\}|\\\\(\\d+)|/(\\d+)|_|-|\\^|~|>|<|=|\\(+|\\)+)*)(?: *$| .*$)");

    public void setWriteChildren(boolean bl) {
        this.writeChildren = bl;
    }

    public Block(Task task, int n, String string) {
        this(task, n, string, false);
    }

    Block(Task task, int n, String string, boolean bl) {
        this.startBlock = bl;
        this.task = task;
        this.startLineNumber = n;
        if (this.sigNormal(string) || this.sigSymbol(string) || this.sigAbrrev(string)) {
            this.signed = true;
        } else {
            this.sig = task.getSignature(task.value(Key._UnsignedBlockSigName_));
            this.addLine(n, string);
            this.signed = false;
        }
    }

    static Block createEndBlock(Task task, int n) {
        Block block = new Block(task, new Signature(){

            public String translate(Task task, Block block) {
                task.error(block.getLineNumber(), "end block being translated, coding error");
                return "";
            }
        });
        block.startLineNumber = n;
        block.endBlock = true;
        return block;
    }

    Block(Task task, Signature signature) {
        this.task = task;
        this.sig = signature;
        this.startLineNumber = -1;
        this.signed = true;
    }

    Block(String string) {
        this.translation = string;
    }

    public Block() {
    }

    private boolean sigNormal(String string) {
        Matcher matcher = SIGNATURE_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2) == null ? "" : matcher.group(2);
        this.extended = matcher.group(10).length() == 2;
        Matcher matcher2 = NOT_SIG_PATTERN.matcher(string2);
        if (matcher2.matches()) {
            return false;
        }
        Matcher matcher3 = FN_SIG_PATTERN.matcher(string2);
        if (matcher3.matches()) {
            this.sig = new Signature.Footnote(matcher3.group(1));
        } else {
            this.sig = this.task._getSignature(string2);
            if (this.sig == null) {
                if (!this.task.isDefined(Key._NoWarnOnLooksLikeSig_)) {
                    this.task.warning(this.startLineNumber, "\"" + string2 + string3 + matcher.group(10) + "\" looks like a signature");
                }
                return false;
            }
            this.sig = this.sig.copy();
        }
        String string4 = matcher.group(11);
        if (string4 != null) {
            this.addLine(this.startLineNumber, string4);
        }
        this.sig.setMods(this.task, string3);
        return true;
    }

    private boolean sigSymbol(String string) {
        Matcher matcher = SYMBOL_SIG_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String string2 = matcher.group(9);
        String string3 = matcher.group(10);
        char c = matcher.group(9).charAt(0);
        switch (c) {
            case '|': {
                this.addLine(this.startLineNumber, matcher.group(0));
                this.sig = new SigTable();
                break;
            }
            case '#': 
            case '*': {
                this.addLine(this.startLineNumber, matcher.group(0));
                this.sig = new SigList();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean sigAbrrev(String string) {
        if (Signature.Abbrev.isAbbrevLine(string)) {
            this.addLine(this.startLineNumber, string);
            this.sig = new Signature.Abbrev();
            return true;
        }
        return false;
    }

    public void wrapChildren(String string, String string2) {
        if (this.children == null) {
            this.setChildren(new ArrayList<Block>());
        }
        this.children.add(0, new Static(string));
        this.children.add(new Static(string2));
    }

    void addLine(int n, String string, boolean bl) {
        this.startBlock = bl;
        this.addLine(n, string);
    }

    public void addLine(int n, String string) {
        this.lines.add(string);
        this.lineNumbers.add(n);
    }

    public void removeLine(int n) {
        this.lines.remove(n);
        this.lineNumbers.remove(n);
    }

    public void setLine(int n, String string) {
        this.lines.set(n, string);
    }

    public String getLine(int n) {
        return this.lines.get(n);
    }

    public String linesAsString() {
        return this.linesAsString(0, false);
    }

    public String linesAsStringTrim() {
        return this.linesAsString(0, true);
    }

    public String linesAsString(int n) {
        return this.linesAsString(n, false);
    }

    public String linesAsStringTrim(int n) {
        return this.linesAsString(n, true);
    }

    private void wrapLine(int n, String string, StringBuilder stringBuilder) {
        if (n < 1) {
            stringBuilder.append(string);
            stringBuilder.append('\n');
            return;
        }
        do {
            if (n > string.length()) {
                stringBuilder.append(string);
                stringBuilder.append('\n');
                string = "";
                continue;
            }
            int n2 = string.lastIndexOf(32, n);
            if (n2 == -1) {
                stringBuilder.append(string + '\n');
                string = "";
                continue;
            }
            stringBuilder.append(string.substring(0, n2));
            stringBuilder.append('\n');
            string = n2 < string.length() - 1 ? string.substring(n2 + 1) : "";
        } while (!string.equals(""));
    }

    private void wrapLines(int n, StringBuilder stringBuilder, boolean bl) {
        for (String string : this.lines) {
            this.wrapLine(n, string, stringBuilder);
        }
        if (bl) {
            for (int i = 0; i < this.trailingBlankLineCount; ++i) {
                stringBuilder.append('\n');
            }
        }
    }

    public String wrapLines(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.children == null) {
            this.wrapLines(n, stringBuilder, false);
            return stringBuilder.toString();
        }
        this.wrapLines(n, stringBuilder, true);
        for (int i = 0; i < this.children.size() - 1; ++i) {
            this.children.get(i).wrapLines(n, stringBuilder, true);
        }
        if (!this.children.isEmpty()) {
            this.children.get(this.children.size() - 1).wrapLines(n, stringBuilder, false);
        }
        return stringBuilder.toString();
    }

    private String linesAsString(int n, boolean bl) {
        if (this.lines == null || this.lines.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < this.lines.size() - 1; ++i) {
            stringBuilder.append(bl ? this.lines.get(i).trim() : this.lines.get(i));
            stringBuilder.append('\n');
        }
        stringBuilder.append(bl ? this.lines.get(this.lines.size() - 1).trim() : this.lines.get(this.lines.size() - 1));
        return stringBuilder.toString();
    }

    public void exec() throws XilizeException {
        this.sig.exec(this.task, this);
    }

    void lastPass(Block block) {
    }

    public void translate() {
        this.translation = this.sig.translate(this.task, this);
    }

    public void translateLast() {
        if (this.translation == null) {
            this.translation = this.sig.translateLast(this.task, this);
        }
    }

    public void translateChildren() {
        for (Block block : this.children) {
            block.translate();
        }
    }

    public void write(PrintWriter printWriter) {
        if (this.sig.writes()) {
            this.sig.write(printWriter, this);
        } else if (this.writeChildren && this.children != null) {
            for (Block block : this.children) {
                block.write(printWriter);
            }
        } else if (this.translation != null) {
            printWriter.println(this.translation);
        }
    }

    public void addChild(Block block) {
        if (this.children == null) {
            this.setChildren(new ArrayList<Block>());
        }
        this.children.add(block);
    }

    public Signature getSignature() {
        return this.sig;
    }

    public void setSignature(Signature signature) {
        this.sig = signature;
    }

    boolean isStartBlock() {
        return this.startBlock;
    }

    public String getTranslation() {
        return this.translation;
    }

    public void setTranslation(String string) {
        this.translation = string;
    }

    public ArrayList<Block> getChildren() {
        return this.children;
    }

    public boolean isParent() {
        return this.children != null;
    }

    Task getTask() {
        return this.task;
    }

    public ArrayList<String> getLines() {
        return this.lines;
    }

    public Block getParent() {
        return this.parent;
    }

    public int getLineNumber() {
        return this.startLineNumber;
    }

    public int getLineNumber(String string) {
        int n = this.lines.indexOf(string);
        if (n == -1) {
            return this.startLineNumber;
        }
        return this.lineNumbers.get(n);
    }

    public int getTrailingBlankLineCount() {
        return this.trailingBlankLineCount;
    }

    void setTrailingBlankLineCount(int n) {
        this.trailingBlankLineCount = n;
    }

    boolean isEndBlock() {
        return this.endBlock;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public String toString() {
        if (this.endBlock) {
            return "[end block:" + this.trailingBlankLineCount + "]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.sig);
        stringBuilder.append(this.extended ? ".." : ".");
        stringBuilder.append(" [lines=" + this.lines.size() + ":" + this.trailingBlankLineCount + "] ");
        if (this.lines.size() > 0) {
            String string = this.lines.get(0);
            if (string.length() < 30) {
                stringBuilder.append(string);
            } else {
                stringBuilder.append(string.substring(0, 30) + "...");
            }
        }
        if (this.startBlock) {
            stringBuilder.append(" [start block]");
        }
        return stringBuilder.toString();
    }

    public void sign(String string, String string2) {
        this.sig = this.task.getSignature(string);
        this.sig.setMods(new Modifiers.Sig(this.task, string2));
    }

    public void sign(String string, Modifiers modifiers) {
        this.sig = this.task.getSignature(string);
        this.sig.setMods(modifiers);
    }

    public String translateAs(String string, String string2) {
        this.sign(string, string2);
        this.translate();
        return this.translation == null ? "" : this.translation;
    }

    public String translateAs(String string, Modifiers modifiers) {
        this.sign(string, modifiers);
        this.translate();
        return this.translation == null ? "" : this.translation;
    }

    public void setChildren(ArrayList<Block> arrayList) {
        this.children = arrayList;
    }

    public void morph(String string) throws XilizeException {
        Block block = new Block(this.task, this.getLineNumber(), string);
        this.setSignature(block.getSignature());
        this.setLine(0, block.getLine(0));
        this.exec();
    }

    public static class Static
    extends Block {
        Static(String string) {
            super(string);
        }

        public void write(PrintWriter printWriter) {
            printWriter.println(this.getTranslation());
        }
    }
}

