/*
 * Decompiled with CFR 0.152.
 */
package com.centeredwork.xilize;

import com.centeredwork.xilize.Block;
import com.centeredwork.xilize.Signature;
import com.centeredwork.xilize.TaskFile;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockAssembler {
    private final TaskFile task;
    int index;
    int start;
    int end;
    ArrayList<Block> rawBlocks = new ArrayList();

    BlockAssembler(TaskFile taskFile, ArrayList<Block> arrayList) {
        this.task = taskFile;
        this.rawBlocks = arrayList;
    }

    void assemble(Block block) {
        this.assembleChildren(block);
        if (this.start > this.end) {
            this.task.warning(0, this.start - this.end + " more start blocks than end blocks");
        }
    }

    private void extendBlock(Block block, Signature signature) {
        if (this.index >= this.rawBlocks.size()) {
            return;
        }
        Block block2 = this.rawBlocks.get(this.index);
        while (this.index < this.rawBlocks.size() && !block2.isSigned() && !block2.isEndBlock()) {
            block2.setSignature(signature);
            block.addChild(block2);
            ++this.index;
            if (this.index >= this.rawBlocks.size()) break;
            block2 = this.rawBlocks.get(this.index);
        }
    }

    private void assembleChildren(Block block) {
        while (this.index < this.rawBlocks.size()) {
            Block block2 = this.rawBlocks.get(this.index);
            ++this.index;
            if (block2.isEndBlock()) {
                ++this.end;
                if (this.end > this.start) {
                    this.task.warning(block2.getLineNumber(), "end block without matching startblock");
                }
                return;
            }
            if (block2.isStartBlock()) {
                ++this.start;
                block.addChild(block2);
                this.assembleChildren(block2);
                continue;
            }
            if (block2.isExtended()) {
                block.addChild(block2);
                this.extendBlock(block, block2.getSignature());
                continue;
            }
            block.addChild(block2);
        }
    }
}

