/*
 * Decompiled with CFR 0.152.
 */
package com.centeredwork.xilize;

import com.centeredwork.xilize.Block;
import com.centeredwork.xilize.Key;
import com.centeredwork.xilize.Task;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BlockReader
extends LineNumberReader {
    private Task task;
    private String lastLine;
    private Pattern isComment;
    private Pattern isStartBlock;
    private Pattern isEndBlock;
    private String tabSpaces;

    public BlockReader(Task task, Reader reader) {
        super(reader);
        this.task = task;
        this.isComment = Pattern.compile("\\s*" + Pattern.quote(task.value(Key._LineCommentString_)) + ".*");
        this.isStartBlock = Pattern.compile("(.*?) *" + Pattern.quote(task.value(Key._BlockStartString_)));
        this.isEndBlock = Pattern.compile(" *" + Pattern.quote(task.value(Key._BlockEndString_)));
        int n = task.isDefined(Key._SpacesPerTab_) ? Integer.valueOf(task.value(Key._SpacesPerTab_)) : 1;
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" ");
        }
        this.tabSpaces = stringBuilder.toString();
    }

    public String nextLine() throws IOException {
        if (this.lastLine != null) {
            String string = this.lastLine;
            this.lastLine = null;
            return string;
        }
        String string = null;
        while ((string = this.readLine()) != null && this.isComment.matcher(string).matches()) {
        }
        return string == null ? null : string.replaceAll("\\s+$", "").replaceAll("\t", this.tabSpaces);
    }

    void pushback(String string) {
        this.lastLine = string;
    }

    public int getLineNumber() {
        if (this.lastLine == null) {
            return super.getLineNumber();
        }
        return super.getLineNumber() - 1;
    }

    Block readRawBlock() throws IOException {
        String string = null;
        do {
            if ((string = this.nextLine()) != null) continue;
            return null;
        } while (string.matches(" *"));
        if (this.isEndBlock.matcher(string).matches()) {
            return Block.createEndBlock(this.task, this.getLineNumber());
        }
        Block block = null;
        Matcher matcher = this.isStartBlock.matcher(string);
        if (matcher.matches()) {
            block = new Block(this.task, this.getLineNumber(), matcher.group(1), true);
            block.setTrailingBlankLineCount(this.blankLines());
            return block;
        }
        block = new Block(this.task, this.getLineNumber(), string);
        string = this.nextLine();
        while (string != null && string.matches(" *\\S.*") && !this.isEndBlock.matcher(string).matches()) {
            matcher = this.isStartBlock.matcher(string);
            if (matcher.matches()) {
                block.addLine(this.getLineNumber(), matcher.group(1), true);
                block.setTrailingBlankLineCount(this.blankLines());
                return block;
            }
            block.addLine(this.getLineNumber(), string);
            string = this.nextLine();
        }
        if (string != null) {
            this.pushback(string);
        }
        block.setTrailingBlankLineCount(this.blankLines());
        return block;
    }

    private int blankLines() throws IOException {
        String string = this.nextLine();
        if (string == null) {
            return 0;
        }
        int n = 0;
        while (string.matches(" *")) {
            ++n;
            string = this.nextLine();
            if (string != null) continue;
            return n;
        }
        if (string != null) {
            this.pushback(string);
        }
        return n;
    }
}

